/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.cmap;

import com.itextpdf.io.font.cmap.AbstractCMap;
import com.itextpdf.io.font.cmap.CMapObject;
import com.itextpdf.io.util.IntHashtable;
import com.itextpdf.io.util.TextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMapToUnicode
extends AbstractCMap {
    public static CMapToUnicode EmptyCMapToUnicodeMap = new CMapToUnicode(true);
    private final Map<Integer, char[]> byteMappings;
    private final List<byte[]> codeSpaceRanges = new ArrayList<byte[]>();

    private CMapToUnicode(boolean emptyCMap) {
        this.byteMappings = Collections.emptyMap();
    }

    public CMapToUnicode() {
        this.byteMappings = new HashMap<Integer, char[]>();
    }

    public static CMapToUnicode getIdentity() {
        CMapToUnicode uni = new CMapToUnicode();
        for (int i = 0; i < 65537; ++i) {
            uni.addChar(i, TextUtil.convertFromUtf32(i));
        }
        uni.addCodeSpaceRange(new byte[]{0, 0}, new byte[]{-1, -1});
        return uni;
    }

    public boolean hasByteMappings() {
        return this.byteMappings.size() != 0;
    }

    public char[] lookup(byte[] code, int offset, int length) {
        char[] result = null;
        if (length == 1) {
            int key = code[offset] & 0xFF;
            result = this.byteMappings.get(key);
        } else if (length == 2) {
            int intKey = code[offset] & 0xFF;
            intKey <<= 8;
            int key = intKey += code[offset + 1] & 0xFF;
            result = this.byteMappings.get(key);
        }
        return result;
    }

    public char[] lookup(byte[] code) {
        return this.lookup(code, 0, code.length);
    }

    public char[] lookup(int code) {
        return this.byteMappings.get(code);
    }

    public Set<Integer> getCodes() {
        return this.byteMappings.keySet();
    }

    public IntHashtable createDirectMapping() {
        IntHashtable result = new IntHashtable();
        for (Map.Entry<Integer, char[]> entry : this.byteMappings.entrySet()) {
            if (entry.getValue().length != 1) continue;
            result.put(entry.getKey(), this.convertToInt(entry.getValue()));
        }
        return result;
    }

    public Map<Integer, Integer> createReverseMapping() {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, char[]> entry : this.byteMappings.entrySet()) {
            if (entry.getValue().length != 1) continue;
            result.put(this.convertToInt(entry.getValue()), entry.getKey());
        }
        return result;
    }

    public List<byte[]> getCodeSpaceRanges() {
        return this.codeSpaceRanges;
    }

    @Override
    void addCodeSpaceRange(byte[] low, byte[] high) {
        this.codeSpaceRanges.add(low);
        this.codeSpaceRanges.add(high);
    }

    private int convertToInt(char[] s) {
        int value = 0;
        for (int i = 0; i < s.length - 1; ++i) {
            value += s[i];
            value <<= 8;
        }
        return value += s[s.length - 1];
    }

    void addChar(int cid, char[] uni) {
        this.byteMappings.put(cid, uni);
    }

    @Override
    void addChar(String mark, CMapObject code) {
        if (mark.length() == 1) {
            char[] dest = this.createCharsFromDoubleBytes((byte[])code.getValue());
            this.byteMappings.put(Integer.valueOf(mark.charAt(0)), dest);
        } else if (mark.length() == 2) {
            char[] dest = this.createCharsFromDoubleBytes((byte[])code.getValue());
            this.byteMappings.put((mark.charAt(0) << 8) + mark.charAt(1), dest);
        } else {
            Logger logger = LoggerFactory.getLogger(CMapToUnicode.class);
            logger.warn("ToUnicode CMap more than 2 bytes not supported.");
        }
    }

    private char[] createCharsFromSingleBytes(byte[] bytes) {
        if (bytes.length == 1) {
            return new char[]{(char)(bytes[0] & 0xFF)};
        }
        char[] chars = new char[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            chars[i] = (char)(bytes[i] & 0xFF);
        }
        return chars;
    }

    private char[] createCharsFromDoubleBytes(byte[] bytes) {
        char[] chars = new char[bytes.length / 2];
        for (int i = 0; i < bytes.length; i += 2) {
            chars[i / 2] = (char)(((bytes[i] & 0xFF) << 8) + (bytes[i + 1] & 0xFF));
        }
        return chars;
    }
}

