/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.image;

import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageDataFactory;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.IOException;

class AwtImageDataFactory {
    AwtImageDataFactory() {
    }

    public static ImageData create(Image image, Color color) throws IOException {
        return AwtImageDataFactory.create(image, color, false);
    }

    public static ImageData create(Image image, Color color, boolean forceBW) throws IOException {
        BufferedImage bi;
        if (image instanceof BufferedImage && (bi = (BufferedImage)image).getType() == 12 && bi.getColorModel().getPixelSize() == 1) {
            forceBW = true;
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, -1, -1, true);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            throw new IOException("Java.awt.image was interrupted. Waiting for pixels");
        }
        if ((pg.getStatus() & 0x80) != 0) {
            throw new IOException("Java.awt.image fetch aborted or errored");
        }
        int w = pg.getWidth();
        int h = pg.getHeight();
        int[] pixels = (int[])pg.getPixels();
        if (forceBW) {
            int byteWidth = w / 8 + ((w & 7) != 0 ? 1 : 0);
            byte[] pixelsByte = new byte[byteWidth * h];
            int index = 0;
            int size = h * w;
            boolean transColor = true;
            if (color != null) {
                transColor = color.getRed() + color.getGreen() + color.getBlue() >= 384;
            }
            int[] transparency = null;
            int cbyte = 128;
            int wMarker = 0;
            int currByte = 0;
            if (color != null) {
                for (int j = 0; j < size; ++j) {
                    int alpha = pixels[j] >> 24 & 0xFF;
                    if (alpha < 250) {
                        if (transColor) {
                            currByte |= cbyte;
                        }
                    } else if ((pixels[j] & 0x888) != 0) {
                        currByte |= cbyte;
                    }
                    if ((cbyte >>= 1) == 0 || wMarker + 1 >= w) {
                        pixelsByte[index++] = (byte)currByte;
                        cbyte = 128;
                        currByte = 0;
                    }
                    if (++wMarker < w) continue;
                    wMarker = 0;
                }
            } else {
                for (int j = 0; j < size; ++j) {
                    int alpha;
                    if (transparency == null && (alpha = pixels[j] >> 24 & 0xFF) == 0) {
                        transparency = new int[2];
                        transparency[1] = (pixels[j] & 0x888) != 0 ? 255 : 0;
                        transparency[0] = transparency[1];
                    }
                    if ((pixels[j] & 0x888) != 0) {
                        currByte |= cbyte;
                    }
                    if ((cbyte >>= 1) == 0 || wMarker + 1 >= w) {
                        pixelsByte[index++] = (byte)currByte;
                        cbyte = 128;
                        currByte = 0;
                    }
                    if (++wMarker < w) continue;
                    wMarker = 0;
                }
            }
            return ImageDataFactory.create(w, h, 1, 1, pixelsByte, transparency);
        }
        byte[] pixelsByte = new byte[w * h * 3];
        byte[] smask = null;
        int index = 0;
        int size = h * w;
        int red = 255;
        int green = 255;
        int blue = 255;
        if (color != null) {
            red = color.getRed();
            green = color.getGreen();
            blue = color.getBlue();
        }
        int[] transparency = null;
        if (color != null) {
            for (int j = 0; j < size; ++j) {
                int alpha = pixels[j] >> 24 & 0xFF;
                if (alpha < 250) {
                    pixelsByte[index++] = (byte)red;
                    pixelsByte[index++] = (byte)green;
                    pixelsByte[index++] = (byte)blue;
                    continue;
                }
                pixelsByte[index++] = (byte)(pixels[j] >> 16 & 0xFF);
                pixelsByte[index++] = (byte)(pixels[j] >> 8 & 0xFF);
                pixelsByte[index++] = (byte)(pixels[j] & 0xFF);
            }
        } else {
            int transparentPixel = 0;
            smask = new byte[w * h];
            boolean shades = false;
            for (int j = 0; j < size; ++j) {
                byte alpha = smask[j] = (byte)(pixels[j] >> 24 & 0xFF);
                if (!shades) {
                    if (alpha != 0 && alpha != -1) {
                        shades = true;
                    } else if (transparency == null) {
                        if (alpha == 0) {
                            transparentPixel = pixels[j] & 0xFFFFFF;
                            transparency = new int[6];
                            transparency[0] = transparency[1] = transparentPixel >> 16 & 0xFF;
                            transparency[2] = transparency[3] = transparentPixel >> 8 & 0xFF;
                            transparency[4] = transparency[5] = transparentPixel & 0xFF;
                            for (int prevPixel = 0; prevPixel < j; ++prevPixel) {
                                if ((pixels[prevPixel] & 0xFFFFFF) != transparentPixel) continue;
                                shades = true;
                                break;
                            }
                        }
                    } else if ((pixels[j] & 0xFFFFFF) != transparentPixel && alpha == 0) {
                        shades = true;
                    } else if ((pixels[j] & 0xFFFFFF) == transparentPixel && alpha != 0) {
                        shades = true;
                    }
                }
                pixelsByte[index++] = (byte)(pixels[j] >> 16 & 0xFF);
                pixelsByte[index++] = (byte)(pixels[j] >> 8 & 0xFF);
                pixelsByte[index++] = (byte)(pixels[j] & 0xFF);
            }
            if (shades) {
                transparency = null;
            } else {
                smask = null;
            }
        }
        ImageData img = ImageDataFactory.create(w, h, 3, 8, pixelsByte, transparency);
        if (smask != null) {
            ImageData sm = ImageDataFactory.create(w, h, 1, 8, smask, null);
            sm.makeMask();
            img.setImageMask(sm);
        }
        return img;
    }
}

