/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.font;

import com.itextpdf.commons.exceptions.ITextException;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.font.CFFFontSubset;
import com.itextpdf.io.font.CMapEncoding;
import com.itextpdf.io.font.CidFont;
import com.itextpdf.io.font.CidFontProperties;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.FontProgramFactory;
import com.itextpdf.io.font.PdfEncodings;
import com.itextpdf.io.font.TrueTypeFont;
import com.itextpdf.io.font.cmap.CMapCharsetEncoder;
import com.itextpdf.io.font.cmap.CMapContentParser;
import com.itextpdf.io.font.cmap.CMapToUnicode;
import com.itextpdf.io.font.cmap.StandardCMapCharsets;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.source.ByteArrayOutputStream;
import com.itextpdf.io.source.ByteBuffer;
import com.itextpdf.io.util.StreamUtil;
import com.itextpdf.io.util.TextUtil;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.font.DocTrueTypeFont;
import com.itextpdf.kernel.font.FontUtil;
import com.itextpdf.kernel.font.IDocFontProgram;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfLiteral;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfOutputStream;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.PdfVersion;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfType0Font
extends PdfFont {
    private static final String DEFAULT_ENCODING = "";
    private static final int MAX_CID_CODE_LENGTH = 4;
    private static final byte[] rotbits = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
    protected static final int CID_FONT_TYPE_0 = 0;
    protected static final int CID_FONT_TYPE_2 = 2;
    protected boolean vertical;
    protected CMapEncoding cmapEncoding;
    protected Set<Integer> usedGlyphs;
    protected int cidFontType;
    protected char[] specificUnicodeDifferences;
    private final CMapToUnicode embeddedToUnicode;

    PdfType0Font(TrueTypeFont ttf, String cmap) {
        if (!"Identity-H".equals(cmap) && !"Identity-V".equals(cmap)) {
            throw new PdfException("Only Identity CMaps supports with truetype");
        }
        if (!ttf.getFontNames().allowEmbedding()) {
            throw new PdfException("{0} cannot be embedded due to licensing restrictions.").setMessageParams(ttf.getFontNames().getFontName() + ttf.getFontNames().getStyle());
        }
        this.fontProgram = ttf;
        this.embedded = true;
        this.vertical = cmap.endsWith("V");
        this.cmapEncoding = new CMapEncoding(cmap);
        this.usedGlyphs = new TreeSet<Integer>();
        this.cidFontType = 2;
        this.embeddedToUnicode = null;
        if (ttf.isFontSpecific()) {
            this.specificUnicodeDifferences = new char[256];
            byte[] bytes = new byte[1];
            for (int k = 0; k < 256; ++k) {
                int ch;
                bytes[0] = (byte)k;
                String s = PdfEncodings.convertToString((byte[])bytes, null);
                this.specificUnicodeDifferences[k] = ch = s.length() > 0 ? (int)s.charAt(0) : 63;
            }
        }
    }

    PdfType0Font(CidFont font, String cmap) {
        if (!CidFontProperties.isCidFont((String)font.getFontNames().getFontName(), (String)cmap)) {
            throw new PdfException("Font {0} with {1} encoding is not a cjk font.").setMessageParams(font.getFontNames().getFontName(), cmap);
        }
        this.fontProgram = font;
        this.vertical = cmap.endsWith("V");
        String uniMap = this.getCompatibleUniMap(this.fontProgram.getRegistry());
        this.cmapEncoding = new CMapEncoding(cmap, uniMap);
        this.usedGlyphs = new TreeSet<Integer>();
        this.cidFontType = 0;
        this.embeddedToUnicode = null;
    }

    PdfType0Font(PdfDictionary fontDictionary) {
        super(fontDictionary);
        CMapToUnicode toUnicodeCMap;
        this.newFont = false;
        PdfDictionary cidFont = fontDictionary.getAsArray(PdfName.DescendantFonts).getAsDictionary(0);
        PdfObject cmap = fontDictionary.get(PdfName.Encoding);
        String ordering = PdfType0Font.getOrdering(cidFont);
        if (ordering == null) {
            throw new PdfException("Ordering should be determined for CIDFont of Type0 font.");
        }
        PdfObject toUnicode = fontDictionary.get(PdfName.ToUnicode);
        if (toUnicode == null) {
            toUnicodeCMap = FontUtil.parseUniversalToUnicodeCMap(ordering);
            this.embeddedToUnicode = null;
        } else {
            this.embeddedToUnicode = toUnicodeCMap = FontUtil.processToUnicode(toUnicode);
        }
        if (cmap.isName() && (toUnicodeCMap != null || "Identity-H".equals(((PdfName)cmap).getValue()) || "Identity-V".equals(((PdfName)cmap).getValue()))) {
            String uniMap;
            if (toUnicodeCMap == null && (toUnicodeCMap = FontUtil.getToUnicodeFromUniMap(uniMap = PdfType0Font.getUniMapFromOrdering(ordering, "Identity-H".equals(((PdfName)cmap).getValue())))) == null) {
                toUnicodeCMap = FontUtil.getToUnicodeFromUniMap("Identity-H");
                Logger logger = LoggerFactory.getLogger(PdfType0Font.class);
                logger.error(MessageFormatUtil.format((String)"Unknown CMap {0}", (Object[])new Object[]{uniMap}));
            }
            this.fontProgram = DocTrueTypeFont.createFontProgram(cidFont, toUnicodeCMap);
            this.cmapEncoding = PdfType0Font.createCMap(cmap, null);
            assert (this.fontProgram instanceof IDocFontProgram);
            this.embedded = ((IDocFontProgram)this.fontProgram).getFontFile() != null;
        } else {
            String cidFontName = cidFont.getAsName(PdfName.BaseFont).getValue();
            String uniMap = PdfType0Font.getUniMapFromOrdering(ordering, true);
            if (uniMap != null && uniMap.startsWith("Uni") && CidFontProperties.isCidFont((String)cidFontName, (String)uniMap)) {
                try {
                    this.fontProgram = FontProgramFactory.createFont((String)cidFontName);
                    this.cmapEncoding = PdfType0Font.createCMap(cmap, uniMap);
                    this.embedded = false;
                }
                catch (IOException ignored) {
                    this.fontProgram = null;
                    this.cmapEncoding = null;
                }
            } else {
                if (toUnicodeCMap == null) {
                    toUnicodeCMap = FontUtil.getToUnicodeFromUniMap(uniMap);
                }
                if (toUnicodeCMap != null) {
                    this.fontProgram = DocTrueTypeFont.createFontProgram(cidFont, toUnicodeCMap);
                    this.cmapEncoding = PdfType0Font.createCMap(cmap, uniMap);
                }
            }
            if (this.fontProgram == null) {
                throw new PdfException(MessageFormatUtil.format((String)"Cannot recognise document font {0} with {1} encoding", (Object[])new Object[]{cidFontName, cmap}));
            }
        }
        PdfDictionary cidFontDictionary = fontDictionary.getAsArray(PdfName.DescendantFonts).getAsDictionary(0);
        PdfName subtype = cidFontDictionary.getAsName(PdfName.Subtype);
        if (PdfName.CIDFontType0.equals(subtype)) {
            this.cidFontType = 0;
        } else if (PdfName.CIDFontType2.equals(subtype)) {
            this.cidFontType = 2;
        } else {
            LoggerFactory.getLogger(this.getClass()).error("Failed to determine CIDFont subtype. The type of CIDFont shall be CIDFontType0 or CIDFontType2.");
        }
        this.usedGlyphs = new TreeSet<Integer>();
        this.subset = false;
    }

    public static String getUniMapFromOrdering(String ordering, boolean horizontal) {
        String result = null;
        switch (ordering) {
            case "CNS1": {
                result = "UniCNS-UTF16-";
                break;
            }
            case "Japan1": {
                result = "UniJIS-UTF16-";
                break;
            }
            case "Korea1": {
                result = "UniKS-UTF16-";
                break;
            }
            case "GB1": {
                result = "UniGB-UTF16-";
                break;
            }
            case "Identity": {
                result = "Identity-";
                break;
            }
            default: {
                return null;
            }
        }
        if (horizontal) {
            return result + 'H';
        }
        return result + 'V';
    }

    @Override
    public Glyph getGlyph(int unicode) {
        Glyph glyph = this.getFontProgram().getGlyph(unicode);
        if (glyph == null && (glyph = (Glyph)this.notdefGlyphs.get(unicode)) == null) {
            Glyph notdef = this.getFontProgram().getGlyphByCode(0);
            glyph = notdef != null ? new Glyph(notdef, unicode) : new Glyph(-1, 0, unicode);
            this.notdefGlyphs.put(unicode, glyph);
        }
        return glyph;
    }

    @Override
    public boolean containsGlyph(int unicode) {
        if (this.cidFontType == 0) {
            if (this.cmapEncoding.isDirect()) {
                return this.fontProgram.getGlyphByCode(unicode) != null;
            }
            return this.getFontProgram().getGlyph(unicode) != null;
        }
        if (this.cidFontType == 2) {
            if (this.fontProgram.isFontSpecific()) {
                byte[] b = PdfEncodings.convertToBytes((char)((char)unicode), (String)"symboltt");
                return b.length > 0 && this.fontProgram.getGlyph(b[0] & 0xFF) != null;
            }
            return this.getFontProgram().getGlyph(unicode) != null;
        }
        throw new PdfException("Invalid CID font type: " + this.cidFontType);
    }

    private byte[] convertToBytesUsingCMap(String text) {
        int len = text.length();
        ByteBuffer buffer = new ByteBuffer();
        if (this.fontProgram.isFontSpecific()) {
            byte[] b = PdfEncodings.convertToBytes((String)text, (String)"symboltt");
            len = b.length;
            for (int k = 0; k < len; ++k) {
                Glyph glyph = this.fontProgram.getGlyph(b[k] & 0xFF);
                if (glyph == null) continue;
                this.convertToBytes(glyph, buffer);
            }
        } else {
            for (int k = 0; k < len; ++k) {
                int val;
                if (TextUtil.isSurrogatePair((String)text, (int)k)) {
                    val = TextUtil.convertToUtf32((String)text, (int)k);
                    ++k;
                } else {
                    val = text.charAt(k);
                }
                Glyph glyph = this.getGlyph(val);
                if (glyph.getCode() > 0) {
                    this.convertToBytes(glyph, buffer);
                    continue;
                }
                buffer.append(this.cmapEncoding.getCmapBytes(0));
            }
        }
        return buffer.toByteArray();
    }

    @Override
    public byte[] convertToBytes(String text) {
        CMapCharsetEncoder encoder = StandardCMapCharsets.getEncoder((String)this.cmapEncoding.getCmapName());
        if (encoder == null) {
            return this.convertToBytesUsingCMap(text);
        }
        return this.converToBytesUsingEncoder(text, encoder);
    }

    private byte[] converToBytesUsingEncoder(String text, CMapCharsetEncoder encoder) {
        int[] codePoints;
        java.io.ByteArrayOutputStream stream = new java.io.ByteArrayOutputStream();
        for (int cp : codePoints = TextUtil.convertToUtf32((String)text)) {
            try {
                stream.write(encoder.encodeUnicodeCodePoint(cp));
                Glyph glyph = this.getGlyph(cp);
                if (glyph.getCode() <= 0) continue;
                this.usedGlyphs.add(glyph.getCode());
            }
            catch (IOException e) {
                throw new ITextException((Throwable)e);
            }
        }
        return stream.toByteArray();
    }

    @Override
    public byte[] convertToBytes(GlyphLine glyphLine) {
        if (glyphLine == null) {
            return new byte[0];
        }
        CMapCharsetEncoder encoder = StandardCMapCharsets.getEncoder((String)this.cmapEncoding.getCmapName());
        if (encoder == null) {
            int totalByteCount = 0;
            for (int i = glyphLine.start; i < glyphLine.end; ++i) {
                totalByteCount += this.cmapEncoding.getCmapBytesLength(glyphLine.get(i).getCode());
            }
            byte[] bytes = new byte[totalByteCount];
            int offset = 0;
            for (int i = glyphLine.start; i < glyphLine.end; ++i) {
                this.usedGlyphs.add(glyphLine.get(i).getCode());
                offset = this.cmapEncoding.fillCmapBytes(glyphLine.get(i).getCode(), bytes, offset);
            }
            return bytes;
        }
        java.io.ByteArrayOutputStream baos = new java.io.ByteArrayOutputStream();
        for (int i = glyphLine.start; i < glyphLine.end; ++i) {
            Glyph g = glyphLine.get(i);
            this.usedGlyphs.add(g.getCode());
            byte[] encodedBit = encoder.encodeUnicodeCodePoint(g.getUnicode());
            try {
                baos.write(encodedBit);
                continue;
            }
            catch (IOException e) {
                throw new PdfException(e);
            }
        }
        return baos.toByteArray();
    }

    @Override
    public byte[] convertToBytes(Glyph glyph) {
        this.usedGlyphs.add(glyph.getCode());
        CMapCharsetEncoder encoder = StandardCMapCharsets.getEncoder((String)this.cmapEncoding.getCmapName());
        if (encoder == null) {
            return this.cmapEncoding.getCmapBytes(glyph.getCode());
        }
        int cp = glyph.getUnicode();
        return encoder.encodeUnicodeCodePoint(cp);
    }

    @Override
    public void writeText(GlyphLine text, int from, int to, PdfOutputStream stream) {
        int len = to - from + 1;
        if (len > 0) {
            byte[] bytes = this.convertToBytes(new GlyphLine(text, from, to + 1));
            StreamUtil.writeHexedString((OutputStream)((Object)stream), (byte[])bytes);
        }
    }

    @Override
    public void writeText(String text, PdfOutputStream stream) {
        StreamUtil.writeHexedString((OutputStream)((Object)stream), (byte[])this.convertToBytes(text));
    }

    @Override
    public GlyphLine createGlyphLine(String content) {
        ArrayList<Glyph> glyphs = new ArrayList<Glyph>();
        if (this.cidFontType == 0) {
            int len = content.length();
            if (this.cmapEncoding.isDirect()) {
                for (int k = 0; k < len; ++k) {
                    Glyph glyph = this.fontProgram.getGlyphByCode((int)content.charAt(k));
                    if (glyph == null) continue;
                    glyphs.add(glyph);
                }
            } else {
                for (int k = 0; k < len; ++k) {
                    int ch;
                    if (TextUtil.isSurrogatePair((String)content, (int)k)) {
                        ch = TextUtil.convertToUtf32((String)content, (int)k);
                        ++k;
                    } else {
                        ch = content.charAt(k);
                    }
                    glyphs.add(this.getGlyph(ch));
                }
            }
        } else if (this.cidFontType == 2) {
            int len = content.length();
            if (this.fontProgram.isFontSpecific()) {
                byte[] b = PdfEncodings.convertToBytes((String)content, (String)"symboltt");
                len = b.length;
                for (int k = 0; k < len; ++k) {
                    Glyph glyph = this.fontProgram.getGlyph(b[k] & 0xFF);
                    if (glyph == null) continue;
                    glyphs.add(glyph);
                }
            } else {
                for (int k = 0; k < len; ++k) {
                    int val;
                    if (TextUtil.isSurrogatePair((String)content, (int)k)) {
                        val = TextUtil.convertToUtf32((String)content, (int)k);
                        ++k;
                    } else {
                        val = content.charAt(k);
                    }
                    glyphs.add(this.getGlyph(val));
                }
            }
        } else {
            throw new PdfException("Font has no suitable cmap.");
        }
        return new GlyphLine(glyphs);
    }

    @Override
    public int appendGlyphs(String text, int from, int to, List<Glyph> glyphs) {
        if (this.cidFontType == 0) {
            if (this.cmapEncoding.isDirect()) {
                Glyph glyph;
                int processed = 0;
                for (int k = from; k <= to && (glyph = this.fontProgram.getGlyphByCode((int)text.charAt(k))) != null && this.isAppendableGlyph(glyph); ++k) {
                    glyphs.add(glyph);
                    ++processed;
                }
                return processed;
            }
            return this.appendUniGlyphs(text, from, to, glyphs);
        }
        if (this.cidFontType == 2) {
            if (this.fontProgram.isFontSpecific()) {
                Glyph glyph;
                int processed = 0;
                for (int k = from; k <= to && (glyph = this.fontProgram.getGlyph(text.charAt(k) & 0xFF)) != null && this.isAppendableGlyph(glyph); ++k) {
                    glyphs.add(glyph);
                    ++processed;
                }
                return processed;
            }
            return this.appendUniGlyphs(text, from, to, glyphs);
        }
        throw new PdfException("Font has no suitable cmap.");
    }

    private int appendUniGlyphs(String text, int from, int to, List<Glyph> glyphs) {
        int processed = 0;
        for (int k = from; k <= to; ++k) {
            int val;
            int currentlyProcessed = processed++;
            if (TextUtil.isSurrogatePair((String)text, (int)k)) {
                val = TextUtil.convertToUtf32((String)text, (int)k);
                processed += 2;
                ++k;
            } else {
                val = text.charAt(k);
            }
            Glyph glyph = this.getGlyph(val);
            if (!this.isAppendableGlyph(glyph)) {
                processed = currentlyProcessed;
                break;
            }
            glyphs.add(glyph);
        }
        return processed;
    }

    @Override
    public int appendAnyGlyph(String text, int from, List<Glyph> glyphs) {
        int process = 1;
        if (this.cidFontType == 0) {
            if (this.cmapEncoding.isDirect()) {
                Glyph glyph = this.fontProgram.getGlyphByCode((int)text.charAt(from));
                if (glyph != null) {
                    glyphs.add(glyph);
                }
            } else {
                int ch;
                if (TextUtil.isSurrogatePair((String)text, (int)from)) {
                    ch = TextUtil.convertToUtf32((String)text, (int)from);
                    process = 2;
                } else {
                    ch = text.charAt(from);
                }
                glyphs.add(this.getGlyph(ch));
            }
        } else if (this.cidFontType == 2) {
            TrueTypeFont ttf = (TrueTypeFont)this.fontProgram;
            if (ttf.isFontSpecific()) {
                Glyph glyph;
                byte[] b = PdfEncodings.convertToBytes((String)text, (String)"symboltt");
                if (b.length > 0 && (glyph = this.fontProgram.getGlyph(b[0] & 0xFF)) != null) {
                    glyphs.add(glyph);
                }
            } else {
                int ch;
                if (TextUtil.isSurrogatePair((String)text, (int)from)) {
                    ch = TextUtil.convertToUtf32((String)text, (int)from);
                    process = 2;
                } else {
                    ch = text.charAt(from);
                }
                glyphs.add(this.getGlyph(ch));
            }
        } else {
            throw new PdfException("Font has no suitable cmap.");
        }
        return process;
    }

    private boolean isAppendableGlyph(Glyph glyph) {
        return glyph.getCode() > 0 || TextUtil.isWhitespaceOrNonPrintable((int)glyph.getUnicode());
    }

    @Override
    public String decode(PdfString content) {
        return this.decodeIntoGlyphLine(content).toString();
    }

    @Override
    public GlyphLine decodeIntoGlyphLine(PdfString characterCodes) {
        ArrayList<Glyph> glyphs = new ArrayList<Glyph>();
        this.appendDecodedCodesToGlyphsList(glyphs, characterCodes);
        return new GlyphLine(glyphs);
    }

    @Override
    public boolean appendDecodedCodesToGlyphsList(List<Glyph> list, PdfString characterCodes) {
        boolean allCodesDecoded = true;
        boolean isToUnicodeEmbedded = this.embeddedToUnicode != null;
        CMapEncoding cmap = this.getCmap();
        FontProgram fontProgram = this.getFontProgram();
        List codeSpaceRanges = isToUnicodeEmbedded ? this.embeddedToUnicode.getCodeSpaceRanges() : cmap.getCodeSpaceRanges();
        String charCodesSequence = characterCodes.getValue();
        for (int i = 0; i < charCodesSequence.length(); ++i) {
            int code = 0;
            Glyph glyph = null;
            int codeSpaceMatchedLength = 1;
            for (int codeLength = 1; codeLength <= 4 && i + codeLength <= charCodesSequence.length(); ++codeLength) {
                if (!PdfType0Font.containsCodeInCodeSpaceRange(codeSpaceRanges, code = (code << 8) + charCodesSequence.charAt(i + codeLength - 1), codeLength)) continue;
                codeSpaceMatchedLength = codeLength;
                int glyphCode = isToUnicodeEmbedded ? code : cmap.getCidCode(code);
                glyph = fontProgram.getGlyphByCode(glyphCode);
                if (glyph == null) continue;
                i += codeLength - 1;
                break;
            }
            if (glyph == null) {
                Logger logger = LoggerFactory.getLogger(PdfType0Font.class);
                if (logger.isWarnEnabled()) {
                    StringBuilder failedCodes = new StringBuilder();
                    for (int codeLength = 1; codeLength <= 4 && i + codeLength <= charCodesSequence.length(); ++codeLength) {
                        failedCodes.append((int)charCodesSequence.charAt(i + codeLength - 1)).append(" ");
                    }
                    logger.warn(MessageFormatUtil.format((String)"Could not find glyph with the following code: {0}", (Object[])new Object[]{failedCodes.toString()}));
                }
                i += codeSpaceMatchedLength - 1;
            }
            if (glyph == null || glyph.getChars() == null) {
                list.add(new Glyph(0, fontProgram.getGlyphByCode(0).getWidth(), -1));
                allCodesDecoded = false;
                continue;
            }
            list.add(glyph);
        }
        return allCodesDecoded;
    }

    @Override
    public float getContentWidth(PdfString content) {
        float width = 0.0f;
        GlyphLine glyphLine = this.decodeIntoGlyphLine(content);
        for (int i = glyphLine.start; i < glyphLine.end; ++i) {
            width += (float)glyphLine.get(i).getWidth();
        }
        return width;
    }

    @Override
    public boolean isBuiltWith(String fontProgram, String encoding) {
        return this.getFontProgram().isBuiltWith(fontProgram) && this.cmapEncoding.isBuiltWith(PdfType0Font.normalizeEncoding(encoding));
    }

    @Override
    public void flush() {
        if (this.isFlushed()) {
            return;
        }
        this.ensureUnderlyingObjectHasIndirectReference();
        if (this.newFont) {
            this.flushFontData();
        }
        super.flush();
    }

    public CMapEncoding getCmap() {
        return this.cmapEncoding;
    }

    @Override
    protected PdfDictionary getFontDescriptor(String fontName) {
        PdfDictionary fontDescriptor = new PdfDictionary();
        this.makeObjectIndirect(fontDescriptor);
        fontDescriptor.put(PdfName.Type, PdfName.FontDescriptor);
        fontDescriptor.put(PdfName.FontName, new PdfName(fontName));
        fontDescriptor.put(PdfName.FontBBox, new PdfArray(this.getFontProgram().getFontMetrics().getBbox()));
        fontDescriptor.put(PdfName.Ascent, new PdfNumber(this.getFontProgram().getFontMetrics().getTypoAscender()));
        fontDescriptor.put(PdfName.Descent, new PdfNumber(this.getFontProgram().getFontMetrics().getTypoDescender()));
        fontDescriptor.put(PdfName.CapHeight, new PdfNumber(this.getFontProgram().getFontMetrics().getCapHeight()));
        fontDescriptor.put(PdfName.ItalicAngle, new PdfNumber(this.getFontProgram().getFontMetrics().getItalicAngle()));
        fontDescriptor.put(PdfName.StemV, new PdfNumber(this.getFontProgram().getFontMetrics().getStemV()));
        fontDescriptor.put(PdfName.Flags, new PdfNumber(this.getFontProgram().getPdfFontFlags()));
        if (this.fontProgram.getFontIdentification().getPanose() != null) {
            PdfDictionary styleDictionary = new PdfDictionary();
            styleDictionary.put(PdfName.Panose, new PdfString(this.fontProgram.getFontIdentification().getPanose()).setHexWriting(true));
            fontDescriptor.put(PdfName.Style, styleDictionary);
        }
        return fontDescriptor;
    }

    private void convertToBytes(Glyph glyph, ByteBuffer result) {
        int code = glyph.getCode();
        this.usedGlyphs.add(code);
        this.cmapEncoding.fillCmapBytes(code, result);
    }

    private static String getOrdering(PdfDictionary cidFont) {
        PdfDictionary cidinfo = cidFont.getAsDictionary(PdfName.CIDSystemInfo);
        if (cidinfo == null) {
            return null;
        }
        return cidinfo.containsKey(PdfName.Ordering) ? cidinfo.get(PdfName.Ordering).toString() : null;
    }

    private static boolean containsCodeInCodeSpaceRange(List<byte[]> codeSpaceRanges, int code, int length) {
        long unsignedCode = code & 0xFFFFFFFF;
        for (int i = 0; i < codeSpaceRanges.size(); i += 2) {
            if (length != codeSpaceRanges.get(i).length) continue;
            byte[] low = codeSpaceRanges.get(i);
            byte[] high = codeSpaceRanges.get(i + 1);
            long lowValue = PdfType0Font.bytesToLong(low);
            long highValue = PdfType0Font.bytesToLong(high);
            if (unsignedCode < lowValue || unsignedCode > highValue) continue;
            return true;
        }
        return false;
    }

    private static long bytesToLong(byte[] bytes) {
        long res = 0L;
        int shift = 0;
        for (int i = bytes.length - 1; i >= 0; --i) {
            res += (long)((bytes[i] & 0xFF) << shift);
            shift += 8;
        }
        return res;
    }

    private void flushFontData() {
        if (this.cidFontType == 0) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Type, PdfName.Font);
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Subtype, PdfName.Type0);
            String name = this.fontProgram.getFontNames().getFontName();
            String style = this.fontProgram.getFontNames().getStyle();
            if (style.length() > 0) {
                name = name + "-" + style;
            }
            ((PdfDictionary)this.getPdfObject()).put(PdfName.BaseFont, new PdfName(MessageFormatUtil.format((String)"{0}-{1}", (Object[])new Object[]{name, this.cmapEncoding.getCmapName()})));
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Encoding, new PdfName(this.cmapEncoding.getCmapName()));
            PdfDictionary fontDescriptor = this.getFontDescriptor(name);
            PdfDictionary cidFont = this.getCidFont(fontDescriptor, this.fontProgram.getFontNames().getFontName(), false);
            ((PdfDictionary)this.getPdfObject()).put(PdfName.DescendantFonts, new PdfArray(cidFont));
            fontDescriptor.flush();
            cidFont.flush();
        } else if (this.cidFontType == 2) {
            PdfStream fontStream;
            TrueTypeFont ttf = (TrueTypeFont)this.getFontProgram();
            String fontName = PdfType0Font.updateSubsetPrefix(ttf.getFontNames().getFontName(), this.subset, this.embedded);
            PdfDictionary fontDescriptor = this.getFontDescriptor(fontName);
            ttf.updateUsedGlyphs((SortedSet)this.usedGlyphs, this.subset, this.subsetRanges);
            if (ttf.isCff()) {
                byte[] cffBytes;
                if (this.subset) {
                    byte[] bytes = ttf.getFontStreamBytes();
                    Set usedGids = ttf.mapGlyphsCidsToGids(this.usedGlyphs);
                    cffBytes = new CFFFontSubset(bytes, usedGids).Process();
                } else {
                    cffBytes = ttf.getFontStreamBytes();
                }
                fontStream = this.getPdfFontStream(cffBytes, new int[]{cffBytes.length});
                fontStream.put(PdfName.Subtype, new PdfName("CIDFontType0C"));
                ((PdfDictionary)this.getPdfObject()).put(PdfName.BaseFont, new PdfName(MessageFormatUtil.format((String)"{0}-{1}", (Object[])new Object[]{fontName, this.cmapEncoding.getCmapName()})));
                fontDescriptor.put(PdfName.FontFile3, fontStream);
            } else {
                byte[] ttfBytes = null;
                if (this.subset || ttf.getDirectoryOffset() > 0) {
                    try {
                        ttfBytes = ttf.getSubset(this.usedGlyphs, this.subset);
                    }
                    catch (com.itextpdf.io.exceptions.IOException e) {
                        Logger logger = LoggerFactory.getLogger(PdfType0Font.class);
                        logger.warn("Font subset issue. Full font will be embedded.");
                        ttfBytes = null;
                    }
                }
                if (ttfBytes == null) {
                    ttfBytes = ttf.getFontStreamBytes();
                }
                fontStream = this.getPdfFontStream(ttfBytes, new int[]{ttfBytes.length});
                ((PdfDictionary)this.getPdfObject()).put(PdfName.BaseFont, new PdfName(fontName));
                fontDescriptor.put(PdfName.FontFile2, fontStream);
            }
            int numOfGlyphs = ttf.getFontMetrics().getNumberOfGlyphs();
            byte[] cidSetBytes = new byte[ttf.getFontMetrics().getNumberOfGlyphs() / 8 + 1];
            int i = 0;
            while (i < numOfGlyphs / 8) {
                int n = i++;
                cidSetBytes[n] = (byte)(cidSetBytes[n] | 0xFF);
            }
            for (i = 0; i < numOfGlyphs % 8; ++i) {
                int n = cidSetBytes.length - 1;
                cidSetBytes[n] = (byte)(cidSetBytes[n] | rotbits[i]);
            }
            fontDescriptor.put(PdfName.CIDSet, new PdfStream(cidSetBytes));
            PdfDictionary cidFont = this.getCidFont(fontDescriptor, fontName, !ttf.isCff());
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Type, PdfName.Font);
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Subtype, PdfName.Type0);
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Encoding, new PdfName(this.cmapEncoding.getCmapName()));
            ((PdfDictionary)this.getPdfObject()).put(PdfName.DescendantFonts, new PdfArray(cidFont));
            PdfStream toUnicode = this.getToUnicode();
            if (toUnicode != null) {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.ToUnicode, toUnicode);
                if (toUnicode.getIndirectReference() != null) {
                    toUnicode.flush();
                }
            }
            if (((PdfDictionary)this.getPdfObject()).getIndirectReference().getDocument().getPdfVersion().compareTo(PdfVersion.PDF_2_0) >= 0) {
                fontDescriptor.remove(PdfName.CIDSet);
            }
            fontDescriptor.flush();
            cidFont.flush();
            fontStream.flush();
        } else {
            throw new IllegalStateException("Unsupported CID Font");
        }
    }

    protected PdfDictionary getCidFont(PdfDictionary fontDescriptor, String fontName, boolean isType2) {
        PdfDictionary cidFont = new PdfDictionary();
        PdfType0Font.markObjectAsIndirect(cidFont);
        cidFont.put(PdfName.Type, PdfName.Font);
        cidFont.put(PdfName.FontDescriptor, fontDescriptor);
        if (isType2) {
            cidFont.put(PdfName.Subtype, PdfName.CIDFontType2);
            cidFont.put(PdfName.CIDToGIDMap, PdfName.Identity);
        } else {
            cidFont.put(PdfName.Subtype, PdfName.CIDFontType0);
        }
        cidFont.put(PdfName.BaseFont, new PdfName(fontName));
        PdfDictionary cidInfo = new PdfDictionary();
        cidInfo.put(PdfName.Registry, new PdfString(this.cmapEncoding.getRegistry()));
        cidInfo.put(PdfName.Ordering, new PdfString(this.cmapEncoding.getOrdering()));
        cidInfo.put(PdfName.Supplement, new PdfNumber(this.cmapEncoding.getSupplement()));
        cidFont.put(PdfName.CIDSystemInfo, cidInfo);
        if (!this.vertical) {
            cidFont.put(PdfName.DW, new PdfNumber(1000));
            PdfObject widthsArray = this.generateWidthsArray();
            if (widthsArray != null) {
                cidFont.put(PdfName.W, widthsArray);
            }
        } else {
            Logger logger = LoggerFactory.getLogger(PdfType0Font.class);
            logger.warn("Vertical writing has not been implemented yet.");
        }
        return cidFont;
    }

    private PdfObject generateWidthsArray() {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        com.itextpdf.io.source.OutputStream stream = new com.itextpdf.io.source.OutputStream((OutputStream)bytes);
        stream.writeByte(91);
        int lastNumber = -10;
        boolean firstTime = true;
        for (int code : this.usedGlyphs) {
            Glyph glyph = this.fontProgram.getGlyphByCode(code);
            if (glyph.getWidth() == 1000) continue;
            if (glyph.getCode() == lastNumber + 1) {
                stream.writeByte(32);
            } else {
                if (!firstTime) {
                    stream.writeByte(93);
                }
                firstTime = false;
                stream.writeInteger(glyph.getCode());
                stream.writeByte(91);
            }
            stream.writeInteger(glyph.getWidth());
            lastNumber = glyph.getCode();
        }
        if (stream.getCurrentPos() > 1L) {
            stream.writeString("]]");
            return new PdfLiteral(bytes.toByteArray());
        }
        return null;
    }

    public PdfStream getToUnicode() {
        com.itextpdf.io.source.OutputStream stream = new com.itextpdf.io.source.OutputStream((OutputStream)new ByteArrayOutputStream());
        stream.writeString("/CIDInit /ProcSet findresource begin\n12 dict begin\nbegincmap\n/CIDSystemInfo\n<< /Registry (Adobe)\n/Ordering (UCS)\n/Supplement 0\n>> def\n/CMapName /Adobe-Identity-UCS def\n/CMapType 2 def\n1 begincodespacerange\n<0000><FFFF>\nendcodespacerange\n");
        ArrayList<Glyph> glyphGroup = new ArrayList<Glyph>(100);
        int bfranges = 0;
        for (Integer glyphId : this.usedGlyphs) {
            Glyph glyph = this.fontProgram.getGlyphByCode(glyphId.intValue());
            if (glyph.getChars() == null) continue;
            glyphGroup.add(glyph);
            if (glyphGroup.size() != 100) continue;
            bfranges += this.writeBfrange((com.itextpdf.io.source.OutputStream<ByteArrayOutputStream>)stream, glyphGroup);
        }
        if ((bfranges += this.writeBfrange((com.itextpdf.io.source.OutputStream<ByteArrayOutputStream>)stream, glyphGroup)) == 0) {
            return null;
        }
        stream.writeString("endcmap\nCMapName currentdict /CMap defineresource pop\nend end\n");
        return new PdfStream(((ByteArrayOutputStream)stream.getOutputStream()).toByteArray());
    }

    private int writeBfrange(com.itextpdf.io.source.OutputStream<ByteArrayOutputStream> stream, List<Glyph> range) {
        if (range.isEmpty()) {
            return 0;
        }
        stream.writeInteger(range.size());
        stream.writeString(" beginbfrange\n");
        for (Glyph glyph : range) {
            String fromTo = CMapContentParser.toHex((int)glyph.getCode());
            stream.writeString(fromTo);
            stream.writeString(fromTo);
            stream.writeByte(60);
            for (char ch : glyph.getChars()) {
                stream.writeString(PdfType0Font.toHex4(ch));
            }
            stream.writeByte(62);
            stream.writeByte(10);
        }
        stream.writeString("endbfrange\n");
        range.clear();
        return 1;
    }

    private static String toHex4(char ch) {
        String s = "0000" + Integer.toHexString(ch);
        return s.substring(s.length() - 4);
    }

    private String getCompatibleUniMap(String registry) {
        String uniMap = DEFAULT_ENCODING;
        Iterator iterator = ((Set)CidFontProperties.getRegistryNames().get(registry + "_Uni")).iterator();
        while (iterator.hasNext()) {
            String name;
            uniMap = name = (String)iterator.next();
            if ((!name.endsWith("V") || !this.vertical) && (name.endsWith("V") || this.vertical)) continue;
            break;
        }
        return uniMap;
    }

    private static CMapEncoding createCMap(PdfObject cmap, String uniMap) {
        if (cmap.isStream()) {
            PdfStream cmapStream = (PdfStream)cmap;
            byte[] cmapBytes = cmapStream.getBytes();
            return new CMapEncoding(cmapStream.getAsName(PdfName.CMapName).getValue(), cmapBytes);
        }
        String cmapName = ((PdfName)cmap).getValue();
        if ("Identity-H".equals(cmapName) || "Identity-V".equals(cmapName)) {
            return new CMapEncoding(cmapName);
        }
        return new CMapEncoding(cmapName, uniMap);
    }

    private static String normalizeEncoding(String encoding) {
        return null == encoding || DEFAULT_ENCODING.equals(encoding) ? "Identity-H" : encoding;
    }
}

