/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.canvas.parser.clipper;

import com.itextpdf.kernel.pdf.canvas.parser.clipper.ClipperBase;
import com.itextpdf.kernel.pdf.canvas.parser.clipper.Edge;
import com.itextpdf.kernel.pdf.canvas.parser.clipper.IClipper;
import com.itextpdf.kernel.pdf.canvas.parser.clipper.Path;
import com.itextpdf.kernel.pdf.canvas.parser.clipper.Paths;
import com.itextpdf.kernel.pdf.canvas.parser.clipper.Point;
import com.itextpdf.kernel.pdf.canvas.parser.clipper.PolyNode;
import com.itextpdf.kernel.pdf.canvas.parser.clipper.PolyTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;

public class DefaultClipper
extends ClipperBase {
    protected final List<Path.OutRec> polyOuts;
    private IClipper.ClipType clipType;
    private ClipperBase.Scanbeam scanbeam = null;
    private Path.Maxima maxima = null;
    private Edge activeEdges = null;
    private Edge sortedEdges = null;
    private final List<IntersectNode> intersectList = new ArrayList<IntersectNode>();
    private final Comparator<IntersectNode> intersectNodeComparer = new Comparator<IntersectNode>(){

        @Override
        public int compare(IntersectNode o1, IntersectNode o2) {
            long i = o2.getPt().getY() - o1.getPt().getY();
            if (i > 0L) {
                return 1;
            }
            if (i < 0L) {
                return -1;
            }
            return 0;
        }
    };
    private IClipper.PolyFillType clipFillType;
    private IClipper.PolyFillType subjFillType;
    private final List<Path.Join> joins;
    private final List<Path.Join> ghostJoins;
    private boolean usingPolyTree = false;
    public IClipper.IZFillCallback zFillFunction;
    private final boolean reverseSolution;
    private final boolean strictlySimple;
    private static final Logger LOGGER = Logger.getLogger(DefaultClipper.class.getName());

    private static void getHorzDirection(Edge HorzEdge, IClipper.Direction[] Dir, long[] Left, long[] Right) {
        if (HorzEdge.getBot().getX() < HorzEdge.getTop().getX()) {
            Left[0] = HorzEdge.getBot().getX();
            Right[0] = HorzEdge.getTop().getX();
            Dir[0] = IClipper.Direction.LEFT_TO_RIGHT;
        } else {
            Left[0] = HorzEdge.getTop().getX();
            Right[0] = HorzEdge.getBot().getX();
            Dir[0] = IClipper.Direction.RIGHT_TO_LEFT;
        }
    }

    private static boolean getOverlap(long a1, long a2, long b1, long b2, long[] Left, long[] Right) {
        if (a1 < a2) {
            if (b1 < b2) {
                Left[0] = Math.max(a1, b1);
                Right[0] = Math.min(a2, b2);
            } else {
                Left[0] = Math.max(a1, b2);
                Right[0] = Math.min(a2, b1);
            }
        } else if (b1 < b2) {
            Left[0] = Math.max(a2, b1);
            Right[0] = Math.min(a1, b2);
        } else {
            Left[0] = Math.max(a2, b2);
            Right[0] = Math.min(a1, b1);
        }
        return Left[0] < Right[0];
    }

    private static boolean isParam1RightOfParam2(Path.OutRec outRec1, Path.OutRec outRec2) {
        do {
            if ((outRec1 = outRec1.firstLeft) != outRec2) continue;
            return true;
        } while (outRec1 != null);
        return false;
    }

    private static int isPointInPolygon(Point.LongPoint pt, Path.OutPt op) {
        int result = 0;
        Path.OutPt startOp = op;
        long ptx = pt.getX();
        long pty = pt.getY();
        long poly0x = op.getPt().getX();
        long poly0y = op.getPt().getY();
        do {
            op = op.next;
            long poly1x = op.getPt().getX();
            long poly1y = op.getPt().getY();
            if (poly1y == pty && (poly1x == ptx || poly0y == pty && poly1x > ptx == poly0x < ptx)) {
                return -1;
            }
            if (poly0y < pty != poly1y < pty) {
                double d;
                if (poly0x >= ptx) {
                    if (poly1x > ptx) {
                        result = 1 - result;
                    } else {
                        d = (double)(poly0x - ptx) * (double)(poly1y - pty) - (double)(poly1x - ptx) * (double)(poly0y - pty);
                        if (d == 0.0) {
                            return -1;
                        }
                        if (d > 0.0 == poly1y > poly0y) {
                            result = 1 - result;
                        }
                    }
                } else if (poly1x > ptx) {
                    d = (double)(poly0x - ptx) * (double)(poly1y - pty) - (double)(poly1x - ptx) * (double)(poly0y - pty);
                    if (d == 0.0) {
                        return -1;
                    }
                    if (d > 0.0 == poly1y > poly0y) {
                        result = 1 - result;
                    }
                }
            }
            poly0x = poly1x;
            poly0y = poly1y;
        } while (startOp != op);
        return result;
    }

    private static boolean joinHorz(Path.OutPt op1, Path.OutPt op1b, Path.OutPt op2, Path.OutPt op2b, Point.LongPoint Pt, boolean DiscardLeft) {
        IClipper.Direction Dir2;
        IClipper.Direction Dir1 = op1.getPt().getX() > op1b.getPt().getX() ? IClipper.Direction.RIGHT_TO_LEFT : IClipper.Direction.LEFT_TO_RIGHT;
        IClipper.Direction direction = Dir2 = op2.getPt().getX() > op2b.getPt().getX() ? IClipper.Direction.RIGHT_TO_LEFT : IClipper.Direction.LEFT_TO_RIGHT;
        if (Dir1 == Dir2) {
            return false;
        }
        if (Dir1 == IClipper.Direction.LEFT_TO_RIGHT) {
            while (op1.next.getPt().getX() <= Pt.getX() && op1.next.getPt().getX() >= op1.getPt().getX() && op1.next.getPt().getY() == Pt.getY()) {
                op1 = op1.next;
            }
            if (DiscardLeft && op1.getPt().getX() != Pt.getX()) {
                op1 = op1.next;
            }
            if (!(op1b = op1.duplicate(!DiscardLeft)).getPt().equals(Pt)) {
                op1 = op1b;
                op1.setPt(Pt);
                op1b = op1.duplicate(!DiscardLeft);
            }
        } else {
            while (op1.next.getPt().getX() >= Pt.getX() && op1.next.getPt().getX() <= op1.getPt().getX() && op1.next.getPt().getY() == Pt.getY()) {
                op1 = op1.next;
            }
            if (!DiscardLeft && op1.getPt().getX() != Pt.getX()) {
                op1 = op1.next;
            }
            if (!(op1b = op1.duplicate(DiscardLeft)).getPt().equals(Pt)) {
                op1 = op1b;
                op1.setPt(Pt);
                op1b = op1.duplicate(DiscardLeft);
            }
        }
        if (Dir2 == IClipper.Direction.LEFT_TO_RIGHT) {
            while (op2.next.getPt().getX() <= Pt.getX() && op2.next.getPt().getX() >= op2.getPt().getX() && op2.next.getPt().getY() == Pt.getY()) {
                op2 = op2.next;
            }
            if (DiscardLeft && op2.getPt().getX() != Pt.getX()) {
                op2 = op2.next;
            }
            if (!(op2b = op2.duplicate(!DiscardLeft)).getPt().equals(Pt)) {
                op2 = op2b;
                op2.setPt(Pt);
                op2b = op2.duplicate(!DiscardLeft);
            }
        } else {
            while (op2.next.getPt().getX() >= Pt.getX() && op2.next.getPt().getX() <= op2.getPt().getX() && op2.next.getPt().getY() == Pt.getY()) {
                op2 = op2.next;
            }
            if (!DiscardLeft && op2.getPt().getX() != Pt.getX()) {
                op2 = op2.next;
            }
            if (!(op2b = op2.duplicate(DiscardLeft)).getPt().equals(Pt)) {
                op2 = op2b;
                op2.setPt(Pt);
                op2b = op2.duplicate(DiscardLeft);
            }
        }
        if (Dir1 == IClipper.Direction.LEFT_TO_RIGHT == DiscardLeft) {
            op1.prev = op2;
            op2.next = op1;
            op1b.next = op2b;
            op2b.prev = op1b;
        } else {
            op1.next = op2;
            op2.prev = op1;
            op1b.prev = op2b;
            op2b.next = op1b;
        }
        return true;
    }

    private boolean joinPoints(Path.Join j, Path.OutRec outRec1, Path.OutRec outRec2) {
        boolean Reverse2;
        boolean Reverse1;
        boolean isHorizontal;
        Path.OutPt op1 = j.outPt1;
        Path.OutPt op2 = j.outPt2;
        boolean bl = isHorizontal = j.outPt1.getPt().getY() == j.getOffPt().getY();
        if (isHorizontal && j.getOffPt().equals(j.outPt1.getPt()) && j.getOffPt().equals(j.outPt2.getPt())) {
            boolean reverse2;
            if (outRec1 != outRec2) {
                return false;
            }
            Path.OutPt op1b = j.outPt1.next;
            while (op1b != op1 && op1b.getPt().equals(j.getOffPt())) {
                op1b = op1b.next;
            }
            boolean reverse1 = op1b.getPt().getY() > j.getOffPt().getY();
            Path.OutPt op2b = j.outPt2.next;
            while (op2b != op2 && op2b.getPt().equals(j.getOffPt())) {
                op2b = op2b.next;
            }
            boolean bl2 = reverse2 = op2b.getPt().getY() > j.getOffPt().getY();
            if (reverse1 == reverse2) {
                return false;
            }
            if (reverse1) {
                op1b = op1.duplicate(false);
                op2b = op2.duplicate(true);
                op1.prev = op2;
                op2.next = op1;
                op1b.next = op2b;
                op2b.prev = op1b;
                j.outPt1 = op1;
                j.outPt2 = op1b;
                return true;
            }
            op1b = op1.duplicate(true);
            op2b = op2.duplicate(false);
            op1.next = op2;
            op2.prev = op1;
            op1b.prev = op2b;
            op2b.next = op1b;
            j.outPt1 = op1;
            j.outPt2 = op1b;
            return true;
        }
        if (isHorizontal) {
            boolean DiscardLeftSide;
            Point.LongPoint Pt;
            Path.OutPt op1b = op1;
            while (op1.prev.getPt().getY() == op1.getPt().getY() && op1.prev != op1b && op1.prev != op2) {
                op1 = op1.prev;
            }
            while (op1b.next.getPt().getY() == op1b.getPt().getY() && op1b.next != op1 && op1b.next != op2) {
                op1b = op1b.next;
            }
            if (op1b.next == op1 || op1b.next == op2) {
                return false;
            }
            Path.OutPt op2b = op2;
            while (op2.prev.getPt().getY() == op2.getPt().getY() && op2.prev != op2b && op2.prev != op1b) {
                op2 = op2.prev;
            }
            while (op2b.next.getPt().getY() == op2b.getPt().getY() && op2b.next != op2 && op2b.next != op1) {
                op2b = op2b.next;
            }
            if (op2b.next == op2 || op2b.next == op1) {
                return false;
            }
            long[] LeftV = new long[1];
            long[] RightV = new long[1];
            if (!DefaultClipper.getOverlap(op1.getPt().getX(), op1b.getPt().getX(), op2.getPt().getX(), op2b.getPt().getX(), LeftV, RightV)) {
                return false;
            }
            long Left = LeftV[0];
            long Right = RightV[0];
            if (op1.getPt().getX() >= Left && op1.getPt().getX() <= Right) {
                Pt = new Point.LongPoint(op1.getPt());
                DiscardLeftSide = op1.getPt().getX() > op1b.getPt().getX();
            } else if (op2.getPt().getX() >= Left && op2.getPt().getX() <= Right) {
                Pt = new Point.LongPoint(op2.getPt());
                DiscardLeftSide = op2.getPt().getX() > op2b.getPt().getX();
            } else if (op1b.getPt().getX() >= Left && op1b.getPt().getX() <= Right) {
                Pt = new Point.LongPoint(op1b.getPt());
                DiscardLeftSide = op1b.getPt().getX() > op1.getPt().getX();
            } else {
                Pt = new Point.LongPoint(op2b.getPt());
                DiscardLeftSide = op2b.getPt().getX() > op2.getPt().getX();
            }
            j.outPt1 = op1;
            j.outPt2 = op2;
            return DefaultClipper.joinHorz(op1, op1b, op2, op2b, Pt, DiscardLeftSide);
        }
        Path.OutPt op1b = op1.next;
        while (op1b.getPt().equals(op1.getPt()) && op1b != op1) {
            op1b = op1b.next;
        }
        boolean bl3 = Reverse1 = op1b.getPt().getY() > op1.getPt().getY() || !Point.slopesEqual(op1.getPt(), op1b.getPt(), j.getOffPt(), this.useFullRange);
        if (Reverse1) {
            op1b = op1.prev;
            while (op1b.getPt().equals(op1.getPt()) && op1b != op1) {
                op1b = op1b.prev;
            }
            if (op1b.getPt().getY() > op1.getPt().getY() || !Point.slopesEqual(op1.getPt(), op1b.getPt(), j.getOffPt(), this.useFullRange)) {
                return false;
            }
        }
        Path.OutPt op2b = op2.next;
        while (op2b.getPt().equals(op2.getPt()) && op2b != op2) {
            op2b = op2b.next;
        }
        boolean bl4 = Reverse2 = op2b.getPt().getY() > op2.getPt().getY() || !Point.slopesEqual(op2.getPt(), op2b.getPt(), j.getOffPt(), this.useFullRange);
        if (Reverse2) {
            op2b = op2.prev;
            while (op2b.getPt().equals(op2.getPt()) && op2b != op2) {
                op2b = op2b.prev;
            }
            if (op2b.getPt().getY() > op2.getPt().getY() || !Point.slopesEqual(op2.getPt(), op2b.getPt(), j.getOffPt(), this.useFullRange)) {
                return false;
            }
        }
        if (op1b == op1 || op2b == op2 || op1b == op2b || outRec1 == outRec2 && Reverse1 == Reverse2) {
            return false;
        }
        if (Reverse1) {
            op1b = op1.duplicate(false);
            op2b = op2.duplicate(true);
            op1.prev = op2;
            op2.next = op1;
            op1b.next = op2b;
            op2b.prev = op1b;
            j.outPt1 = op1;
            j.outPt2 = op1b;
            return true;
        }
        op1b = op1.duplicate(true);
        op2b = op2.duplicate(false);
        op1.next = op2;
        op2.prev = op1;
        op1b.prev = op2b;
        op2b.next = op1b;
        j.outPt1 = op1;
        j.outPt2 = op1b;
        return true;
    }

    private static Paths minkowski(Path pattern, Path path, boolean IsSum, boolean IsClosed) {
        Path p;
        int i;
        int delta = IsClosed ? 1 : 0;
        int polyCnt = pattern.size();
        int pathCnt = path.size();
        Paths result = new Paths(pathCnt);
        if (IsSum) {
            for (i = 0; i < pathCnt; ++i) {
                p = new Path(polyCnt);
                for (Point.LongPoint ip : pattern) {
                    p.add(new Point.LongPoint(((Point.LongPoint)path.get(i)).getX() + ip.getX(), ((Point.LongPoint)path.get(i)).getY() + ip.getY(), 0L));
                }
                result.add(p);
            }
        } else {
            for (i = 0; i < pathCnt; ++i) {
                p = new Path(polyCnt);
                for (Point.LongPoint ip : pattern) {
                    p.add(new Point.LongPoint(((Point.LongPoint)path.get(i)).getX() - ip.getX(), ((Point.LongPoint)path.get(i)).getY() - ip.getY(), 0L));
                }
                result.add(p);
            }
        }
        Paths quads = new Paths((pathCnt + delta) * (polyCnt + 1));
        for (int i2 = 0; i2 < pathCnt - 1 + delta; ++i2) {
            for (int j = 0; j < polyCnt; ++j) {
                Path quad = new Path(4);
                quad.add(((Path)result.get(i2 % pathCnt)).get(j % polyCnt));
                quad.add(((Path)result.get((i2 + 1) % pathCnt)).get(j % polyCnt));
                quad.add(((Path)result.get((i2 + 1) % pathCnt)).get((j + 1) % polyCnt));
                quad.add(((Path)result.get(i2 % pathCnt)).get((j + 1) % polyCnt));
                if (!quad.orientation()) {
                    Collections.reverse(quad);
                }
                quads.add(quad);
            }
        }
        return quads;
    }

    public static Paths minkowskiDiff(Path poly1, Path poly2) {
        Paths paths = DefaultClipper.minkowski(poly1, poly2, false, true);
        DefaultClipper c = new DefaultClipper();
        c.addPaths(paths, IClipper.PolyType.SUBJECT, true);
        c.execute(IClipper.ClipType.UNION, paths, IClipper.PolyFillType.NON_ZERO, IClipper.PolyFillType.NON_ZERO);
        return paths;
    }

    public static Paths minkowskiSum(Path pattern, Path path, boolean pathIsClosed) {
        Paths paths = DefaultClipper.minkowski(pattern, path, true, pathIsClosed);
        DefaultClipper c = new DefaultClipper();
        c.addPaths(paths, IClipper.PolyType.SUBJECT, true);
        c.execute(IClipper.ClipType.UNION, paths, IClipper.PolyFillType.NON_ZERO, IClipper.PolyFillType.NON_ZERO);
        return paths;
    }

    public static Paths minkowskiSum(Path pattern, Paths paths, boolean pathIsClosed) {
        Paths solution = new Paths();
        DefaultClipper c = new DefaultClipper();
        for (int i = 0; i < paths.size(); ++i) {
            Paths tmp = DefaultClipper.minkowski(pattern, (Path)paths.get(i), true, pathIsClosed);
            c.addPaths(tmp, IClipper.PolyType.SUBJECT, true);
            if (!pathIsClosed) continue;
            Path path = ((Path)paths.get(i)).TranslatePath((Point.LongPoint)pattern.get(0));
            c.addPath(path, IClipper.PolyType.CLIP, true);
        }
        c.execute(IClipper.ClipType.UNION, solution, IClipper.PolyFillType.NON_ZERO, IClipper.PolyFillType.NON_ZERO);
        return solution;
    }

    private static boolean poly2ContainsPoly1(Path.OutPt outPt1, Path.OutPt outPt2) {
        Path.OutPt op = outPt1;
        do {
            int res;
            if ((res = DefaultClipper.isPointInPolygon(op.getPt(), outPt2)) < 0) continue;
            return res > 0;
        } while ((op = op.next) != outPt1);
        return true;
    }

    public static Paths simplifyPolygon(Path poly) {
        return DefaultClipper.simplifyPolygon(poly, IClipper.PolyFillType.EVEN_ODD);
    }

    public static Paths simplifyPolygon(Path poly, IClipper.PolyFillType fillType) {
        Paths result = new Paths();
        DefaultClipper c = new DefaultClipper(2);
        c.addPath(poly, IClipper.PolyType.SUBJECT, true);
        c.execute(IClipper.ClipType.UNION, result, fillType, fillType);
        return result;
    }

    public static Paths simplifyPolygons(Paths polys) {
        return DefaultClipper.simplifyPolygons(polys, IClipper.PolyFillType.EVEN_ODD);
    }

    public static Paths simplifyPolygons(Paths polys, IClipper.PolyFillType fillType) {
        Paths result = new Paths();
        DefaultClipper c = new DefaultClipper(2);
        c.addPaths(polys, IClipper.PolyType.SUBJECT, true);
        c.execute(IClipper.ClipType.UNION, result, fillType, fillType);
        return result;
    }

    public DefaultClipper() {
        this(0);
    }

    public DefaultClipper(int InitOptions) {
        super((4 & InitOptions) != 0);
        this.polyOuts = new ArrayList<Path.OutRec>();
        this.joins = new ArrayList<Path.Join>();
        this.ghostJoins = new ArrayList<Path.Join>();
        this.reverseSolution = (1 & InitOptions) != 0;
        this.strictlySimple = (2 & InitOptions) != 0;
        this.zFillFunction = null;
    }

    private void insertScanbeam(long Y) {
        if (this.scanbeam == null) {
            this.scanbeam = new ClipperBase.Scanbeam();
            this.scanbeam.next = null;
            this.scanbeam.y = Y;
        } else if (Y > this.scanbeam.y) {
            ClipperBase.Scanbeam newSb = new ClipperBase.Scanbeam();
            newSb.y = Y;
            newSb.next = this.scanbeam;
            this.scanbeam = newSb;
        } else {
            ClipperBase.Scanbeam sb2 = this.scanbeam;
            while (sb2.next != null && Y <= sb2.next.y) {
                sb2 = sb2.next;
            }
            if (Y == sb2.y) {
                return;
            }
            ClipperBase.Scanbeam newSb = new ClipperBase.Scanbeam();
            newSb.y = Y;
            newSb.next = sb2.next;
            sb2.next = newSb;
        }
    }

    private void InsertMaxima(long X) {
        Path.Maxima newMax = new Path.Maxima();
        newMax.X = X;
        if (this.maxima == null) {
            this.maxima = newMax;
            this.maxima.Next = null;
            this.maxima.Prev = null;
        } else if (X < this.maxima.X) {
            newMax.Next = this.maxima;
            newMax.Prev = null;
            this.maxima = newMax;
        } else {
            Path.Maxima m = this.maxima;
            while (m.Next != null && X >= m.Next.X) {
                m = m.Next;
            }
            if (X == m.X) {
                return;
            }
            newMax.Next = m.Next;
            newMax.Prev = m;
            if (m.Next != null) {
                m.Next.Prev = newMax;
            }
            m.Next = newMax;
        }
    }

    private void addEdgeToSEL(Edge edge) {
        LOGGER.entering(DefaultClipper.class.getName(), "addEdgeToSEL");
        if (this.sortedEdges == null) {
            this.sortedEdges = edge;
            edge.prevInSEL = null;
            edge.nextInSEL = null;
        } else {
            edge.nextInSEL = this.sortedEdges;
            edge.prevInSEL = null;
            this.sortedEdges.prevInSEL = edge;
            this.sortedEdges = edge;
        }
    }

    private void addGhostJoin(Path.OutPt Op, Point.LongPoint OffPt) {
        Path.Join j = new Path.Join();
        j.outPt1 = Op;
        j.setOffPt(OffPt);
        this.ghostJoins.add(j);
    }

    private void addJoin(Path.OutPt Op1, Path.OutPt Op2, Point.LongPoint OffPt) {
        LOGGER.entering(DefaultClipper.class.getName(), "addJoin");
        Path.Join j = new Path.Join();
        j.outPt1 = Op1;
        j.outPt2 = Op2;
        j.setOffPt(OffPt);
        this.joins.add(j);
    }

    private void addLocalMaxPoly(Edge e1, Edge e2, Point.LongPoint pt) {
        this.addOutPt(e1, pt);
        if (e2.windDelta == 0) {
            this.addOutPt(e2, pt);
        }
        if (e1.outIdx == e2.outIdx) {
            e1.outIdx = -1;
            e2.outIdx = -1;
        } else if (e1.outIdx < e2.outIdx) {
            this.appendPolygon(e1, e2);
        } else {
            this.appendPolygon(e2, e1);
        }
    }

    private Path.OutPt addLocalMinPoly(Edge e1, Edge e2, Point.LongPoint pt) {
        Edge prevE;
        Edge e;
        Path.OutPt result;
        LOGGER.entering(DefaultClipper.class.getName(), "addLocalMinPoly");
        if (e2.isHorizontal() || e1.deltaX > e2.deltaX) {
            result = this.addOutPt(e1, pt);
            e2.outIdx = e1.outIdx;
            e1.side = Edge.Side.LEFT;
            e2.side = Edge.Side.RIGHT;
            e = e1;
            prevE = e.prevInAEL == e2 ? e2.prevInAEL : e.prevInAEL;
        } else {
            result = this.addOutPt(e2, pt);
            e1.outIdx = e2.outIdx;
            e1.side = Edge.Side.RIGHT;
            e2.side = Edge.Side.LEFT;
            e = e2;
            prevE = e.prevInAEL == e1 ? e1.prevInAEL : e.prevInAEL;
        }
        if (prevE != null && prevE.outIdx >= 0 && Edge.topX(prevE, pt.getY()) == Edge.topX(e, pt.getY()) && Edge.slopesEqual(e, prevE, this.useFullRange) && e.windDelta != 0 && prevE.windDelta != 0) {
            Path.OutPt outPt = this.addOutPt(prevE, pt);
            this.addJoin(result, outPt, e.getTop());
        }
        return result;
    }

    private Path.OutPt addOutPt(Edge e, Point.LongPoint pt) {
        LOGGER.entering(DefaultClipper.class.getName(), "addOutPt");
        if (e.outIdx < 0) {
            Path.OutPt newOp;
            Path.OutRec outRec = this.createOutRec();
            outRec.isOpen = e.windDelta == 0;
            outRec.pts = newOp = new Path.OutPt();
            newOp.idx = outRec.Idx;
            newOp.pt = pt;
            newOp.next = newOp;
            newOp.prev = newOp;
            if (!outRec.isOpen) {
                this.setHoleState(e, outRec);
            }
            e.outIdx = outRec.Idx;
            return newOp;
        }
        Path.OutRec outRec = this.polyOuts.get(e.outIdx);
        Path.OutPt op = outRec.getPoints();
        boolean ToFront = e.side == Edge.Side.LEFT;
        LOGGER.finest("op=" + op.getPointCount());
        LOGGER.finest(ToFront + " " + pt + " " + op.getPt());
        if (ToFront && pt.equals(op.getPt())) {
            return op;
        }
        if (!ToFront && pt.equals(op.prev.getPt())) {
            return op.prev;
        }
        Path.OutPt newOp = new Path.OutPt();
        newOp.idx = outRec.Idx;
        newOp.setPt(new Point.LongPoint(pt));
        newOp.next = op;
        newOp.prev = op.prev;
        newOp.prev.next = newOp;
        op.prev = newOp;
        if (ToFront) {
            outRec.setPoints(newOp);
        }
        return newOp;
    }

    private Path.OutPt GetLastOutPt(Edge e) {
        Path.OutRec outRec = this.polyOuts.get(e.outIdx);
        if (e.side == Edge.Side.LEFT) {
            return outRec.pts;
        }
        return outRec.pts.prev;
    }

    private void appendPolygon(Edge e1, Edge e2) {
        Edge.Side side;
        LOGGER.entering(DefaultClipper.class.getName(), "appendPolygon");
        Path.OutRec outRec1 = this.polyOuts.get(e1.outIdx);
        Path.OutRec outRec2 = this.polyOuts.get(e2.outIdx);
        LOGGER.finest("" + e1.outIdx);
        LOGGER.finest("" + e2.outIdx);
        Path.OutRec holeStateRec = DefaultClipper.isParam1RightOfParam2(outRec1, outRec2) ? outRec2 : (DefaultClipper.isParam1RightOfParam2(outRec2, outRec1) ? outRec1 : Path.OutPt.getLowerMostRec(outRec1, outRec2));
        Path.OutPt p1_lft = outRec1.getPoints();
        Path.OutPt p1_rt = p1_lft.prev;
        Path.OutPt p2_lft = outRec2.getPoints();
        Path.OutPt p2_rt = p2_lft.prev;
        LOGGER.finest("p1_lft.getPointCount() = " + p1_lft.getPointCount());
        LOGGER.finest("p1_rt.getPointCount() = " + p1_rt.getPointCount());
        LOGGER.finest("p2_lft.getPointCount() = " + p2_lft.getPointCount());
        LOGGER.finest("p2_rt.getPointCount() = " + p2_rt.getPointCount());
        if (e1.side == Edge.Side.LEFT) {
            if (e2.side == Edge.Side.LEFT) {
                p2_lft.reversePolyPtLinks();
                p2_lft.next = p1_lft;
                p1_lft.prev = p2_lft;
                p1_rt.next = p2_rt;
                p2_rt.prev = p1_rt;
                outRec1.setPoints(p2_rt);
            } else {
                p2_rt.next = p1_lft;
                p1_lft.prev = p2_rt;
                p2_lft.prev = p1_rt;
                p1_rt.next = p2_lft;
                outRec1.setPoints(p2_lft);
            }
            side = Edge.Side.LEFT;
        } else {
            if (e2.side == Edge.Side.RIGHT) {
                p2_lft.reversePolyPtLinks();
                p1_rt.next = p2_rt;
                p2_rt.prev = p1_rt;
                p2_lft.next = p1_lft;
                p1_lft.prev = p2_lft;
            } else {
                p1_rt.next = p2_lft;
                p2_lft.prev = p1_rt;
                p1_lft.prev = p2_rt;
                p2_rt.next = p1_lft;
            }
            side = Edge.Side.RIGHT;
        }
        outRec1.bottomPt = null;
        if (holeStateRec.equals(outRec2)) {
            if (outRec2.firstLeft != outRec1) {
                outRec1.firstLeft = outRec2.firstLeft;
            }
            outRec1.isHole = outRec2.isHole;
        }
        outRec2.setPoints(null);
        outRec2.bottomPt = null;
        outRec2.firstLeft = outRec1;
        int OKIdx = e1.outIdx;
        int ObsoleteIdx = e2.outIdx;
        e1.outIdx = -1;
        e2.outIdx = -1;
        Edge e = this.activeEdges;
        while (e != null) {
            if (e.outIdx == ObsoleteIdx) {
                e.outIdx = OKIdx;
                e.side = side;
                break;
            }
            e = e.nextInAEL;
        }
        outRec2.Idx = outRec1.Idx;
    }

    private void buildIntersectList(long topY) {
        Edge e;
        if (this.activeEdges == null) {
            return;
        }
        this.sortedEdges = e = this.activeEdges;
        while (e != null) {
            e.prevInSEL = e.prevInAEL;
            e.nextInSEL = e.nextInAEL;
            e.getCurrent().setX(Edge.topX(e, topY));
            e = e.nextInAEL;
        }
        boolean isModified = true;
        while (isModified && this.sortedEdges != null) {
            isModified = false;
            e = this.sortedEdges;
            while (e.nextInSEL != null) {
                Edge eNext = e.nextInSEL;
                Point.LongPoint[] pt = new Point.LongPoint[1];
                if (e.getCurrent().getX() > eNext.getCurrent().getX()) {
                    this.intersectPoint(e, eNext, pt);
                    IntersectNode newNode = new IntersectNode();
                    newNode.edge1 = e;
                    newNode.Edge2 = eNext;
                    newNode.setPt(pt[0]);
                    this.intersectList.add(newNode);
                    this.swapPositionsInSEL(e, eNext);
                    isModified = true;
                    continue;
                }
                e = eNext;
            }
            if (e.prevInSEL == null) break;
            e.prevInSEL.nextInSEL = null;
        }
        this.sortedEdges = null;
    }

    private void buildResult(Paths polyg) {
        polyg.clear();
        for (int i = 0; i < this.polyOuts.size(); ++i) {
            Path.OutRec outRec = this.polyOuts.get(i);
            if (outRec.getPoints() == null) continue;
            Path.OutPt p = outRec.getPoints().prev;
            int cnt = p.getPointCount();
            LOGGER.finest("cnt = " + cnt);
            if (cnt < 2) continue;
            Path pg = new Path(cnt);
            for (int j = 0; j < cnt; ++j) {
                pg.add(p.getPt());
                p = p.prev;
            }
            polyg.add(pg);
        }
    }

    private void buildResult2(PolyTree polytree) {
        Path.OutRec outRec;
        int i;
        polytree.Clear();
        for (i = 0; i < this.polyOuts.size(); ++i) {
            int cnt;
            outRec = this.polyOuts.get(i);
            int n = cnt = outRec.getPoints() != null ? outRec.getPoints().getPointCount() : 0;
            if (outRec.isOpen && cnt < 2 || !outRec.isOpen && cnt < 3) continue;
            outRec.fixHoleLinkage();
            PolyNode pn = new PolyNode();
            polytree.getAllPolys().add(pn);
            outRec.polyNode = pn;
            Path.OutPt op = outRec.getPoints().prev;
            for (int j = 0; j < cnt; ++j) {
                pn.getPolygon().add(op.getPt());
                op = op.prev;
            }
        }
        for (i = 0; i < this.polyOuts.size(); ++i) {
            outRec = this.polyOuts.get(i);
            if (outRec.polyNode == null) continue;
            if (outRec.isOpen) {
                outRec.polyNode.setOpen(true);
                polytree.addChild(outRec.polyNode);
                continue;
            }
            if (outRec.firstLeft != null && outRec.firstLeft.polyNode != null) {
                outRec.firstLeft.polyNode.addChild(outRec.polyNode);
                continue;
            }
            polytree.addChild(outRec.polyNode);
        }
    }

    private void copyAELToSEL() {
        Edge e;
        this.sortedEdges = e = this.activeEdges;
        while (e != null) {
            e.prevInSEL = e.prevInAEL;
            e.nextInSEL = e.nextInAEL;
            e = e.nextInAEL;
        }
    }

    private Path.OutRec createOutRec() {
        Path.OutRec result = new Path.OutRec();
        result.Idx = -1;
        result.isHole = false;
        result.isOpen = false;
        result.firstLeft = null;
        result.setPoints(null);
        result.bottomPt = null;
        result.polyNode = null;
        this.polyOuts.add(result);
        result.Idx = this.polyOuts.size() - 1;
        return result;
    }

    private void deleteFromAEL(Edge e) {
        LOGGER.entering(DefaultClipper.class.getName(), "deleteFromAEL");
        Edge AelPrev = e.prevInAEL;
        Edge AelNext = e.nextInAEL;
        if (AelPrev == null && AelNext == null && e != this.activeEdges) {
            return;
        }
        if (AelPrev != null) {
            AelPrev.nextInAEL = AelNext;
        } else {
            this.activeEdges = AelNext;
        }
        if (AelNext != null) {
            AelNext.prevInAEL = AelPrev;
        }
        e.nextInAEL = null;
        e.prevInAEL = null;
        LOGGER.exiting(DefaultClipper.class.getName(), "deleteFromAEL");
    }

    private void deleteFromSEL(Edge e) {
        LOGGER.entering(DefaultClipper.class.getName(), "deleteFromSEL");
        Edge SelPrev = e.prevInSEL;
        Edge SelNext = e.nextInSEL;
        if (SelPrev == null && SelNext == null && !e.equals(this.sortedEdges)) {
            return;
        }
        if (SelPrev != null) {
            SelPrev.nextInSEL = SelNext;
        } else {
            this.sortedEdges = SelNext;
        }
        if (SelNext != null) {
            SelNext.prevInSEL = SelPrev;
        }
        e.nextInSEL = null;
        e.prevInSEL = null;
    }

    private boolean doHorzSegmentsOverlap(long seg1a, long seg1b, long seg2a, long seg2b) {
        long tmp;
        if (seg1a > seg1b) {
            tmp = seg1a;
            seg1a = seg1b;
            seg1b = tmp;
        }
        if (seg2a > seg2b) {
            tmp = seg2a;
            seg2a = seg2b;
            seg2b = tmp;
        }
        return seg1a < seg2b && seg2a < seg1b;
    }

    private void doMaxima(Edge e) {
        Edge eMaxPair = e.getMaximaPair();
        if (eMaxPair == null) {
            if (e.outIdx >= 0) {
                this.addOutPt(e, e.getTop());
            }
            this.deleteFromAEL(e);
            return;
        }
        Edge eNext = e.nextInAEL;
        while (eNext != null && eNext != eMaxPair) {
            Point.LongPoint tmp = new Point.LongPoint(e.getTop());
            this.intersectEdges(e, eNext, tmp);
            e.setTop(tmp);
            this.swapPositionsInAEL(e, eNext);
            eNext = e.nextInAEL;
        }
        if (e.outIdx == -1 && eMaxPair.outIdx == -1) {
            this.deleteFromAEL(e);
            this.deleteFromAEL(eMaxPair);
        } else if (e.outIdx >= 0 && eMaxPair.outIdx >= 0) {
            if (e.outIdx >= 0) {
                this.addLocalMaxPoly(e, eMaxPair, e.getTop());
            }
            this.deleteFromAEL(e);
            this.deleteFromAEL(eMaxPair);
        } else if (e.windDelta == 0) {
            if (e.outIdx >= 0) {
                this.addOutPt(e, e.getTop());
                e.outIdx = -1;
            }
            this.deleteFromAEL(e);
            if (eMaxPair.outIdx >= 0) {
                this.addOutPt(eMaxPair, e.getTop());
                eMaxPair.outIdx = -1;
            }
            this.deleteFromAEL(eMaxPair);
        } else {
            throw new IllegalStateException("DoMaxima error");
        }
    }

    private void doSimplePolygons() {
        int i = 0;
        while (i < this.polyOuts.size()) {
            Path.OutRec outrec;
            Path.OutPt op;
            if ((op = (outrec = this.polyOuts.get(i++)).getPoints()) == null || outrec.isOpen) continue;
            do {
                Path.OutPt op2 = op.next;
                while (op2 != outrec.getPoints()) {
                    if (op.getPt().equals(op2.getPt()) && !op2.next.equals(op) && !op2.prev.equals(op)) {
                        Path.OutPt op4;
                        Path.OutPt op3 = op.prev;
                        op.prev = op4 = op2.prev;
                        op4.next = op;
                        op2.prev = op3;
                        op3.next = op2;
                        outrec.setPoints(op);
                        Path.OutRec outrec2 = this.createOutRec();
                        outrec2.setPoints(op2);
                        this.updateOutPtIdxs(outrec2);
                        if (DefaultClipper.poly2ContainsPoly1(outrec2.getPoints(), outrec.getPoints())) {
                            outrec2.isHole = !outrec.isHole;
                            outrec2.firstLeft = outrec;
                            if (this.usingPolyTree) {
                                this.fixupFirstLefts2(outrec2, outrec);
                            }
                        } else if (DefaultClipper.poly2ContainsPoly1(outrec.getPoints(), outrec2.getPoints())) {
                            outrec2.isHole = outrec.isHole;
                            outrec.isHole = !outrec2.isHole;
                            outrec2.firstLeft = outrec.firstLeft;
                            outrec.firstLeft = outrec2;
                            if (this.usingPolyTree) {
                                this.fixupFirstLefts2(outrec, outrec2);
                            }
                        } else {
                            outrec2.isHole = outrec.isHole;
                            outrec2.firstLeft = outrec.firstLeft;
                            if (this.usingPolyTree) {
                                this.fixupFirstLefts1(outrec, outrec2);
                            }
                        }
                        op2 = op;
                    }
                    op2 = op2.next;
                }
            } while ((op = op.next) != outrec.getPoints());
        }
    }

    private boolean EdgesAdjacent(IntersectNode inode) {
        return inode.edge1.nextInSEL == inode.Edge2 || inode.edge1.prevInSEL == inode.Edge2;
    }

    public boolean execute(IClipper.ClipType clipType, Paths solution, IClipper.PolyFillType FillType) {
        return this.execute(clipType, solution, FillType, FillType);
    }

    @Override
    public boolean execute(IClipper.ClipType clipType, PolyTree polytree) {
        return this.execute(clipType, polytree, IClipper.PolyFillType.EVEN_ODD);
    }

    public boolean execute(IClipper.ClipType clipType, PolyTree polytree, IClipper.PolyFillType FillType) {
        return this.execute(clipType, polytree, FillType, FillType);
    }

    @Override
    public boolean execute(IClipper.ClipType clipType, Paths solution) {
        return this.execute(clipType, solution, IClipper.PolyFillType.EVEN_ODD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(IClipper.ClipType clipType, Paths solution, IClipper.PolyFillType subjFillType, IClipper.PolyFillType clipFillType) {
        DefaultClipper defaultClipper = this;
        synchronized (defaultClipper) {
            boolean bl;
            if (this.hasOpenPaths) {
                throw new IllegalStateException("Error: PolyTree struct is needed for open path clipping.");
            }
            solution.clear();
            this.subjFillType = subjFillType;
            this.clipFillType = clipFillType;
            this.clipType = clipType;
            this.usingPolyTree = false;
            try {
                boolean succeeded = this.executeInternal();
                if (succeeded) {
                    this.buildResult(solution);
                }
                bl = succeeded;
                this.polyOuts.clear();
            }
            catch (Throwable throwable) {
                this.polyOuts.clear();
                throw throwable;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(IClipper.ClipType clipType, PolyTree polytree, IClipper.PolyFillType subjFillType, IClipper.PolyFillType clipFillType) {
        DefaultClipper defaultClipper = this;
        synchronized (defaultClipper) {
            boolean succeeded;
            this.subjFillType = subjFillType;
            this.clipFillType = clipFillType;
            this.clipType = clipType;
            this.usingPolyTree = true;
            try {
                succeeded = this.executeInternal();
                if (succeeded) {
                    this.buildResult2(polytree);
                }
            }
            finally {
                this.polyOuts.clear();
            }
            return succeeded;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeInternal() {
        try {
            Path.OutRec outRec;
            int i;
            this.reset();
            if (this.currentLM == null) {
                boolean bl = false;
                return bl;
            }
            long botY = this.popScanbeam();
            do {
                this.insertLocalMinimaIntoAEL(botY);
                this.processHorizontals();
                this.ghostJoins.clear();
                if (this.scanbeam == null) break;
                long topY = this.popScanbeam();
                if (!this.processIntersections(topY)) {
                    boolean bl = false;
                    return bl;
                }
                this.processEdgesAtTopOfScanbeam(topY);
                botY = topY;
            } while (this.scanbeam != null || this.currentLM != null);
            for (i = 0; i < this.polyOuts.size(); ++i) {
                outRec = this.polyOuts.get(i);
                if (outRec.pts == null || outRec.isOpen || (outRec.isHole ^ this.reverseSolution) != outRec.area() > 0.0) continue;
                outRec.getPoints().reversePolyPtLinks();
            }
            this.joinCommonEdges();
            for (i = 0; i < this.polyOuts.size(); ++i) {
                outRec = this.polyOuts.get(i);
                if (outRec.getPoints() == null) continue;
                if (outRec.isOpen) {
                    this.fixupOutPolyline(outRec);
                    continue;
                }
                this.fixupOutPolygon(outRec);
            }
            if (this.strictlySimple) {
                this.doSimplePolygons();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.joins.clear();
            this.ghostJoins.clear();
        }
    }

    private void fixupFirstLefts1(Path.OutRec OldOutRec, Path.OutRec NewOutRec) {
        for (int i = 0; i < this.polyOuts.size(); ++i) {
            Path.OutRec firstLeft;
            Path.OutRec outRec = this.polyOuts.get(i);
            if (outRec.getPoints() == null || outRec.firstLeft == null || !(firstLeft = DefaultClipper.parseFirstLeft(outRec.firstLeft)).equals(OldOutRec) || !DefaultClipper.poly2ContainsPoly1(outRec.getPoints(), NewOutRec.getPoints())) continue;
            outRec.firstLeft = NewOutRec;
        }
    }

    private void fixupFirstLefts2(Path.OutRec OldOutRec, Path.OutRec NewOutRec) {
        for (Path.OutRec outRec : this.polyOuts) {
            if (outRec.firstLeft != OldOutRec) continue;
            outRec.firstLeft = NewOutRec;
        }
    }

    private boolean fixupIntersectionOrder() {
        Collections.sort(this.intersectList, this.intersectNodeComparer);
        this.copyAELToSEL();
        int cnt = this.intersectList.size();
        for (int i = 0; i < cnt; ++i) {
            if (!this.EdgesAdjacent(this.intersectList.get(i))) {
                int j;
                for (j = i + 1; j < cnt && !this.EdgesAdjacent(this.intersectList.get(j)); ++j) {
                }
                if (j == cnt) {
                    return false;
                }
                IntersectNode tmp = this.intersectList.get(i);
                this.intersectList.set(i, this.intersectList.get(j));
                this.intersectList.set(j, tmp);
            }
            this.swapPositionsInSEL(this.intersectList.get((int)i).edge1, this.intersectList.get((int)i).Edge2);
        }
        return true;
    }

    private void fixupOutPolyline(Path.OutRec outrec) {
        Path.OutPt pp = outrec.pts;
        Path.OutPt lastPP = pp.prev;
        while (pp != lastPP) {
            pp = pp.next;
            if (!pp.pt.equals(pp.prev.pt)) continue;
            if (pp == lastPP) {
                lastPP = pp.prev;
            }
            Path.OutPt tmpPP = pp.prev;
            tmpPP.next = pp.next;
            pp.next.prev = tmpPP;
            pp = tmpPP;
        }
        if (pp == pp.prev) {
            outrec.pts = null;
        }
    }

    private void fixupOutPolygon(Path.OutRec outRec) {
        boolean preserveCol;
        Path.OutPt lastOK = null;
        outRec.bottomPt = null;
        Path.OutPt pp = outRec.getPoints();
        boolean bl = preserveCol = this.preserveCollinear || this.strictlySimple;
        while (true) {
            if (pp.prev == pp || pp.prev == pp.next) {
                outRec.setPoints(null);
                return;
            }
            if (pp.getPt().equals(pp.next.getPt()) || pp.getPt().equals(pp.prev.getPt()) || Point.slopesEqual(pp.prev.getPt(), pp.getPt(), pp.next.getPt(), this.useFullRange) && (!preserveCol || !Point.isPt2BetweenPt1AndPt3(pp.prev.getPt(), pp.getPt(), pp.next.getPt()))) {
                lastOK = null;
                pp.prev.next = pp.next;
                pp.next.prev = pp.prev;
                pp = pp.prev;
                continue;
            }
            if (pp == lastOK) break;
            if (lastOK == null) {
                lastOK = pp;
            }
            pp = pp.next;
        }
        outRec.setPoints(pp);
    }

    private Path.OutRec getOutRec(int idx) {
        Path.OutRec outrec = this.polyOuts.get(idx);
        while (outrec != this.polyOuts.get(outrec.Idx)) {
            outrec = this.polyOuts.get(outrec.Idx);
        }
        return outrec;
    }

    private void insertEdgeIntoAEL(Edge edge, Edge startEdge) {
        LOGGER.entering(DefaultClipper.class.getName(), "insertEdgeIntoAEL");
        if (this.activeEdges == null) {
            edge.prevInAEL = null;
            edge.nextInAEL = null;
            LOGGER.finest("Edge " + edge.outIdx + " -> " + null);
            this.activeEdges = edge;
        } else if (startEdge == null && Edge.doesE2InsertBeforeE1(this.activeEdges, edge)) {
            edge.prevInAEL = null;
            edge.nextInAEL = this.activeEdges;
            LOGGER.finest("Edge " + edge.outIdx + " -> " + edge.nextInAEL.outIdx);
            this.activeEdges.prevInAEL = edge;
            this.activeEdges = edge;
        } else {
            LOGGER.finest("activeEdges unchanged");
            if (startEdge == null) {
                startEdge = this.activeEdges;
            }
            while (startEdge.nextInAEL != null && !Edge.doesE2InsertBeforeE1(startEdge.nextInAEL, edge)) {
                startEdge = startEdge.nextInAEL;
            }
            edge.nextInAEL = startEdge.nextInAEL;
            if (startEdge.nextInAEL != null) {
                startEdge.nextInAEL.prevInAEL = edge;
            }
            edge.prevInAEL = startEdge;
            startEdge.nextInAEL = edge;
        }
    }

    private void insertLocalMinimaIntoAEL(long botY) {
        LOGGER.entering(DefaultClipper.class.getName(), "insertLocalMinimaIntoAEL");
        while (this.currentLM != null && this.currentLM.y == botY) {
            Edge e;
            Edge lb = this.currentLM.leftBound;
            Edge rb = this.currentLM.rightBound;
            this.popLocalMinima();
            Path.OutPt Op1 = null;
            if (lb == null) {
                this.insertEdgeIntoAEL(rb, null);
                this.updateWindingCount(rb);
                if (rb.isContributing(this.clipFillType, this.subjFillType, this.clipType)) {
                    Op1 = this.addOutPt(rb, rb.getBot());
                }
            } else if (rb == null) {
                this.insertEdgeIntoAEL(lb, null);
                this.updateWindingCount(lb);
                if (lb.isContributing(this.clipFillType, this.subjFillType, this.clipType)) {
                    Op1 = this.addOutPt(lb, lb.getBot());
                }
                this.insertScanbeam(lb.getTop().getY());
            } else {
                this.insertEdgeIntoAEL(lb, null);
                this.insertEdgeIntoAEL(rb, lb);
                this.updateWindingCount(lb);
                rb.windCnt = lb.windCnt;
                rb.windCnt2 = lb.windCnt2;
                if (lb.isContributing(this.clipFillType, this.subjFillType, this.clipType)) {
                    Op1 = this.addLocalMinPoly(lb, rb, lb.getBot());
                }
                this.insertScanbeam(lb.getTop().getY());
            }
            if (rb != null) {
                if (rb.isHorizontal()) {
                    this.addEdgeToSEL(rb);
                } else {
                    this.insertScanbeam(rb.getTop().getY());
                }
            }
            if (lb == null || rb == null) continue;
            if (Op1 != null && rb.isHorizontal() && this.ghostJoins.size() > 0 && rb.windDelta != 0) {
                for (int i = 0; i < this.ghostJoins.size(); ++i) {
                    Path.Join j = this.ghostJoins.get(i);
                    if (!this.doHorzSegmentsOverlap(j.outPt1.getPt().getX(), j.getOffPt().getX(), rb.getBot().getX(), rb.getTop().getX())) continue;
                    this.addJoin(j.outPt1, Op1, j.getOffPt());
                }
            }
            if (lb.outIdx >= 0 && lb.prevInAEL != null && lb.prevInAEL.getCurrent().getX() == lb.getBot().getX() && lb.prevInAEL.outIdx >= 0 && Edge.slopesEqual(lb.prevInAEL, lb, this.useFullRange) && lb.windDelta != 0 && lb.prevInAEL.windDelta != 0) {
                Path.OutPt Op2 = this.addOutPt(lb.prevInAEL, lb.getBot());
                this.addJoin(Op1, Op2, lb.getTop());
            }
            if (lb.nextInAEL == rb) continue;
            if (rb.outIdx >= 0 && rb.prevInAEL.outIdx >= 0 && Edge.slopesEqual(rb.prevInAEL, rb, this.useFullRange) && rb.windDelta != 0 && rb.prevInAEL.windDelta != 0) {
                Path.OutPt Op2 = this.addOutPt(rb.prevInAEL, rb.getBot());
                this.addJoin(Op1, Op2, rb.getTop());
            }
            if ((e = lb.nextInAEL) == null) continue;
            while (e != rb) {
                this.intersectEdges(rb, e, lb.getCurrent());
                e = e.nextInAEL;
            }
        }
    }

    private void intersectEdges(Edge e1, Edge e2, Point.LongPoint pt) {
        int e2Wc;
        int e1Wc;
        IClipper.PolyFillType e2FillType2;
        IClipper.PolyFillType e2FillType;
        IClipper.PolyFillType e1FillType2;
        IClipper.PolyFillType e1FillType;
        LOGGER.entering(DefaultClipper.class.getName(), "insersectEdges");
        boolean e1Contributing = e1.outIdx >= 0;
        boolean e2Contributing = e2.outIdx >= 0;
        this.setZ(pt, e1, e2);
        if (e1.windDelta == 0 || e2.windDelta == 0) {
            if (e1.windDelta == 0 && e2.windDelta == 0) {
                return;
            }
            if (e1.polyTyp == e2.polyTyp && e1.windDelta != e2.windDelta && this.clipType == IClipper.ClipType.UNION) {
                if (e1.windDelta == 0) {
                    if (e2Contributing) {
                        this.addOutPt(e1, pt);
                        if (e1Contributing) {
                            e1.outIdx = -1;
                        }
                    }
                } else if (e1Contributing) {
                    this.addOutPt(e2, pt);
                    if (e2Contributing) {
                        e2.outIdx = -1;
                    }
                }
            } else if (e1.polyTyp != e2.polyTyp) {
                if (e1.windDelta == 0 && Math.abs(e2.windCnt) == 1 && (this.clipType != IClipper.ClipType.UNION || e2.windCnt2 == 0)) {
                    this.addOutPt(e1, pt);
                    if (e1Contributing) {
                        e1.outIdx = -1;
                    }
                } else if (e2.windDelta == 0 && Math.abs(e1.windCnt) == 1 && (this.clipType != IClipper.ClipType.UNION || e1.windCnt2 == 0)) {
                    this.addOutPt(e2, pt);
                    if (e2Contributing) {
                        e2.outIdx = -1;
                    }
                }
            }
            return;
        }
        if (e1.polyTyp == e2.polyTyp) {
            if (e1.isEvenOddFillType(this.clipFillType, this.subjFillType)) {
                int oldE1WindCnt = e1.windCnt;
                e1.windCnt = e2.windCnt;
                e2.windCnt = oldE1WindCnt;
            } else {
                e1.windCnt = e1.windCnt + e2.windDelta == 0 ? -e1.windCnt : (e1.windCnt += e2.windDelta);
                e2.windCnt = e2.windCnt - e1.windDelta == 0 ? -e2.windCnt : (e2.windCnt -= e1.windDelta);
            }
        } else {
            if (!e2.isEvenOddFillType(this.clipFillType, this.subjFillType)) {
                e1.windCnt2 += e2.windDelta;
            } else {
                int n = e1.windCnt2 = e1.windCnt2 == 0 ? 1 : 0;
            }
            if (!e1.isEvenOddFillType(this.clipFillType, this.subjFillType)) {
                e2.windCnt2 -= e1.windDelta;
            } else {
                int n = e2.windCnt2 = e2.windCnt2 == 0 ? 1 : 0;
            }
        }
        if (e1.polyTyp == IClipper.PolyType.SUBJECT) {
            e1FillType = this.subjFillType;
            e1FillType2 = this.clipFillType;
        } else {
            e1FillType = this.clipFillType;
            e1FillType2 = this.subjFillType;
        }
        if (e2.polyTyp == IClipper.PolyType.SUBJECT) {
            e2FillType = this.subjFillType;
            e2FillType2 = this.clipFillType;
        } else {
            e2FillType = this.clipFillType;
            e2FillType2 = this.subjFillType;
        }
        switch (e1FillType) {
            case POSITIVE: {
                e1Wc = e1.windCnt;
                break;
            }
            case NEGATIVE: {
                e1Wc = -e1.windCnt;
                break;
            }
            default: {
                e1Wc = Math.abs(e1.windCnt);
            }
        }
        switch (e2FillType) {
            case POSITIVE: {
                e2Wc = e2.windCnt;
                break;
            }
            case NEGATIVE: {
                e2Wc = -e2.windCnt;
                break;
            }
            default: {
                e2Wc = Math.abs(e2.windCnt);
            }
        }
        if (e1Contributing && e2Contributing) {
            if (e1Wc != 0 && e1Wc != 1 || e2Wc != 0 && e2Wc != 1 || e1.polyTyp != e2.polyTyp && this.clipType != IClipper.ClipType.XOR) {
                this.addLocalMaxPoly(e1, e2, pt);
            } else {
                this.addOutPt(e1, pt);
                this.addOutPt(e2, pt);
                Edge.swapSides(e1, e2);
                Edge.swapPolyIndexes(e1, e2);
            }
        } else if (e1Contributing) {
            if (e2Wc == 0 || e2Wc == 1) {
                this.addOutPt(e1, pt);
                Edge.swapSides(e1, e2);
                Edge.swapPolyIndexes(e1, e2);
            }
        } else if (e2Contributing) {
            if (e1Wc == 0 || e1Wc == 1) {
                this.addOutPt(e2, pt);
                Edge.swapSides(e1, e2);
                Edge.swapPolyIndexes(e1, e2);
            }
        } else if (!(e1Wc != 0 && e1Wc != 1 || e2Wc != 0 && e2Wc != 1)) {
            int e2Wc2;
            int e1Wc2;
            switch (e1FillType2) {
                case POSITIVE: {
                    e1Wc2 = e1.windCnt2;
                    break;
                }
                case NEGATIVE: {
                    e1Wc2 = -e1.windCnt2;
                    break;
                }
                default: {
                    e1Wc2 = Math.abs(e1.windCnt2);
                }
            }
            switch (e2FillType2) {
                case POSITIVE: {
                    e2Wc2 = e2.windCnt2;
                    break;
                }
                case NEGATIVE: {
                    e2Wc2 = -e2.windCnt2;
                    break;
                }
                default: {
                    e2Wc2 = Math.abs(e2.windCnt2);
                }
            }
            if (e1.polyTyp != e2.polyTyp) {
                this.addLocalMinPoly(e1, e2, pt);
            } else if (e1Wc == 1 && e2Wc == 1) {
                switch (this.clipType) {
                    case INTERSECTION: {
                        if (e1Wc2 <= 0 || e2Wc2 <= 0) break;
                        this.addLocalMinPoly(e1, e2, pt);
                        break;
                    }
                    case UNION: {
                        if (e1Wc2 > 0 || e2Wc2 > 0) break;
                        this.addLocalMinPoly(e1, e2, pt);
                        break;
                    }
                    case DIFFERENCE: {
                        if ((e1.polyTyp != IClipper.PolyType.CLIP || e1Wc2 <= 0 || e2Wc2 <= 0) && (e1.polyTyp != IClipper.PolyType.SUBJECT || e1Wc2 > 0 || e2Wc2 > 0)) break;
                        this.addLocalMinPoly(e1, e2, pt);
                        break;
                    }
                    case XOR: {
                        this.addLocalMinPoly(e1, e2, pt);
                    }
                }
            } else {
                Edge.swapSides(e1, e2);
            }
        }
    }

    private void intersectPoint(Edge edge1, Edge edge2, Point.LongPoint[] ipV) {
        Point.LongPoint ip = ipV[0] = new Point.LongPoint();
        if (edge1.deltaX == edge2.deltaX) {
            ip.setY(edge1.getCurrent().getY());
            ip.setX(Edge.topX(edge1, ip.getY()));
            return;
        }
        if (edge1.getDelta().getX() == 0L) {
            ip.setX(edge1.getBot().getX());
            if (edge2.isHorizontal()) {
                ip.setY(edge2.getBot().getY());
            } else {
                double b2 = (double)edge2.getBot().getY() - (double)edge2.getBot().getX() / edge2.deltaX;
                ip.setY(Math.round((double)ip.getX() / edge2.deltaX + b2));
            }
        } else if (edge2.getDelta().getX() == 0L) {
            ip.setX(edge2.getBot().getX());
            if (edge1.isHorizontal()) {
                ip.setY(edge1.getBot().getY());
            } else {
                double b1 = (double)edge1.getBot().getY() - (double)edge1.getBot().getX() / edge1.deltaX;
                ip.setY(Math.round((double)ip.getX() / edge1.deltaX + b1));
            }
        } else {
            double b1 = (double)edge1.getBot().getX() - (double)edge1.getBot().getY() * edge1.deltaX;
            double b2 = (double)edge2.getBot().getX() - (double)edge2.getBot().getY() * edge2.deltaX;
            double q = (b2 - b1) / (edge1.deltaX - edge2.deltaX);
            ip.setY(Math.round(q));
            if (Math.abs(edge1.deltaX) < Math.abs(edge2.deltaX)) {
                ip.setX(Math.round(edge1.deltaX * q + b1));
            } else {
                ip.setX(Math.round(edge2.deltaX * q + b2));
            }
        }
        if (ip.getY() < edge1.getTop().getY() || ip.getY() < edge2.getTop().getY()) {
            if (edge1.getTop().getY() > edge2.getTop().getY()) {
                ip.setY(edge1.getTop().getY());
            } else {
                ip.setY(edge2.getTop().getY());
            }
            if (Math.abs(edge1.deltaX) < Math.abs(edge2.deltaX)) {
                ip.setX(Edge.topX(edge1, ip.getY()));
            } else {
                ip.setX(Edge.topX(edge2, ip.getY()));
            }
        }
        if (ip.getY() > edge1.getCurrent().getY()) {
            ip.setY(edge1.getCurrent().getY());
            if (Math.abs(edge1.deltaX) > Math.abs(edge2.deltaX)) {
                ip.setX(Edge.topX(edge2, ip.getY()));
            } else {
                ip.setX(Edge.topX(edge1, ip.getY()));
            }
        }
    }

    private void joinCommonEdges() {
        for (int i = 0; i < this.joins.size(); ++i) {
            Path.Join join = this.joins.get(i);
            Path.OutRec outRec1 = this.getOutRec(join.outPt1.idx);
            Path.OutRec outRec2 = this.getOutRec(join.outPt2.idx);
            if (outRec1.getPoints() == null || outRec2.getPoints() == null || outRec1.isOpen || outRec2.isOpen) continue;
            Path.OutRec holeStateRec = outRec1 == outRec2 ? outRec1 : (DefaultClipper.isParam1RightOfParam2(outRec1, outRec2) ? outRec2 : (DefaultClipper.isParam1RightOfParam2(outRec2, outRec1) ? outRec1 : Path.OutPt.getLowerMostRec(outRec1, outRec2)));
            if (!this.joinPoints(join, outRec1, outRec2)) continue;
            if (outRec1 == outRec2) {
                outRec1.setPoints(join.outPt1);
                outRec1.bottomPt = null;
                outRec2 = this.createOutRec();
                outRec2.setPoints(join.outPt2);
                this.updateOutPtIdxs(outRec2);
                if (this.usingPolyTree) {
                    for (int j = 0; j < this.polyOuts.size() - 1; ++j) {
                        Path.OutRec oRec = this.polyOuts.get(j);
                        if (oRec.getPoints() == null || DefaultClipper.parseFirstLeft(oRec.firstLeft) != outRec1 || oRec.isHole == outRec1.isHole || !DefaultClipper.poly2ContainsPoly1(oRec.getPoints(), join.outPt2)) continue;
                        oRec.firstLeft = outRec2;
                    }
                }
                if (DefaultClipper.poly2ContainsPoly1(outRec2.getPoints(), outRec1.getPoints())) {
                    outRec2.isHole = !outRec1.isHole;
                    outRec2.firstLeft = outRec1;
                    if (this.usingPolyTree) {
                        this.fixupFirstLefts2(outRec2, outRec1);
                    }
                    if ((outRec2.isHole ^ this.reverseSolution) != outRec2.area() > 0.0) continue;
                    outRec2.getPoints().reversePolyPtLinks();
                    continue;
                }
                if (DefaultClipper.poly2ContainsPoly1(outRec1.getPoints(), outRec2.getPoints())) {
                    outRec2.isHole = outRec1.isHole;
                    outRec1.isHole = !outRec2.isHole;
                    outRec2.firstLeft = outRec1.firstLeft;
                    outRec1.firstLeft = outRec2;
                    if (this.usingPolyTree) {
                        this.fixupFirstLefts2(outRec1, outRec2);
                    }
                    if ((outRec1.isHole ^ this.reverseSolution) != outRec1.area() > 0.0) continue;
                    outRec1.getPoints().reversePolyPtLinks();
                    continue;
                }
                outRec2.isHole = outRec1.isHole;
                outRec2.firstLeft = outRec1.firstLeft;
                if (!this.usingPolyTree) continue;
                this.fixupFirstLefts1(outRec1, outRec2);
                continue;
            }
            outRec2.setPoints(null);
            outRec2.bottomPt = null;
            outRec2.Idx = outRec1.Idx;
            outRec1.isHole = holeStateRec.isHole;
            if (holeStateRec == outRec2) {
                outRec1.firstLeft = outRec2.firstLeft;
            }
            outRec2.firstLeft = outRec1;
            if (!this.usingPolyTree) continue;
            this.fixupFirstLefts2(outRec2, outRec1);
        }
    }

    private long popScanbeam() {
        LOGGER.entering(DefaultClipper.class.getName(), "popBeam");
        long y = this.scanbeam.y;
        this.scanbeam = this.scanbeam.next;
        return y;
    }

    private void processEdgesAtTopOfScanbeam(long topY) {
        Path.OutPt op2;
        Edge[] t;
        LOGGER.entering(DefaultClipper.class.getName(), "processEdgesAtTopOfScanbeam");
        Edge e = this.activeEdges;
        while (e != null) {
            Edge ePrev;
            boolean IsMaximaEdge = e.isMaxima(topY);
            if (IsMaximaEdge) {
                Edge eMaxPair = e.getMaximaPair();
                boolean bl = IsMaximaEdge = eMaxPair == null || !eMaxPair.isHorizontal();
            }
            if (IsMaximaEdge) {
                if (this.strictlySimple) {
                    this.InsertMaxima(e.getTop().getX());
                }
                ePrev = e.prevInAEL;
                this.doMaxima(e);
                if (ePrev == null) {
                    e = this.activeEdges;
                    continue;
                }
                e = ePrev.nextInAEL;
                continue;
            }
            if (e.isIntermediate(topY) && e.nextInLML.isHorizontal()) {
                t = new Edge[]{e};
                this.updateEdgeIntoAEL(t);
                e = t[0];
                if (e.outIdx >= 0) {
                    this.addOutPt(e, e.getBot());
                }
                this.addEdgeToSEL(e);
            } else {
                e.getCurrent().setX(Edge.topX(e, topY));
                e.getCurrent().setY(topY);
            }
            if (this.strictlySimple) {
                ePrev = e.prevInAEL;
                if (e.outIdx >= 0 && e.windDelta != 0 && ePrev != null && ePrev.outIdx >= 0 && ePrev.getCurrent().getX() == e.getCurrent().getX() && ePrev.windDelta != 0) {
                    Point.LongPoint ip = new Point.LongPoint(e.getCurrent());
                    this.setZ(ip, ePrev, e);
                    Path.OutPt op = this.addOutPt(ePrev, ip);
                    op2 = this.addOutPt(e, ip);
                    this.addJoin(op, op2, ip);
                }
            }
            e = e.nextInAEL;
        }
        this.processHorizontals();
        this.maxima = null;
        e = this.activeEdges;
        while (e != null) {
            if (e.isIntermediate(topY)) {
                Path.OutPt op = null;
                if (e.outIdx >= 0) {
                    op = this.addOutPt(e, e.getTop());
                }
                t = new Edge[]{e};
                this.updateEdgeIntoAEL(t);
                e = t[0];
                Edge ePrev = e.prevInAEL;
                Edge eNext = e.nextInAEL;
                if (ePrev != null && ePrev.getCurrent().equals(e.getBot()) && op != null && ePrev.outIdx >= 0 && ePrev.getCurrent().getY() > ePrev.getTop().getY() && Edge.slopesEqual(e, ePrev, this.useFullRange) && e.windDelta != 0 && ePrev.windDelta != 0) {
                    op2 = this.addOutPt(ePrev, e.getBot());
                    this.addJoin(op, op2, e.getTop());
                } else if (eNext != null && eNext.getCurrent().equals(e.getBot()) && op != null && eNext.outIdx >= 0 && eNext.getCurrent().getY() > eNext.getTop().getY() && Edge.slopesEqual(e, eNext, this.useFullRange) && e.windDelta != 0 && eNext.windDelta != 0) {
                    op2 = this.addOutPt(eNext, e.getBot());
                    this.addJoin(op, op2, e.getTop());
                }
            }
            e = e.nextInAEL;
        }
        LOGGER.exiting(DefaultClipper.class.getName(), "processEdgesAtTopOfScanbeam");
    }

    private void processHorizontal(Edge horzEdge) {
        Edge eNext;
        Path.OutPt op2;
        Path.Maxima currMax;
        LOGGER.entering(DefaultClipper.class.getName(), "isHorizontal");
        IClipper.Direction[] dir = new IClipper.Direction[1];
        long[] horzLeft = new long[1];
        long[] horzRight = new long[1];
        boolean IsOpen = horzEdge.outIdx >= 0 && this.polyOuts.get((int)horzEdge.outIdx).isOpen;
        DefaultClipper.getHorzDirection(horzEdge, dir, horzLeft, horzRight);
        Edge eLastHorz = horzEdge;
        Edge eMaxPair = null;
        while (eLastHorz.nextInLML != null && eLastHorz.nextInLML.isHorizontal()) {
            eLastHorz = eLastHorz.nextInLML;
        }
        if (eLastHorz.nextInLML == null) {
            eMaxPair = eLastHorz.getMaximaPair();
        }
        if ((currMax = this.maxima) != null) {
            if (dir[0] == IClipper.Direction.LEFT_TO_RIGHT) {
                while (currMax != null && currMax.X <= horzEdge.getBot().getX()) {
                    currMax = currMax.Next;
                }
                if (currMax != null && currMax.X >= eLastHorz.getBot().getX()) {
                    currMax = null;
                }
            } else {
                while (currMax.Next != null && currMax.Next.X < horzEdge.getBot().getX()) {
                    currMax = currMax.Next;
                }
                if (currMax.X <= eLastHorz.getTop().getX()) {
                    currMax = null;
                }
            }
        }
        Path.OutPt op1 = null;
        while (true) {
            boolean IsLastHorz = horzEdge == eLastHorz;
            Edge e = horzEdge.getNextInAEL(dir[0]);
            while (e != null) {
                Point.LongPoint Pt;
                if (currMax != null) {
                    if (dir[0] == IClipper.Direction.LEFT_TO_RIGHT) {
                        while (currMax != null && currMax.X < e.getCurrent().getX()) {
                            if (horzEdge.outIdx >= 0 && !IsOpen) {
                                this.addOutPt(horzEdge, new Point.LongPoint(currMax.X, horzEdge.getBot().getY()));
                            }
                            currMax = currMax.Next;
                        }
                    } else {
                        while (currMax != null && currMax.X > e.getCurrent().getX()) {
                            if (horzEdge.outIdx >= 0 && !IsOpen) {
                                this.addOutPt(horzEdge, new Point.LongPoint(currMax.X, horzEdge.getBot().getY()));
                            }
                            currMax = currMax.Prev;
                        }
                    }
                }
                if (dir[0] == IClipper.Direction.LEFT_TO_RIGHT && e.getCurrent().getX() > horzRight[0] || dir[0] == IClipper.Direction.RIGHT_TO_LEFT && e.getCurrent().getX() < horzLeft[0] || e.getCurrent().getX() == horzEdge.getTop().getX() && horzEdge.nextInLML != null && e.deltaX < horzEdge.nextInLML.deltaX) break;
                if (horzEdge.outIdx >= 0 && !IsOpen) {
                    op1 = this.addOutPt(horzEdge, e.getCurrent());
                    Edge eNextHorz = this.sortedEdges;
                    while (eNextHorz != null) {
                        if (eNextHorz.outIdx >= 0 && this.doHorzSegmentsOverlap(horzEdge.getBot().getX(), horzEdge.getTop().getX(), eNextHorz.getBot().getX(), eNextHorz.getTop().getX())) {
                            op2 = this.GetLastOutPt(eNextHorz);
                            this.addJoin(op2, op1, eNextHorz.getTop());
                        }
                        eNextHorz = eNextHorz.nextInSEL;
                    }
                    this.addGhostJoin(op1, horzEdge.getBot());
                }
                if (e == eMaxPair && IsLastHorz) {
                    if (horzEdge.outIdx >= 0) {
                        this.addLocalMaxPoly(horzEdge, eMaxPair, horzEdge.getTop());
                    }
                    this.deleteFromAEL(horzEdge);
                    this.deleteFromAEL(eMaxPair);
                    return;
                }
                if (dir[0] == IClipper.Direction.LEFT_TO_RIGHT) {
                    Pt = new Point.LongPoint(e.getCurrent().getX(), horzEdge.getCurrent().getY());
                    this.intersectEdges(horzEdge, e, Pt);
                } else {
                    Pt = new Point.LongPoint(e.getCurrent().getX(), horzEdge.getCurrent().getY());
                    this.intersectEdges(e, horzEdge, Pt);
                }
                eNext = e.getNextInAEL(dir[0]);
                this.swapPositionsInAEL(horzEdge, e);
                e = eNext;
            }
            if (horzEdge.nextInLML == null || !horzEdge.nextInLML.isHorizontal()) break;
            Edge[] temp = new Edge[]{horzEdge};
            this.updateEdgeIntoAEL(temp);
            horzEdge = temp[0];
            if (horzEdge.outIdx >= 0) {
                this.addOutPt(horzEdge, horzEdge.getBot());
            }
            DefaultClipper.getHorzDirection(horzEdge, dir, horzLeft, horzRight);
        }
        if (horzEdge.outIdx >= 0 && op1 == null) {
            op1 = this.GetLastOutPt(horzEdge);
            Edge eNextHorz = this.sortedEdges;
            while (eNextHorz != null) {
                if (eNextHorz.outIdx >= 0 && this.doHorzSegmentsOverlap(horzEdge.getBot().getX(), horzEdge.getTop().getX(), eNextHorz.getBot().getX(), eNextHorz.getTop().getX())) {
                    Path.OutPt op22 = this.GetLastOutPt(eNextHorz);
                    this.addJoin(op22, op1, eNextHorz.getTop());
                }
                eNextHorz = eNextHorz.nextInSEL;
            }
            this.addGhostJoin(op1, horzEdge.getTop());
        }
        if (horzEdge.nextInLML != null) {
            if (horzEdge.outIdx >= 0) {
                op1 = this.addOutPt(horzEdge, horzEdge.getTop());
                Edge[] t = new Edge[]{horzEdge};
                this.updateEdgeIntoAEL(t);
                horzEdge = t[0];
                if (horzEdge.windDelta == 0) {
                    return;
                }
                Edge ePrev = horzEdge.prevInAEL;
                eNext = horzEdge.nextInAEL;
                if (ePrev != null && ePrev.getCurrent().equals(horzEdge.getBot()) && ePrev.windDelta != 0 && ePrev.outIdx >= 0 && ePrev.getCurrent().getY() > ePrev.getTop().getY() && Edge.slopesEqual(horzEdge, ePrev, this.useFullRange)) {
                    op2 = this.addOutPt(ePrev, horzEdge.getBot());
                    this.addJoin(op1, op2, horzEdge.getTop());
                } else if (eNext != null && eNext.getCurrent().equals(horzEdge.getBot()) && eNext.windDelta != 0 && eNext.outIdx >= 0 && eNext.getCurrent().getY() > eNext.getTop().getY() && Edge.slopesEqual(horzEdge, eNext, this.useFullRange)) {
                    op2 = this.addOutPt(eNext, horzEdge.getBot());
                    this.addJoin(op1, op2, horzEdge.getTop());
                }
            } else {
                Edge[] t = new Edge[]{horzEdge};
                this.updateEdgeIntoAEL(t);
                horzEdge = t[0];
            }
        } else {
            if (horzEdge.outIdx >= 0) {
                this.addOutPt(horzEdge, horzEdge.getTop());
            }
            this.deleteFromAEL(horzEdge);
        }
    }

    private void processHorizontals() {
        LOGGER.entering(DefaultClipper.class.getName(), "processHorizontals");
        Edge horzEdge = this.sortedEdges;
        while (horzEdge != null) {
            this.deleteFromSEL(horzEdge);
            this.processHorizontal(horzEdge);
            horzEdge = this.sortedEdges;
        }
    }

    private boolean processIntersections(long topY) {
        LOGGER.entering(DefaultClipper.class.getName(), "processIntersections");
        if (this.activeEdges == null) {
            return true;
        }
        try {
            this.buildIntersectList(topY);
            if (this.intersectList.size() == 0) {
                return true;
            }
            if (this.intersectList.size() != 1 && !this.fixupIntersectionOrder()) {
                return false;
            }
            this.processIntersectList();
        }
        catch (Exception e) {
            this.sortedEdges = null;
            this.intersectList.clear();
            throw new IllegalStateException("ProcessIntersections error", e);
        }
        this.sortedEdges = null;
        return true;
    }

    private void processIntersectList() {
        for (int i = 0; i < this.intersectList.size(); ++i) {
            IntersectNode iNode = this.intersectList.get(i);
            this.intersectEdges(iNode.edge1, iNode.Edge2, iNode.getPt());
            this.swapPositionsInAEL(iNode.edge1, iNode.Edge2);
        }
        this.intersectList.clear();
    }

    @Override
    protected void reset() {
        super.reset();
        this.scanbeam = null;
        this.maxima = null;
        this.activeEdges = null;
        this.sortedEdges = null;
        ClipperBase.LocalMinima lm = this.minimaList;
        while (lm != null) {
            this.insertScanbeam(lm.y);
            lm = lm.next;
        }
    }

    private void setHoleState(Edge e, Path.OutRec outRec) {
        boolean isHole = false;
        Edge e2 = e.prevInAEL;
        while (e2 != null) {
            if (e2.outIdx >= 0 && e2.windDelta != 0) {
                boolean bl = isHole = !isHole;
                if (outRec.firstLeft == null) {
                    outRec.firstLeft = this.polyOuts.get(e2.outIdx);
                }
            }
            e2 = e2.prevInAEL;
        }
        if (isHole) {
            outRec.isHole = true;
        }
    }

    private void setZ(Point.LongPoint pt, Edge e1, Edge e2) {
        if (pt.getZ() != 0L || this.zFillFunction == null) {
            return;
        }
        if (pt.equals(e1.getBot())) {
            pt.setZ(e1.getBot().getZ());
        } else if (pt.equals(e1.getTop())) {
            pt.setZ(e1.getTop().getZ());
        } else if (pt.equals(e2.getBot())) {
            pt.setZ(e2.getBot().getZ());
        } else if (pt.equals(e2.getTop())) {
            pt.setZ(e2.getTop().getZ());
        } else {
            this.zFillFunction.zFill(e1.getBot(), e1.getTop(), e2.getBot(), e2.getTop(), pt);
        }
    }

    private void swapPositionsInAEL(Edge edge1, Edge edge2) {
        LOGGER.entering(DefaultClipper.class.getName(), "swapPositionsInAEL");
        if (edge1.nextInAEL == edge1.prevInAEL || edge2.nextInAEL == edge2.prevInAEL) {
            return;
        }
        if (edge1.nextInAEL == edge2) {
            Edge prev;
            Edge next = edge2.nextInAEL;
            if (next != null) {
                next.prevInAEL = edge1;
            }
            if ((prev = edge1.prevInAEL) != null) {
                prev.nextInAEL = edge2;
            }
            edge2.prevInAEL = prev;
            edge2.nextInAEL = edge1;
            edge1.prevInAEL = edge2;
            edge1.nextInAEL = next;
        } else if (edge2.nextInAEL == edge1) {
            Edge prev;
            Edge next = edge1.nextInAEL;
            if (next != null) {
                next.prevInAEL = edge2;
            }
            if ((prev = edge2.prevInAEL) != null) {
                prev.nextInAEL = edge1;
            }
            edge1.prevInAEL = prev;
            edge1.nextInAEL = edge2;
            edge2.prevInAEL = edge1;
            edge2.nextInAEL = next;
        } else {
            Edge next = edge1.nextInAEL;
            Edge prev = edge1.prevInAEL;
            edge1.nextInAEL = edge2.nextInAEL;
            if (edge1.nextInAEL != null) {
                edge1.nextInAEL.prevInAEL = edge1;
            }
            edge1.prevInAEL = edge2.prevInAEL;
            if (edge1.prevInAEL != null) {
                edge1.prevInAEL.nextInAEL = edge1;
            }
            edge2.nextInAEL = next;
            if (edge2.nextInAEL != null) {
                edge2.nextInAEL.prevInAEL = edge2;
            }
            edge2.prevInAEL = prev;
            if (edge2.prevInAEL != null) {
                edge2.prevInAEL.nextInAEL = edge2;
            }
        }
        if (edge1.prevInAEL == null) {
            this.activeEdges = edge1;
        } else if (edge2.prevInAEL == null) {
            this.activeEdges = edge2;
        }
        LOGGER.exiting(DefaultClipper.class.getName(), "swapPositionsInAEL");
    }

    private void swapPositionsInSEL(Edge edge1, Edge edge2) {
        if (edge1.nextInSEL == null && edge1.prevInSEL == null) {
            return;
        }
        if (edge2.nextInSEL == null && edge2.prevInSEL == null) {
            return;
        }
        if (edge1.nextInSEL == edge2) {
            Edge prev;
            Edge next = edge2.nextInSEL;
            if (next != null) {
                next.prevInSEL = edge1;
            }
            if ((prev = edge1.prevInSEL) != null) {
                prev.nextInSEL = edge2;
            }
            edge2.prevInSEL = prev;
            edge2.nextInSEL = edge1;
            edge1.prevInSEL = edge2;
            edge1.nextInSEL = next;
        } else if (edge2.nextInSEL == edge1) {
            Edge prev;
            Edge next = edge1.nextInSEL;
            if (next != null) {
                next.prevInSEL = edge2;
            }
            if ((prev = edge2.prevInSEL) != null) {
                prev.nextInSEL = edge1;
            }
            edge1.prevInSEL = prev;
            edge1.nextInSEL = edge2;
            edge2.prevInSEL = edge1;
            edge2.nextInSEL = next;
        } else {
            Edge next = edge1.nextInSEL;
            Edge prev = edge1.prevInSEL;
            edge1.nextInSEL = edge2.nextInSEL;
            if (edge1.nextInSEL != null) {
                edge1.nextInSEL.prevInSEL = edge1;
            }
            edge1.prevInSEL = edge2.prevInSEL;
            if (edge1.prevInSEL != null) {
                edge1.prevInSEL.nextInSEL = edge1;
            }
            edge2.nextInSEL = next;
            if (edge2.nextInSEL != null) {
                edge2.nextInSEL.prevInSEL = edge2;
            }
            edge2.prevInSEL = prev;
            if (edge2.prevInSEL != null) {
                edge2.prevInSEL.nextInSEL = edge2;
            }
        }
        if (edge1.prevInSEL == null) {
            this.sortedEdges = edge1;
        } else if (edge2.prevInSEL == null) {
            this.sortedEdges = edge2;
        }
    }

    private void updateEdgeIntoAEL(Edge[] eV) {
        Edge e = eV[0];
        if (e.nextInLML == null) {
            throw new IllegalStateException("UpdateEdgeIntoAEL: invalid call");
        }
        Edge AelPrev = e.prevInAEL;
        Edge AelNext = e.nextInAEL;
        e.nextInLML.outIdx = e.outIdx;
        if (AelPrev != null) {
            AelPrev.nextInAEL = e.nextInLML;
        } else {
            this.activeEdges = e.nextInLML;
        }
        if (AelNext != null) {
            AelNext.prevInAEL = e.nextInLML;
        }
        e.nextInLML.side = e.side;
        e.nextInLML.windDelta = e.windDelta;
        e.nextInLML.windCnt = e.windCnt;
        e.nextInLML.windCnt2 = e.windCnt2;
        eV[0] = e = e.nextInLML;
        e.setCurrent(e.getBot());
        e.prevInAEL = AelPrev;
        e.nextInAEL = AelNext;
        if (!e.isHorizontal()) {
            this.insertScanbeam(e.getTop().getY());
        }
    }

    private void updateOutPtIdxs(Path.OutRec outrec) {
        Path.OutPt op = outrec.getPoints();
        do {
            op.idx = outrec.Idx;
        } while ((op = op.prev) != outrec.getPoints());
    }

    private void updateWindingCount(Edge edge) {
        LOGGER.entering(DefaultClipper.class.getName(), "updateWindingCount");
        Edge e = edge.prevInAEL;
        while (e != null && (e.polyTyp != edge.polyTyp || e.windDelta == 0)) {
            e = e.prevInAEL;
        }
        if (e == null) {
            edge.windCnt = edge.windDelta == 0 ? 1 : edge.windDelta;
            edge.windCnt2 = 0;
            e = this.activeEdges;
        } else if (edge.windDelta == 0 && this.clipType != IClipper.ClipType.UNION) {
            edge.windCnt = 1;
            edge.windCnt2 = e.windCnt2;
            e = e.nextInAEL;
        } else if (edge.isEvenOddFillType(this.clipFillType, this.subjFillType)) {
            if (edge.windDelta == 0) {
                boolean Inside = true;
                Edge e2 = e.prevInAEL;
                while (e2 != null) {
                    if (e2.polyTyp == e.polyTyp && e2.windDelta != 0) {
                        Inside = !Inside;
                    }
                    e2 = e2.prevInAEL;
                }
                edge.windCnt = Inside ? 0 : 1;
            } else {
                edge.windCnt = edge.windDelta;
            }
            edge.windCnt2 = e.windCnt2;
            e = e.nextInAEL;
        } else {
            edge.windCnt = e.windCnt * e.windDelta < 0 ? (Math.abs(e.windCnt) > 1 ? (e.windDelta * edge.windDelta < 0 ? e.windCnt : e.windCnt + edge.windDelta) : (edge.windDelta == 0 ? 1 : edge.windDelta)) : (edge.windDelta == 0 ? (e.windCnt < 0 ? e.windCnt - 1 : e.windCnt + 1) : (e.windDelta * edge.windDelta < 0 ? e.windCnt : e.windCnt + edge.windDelta));
            edge.windCnt2 = e.windCnt2;
            e = e.nextInAEL;
        }
        if (edge.isEvenOddAltFillType(this.clipFillType, this.subjFillType)) {
            while (e != edge) {
                if (e.windDelta != 0) {
                    edge.windCnt2 = edge.windCnt2 == 0 ? 1 : 0;
                }
                e = e.nextInAEL;
            }
        } else {
            while (e != edge) {
                edge.windCnt2 += e.windDelta;
                e = e.nextInAEL;
            }
        }
    }

    private class IntersectNode {
        Edge edge1;
        Edge Edge2;
        private Point.LongPoint pt;

        private IntersectNode() {
        }

        public Point.LongPoint getPt() {
            return this.pt;
        }

        public void setPt(Point.LongPoint pt) {
            this.pt = pt;
        }
    }
}

