/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfa.checker;

import com.itextpdf.io.colors.IccProfile;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfTrueTypeFont;
import com.itextpdf.kernel.pdf.IsoKey;
import com.itextpdf.kernel.pdf.PdfAConformanceLevel;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfCatalog;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfOutline;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfResources;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.PdfXrefTable;
import com.itextpdf.kernel.pdf.canvas.CanvasGraphicsState;
import com.itextpdf.kernel.pdf.colorspace.PdfColorSpace;
import com.itextpdf.kernel.utils.IValidationChecker;
import com.itextpdf.kernel.utils.ValidationContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class PdfAChecker
implements IValidationChecker {
    public static final String ICC_COLOR_SPACE_RGB = "RGB ";
    public static final String ICC_COLOR_SPACE_CMYK = "CMYK";
    public static final String ICC_COLOR_SPACE_GRAY = "GRAY";
    public static final String ICC_DEVICE_CLASS_OUTPUT_PROFILE = "prtr";
    public static final String ICC_DEVICE_CLASS_MONITOR_PROFILE = "mntr";
    public static final int maxGsStackDepth = 28;
    protected PdfAConformanceLevel conformanceLevel;
    protected PdfStream pdfAOutputIntentDestProfile;
    protected String pdfAOutputIntentColorSpace;
    protected int gsStackDepth = 0;
    @Deprecated
    protected boolean rgbIsUsed = false;
    @Deprecated
    protected boolean cmykIsUsed = false;
    @Deprecated
    protected boolean grayIsUsed = false;
    protected Set<PdfObject> rgbUsedObjects = new HashSet<PdfObject>();
    protected Set<PdfObject> cmykUsedObjects = new HashSet<PdfObject>();
    protected Set<PdfObject> grayUsedObjects = new HashSet<PdfObject>();
    protected Set<PdfObject> checkedObjects = new HashSet<PdfObject>();
    protected Map<PdfObject, PdfColorSpace> checkedObjectsColorspace = new HashMap<PdfObject, PdfColorSpace>();
    private boolean fullCheckMode = false;

    protected PdfAChecker(PdfAConformanceLevel conformanceLevel) {
        this.conformanceLevel = conformanceLevel;
    }

    public void checkDocument(PdfCatalog catalog) {
        PdfDictionary catalogDict = (PdfDictionary)catalog.getPdfObject();
        this.setPdfAOutputIntentColorSpace(catalogDict);
        this.checkOutputIntents(catalogDict);
        this.checkMetaData(catalogDict);
        this.checkCatalogValidEntries(catalogDict);
        this.checkTrailer(catalog.getDocument().getTrailer());
        this.checkCatalog(catalog);
        this.checkLogicalStructure(catalogDict);
        this.checkForm(catalogDict.getAsDictionary(PdfName.AcroForm));
        if (catalog.getDocument().hasOutlines()) {
            this.checkOutlines(catalog.getDocument().getOutlines(false));
        }
        this.checkPages(catalog.getDocument());
        this.checkOpenAction(catalogDict.get(PdfName.OpenAction));
        this.checkColorsUsages();
    }

    public void validateDocument(ValidationContext validationContext) {
        for (PdfFont pdfFont : validationContext.getFonts()) {
            this.checkFont(pdfFont);
        }
        PdfCatalog catalog = validationContext.getPdfDocument().getCatalog();
        this.checkDocument(catalog);
    }

    public void validateObject(Object obj, IsoKey key, PdfResources resources, PdfStream contentStream, Object extra) {
        PdfDictionary currentColorSpaces = null;
        if (resources != null) {
            currentColorSpaces = ((PdfDictionary)resources.getPdfObject()).getAsDictionary(PdfName.ColorSpace);
        }
        switch (key) {
            case CANVAS_STACK: {
                this.checkCanvasStack(((Character)obj).charValue());
                break;
            }
            case PDF_OBJECT: {
                this.checkPdfObject((PdfObject)obj);
                break;
            }
            case RENDERING_INTENT: {
                this.checkRenderingIntent((PdfName)obj);
                break;
            }
            case INLINE_IMAGE: {
                this.checkInlineImage((PdfStream)obj, currentColorSpaces);
                break;
            }
            case EXTENDED_GRAPHICS_STATE: {
                CanvasGraphicsState gState = (CanvasGraphicsState)obj;
                this.checkExtGState(gState, contentStream);
                break;
            }
            case FILL_COLOR: {
                CanvasGraphicsState gState = (CanvasGraphicsState)obj;
                this.checkColor(gState, gState.getFillColor(), currentColorSpaces, true, contentStream);
                break;
            }
            case PAGE: {
                this.checkSinglePage((PdfPage)obj);
                break;
            }
            case STROKE_COLOR: {
                CanvasGraphicsState gState = (CanvasGraphicsState)obj;
                this.checkColor(gState, gState.getStrokeColor(), currentColorSpaces, false, contentStream);
                break;
            }
            case TAG_STRUCTURE_ELEMENT: {
                this.checkTagStructureElement((PdfObject)obj);
                break;
            }
            case FONT_GLYPHS: {
                this.checkFontGlyphs(((CanvasGraphicsState)obj).getFont(), contentStream);
                break;
            }
            case XREF_TABLE: {
                this.checkXrefTable((PdfXrefTable)obj);
                break;
            }
            case SIGNATURE: {
                this.checkSignature((PdfDictionary)obj);
                break;
            }
            case SIGNATURE_TYPE: {
                this.checkSignatureType((Boolean)obj);
                break;
            }
            case CRYPTO: {
                this.checkCrypto((PdfObject)obj);
                break;
            }
            case FONT: {
                this.checkText((String)obj, (PdfFont)extra);
            }
        }
    }

    public void checkSinglePage(PdfPage page) {
        this.checkPage(page);
    }

    public void checkPdfObject(PdfObject obj) {
        switch (obj.getType()) {
            case 6: {
                this.checkPdfName((PdfName)obj);
                break;
            }
            case 8: {
                this.checkPdfNumber((PdfNumber)obj);
                break;
            }
            case 10: {
                this.checkPdfString((PdfString)obj);
                break;
            }
            case 1: {
                PdfArray array = (PdfArray)obj;
                this.checkPdfArray(array);
                this.checkArrayRecursively(array);
                break;
            }
            case 3: {
                PdfDictionary dict = (PdfDictionary)obj;
                PdfName type = dict.getAsName(PdfName.Type);
                if (PdfName.Filespec.equals((Object)type)) {
                    this.checkFileSpec(dict);
                }
                this.checkPdfDictionary(dict);
                this.checkDictionaryRecursively(dict);
                break;
            }
            case 9: {
                PdfStream stream = (PdfStream)obj;
                this.checkPdfStream(stream);
                this.checkDictionaryRecursively((PdfDictionary)stream);
            }
        }
    }

    public PdfAConformanceLevel getConformanceLevel() {
        return this.conformanceLevel;
    }

    public boolean isFullCheckMode() {
        return this.fullCheckMode;
    }

    public void setFullCheckMode(boolean fullCheckMode) {
        this.fullCheckMode = fullCheckMode;
    }

    public boolean objectIsChecked(PdfObject object) {
        return this.checkedObjects.contains(object);
    }

    public void checkTagStructureElement(PdfObject obj) {
        this.checkedObjects.add(obj);
    }

    public void checkSignature(PdfDictionary signatureDict) {
        this.checkedObjects.add((PdfObject)signatureDict);
    }

    @Deprecated
    public void checkSignatureType(boolean isCAdES) {
    }

    public abstract void checkCanvasStack(char var1);

    public abstract void checkInlineImage(PdfStream var1, PdfDictionary var2);

    @Deprecated
    public abstract void checkColor(Color var1, PdfDictionary var2, Boolean var3, PdfStream var4);

    @Deprecated
    public void checkColor(CanvasGraphicsState gState, Color color, PdfDictionary currentColorSpaces, Boolean fill, PdfStream contentStream) {
    }

    @Deprecated
    public void checkColorSpace(PdfColorSpace colorSpace, PdfObject pdfObject, PdfDictionary currentColorSpaces, boolean checkAlternate, Boolean fill) {
    }

    @Deprecated
    public void checkColorSpace(PdfColorSpace colorSpace, PdfDictionary currentColorSpaces, boolean checkAlternate, Boolean fill) {
        this.checkColorSpace(colorSpace, null, currentColorSpaces, checkAlternate, fill);
    }

    public void setPdfAOutputIntentColorSpace(PdfDictionary catalog) {
        PdfArray outputIntents = catalog.getAsArray(PdfName.OutputIntents);
        if (outputIntents == null) {
            return;
        }
        PdfDictionary pdfAOutputIntent = this.getPdfAOutputIntent(outputIntents);
        this.setCheckerOutputIntent(pdfAOutputIntent);
    }

    public abstract void checkRenderingIntent(PdfName var1);

    public abstract void checkFontGlyphs(PdfFont var1, PdfStream var2);

    public abstract void checkExtGState(CanvasGraphicsState var1, PdfStream var2);

    public abstract void checkFont(PdfFont var1);

    public abstract void checkXrefTable(PdfXrefTable var1);

    @Deprecated
    public void checkCrypto(PdfObject crypto) {
    }

    @Deprecated
    public void checkText(String text, PdfFont font) {
    }

    protected abstract void checkContentStream(PdfStream var1);

    protected void checkContentStreamObject(PdfObject object) {
        byte type = object.getType();
        switch (type) {
            case 6: {
                this.checkPdfName((PdfName)object);
                break;
            }
            case 10: {
                this.checkPdfString((PdfString)object);
                break;
            }
            case 8: {
                this.checkPdfNumber((PdfNumber)object);
                break;
            }
            case 1: {
                PdfArray array = (PdfArray)object;
                this.checkPdfArray(array);
                for (PdfObject obj : array) {
                    this.checkContentStreamObject(obj);
                }
                break;
            }
            case 3: {
                PdfDictionary dictionary = (PdfDictionary)object;
                this.checkPdfDictionary(dictionary);
                for (PdfName name : dictionary.keySet()) {
                    this.checkPdfName(name);
                    this.checkPdfObject(dictionary.get(name, false));
                }
                for (PdfObject obj : dictionary.values()) {
                    this.checkContentStreamObject(obj);
                }
                break;
            }
        }
    }

    protected abstract long getMaxNumberOfIndirectObjects();

    protected abstract Set<PdfName> getForbiddenActions();

    protected abstract Set<PdfName> getAllowedNamedActions();

    protected abstract void checkAction(PdfDictionary var1);

    protected abstract void checkAnnotation(PdfDictionary var1);

    protected abstract void checkCatalogValidEntries(PdfDictionary var1);

    @Deprecated
    protected abstract void checkColorsUsages();

    @Deprecated
    protected void checkPageColorsUsages(PdfDictionary pageDict, PdfDictionary pageResources) {
    }

    protected abstract void checkImage(PdfStream var1, PdfDictionary var2);

    protected abstract void checkFileSpec(PdfDictionary var1);

    protected abstract void checkForm(PdfDictionary var1);

    protected abstract void checkFormXObject(PdfStream var1);

    protected abstract void checkLogicalStructure(PdfDictionary var1);

    protected abstract void checkMetaData(PdfDictionary var1);

    protected abstract void checkNonSymbolicTrueTypeFont(PdfTrueTypeFont var1);

    protected abstract void checkOutputIntents(PdfDictionary var1);

    protected abstract void checkPageObject(PdfDictionary var1, PdfDictionary var2);

    protected abstract void checkPageSize(PdfDictionary var1);

    protected abstract void checkPdfArray(PdfArray var1);

    protected abstract void checkPdfDictionary(PdfDictionary var1);

    protected abstract void checkPdfName(PdfName var1);

    protected abstract void checkPdfNumber(PdfNumber var1);

    protected abstract void checkPdfStream(PdfStream var1);

    protected abstract void checkPdfString(PdfString var1);

    protected abstract void checkSymbolicTrueTypeFont(PdfTrueTypeFont var1);

    protected abstract void checkTrailer(PdfDictionary var1);

    @Deprecated
    protected void checkCatalog(PdfCatalog catalog) {
    }

    protected abstract void checkPageTransparency(PdfDictionary var1, PdfDictionary var2);

    @Deprecated
    protected void checkResources(PdfDictionary resources) {
        this.checkResources(resources, null);
    }

    protected void checkResources(PdfDictionary resources, PdfObject pdfObject) {
        if (resources == null) {
            return;
        }
        PdfDictionary xObjects = resources.getAsDictionary(PdfName.XObject);
        PdfDictionary shadings = resources.getAsDictionary(PdfName.Shading);
        PdfDictionary patterns = resources.getAsDictionary(PdfName.Pattern);
        if (xObjects != null) {
            for (PdfObject xObject : xObjects.values()) {
                PdfStream xObjStream = (PdfStream)xObject;
                PdfObject subtype = null;
                boolean isFlushed = xObjStream.isFlushed();
                if (!isFlushed) {
                    subtype = xObjStream.get(PdfName.Subtype);
                }
                if (PdfName.Image.equals(subtype) || isFlushed) {
                    this.checkImage(xObjStream, resources.getAsDictionary(PdfName.ColorSpace));
                    continue;
                }
                if (!PdfName.Form.equals((Object)subtype)) continue;
                this.checkFormXObject(xObjStream);
            }
        }
        if (shadings != null) {
            for (PdfObject shading : shadings.values()) {
                PdfDictionary shadingDict = (PdfDictionary)shading;
                if (this.isAlreadyChecked(shadingDict)) continue;
                this.checkColorSpace(PdfColorSpace.makeColorSpace((PdfObject)shadingDict.get(PdfName.ColorSpace)), pdfObject, resources.getAsDictionary(PdfName.ColorSpace), true, null);
            }
        }
        if (patterns != null) {
            for (PdfObject p : patterns.values()) {
                PdfStream pStream;
                if (!p.isStream() || this.isAlreadyChecked((PdfDictionary)(pStream = (PdfStream)p))) continue;
                this.checkResources(pStream.getAsDictionary(PdfName.Resources), pdfObject);
            }
        }
    }

    protected static boolean checkFlag(int flags, int flag) {
        return (flags & flag) != 0;
    }

    protected static boolean checkStructure(PdfAConformanceLevel conformanceLevel) {
        return conformanceLevel == PdfAConformanceLevel.PDF_A_1A || conformanceLevel == PdfAConformanceLevel.PDF_A_2A || conformanceLevel == PdfAConformanceLevel.PDF_A_3A;
    }

    protected static boolean isContainsTransparencyGroup(PdfDictionary dictionary) {
        return dictionary.containsKey(PdfName.Group) && PdfName.Transparency.equals((Object)dictionary.getAsDictionary(PdfName.Group).getAsName(PdfName.S));
    }

    protected boolean isAlreadyChecked(PdfDictionary dictionary) {
        if (this.checkedObjects.contains(dictionary)) {
            return true;
        }
        this.checkedObjects.add((PdfObject)dictionary);
        return false;
    }

    protected void checkResourcesOfAppearanceStreams(PdfDictionary appearanceStreamsDict) {
        this.checkResourcesOfAppearanceStreams(appearanceStreamsDict, new HashSet<PdfObject>());
    }

    protected void checkAppearanceStream(PdfStream appearanceStream) {
        if (this.isAlreadyChecked((PdfDictionary)appearanceStream)) {
            return;
        }
        this.checkResources(appearanceStream.getAsDictionary(PdfName.Resources), (PdfObject)appearanceStream);
    }

    PdfDictionary getPdfAOutputIntent(PdfArray outputIntents) {
        for (int i = 0; i < outputIntents.size(); ++i) {
            PdfName outputIntentSubtype = outputIntents.getAsDictionary(i).getAsName(PdfName.S);
            if (!PdfName.GTS_PDFA1.equals((Object)outputIntentSubtype)) continue;
            return outputIntents.getAsDictionary(i);
        }
        return null;
    }

    private void checkResourcesOfAppearanceStreams(PdfDictionary appearanceStreamsDict, Set<PdfObject> checkedObjects) {
        if (checkedObjects.contains(appearanceStreamsDict)) {
            return;
        }
        checkedObjects.add((PdfObject)appearanceStreamsDict);
        for (PdfObject val : appearanceStreamsDict.values()) {
            if (!(val instanceof PdfDictionary)) continue;
            PdfDictionary ap = (PdfDictionary)val;
            if (ap.isDictionary()) {
                this.checkResourcesOfAppearanceStreams(ap, checkedObjects);
                continue;
            }
            if (!ap.isStream()) continue;
            this.checkAppearanceStream((PdfStream)ap);
        }
    }

    private void checkArrayRecursively(PdfArray array) {
        for (int i = 0; i < array.size(); ++i) {
            PdfObject object = array.get(i, false);
            if (object == null || object.isIndirect()) continue;
            this.checkPdfObject(object);
        }
    }

    private void checkDictionaryRecursively(PdfDictionary dictionary) {
        for (PdfName name : dictionary.keySet()) {
            this.checkPdfName(name);
            PdfObject object = dictionary.get(name, false);
            if (object == null || object.isIndirect()) continue;
            this.checkPdfObject(object);
        }
    }

    private void checkPages(PdfDocument document) {
        for (int i = 1; i <= document.getNumberOfPages(); ++i) {
            this.checkPage(document.getPage(i));
        }
    }

    private void checkPage(PdfPage page) {
        PdfDictionary pageDict = (PdfDictionary)page.getPdfObject();
        if (this.isAlreadyChecked(pageDict)) {
            return;
        }
        this.checkPageObject(pageDict, (PdfDictionary)page.getResources().getPdfObject());
        PdfDictionary pageResources = (PdfDictionary)page.getResources().getPdfObject();
        this.checkResources(pageResources, (PdfObject)pageDict);
        this.checkAnnotations(pageDict);
        this.checkPageSize(pageDict);
        this.checkPageTransparency(pageDict, (PdfDictionary)page.getResources().getPdfObject());
        this.checkPageColorsUsages(pageDict, (PdfDictionary)page.getResources().getPdfObject());
        this.checkOutputIntents(pageDict);
        int contentStreamCount = page.getContentStreamCount();
        for (int j = 0; j < contentStreamCount; ++j) {
            PdfStream contentStream = page.getContentStream(j);
            this.checkContentStream(contentStream);
            this.checkedObjects.add((PdfObject)contentStream);
        }
    }

    private void checkOpenAction(PdfObject openAction) {
        if (openAction != null && openAction.isDictionary()) {
            this.checkAction((PdfDictionary)openAction);
        }
    }

    private void checkAnnotations(PdfDictionary page) {
        PdfArray annots = page.getAsArray(PdfName.Annots);
        if (annots != null) {
            for (int i = 0; i < annots.size(); ++i) {
                PdfDictionary annot = annots.getAsDictionary(i);
                this.checkAnnotation(annot);
                PdfDictionary action = annot.getAsDictionary(PdfName.A);
                if (action == null) continue;
                this.checkAction(action);
            }
        }
    }

    private void checkOutlines(PdfOutline outline) {
        if (outline != null) {
            PdfDictionary action = outline.getContent().getAsDictionary(PdfName.A);
            if (action != null) {
                this.checkAction(action);
            }
            for (PdfOutline child : outline.getAllChildren()) {
                this.checkOutlines(child);
            }
        }
    }

    private void setCheckerOutputIntent(PdfDictionary outputIntent) {
        if (outputIntent != null) {
            this.pdfAOutputIntentDestProfile = outputIntent.getAsStream(PdfName.DestOutputProfile);
            if (this.pdfAOutputIntentDestProfile != null) {
                String intentCS;
                this.pdfAOutputIntentColorSpace = intentCS = IccProfile.getIccColorSpaceName((byte[])this.pdfAOutputIntentDestProfile.getBytes());
            }
        }
    }
}

