/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.signatures.DigestAlgorithms;
import com.itextpdf.signatures.IApplicableSignatureParams;
import com.itextpdf.signatures.IExternalSignature;
import com.itextpdf.signatures.ISignatureMechanismParams;
import com.itextpdf.signatures.RSASSAPSSMechanismParams;
import com.itextpdf.signatures.SignUtils;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;

public class PrivateKeySignature
implements IExternalSignature {
    private final PrivateKey pk;
    private final String hashAlgorithm;
    private final String signatureAlgorithm;
    private final String provider;
    private final IApplicableSignatureParams parameters;

    public PrivateKeySignature(PrivateKey pk, String hashAlgorithm, String provider) {
        this(pk, hashAlgorithm, null, provider, null);
    }

    public PrivateKeySignature(PrivateKey pk, String hashAlgorithm, String signatureAlgorithm, String provider, IApplicableSignatureParams params) {
        this.pk = pk;
        this.provider = provider;
        String digestAlgorithmOid = DigestAlgorithms.getAllowedDigest(hashAlgorithm);
        this.hashAlgorithm = DigestAlgorithms.getDigest(digestAlgorithmOid);
        String adjustedSignatureAlgorithm = signatureAlgorithm == null ? SignUtils.getPrivateKeyAlgorithm(pk) : signatureAlgorithm;
        this.signatureAlgorithm = "RSA/PSS".equals(adjustedSignatureAlgorithm) ? "RSASSA-PSS" : adjustedSignatureAlgorithm;
        switch (this.signatureAlgorithm) {
            case "Ed25519": {
                if (!"2.16.840.1.101.3.4.2.3".equals(digestAlgorithmOid)) {
                    throw new PdfException("{0} requires the document to be digested using {1}, not {2}").setMessageParams(new Object[]{"Ed25519", "SHA-512", this.hashAlgorithm});
                }
                this.parameters = null;
                break;
            }
            case "Ed448": {
                if (!"2.16.840.1.101.3.4.2.12".equals(digestAlgorithmOid)) {
                    throw new PdfException("{0} requires the document to be digested using {1}, not {2}").setMessageParams(new Object[]{"Ed448", "512-bit SHAKE256", this.hashAlgorithm});
                }
                this.parameters = null;
                break;
            }
            case "EdDSA": {
                throw new IllegalArgumentException("Key algorithm of EdDSA PrivateKey instance provided by " + pk.getClass() + " is not clear. Expected Ed25519 or Ed448, but got EdDSA. Try a different security provider.");
            }
            case "RSASSA-PSS": {
                if (params != null && !(params instanceof RSASSAPSSMechanismParams)) {
                    throw new IllegalArgumentException("Expected RSASSA-PSS parameters; got " + params);
                }
                if (params == null) {
                    this.parameters = RSASSAPSSMechanismParams.createForDigestAlgorithm(hashAlgorithm);
                    break;
                }
                this.parameters = params;
                break;
            }
            default: {
                this.parameters = null;
            }
        }
    }

    @Override
    public String getDigestAlgorithmName() {
        return this.hashAlgorithm;
    }

    @Override
    public String getSignatureAlgorithmName() {
        return this.signatureAlgorithm;
    }

    @Override
    public ISignatureMechanismParams getSignatureMechanismParameters() {
        return this.parameters;
    }

    @Override
    public byte[] sign(byte[] message) throws GeneralSecurityException {
        String algorithm = this.getSignatureMechanismName();
        try {
            Signature sig = SignUtils.getSignatureHelper(algorithm, this.provider);
            if (this.parameters != null) {
                this.parameters.apply(sig);
            }
            sig.initSign(this.pk);
            sig.update(message);
            return sig.sign();
        }
        catch (Exception ignored) {
            try {
                Signature sig = SignUtils.getSignatureHelper(this.getSignatureAlgorithmName(), this.provider);
                if (this.parameters != null) {
                    this.parameters.apply(sig);
                }
                sig.initSign(this.pk);
                sig.update(message);
                return sig.sign();
            }
            catch (Exception e) {
                throw new PdfException(MessageFormatUtil.format((String)"Signing algorithms {0} and {1} are not supported.", (Object[])new Object[]{algorithm, this.getSignatureAlgorithmName()}), (Throwable)e);
            }
        }
    }

    private String getSignatureMechanismName() {
        String signatureAlgo = this.getSignatureAlgorithmName();
        if ("RSASSA-PSS".equals(signatureAlgo)) {
            return signatureAlgo;
        }
        return this.getDigestAlgorithmName() + "with" + this.getSignatureAlgorithmName();
    }
}

