/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplejmx.client;

import java.lang.reflect.Constructor;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientUtils {
    public static Object stringToParam(String string, String typeString) throws IllegalArgumentException {
        if (typeString.equals("boolean") || typeString.equals("java.lang.Boolean")) {
            return Boolean.parseBoolean(string);
        }
        if (typeString.equals("char") || typeString.equals("java.lang.Character")) {
            if (string.length() == 0) {
                return Character.valueOf('\u0000');
            }
            return Character.valueOf(string.toCharArray()[0]);
        }
        if (typeString.equals("byte") || typeString.equals("java.lang.Byte")) {
            return Byte.parseByte(string);
        }
        if (typeString.equals("short") || typeString.equals("java.lang.Short")) {
            return Short.parseShort(string);
        }
        if (typeString.equals("int") || typeString.equals("java.lang.Integer")) {
            return Integer.parseInt(string);
        }
        if (typeString.equals("long") || typeString.equals("java.lang.Long")) {
            return Long.parseLong(string);
        }
        if (typeString.equals("java.lang.String")) {
            return string;
        }
        if (typeString.equals("float") || typeString.equals("java.lang.Float")) {
            return Float.valueOf(Float.parseFloat(string));
        }
        if (typeString.equals("double") || typeString.equals("java.lang.Double")) {
            return Double.parseDouble(string);
        }
        Constructor constr = ClientUtils.getConstructor(typeString);
        try {
            return constr.newInstance(string);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not get new instance using string constructor for type " + typeString);
        }
    }

    public static String valueToString(Object value) {
        if (value == null) {
            return "null";
        }
        if (!value.getClass().isArray()) {
            return value.toString();
        }
        if (value instanceof boolean[]) {
            return Arrays.toString((boolean[])value);
        }
        if (value instanceof byte[]) {
            return Arrays.toString((byte[])value);
        }
        if (value instanceof char[]) {
            return Arrays.toString((char[])value);
        }
        if (value instanceof short[]) {
            return Arrays.toString((short[])value);
        }
        if (value instanceof int[]) {
            return Arrays.toString((int[])value);
        }
        if (value instanceof long[]) {
            return Arrays.toString((long[])value);
        }
        if (value instanceof float[]) {
            return Arrays.toString((float[])value);
        }
        if (value instanceof double[]) {
            return Arrays.toString((double[])value);
        }
        return Arrays.toString((Object[])value);
    }

    public static String displayType(String className, Object value) {
        if (className == null) {
            return null;
        }
        boolean array = false;
        if (className.equals("[J")) {
            array = true;
            className = value == null ? "" : (value instanceof boolean[] ? "boolean" : (value instanceof byte[] ? "byte" : (value instanceof char[] ? "char" : (value instanceof short[] ? "short" : (value instanceof int[] ? "int" : (value instanceof long[] ? "long" : (value instanceof float[] ? "float" : (value instanceof double[] ? "double" : className.substring(2, className.length() - 1)))))))));
        } else if (className.startsWith("[L")) {
            className = className.substring(2, className.length() - 1);
        }
        if (className.startsWith("java.lang.")) {
            className = className.substring(10);
        } else if (className.startsWith("javax.management.openmbean.")) {
            className = className.substring(27);
        }
        if (array) {
            return "array of " + className;
        }
        return className;
    }

    private static <C> Constructor<C> getConstructor(String typeString) throws IllegalArgumentException {
        Class<?> clazz;
        try {
            Class<?> clazzCast;
            clazz = clazzCast = Class.forName(typeString);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unknown class for type " + typeString);
        }
        try {
            Constructor<?> constructor = clazz.getConstructor(String.class);
            return constructor;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not find constructor with single String argument for " + clazz);
        }
    }
}

