/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplejmx.client;

import com.j256.simplejmx.client.JmxClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class CommandLineJmxClient {
    private static final String HELP_COMMAND = "help";
    private static final String DEFAULT_PROMPT = "Jmx: ";
    private JmxClient jmxClient;

    public CommandLineJmxClient(JmxClient jmxClient) {
        this.jmxClient = jmxClient;
    }

    public CommandLineJmxClient(int port) throws JMException {
        this.jmxClient = new JmxClient(port);
    }

    public CommandLineJmxClient(String host, int port) throws JMException {
        this.jmxClient = new JmxClient(host, port);
    }

    public CommandLineJmxClient(String jmxUrl) throws JMException {
        this.jmxClient = new JmxClient(jmxUrl);
    }

    public void runCommands(final String[] commands) throws IOException {
        this.doLines(0, new LineReader(){
            private int commandC = 0;

            public String getNextLine(String prompt) {
                if (this.commandC >= commands.length) {
                    return null;
                }
                return commands[this.commandC++];
            }
        }, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBatchFile(File batchFile) throws IOException {
        final BufferedReader reader = new BufferedReader(new FileReader(batchFile));
        try {
            this.doLines(0, new LineReader(){

                public String getNextLine(String prompt) throws IOException {
                    return reader.readLine();
                }
            }, true);
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runCommandLine() throws IOException {
        final BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        try {
            System.out.println("Running jmx client interface.  Type 'help' for help.");
            this.doLines(0, new LineReader(){

                public String getNextLine(String prompt) throws IOException {
                    System.out.print(prompt);
                    System.out.flush();
                    return reader.readLine();
                }
            }, false);
        }
        finally {
            reader.close();
        }
    }

    public void close() {
        if (this.jmxClient != null) {
            this.jmxClient.close();
            this.jmxClient = null;
        }
    }

    private void doLines(int levelC, LineReader lineReader, boolean batch) throws IOException {
        String line;
        if (levelC > 20) {
            System.out.print("Ignoring possible recursion after including 20 times");
            return;
        }
        while ((line = lineReader.getNextLine(DEFAULT_PROMPT)) != null) {
            String[] lineParts;
            String command;
            if (line.length() == 0 || line.startsWith("#") || line.startsWith("//")) continue;
            if (batch) {
                System.out.println("> " + line);
            }
            if ((command = (lineParts = line.split(" "))[0]).startsWith(HELP_COMMAND)) {
                this.helpOutput();
                continue;
            }
            if (command.startsWith("objects")) {
                this.listBeans(lineParts);
                continue;
            }
            if (command.startsWith("run")) {
                if (lineParts.length == 2) {
                    this.runScript(lineParts[1], levelC);
                    continue;
                }
                System.out.println("Error.  Usage: run script");
                continue;
            }
            if (command.startsWith("attrs")) {
                this.listAttributes(lineParts);
                continue;
            }
            if (command.startsWith("get")) {
                if (lineParts.length == 2) {
                    this.getAttributes(lineParts);
                    continue;
                }
                this.getAttribute(lineParts);
                continue;
            }
            if (command.startsWith("set")) {
                this.setAttribute(lineParts);
                continue;
            }
            if (command.startsWith("opers") || command.startsWith("ops")) {
                this.listOperations(lineParts);
                continue;
            }
            if (command.startsWith("dolines")) {
                this.invokeOperationLines(lineReader, lineParts, batch);
                continue;
            }
            if (command.startsWith("do")) {
                this.invokeOperation(lineParts);
                continue;
            }
            if (command.startsWith("sleep")) {
                if (lineParts.length == 2) {
                    try {
                        Thread.sleep(Long.parseLong(lineParts[1]));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Error.  Usage: sleep millis, invalid millis number '" + lineParts[1] + "'");
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                System.out.println("Error.  Usage: sleep millis");
                continue;
            }
            if (command.startsWith("examples")) {
                this.exampleOutput();
                continue;
            }
            if (command.startsWith("quit")) break;
            System.out.println("Error.  Unknown command.  Type 'help' for help: " + command);
        }
    }

    private void helpOutput() {
        System.out.println("objects [regex] -  list object-names exposed by JMX");
        System.out.println("run script  -  execute a script from a file path");
        System.out.println("help  -  output this information");
        System.out.println("examples  -  examples on how to use this utility");
        System.out.println("sleep millis  -  sleep for a certain nunber of milliseconds (for scripts)");
        System.out.println("quit  -  quit this application");
        System.out.println("");
        System.out.println("attrs object-name  -  list the attributes associated with the object-name");
        System.out.println("get object-name  -  get all values associated with this attribute");
        System.out.println("get object-name attr  -  output the value associated with this attribute");
        System.out.println("set object-name attr val  -  set the value associated with this attribute");
        System.out.println("ops object-name  -  list the operations associated with the bean");
        System.out.println("do object-name oper arg1 arg2 ... -  invoke this method name with variable number of args");
        System.out.println("dolines object-name oper -  invoke method name, args on next line(s), end with blank");
    }

    private void exampleOutput() {
        System.out.println("");
        System.out.println("To use this utility you can do something like the following:");
        System.out.println("# list the objects published by the server");
        System.out.println("Jmx: objects");
        System.out.println("  ...");
        System.out.println("# list the objects with a regex filter");
        System.out.println("Jmx: objects java.lang");
        System.out.println("  ...");
        System.out.println("  java.lang:type=Memory");
        System.out.println("  ...");
        System.out.println("# show the attributes published by an object");
        System.out.println("Jmx: attrs java.lang:type=Memory");
        System.out.println("  ...");
        System.out.println("# Verbose is attribute name, supports get/set");
        System.out.println("  Verbose(get, set boolean)");
        System.out.println("  ...");
        System.out.println("# get all attributes from an object");
        System.out.println("Jmx: get java.lang:type=Memory");
        System.out.println("  ...");
        System.out.println("  get Verbose in 20ms = false");
        System.out.println("  ...");
        System.out.println("# get just the Verbose value");
        System.out.println("Jmx: get java.lang:type=Memory Verbose");
        System.out.println("  get Verbose in 20ms = false");
        System.out.println("# set the Verbose value");
        System.out.println("Jmx: set java.lang:type=Memory Verbose true");
        System.out.println("  Attribute java.lang:type=Memory set to false");
        System.out.println("# show the available operations for an object");
        System.out.println("Jmx: ops java.lang:type=Memory");
        System.out.println(" void gc()");
        System.out.println("# issue the gc command, any arguments are space seperated after the gc");
        System.out.println("Jmx: do java.lang:type=Memory gc");
        System.out.println(" do gc in 1077ms = null");
        System.out.println("# issue the gc command, but this time arguments on lines after the command");
        System.out.println("# this allows args with spaces");
        System.out.println("Jmx: dolines java.lang:type=Memory gc");
        System.out.println("Enter args for gc, end with blank line");
        System.out.println("args: ");
        System.out.println(" dolines gc in 984ms = null");
        System.out.println("Jmx: quit");
        System.out.println("");
    }

    private void listBeans(String[] args) {
        Set<ObjectName> objectNames;
        try {
            objectNames = this.jmxClient.getBeanNames();
        }
        catch (Exception e) {
            System.out.println("Error.  Problems getting bean names information: " + e.getMessage());
            return;
        }
        ArrayList<String> names = new ArrayList<String>();
        Pattern[] patterns = null;
        if (args.length > 1) {
            patterns = new Pattern[args.length - 1];
            for (int i = 1; i < args.length; ++i) {
                patterns[i - 1] = Pattern.compile("(?i).*" + args[i] + ".*");
            }
        }
        block3: for (ObjectName objectName : objectNames) {
            String name = objectName.getCanonicalName();
            if (patterns != null) {
                for (Pattern pattern : patterns) {
                    if (!pattern.matcher(name).matches()) continue block3;
                }
            }
            names.add(name);
        }
        Collections.sort(names);
        for (String name : names) {
            System.out.println("  " + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runScript(String alias, int levelC) throws IOException {
        InputStream stream;
        String scriptFile = alias;
        try {
            stream = this.getInputStream(scriptFile);
            if (stream == null) {
                System.out.println("Error.  Script file is not found: " + scriptFile);
                return;
            }
        }
        catch (IOException e) {
            System.out.println("Error.  Could not load script file " + scriptFile + ": " + e.getMessage());
            return;
        }
        final BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        try {
            this.doLines(levelC + 1, new LineReader(){

                public String getNextLine(String prompt) throws IOException {
                    return reader.readLine();
                }
            }, true);
        }
        finally {
            reader.close();
        }
    }

    private void listAttributes(String[] parts) {
        MBeanAttributeInfo[] attrs;
        ObjectName currentName = this.getObjectName("attrs", parts);
        if (currentName == null) {
            return;
        }
        try {
            attrs = this.jmxClient.getAttributesInfo(currentName);
        }
        catch (Exception e) {
            System.out.println("Error.  Problems getting information about " + currentName + ": " + e.getMessage());
            return;
        }
        for (MBeanAttributeInfo info : attrs) {
            StringBuilder infoString = new StringBuilder();
            infoString.append("  ").append(info.getName());
            infoString.append("(");
            boolean comma = false;
            if (info.isReadable()) {
                infoString.append("get");
                comma = true;
            }
            if (info.isWritable()) {
                if (comma) {
                    infoString.append(", ");
                }
                infoString.append("set ").append(info.getType());
                comma = true;
            }
            infoString.append(")");
            System.out.println(infoString.toString());
        }
    }

    private void getAttribute(String[] parts) {
        ObjectName currentName = this.getObjectName("get", parts);
        if (currentName == null) {
            return;
        }
        if (parts.length != 3) {
            System.out.println("Error.  Usage: get objectName [attr]");
            return;
        }
        try {
            long start = System.currentTimeMillis();
            Object value = this.jmxClient.getAttribute(currentName, parts[2]);
            this.displayValue("get", parts[2], value, System.currentTimeMillis() - start);
        }
        catch (Exception e) {
            System.out.println("Error.  Problems getting attribute: " + e.getMessage());
            return;
        }
    }

    private void getAttributes(String[] parts) {
        MBeanAttributeInfo[] attrs;
        ObjectName currentName = this.getObjectName("get", parts);
        if (currentName == null) {
            return;
        }
        try {
            attrs = this.jmxClient.getAttributesInfo(currentName);
        }
        catch (Exception e) {
            System.out.println("Error.  Problems getting bean information from " + currentName + ": " + e.getMessage());
            return;
        }
        long start = System.currentTimeMillis();
        Object[] output = new Object[attrs.length];
        for (int i = 0; i < attrs.length; ++i) {
            try {
                output[i] = this.jmxClient.getAttribute(currentName, attrs[i].getName());
                continue;
            }
            catch (Exception e) {
                System.out.println("Error.  Problems getting attribute data " + currentName + " bean " + attrs[i].getName() + ": " + e.getMessage());
                output[i] = "(error)";
            }
        }
        long millis = System.currentTimeMillis() - start;
        for (int i = 0; i < attrs.length; ++i) {
            this.displayValue("get", attrs[i].getName(), output[i], millis);
        }
    }

    private void setAttribute(String[] parts) {
        Object attr;
        ObjectName currentName = this.getObjectName("set", parts);
        if (currentName == null) {
            return;
        }
        if (parts.length < 4) {
            System.out.println("Error.  Usage: set objectName attr value");
            return;
        }
        String attrName = parts[2];
        StringBuilder sb = new StringBuilder();
        for (int partC = 3; partC < parts.length; ++partC) {
            if (partC > 3) {
                sb.append(' ');
            }
            sb.append(parts[partC]);
        }
        String valueString = sb.toString();
        try {
            this.jmxClient.setAttribute(currentName, attrName, valueString);
        }
        catch (Exception e) {
            System.out.println("Error.  Problems setting information about attribute: " + e.getMessage());
            return;
        }
        try {
            attr = this.jmxClient.getAttribute(currentName, attrName);
        }
        catch (Exception e) {
            System.out.println("Error.  Problems setting information about attribute: " + e.getMessage());
            return;
        }
        if (attr.toString().equals(valueString)) {
            System.out.println("  Attribute " + parts[1] + " set to " + valueString);
        } else {
            System.out.println("Error.  Set attribute " + parts[1] + " to " + valueString + " but new value is " + attr);
        }
    }

    private void listOperations(String[] parts) {
        MBeanOperationInfo[] opers;
        ObjectName currentName = this.getObjectName("opers", parts);
        if (currentName == null) {
            return;
        }
        if (parts.length != 2) {
            System.out.println("Error.  Usage: ops objectName");
            return;
        }
        try {
            opers = this.jmxClient.getOperationsInfo(currentName);
        }
        catch (Exception e) {
            System.out.println("Error.  Problems getting information about name: " + e.getMessage());
            return;
        }
        for (MBeanOperationInfo info : opers) {
            System.out.print("  " + info.getReturnType() + " " + info.getName() + "(");
            boolean first = true;
            for (MBeanParameterInfo param : info.getSignature()) {
                if (first) {
                    first = false;
                } else {
                    System.out.print(", ");
                }
                System.out.print(param.getType());
            }
            System.out.println(")");
        }
    }

    private void invokeOperation(String[] parts) {
        ObjectName currentName = this.getObjectName("do", parts);
        if (currentName == null) {
            return;
        }
        if (parts.length < 3) {
            System.out.println("Error.  Usage: do objectName operation [arg1] [arg2] ...");
            return;
        }
        String[] args = new String[parts.length - 3];
        for (int argC = 3; argC < parts.length; ++argC) {
            args[argC - 3] = parts[argC];
        }
        this.invokeJmx("do", currentName, parts[2], args);
    }

    private void invokeOperationLines(LineReader lineReader, String[] parts, boolean batch) throws IOException {
        String line;
        ObjectName currentName = this.getObjectName("dolines", parts);
        if (currentName == null) {
            return;
        }
        if (parts.length < 3) {
            System.out.println("Error.  Usage: dolines objectName operation");
            return;
        }
        if (!batch) {
            System.out.println("Enter args for " + parts[2] + ", end with blank line");
        }
        ArrayList<String> argList = new ArrayList<String>();
        while ((line = batch ? lineReader.getNextLine(null) : lineReader.getNextLine("args: ")) != null && line.length() != 0) {
            if (batch) {
                System.out.println(">>> " + line);
            }
            argList.add(line);
        }
        String[] args = argList.toArray(new String[argList.size()]);
        this.invokeJmx("dolines", currentName, parts[2], args);
    }

    private void invokeJmx(String command, ObjectName currentName, String oper, String[] args) {
        try {
            long start = System.currentTimeMillis();
            Object value = this.jmxClient.invokeOperation(currentName, oper, args);
            this.displayValue(command, oper, value, System.currentTimeMillis() - start);
        }
        catch (Exception e) {
            System.out.println("Error.  Problems invoking operation " + oper + ":");
            for (Throwable y = e; y != null; y = y.getCause()) {
                System.out.println("  " + y);
            }
        }
    }

    private ObjectName getObjectName(String command, String[] parts) {
        if (parts.length < 2) {
            System.out.println("Error.  Usage: " + command + " objectName [...]");
            return null;
        }
        try {
            return new ObjectName(parts[1]);
        }
        catch (MalformedObjectNameException e) {
            System.out.println("Error.  Invalid object name: " + parts[1]);
            return null;
        }
    }

    private void displayValue(String action, String what, Object value, long millis) {
        this.displayValue(value, "  ", action + " '" + what + "' in " + millis + "ms");
    }

    private void displayValue(Object value, String indent, String prefix) {
        System.out.print(indent);
        System.out.print(prefix);
        if (value == null) {
            System.out.println(" = null");
            return;
        }
        Class<?> clazz = value.getClass();
        if (!clazz.isArray()) {
            System.out.println(" = " + value.toString());
            return;
        }
        System.out.println(" is a " + clazz.getSimpleName() + " array:");
        if (clazz == byte[].class) {
            byte[] array = (byte[])value;
            for (int arrayC = 0; arrayC < array.length; ++arrayC) {
                this.displayValue(array[arrayC], indent + "  ", "[" + arrayC + "]");
            }
        } else if (clazz == short[].class) {
            short[] array = (short[])value;
            for (int arrayC = 0; arrayC < array.length; ++arrayC) {
                this.displayValue(array[arrayC], indent + "  ", "[" + arrayC + "]");
            }
        } else if (clazz == int[].class) {
            int[] array = (int[])value;
            for (int arrayC = 0; arrayC < array.length; ++arrayC) {
                this.displayValue(array[arrayC], indent + "  ", "[" + arrayC + "]");
            }
        } else if (clazz == long[].class) {
            long[] array = (long[])value;
            for (int arrayC = 0; arrayC < array.length; ++arrayC) {
                this.displayValue(array[arrayC], indent + "  ", "[" + arrayC + "]");
            }
        } else if (clazz == boolean[].class) {
            boolean[] array = (boolean[])value;
            for (int arrayC = 0; arrayC < array.length; ++arrayC) {
                this.displayValue(array[arrayC], indent + "  ", "[" + arrayC + "]");
            }
        } else if (clazz == char[].class) {
            char[] array = (char[])value;
            for (int arrayC = 0; arrayC < array.length; ++arrayC) {
                this.displayValue(Character.valueOf(array[arrayC]), indent + "  ", "[" + arrayC + "]");
            }
        } else if (clazz == float[].class) {
            float[] array = (float[])value;
            for (int arrayC = 0; arrayC < array.length; ++arrayC) {
                this.displayValue(Float.valueOf(array[arrayC]), indent + "  ", "[" + arrayC + "]");
            }
        } else if (clazz == double[].class) {
            double[] array = (double[])value;
            for (int arrayC = 0; arrayC < array.length; ++arrayC) {
                this.displayValue(array[arrayC], indent + "  ", "[" + arrayC + "]");
            }
        } else {
            Object[] array = (Object[])value;
            for (int arrayC = 0; arrayC < array.length; ++arrayC) {
                this.displayValue(array[arrayC], indent + "  ", "[" + arrayC + "]");
            }
        }
        System.out.println(indent + "END of " + clazz.getSimpleName() + " array:");
    }

    private InputStream getInputStream(String filePath) throws IOException {
        InputStream inputStream;
        if (filePath.startsWith("classpath:")) {
            String[] paths = filePath.split(":", 2);
            assert (paths.length > 1);
            inputStream = filePath.getClass().getResourceAsStream(paths[1]);
            if (inputStream == null) {
                return null;
            }
        } else {
            File inputFile = new File(filePath);
            if (inputFile.exists()) {
                inputStream = new FileInputStream(inputFile);
            } else {
                return null;
            }
        }
        return inputStream;
    }

    private static interface LineReader {
        public String getNextLine(String var1) throws IOException;
    }
}

