/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplejmx.client;

import com.j256.simplejmx.client.CommandLineJmxClient;
import java.io.File;
import java.util.Arrays;

public class Main {
    public static void main(String[] args) throws Exception {
        new Main().doMain(args, false);
    }

    public void doMain(String[] args, boolean throwOnError) throws Exception {
        CommandLineJmxClient jmxClient;
        if (args.length == 0) {
            this.usage(throwOnError, "no arguments specified");
            return;
        }
        if (args.length > 2) {
            this.usage(throwOnError, "improper number of arguments:" + Arrays.toString(args));
            return;
        }
        if (args.length == 1 && ("--usage".equals(args[0]) || "--help".equals(args[0]))) {
            this.usage(throwOnError, null);
            return;
        }
        if (args[0].indexOf(47) >= 0) {
            jmxClient = new CommandLineJmxClient(args[0]);
        } else {
            String[] parts = args[0].split(":");
            if (parts.length != 2) {
                this.usage(throwOnError, "argument should be in 'hostname:port' format, not: " + args[0]);
                return;
            }
            String hostName = parts[0];
            int port = 0;
            try {
                port = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException e) {
                this.usage(throwOnError, "port number not in the right format: " + parts[1]);
                return;
            }
            jmxClient = new CommandLineJmxClient(hostName, port);
        }
        if (args.length == 1) {
            jmxClient.runCommandLine();
        } else if (args.length == 2) {
            jmxClient.runBatchFile(new File(args[1]));
        }
    }

    private void usage(boolean throwOnError, String label) {
        if (label != null) {
            System.err.print("Error: ");
            System.err.println(label);
            System.err.println();
        }
        System.err.println("Usage: java -jar simplejmx.jar host/port/url [batch-script]");
        System.err.println("host/port/url can be one of:");
        System.err.println("       hostname:port");
        System.err.println("or");
        System.err.println("       jmx-url      (ex. service:jmx:rmi:///jndi/rmi://localhost:8000/jmxrmi)");
        System.err.println("The optional [batch-script] will read the commands from the file otherwise stdin.");
        if (throwOnError) {
            throw new IllegalArgumentException("Usage problems: " + label);
        }
    }
}

