/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplejmx.common;

import com.j256.simplejmx.common.JmxFolderName;
import com.j256.simplejmx.common.JmxResource;
import com.j256.simplejmx.common.JmxSelfNaming;
import javax.management.ObjectName;

public class ObjectNameUtil {
    private ObjectNameUtil() {
    }

    public static ObjectName makeObjectName(JmxResource jmxResource, JmxSelfNaming selfNamingObj) {
        String beanName;
        String domainName = selfNamingObj.getJmxDomainName();
        if (domainName == null) {
            if (jmxResource != null) {
                domainName = jmxResource.domainName();
            }
            if (ObjectNameUtil.isEmpty(domainName)) {
                throw new IllegalArgumentException("Could not create ObjectName because domain name not specified in getJmxDomainName() nor @JmxResource");
            }
        }
        if ((beanName = selfNamingObj.getJmxBeanName()) == null) {
            if (jmxResource != null) {
                beanName = ObjectNameUtil.getBeanName(jmxResource);
            }
            if (ObjectNameUtil.isEmpty(beanName)) {
                beanName = selfNamingObj.getClass().getSimpleName();
            }
        }
        String[] jmxResourceFolders = null;
        if (jmxResource != null) {
            jmxResourceFolders = jmxResource.folderNames();
        }
        return ObjectNameUtil.makeObjectName(domainName, beanName, selfNamingObj.getJmxFolderNames(), jmxResourceFolders);
    }

    public static ObjectName makeObjectName(JmxSelfNaming selfNamingObj) {
        JmxResource jmxResource = selfNamingObj.getClass().getAnnotation(JmxResource.class);
        return ObjectNameUtil.makeObjectName(jmxResource, selfNamingObj);
    }

    public static ObjectName makeObjectName(JmxResource jmxResource, Object obj) {
        String domainName = jmxResource.domainName();
        if (ObjectNameUtil.isEmpty(domainName)) {
            throw new IllegalArgumentException("Could not create ObjectName because domain name not specified in @JmxResource");
        }
        String beanName = ObjectNameUtil.getBeanName(jmxResource);
        if (beanName == null) {
            beanName = obj.getClass().getSimpleName();
        }
        return ObjectNameUtil.makeObjectName(domainName, beanName, null, jmxResource.folderNames());
    }

    public static ObjectName makeObjectName(String domainName, String beanName, String[] folderNameStrings) {
        return ObjectNameUtil.makeObjectName(domainName, beanName, null, folderNameStrings);
    }

    public static ObjectName makeObjectName(String domainName, String beanName) {
        return ObjectNameUtil.makeObjectName(domainName, beanName, null, null);
    }

    public static ObjectName makeObjectName(String objectNameString) {
        try {
            return new ObjectName(objectNameString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid ObjectName generated: " + objectNameString, e);
        }
    }

    public static ObjectName makeObjectName(Object obj) {
        JmxResource jmxResource = obj.getClass().getAnnotation(JmxResource.class);
        if (obj instanceof JmxSelfNaming) {
            return ObjectNameUtil.makeObjectName(jmxResource, (JmxSelfNaming)obj);
        }
        if (jmxResource == null) {
            throw new IllegalArgumentException("Registered class must either implement JmxSelfNaming or have JmxResource annotation");
        }
        return ObjectNameUtil.makeObjectName(jmxResource, obj);
    }

    private static ObjectName makeObjectName(String domainName, String beanName, JmxFolderName[] folderNames, String[] folderNameStrings) {
        StringBuilder sb = new StringBuilder();
        sb.append(domainName);
        sb.append(':');
        boolean first = true;
        int prefixC = 0;
        if (folderNames != null) {
            for (JmxFolderName folderName : folderNames) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                String fieldName = folderName.getField();
                if (fieldName == null) {
                    ObjectNameUtil.appendNumericalPrefix(sb, prefixC++);
                } else {
                    sb.append(fieldName);
                }
                sb.append('=');
                sb.append(folderName.getValue());
            }
        } else if (folderNameStrings != null) {
            for (String folderNameString : folderNameStrings) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                if (folderNameString.indexOf(61) == -1) {
                    ObjectNameUtil.appendNumericalPrefix(sb, prefixC++);
                    sb.append('=');
                }
                sb.append(folderNameString);
            }
        }
        if (!first) {
            sb.append(',');
        }
        sb.append("name=");
        sb.append(beanName);
        String objectNameString = sb.toString();
        return ObjectNameUtil.makeObjectName(objectNameString);
    }

    private static void appendNumericalPrefix(StringBuilder sb, int prefixC) {
        if (prefixC < 10) {
            sb.append('0');
        }
        sb.append(prefixC);
    }

    private static String getBeanName(JmxResource jmxResource) {
        String beanName = jmxResource.beanName();
        if (ObjectNameUtil.isEmpty(beanName)) {
            return null;
        }
        return beanName;
    }

    private static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }
}

