/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplejmx.server;

import com.j256.simplejmx.common.JmxAttributeFieldInfo;
import com.j256.simplejmx.common.JmxAttributeMethodInfo;
import com.j256.simplejmx.common.JmxOperationInfo;
import com.j256.simplejmx.common.JmxResource;
import com.j256.simplejmx.common.JmxResourceInfo;
import com.j256.simplejmx.common.ObjectNameUtil;
import com.j256.simplejmx.server.PublishAllBeanWrapper;
import com.j256.simplejmx.server.ReflectionMbean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.rmi.NoSuchObjectException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public class JmxServer {
    private final String RMI_SERVER_HOST_NAME_PROPERTY = "java.rmi.server.hostname";
    private Registry rmiRegistry;
    private InetAddress inetAddress;
    private int serverPort;
    private int registryPort;
    private JMXConnectorServer connector;
    private MBeanServer mbeanServer;
    private int registeredCount;
    private RMIServerSocketFactory serverSocketFactory;
    private boolean serverHostNamePropertySet = false;
    private String serviceUrl;

    public JmxServer() {
    }

    public JmxServer(int registryPort) {
        this.registryPort = registryPort;
    }

    public JmxServer(InetAddress inetAddress, int registryPort) {
        this.inetAddress = inetAddress;
        this.registryPort = registryPort;
    }

    public JmxServer(int registryPort, int serverPort) {
        this.registryPort = registryPort;
        this.serverPort = serverPort;
    }

    public JmxServer(InetAddress inetAddress, int registryPort, int serverPort) {
        this.inetAddress = inetAddress;
        this.registryPort = registryPort;
        this.serverPort = serverPort;
    }

    public JmxServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public synchronized void start() throws JMException {
        if (this.mbeanServer != null) {
            return;
        }
        if (this.registryPort == 0) {
            throw new IllegalStateException("registry-port must be already set when JmxServer is initialized");
        }
        this.startRmiRegistry();
        this.startJmxService();
    }

    public synchronized void stop() {
        try {
            this.stopThrow();
        }
        catch (JMException jMException) {
            // empty catch block
        }
    }

    public synchronized void stopThrow() throws JMException {
        if (this.connector != null) {
            try {
                this.connector.stop();
            }
            catch (IOException e) {
                throw this.createJmException("Could not stop our Jmx connector server", e);
            }
            finally {
                this.connector = null;
            }
        }
        if (this.rmiRegistry != null) {
            try {
                UnicastRemoteObject.unexportObject(this.rmiRegistry, true);
            }
            catch (NoSuchObjectException e) {
                throw this.createJmException("Could not unexport our RMI registry", e);
            }
            finally {
                this.rmiRegistry = null;
            }
        }
        if (this.serverHostNamePropertySet) {
            System.clearProperty("java.rmi.server.hostname");
            this.serverHostNamePropertySet = false;
        }
    }

    public synchronized void register(Object obj) throws JMException {
        ReflectionMbean mbean;
        if (this.mbeanServer == null) {
            throw new JMException("JmxServer has not be started");
        }
        ObjectName objectName = ObjectNameUtil.makeObjectName(obj);
        try {
            mbean = new ReflectionMbean(obj, this.getObjectDescription(obj));
        }
        catch (Exception e) {
            throw this.createJmException("Could not build MBean object for: " + obj, e);
        }
        this.doRegister(objectName, mbean);
    }

    public synchronized void register(Object obj, ObjectName objectName, JmxAttributeFieldInfo[] attributeFieldInfos, JmxAttributeMethodInfo[] attributeMethodInfos, JmxOperationInfo[] operationInfos) throws JMException {
        String description = this.getObjectDescription(obj);
        this.register(obj, objectName, description, attributeFieldInfos, attributeMethodInfos, operationInfos);
    }

    public synchronized void register(PublishAllBeanWrapper wrapper) throws JMException {
        this.register((Object)wrapper, wrapper.getJmxResourceInfo(), wrapper.getAttributeFieldInfos(), wrapper.getAttributeMethodInfos(), wrapper.getOperationInfos());
    }

    public synchronized void register(Object obj, JmxResourceInfo resourceInfo, JmxAttributeFieldInfo[] attributeFieldInfos, JmxAttributeMethodInfo[] attributeMethodInfos, JmxOperationInfo[] operationInfos) throws JMException {
        this.register(obj, ObjectNameUtil.makeObjectName(resourceInfo), resourceInfo.getJmxDescription(), attributeFieldInfos, attributeMethodInfos, operationInfos);
    }

    public synchronized void register(Object obj, ObjectName objectName, String description, JmxAttributeFieldInfo[] attributeFieldInfos, JmxAttributeMethodInfo[] attributeMethodInfos, JmxOperationInfo[] operationInfos) throws JMException {
        ReflectionMbean mbean;
        if (this.mbeanServer == null) {
            throw new JMException("JmxServer has not be started");
        }
        try {
            mbean = new ReflectionMbean(obj, description, attributeFieldInfos, attributeMethodInfos, operationInfos);
        }
        catch (Exception e) {
            throw this.createJmException("Could not build MBean object for: " + obj, e);
        }
        this.doRegister(objectName, mbean);
    }

    public void unregister(Object obj) {
        try {
            this.unregisterThrow(obj);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void unregister(ObjectName objName) {
        try {
            this.unregisterThrow(objName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void unregisterThrow(Object obj) throws JMException {
        this.unregisterThrow(ObjectNameUtil.makeObjectName(obj));
    }

    public synchronized void unregisterThrow(ObjectName objName) throws JMException {
        if (this.mbeanServer == null) {
            throw new JMException("JmxServer has not be started");
        }
        this.mbeanServer.unregisterMBean(objName);
        --this.registeredCount;
    }

    public void setInetAddress(InetAddress inetAddress) {
        this.inetAddress = inetAddress;
    }

    public void setPort(int port) {
        this.setRegistryPort(port);
    }

    public int getRegistryPort() {
        return this.registryPort;
    }

    public void setRegistryPort(int registryPort) {
        this.registryPort = registryPort;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public void setServerSocketFactory(RMIServerSocketFactory serverSocketFactory) {
        this.serverSocketFactory = serverSocketFactory;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public int getRegisteredCount() {
        return this.registeredCount;
    }

    private String getObjectDescription(Object obj) {
        Class<?> clazz = obj.getClass();
        JmxResource jmxResource = clazz.getAnnotation(JmxResource.class);
        if (jmxResource == null || jmxResource.description() == null || jmxResource.description().length() == 0) {
            return null;
        }
        return jmxResource.description();
    }

    private void doRegister(ObjectName objectName, ReflectionMbean mbean) throws JMException {
        try {
            this.mbeanServer.registerMBean(mbean, objectName);
            ++this.registeredCount;
        }
        catch (Exception e) {
            throw this.createJmException("Registering JMX object " + objectName + " failed", e);
        }
    }

    private void startRmiRegistry() throws JMException {
        if (this.rmiRegistry != null) {
            return;
        }
        try {
            if (this.inetAddress == null) {
                this.rmiRegistry = LocateRegistry.createRegistry(this.registryPort);
            } else {
                if (this.serverSocketFactory == null) {
                    this.serverSocketFactory = new LocalSocketFactory(this.inetAddress);
                }
                if (System.getProperty("java.rmi.server.hostname") == null) {
                    System.setProperty("java.rmi.server.hostname", this.inetAddress.getHostAddress());
                    this.serverHostNamePropertySet = true;
                }
                this.rmiRegistry = LocateRegistry.createRegistry(this.registryPort, null, this.serverSocketFactory);
            }
        }
        catch (IOException e) {
            throw this.createJmException("Unable to create RMI registry on port " + this.registryPort, e);
        }
    }

    private void startJmxService() throws JMException {
        JMXServiceURL url;
        if (this.connector != null) {
            return;
        }
        if (this.serverPort == 0) {
            this.serverPort = this.registryPort;
        }
        String serverHost = "localhost";
        String registryHost = "";
        if (this.inetAddress != null) {
            String hostAddr;
            serverHost = hostAddr = this.inetAddress.getHostAddress();
            registryHost = hostAddr;
        }
        if (this.serviceUrl == null) {
            this.serviceUrl = "service:jmx:rmi://" + serverHost + ":" + this.serverPort + "/jndi/rmi://" + registryHost + ":" + this.registryPort + "/jmxrmi";
        }
        try {
            url = new JMXServiceURL(this.serviceUrl);
        }
        catch (MalformedURLException e) {
            throw this.createJmException("Malformed service url created " + this.serviceUrl, e);
        }
        HashMap<String, RMIServerSocketFactory> envMap = null;
        if (this.serverSocketFactory != null) {
            envMap = new HashMap<String, RMIServerSocketFactory>();
            envMap.put("jmx.remote.rmi.server.socket.factory", this.serverSocketFactory);
        }
        try {
            this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
            this.connector = JMXConnectorServerFactory.newJMXConnectorServer(url, envMap, this.mbeanServer);
        }
        catch (IOException e) {
            throw this.createJmException("Could not make our Jmx connector server on URL: " + url, e);
        }
        try {
            this.connector.start();
        }
        catch (IOException e) {
            this.connector = null;
            throw this.createJmException("Could not start our Jmx connector server on URL: " + url, e);
        }
    }

    private JMException createJmException(String message, Exception e) {
        JMException jmException = new JMException(message);
        jmException.initCause(e);
        return jmException;
    }

    private static class LocalSocketFactory
    implements RMIServerSocketFactory {
        private final InetAddress inetAddress;

        public LocalSocketFactory(InetAddress inetAddress) {
            this.inetAddress = inetAddress;
        }

        public ServerSocket createServerSocket(int port) throws IOException {
            return new ServerSocket(port, 0, this.inetAddress);
        }

        public int hashCode() {
            return this.inetAddress == null ? 0 : this.inetAddress.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            LocalSocketFactory other = (LocalSocketFactory)obj;
            if (this.inetAddress == null) {
                return other.inetAddress == null;
            }
            return this.inetAddress.equals(other.inetAddress);
        }
    }
}

