/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplejmx.server;

import com.j256.simplejmx.common.JmxAttributeField;
import com.j256.simplejmx.common.JmxAttributeFieldInfo;
import com.j256.simplejmx.common.JmxAttributeMethod;
import com.j256.simplejmx.common.JmxAttributeMethodInfo;
import com.j256.simplejmx.common.JmxOperation;
import com.j256.simplejmx.common.JmxOperationInfo;
import com.j256.simplejmx.server.PublishAllBeanWrapper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionMbean
implements DynamicMBean {
    private final Object delegate;
    private final String description;
    private final Map<String, AttributeMethodInfo> attributeMethodMap = new HashMap<String, AttributeMethodInfo>();
    private final Map<NameParams, Method> operationMethodMap = new HashMap<NameParams, Method>();
    private final Map<String, AttributeFieldInfo> attributeFieldMap = new HashMap<String, AttributeFieldInfo>();
    private final MBeanInfo mbeanInfo;

    public ReflectionMbean(Object delegate, String description) {
        this(delegate, description, null, null, null);
    }

    public ReflectionMbean(PublishAllBeanWrapper wrapper) {
        this(wrapper.getDelegate(), null, wrapper.getAttributeFieldInfos(), wrapper.getAttributeMethodInfos(), wrapper.getOperationInfos());
    }

    public ReflectionMbean(Object delegate, String description, JmxAttributeFieldInfo[] attributeFieldInfos, JmxAttributeMethodInfo[] attributeMethodInfos, JmxOperationInfo[] operationInfos) {
        this.delegate = delegate;
        this.description = ReflectionMbean.preprocessDescription(delegate, description);
        this.mbeanInfo = this.buildMbeanInfo(attributeFieldInfos, attributeMethodInfos, operationInfos);
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }

    @Override
    public Object getAttribute(String attributeName) throws AttributeNotFoundException, ReflectionException {
        AttributeMethodInfo methodInfo = this.attributeMethodMap.get(attributeName);
        if (methodInfo == null) {
            AttributeFieldInfo fieldInfo = this.attributeFieldMap.get(attributeName);
            if (fieldInfo == null || !fieldInfo.isGetter) {
                this.throwUnknownAttributeException(attributeName);
            }
            try {
                return fieldInfo.field.get(this.delegate);
            }
            catch (Exception e) {
                throw new ReflectionException(e, "Invoking getter attribute on field " + fieldInfo.field.getName() + " on " + this.delegate.getClass() + " threw exception");
            }
        }
        if (methodInfo.getterMethod == null) {
            this.throwUnknownAttributeException(attributeName);
        }
        try {
            return methodInfo.getterMethod.invoke(this.delegate, new Object[0]);
        }
        catch (Exception e) {
            throw new ReflectionException(e, "Invoking getter attribute method " + methodInfo.getterMethod.getName() + " on " + this.delegate.getClass() + " threw exception");
        }
    }

    @Override
    public AttributeList getAttributes(String[] attributeNames) {
        AttributeList returnList = new AttributeList();
        for (String name : attributeNames) {
            try {
                returnList.add(new Attribute(name, this.getAttribute(name)));
            }
            catch (Exception e) {
                returnList.add(new Attribute(name, "Getting attribute threw: " + e.getMessage()));
            }
        }
        return returnList;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, ReflectionException {
        AttributeMethodInfo methodInfo = this.attributeMethodMap.get(attribute.getName());
        if (methodInfo == null) {
            AttributeFieldInfo fieldInfo = this.attributeFieldMap.get(attribute.getName());
            if (fieldInfo == null || !fieldInfo.isSetter) {
                this.throwUnknownAttributeException(attribute.getName());
            }
            try {
                fieldInfo.field.set(this.delegate, attribute.getValue());
            }
            catch (Exception e) {
                throw new ReflectionException(e, "Invoking setter attribute on field " + fieldInfo.field.getName() + " on " + this.delegate.getClass() + " threw exception");
            }
        }
        if (methodInfo.setterMethod == null) {
            this.throwUnknownAttributeException(attribute.getName());
        }
        try {
            methodInfo.setterMethod.invoke(this.delegate, attribute.getValue());
        }
        catch (Exception e) {
            throw new ReflectionException(e, "Invoking setter attribute method " + methodInfo.setterMethod.getName() + " on " + this.delegate.getClass() + " threw exception");
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList returnList = new AttributeList(attributes.size());
        for (Attribute attribute : attributes.asList()) {
            String name = attribute.getName();
            try {
                this.setAttribute(attribute);
                returnList.add(new Attribute(name, this.getAttribute(name)));
            }
            catch (Exception e) {
                returnList.add(new Attribute(name, e.getMessage()));
            }
        }
        return returnList;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signatureTypes) throws MBeanException, ReflectionException {
        Method method = this.operationMethodMap.get(new NameParams(actionName, signatureTypes));
        if (method == null) {
            throw new MBeanException(new IllegalArgumentException("Unknown action '" + actionName + "' with parameter types " + Arrays.toString(signatureTypes)));
        }
        try {
            return method.invoke(this.delegate, params);
        }
        catch (Exception e) {
            throw new ReflectionException(e, "Invoking operation method " + method.getName() + " on " + this.delegate.getClass() + " threw exception");
        }
    }

    private static String preprocessDescription(Object delegate, String description) {
        if (description == null) {
            return "Information about " + delegate.getClass();
        }
        return description;
    }

    private MBeanInfo buildMbeanInfo(JmxAttributeFieldInfo[] attributeFieldInfos, JmxAttributeMethodInfo[] attributeMethodInfos, JmxOperationInfo[] operationInfos) {
        HashMap<String, JmxAttributeFieldInfo> attributeFieldInfoMap = null;
        if (attributeFieldInfos != null) {
            attributeFieldInfoMap = new HashMap<String, JmxAttributeFieldInfo>();
            for (JmxAttributeFieldInfo info : attributeFieldInfos) {
                attributeFieldInfoMap.put(info.getName(), info);
            }
        }
        HashMap<String, JmxAttributeMethodInfo> attributeMethodInfoMap = null;
        if (attributeMethodInfos != null) {
            attributeMethodInfoMap = new HashMap<String, JmxAttributeMethodInfo>();
            for (JmxAttributeMethodInfo info : attributeMethodInfos) {
                attributeMethodInfoMap.put(info.getMethodName(), info);
            }
        }
        HashMap<String, JmxOperationInfo> attributeOperationInfoMap = null;
        if (operationInfos != null) {
            attributeOperationInfoMap = new HashMap<String, JmxOperationInfo>();
            for (JmxOperationInfo info : operationInfos) {
                attributeOperationInfoMap.put(info.getMethodName(), info);
            }
        }
        Class<?> clazz = this.delegate.getClass();
        Method[] methods = clazz.getMethods();
        ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>();
        this.discoverAttributeMethods(methods, attributes, attributeMethodInfoMap);
        this.discoverAttributeFields(attributes, attributeFieldInfoMap);
        List<MBeanOperationInfo> operations = this.discoverOperations(methods, attributeOperationInfoMap);
        return new MBeanInfo(clazz.getName(), this.description, attributes.toArray(new MBeanAttributeInfo[attributes.size()]), null, operations.toArray(new MBeanOperationInfo[operations.size()]), null);
    }

    private void discoverAttributeMethods(Method[] methods, List<MBeanAttributeInfo> attributes, Map<String, JmxAttributeMethodInfo> attributeMethodInfoMap) {
        for (Method method : methods) {
            boolean isIs;
            String methodName;
            JmxAttributeMethod jmxAttribute = method.getAnnotation(JmxAttributeMethod.class);
            JmxAttributeMethodInfo attributeMethodInfo = null;
            if (jmxAttribute == null) {
                if (attributeMethodInfoMap != null) {
                    attributeMethodInfo = attributeMethodInfoMap.get(method.getName());
                }
                if (attributeMethodInfo == null) {
                    continue;
                }
            } else {
                attributeMethodInfo = new JmxAttributeMethodInfo(method.getName(), jmxAttribute);
                jmxAttribute = null;
            }
            if ((methodName = method.getName()).startsWith("is")) {
                if (method.getReturnType() != Boolean.TYPE && method.getReturnType() != Boolean.class) {
                    throw new IllegalArgumentException("Method '" + method + "' starts with 'is' but does not return a boolean or Boolean class");
                }
                isIs = true;
            } else {
                isIs = false;
            }
            String varName = this.buildMethodSuffix(method, methodName, isIs);
            AttributeMethodInfo methodInfo = this.attributeMethodMap.get(varName);
            if (isIs || methodName.startsWith("get")) {
                if (method.getParameterTypes().length != 0) {
                    throw new IllegalArgumentException("Method '" + method + "' starts with 'get' but has arguments");
                }
                if (method.getReturnType() == Void.TYPE) {
                    throw new IllegalArgumentException("Method '" + method + "' starts with 'get' but does not return anything");
                }
                if (methodInfo == null) {
                    this.attributeMethodMap.put(varName, new AttributeMethodInfo(varName, attributeMethodInfo.getDescription(), method, null));
                    continue;
                }
                methodInfo.getterMethod = method;
                continue;
            }
            if (methodName.startsWith("set")) {
                if (method.getParameterTypes().length != 1) {
                    throw new IllegalArgumentException("Method '" + method + "' starts with 'set' but does not have 1 argument");
                }
                if (method.getReturnType() != Void.TYPE) {
                    throw new IllegalArgumentException("Method '" + method + "' starts with 'set' but does not return void");
                }
                if (methodInfo == null) {
                    this.attributeMethodMap.put(varName, new AttributeMethodInfo(varName, attributeMethodInfo.getDescription(), null, method));
                    continue;
                }
                methodInfo.setterMethod = method;
                continue;
            }
            throw new IllegalArgumentException("Method '" + method + "' is marked as an attribute but does not start with 'get' or 'set'");
        }
        for (AttributeMethodInfo methodInfo : this.attributeMethodMap.values()) {
            attributes.add(new MBeanAttributeInfo(methodInfo.varName, methodInfo.type.getName(), methodInfo.description, methodInfo.getterMethod != null, methodInfo.setterMethod != null, methodInfo.isIs()));
        }
    }

    private void discoverAttributeFields(List<MBeanAttributeInfo> attributes, Map<String, JmxAttributeFieldInfo> attributeFieldInfoMap) {
        Field[] fields;
        Class<?> clazz = this.delegate.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            JmxAttributeField attributeField = field.getAnnotation(JmxAttributeField.class);
            JmxAttributeFieldInfo attributeFieldInfo = null;
            if (attributeField == null) {
                if (attributeFieldInfoMap != null) {
                    attributeFieldInfo = attributeFieldInfoMap.get(field.getName());
                }
                if (attributeFieldInfo == null) {
                    continue;
                }
            } else {
                attributeFieldInfo = new JmxAttributeFieldInfo(field.getName(), attributeField);
                attributeField = null;
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            this.attributeFieldMap.put(field.getName(), new AttributeFieldInfo(field, attributeFieldInfo.isReadible(), attributeFieldInfo.isWritable()));
            String description = attributeFieldInfo.getDescription();
            if (ReflectionMbean.isEmpty(description)) {
                description = field.getName() + " attribute";
            }
            boolean isIs = field.getName().startsWith("is") && (field.getType() == Boolean.TYPE || field.getType() == Boolean.class);
            attributes.add(new MBeanAttributeInfo(field.getName(), field.getType().getName(), description, attributeFieldInfo.isReadible(), attributeFieldInfo.isWritable(), isIs));
        }
    }

    private List<MBeanOperationInfo> discoverOperations(Method[] methods, Map<String, JmxOperationInfo> attributeOperationInfoMap) {
        ArrayList<MBeanOperationInfo> operations = new ArrayList<MBeanOperationInfo>(this.operationMethodMap.size());
        for (Method method : methods) {
            String methodName;
            JmxOperation jmxOperation = method.getAnnotation(JmxOperation.class);
            JmxOperationInfo operationInfo = null;
            if (jmxOperation == null) {
                if (attributeOperationInfoMap != null) {
                    operationInfo = attributeOperationInfoMap.get(method.getName());
                }
                if (operationInfo == null) {
                    continue;
                }
            } else {
                operationInfo = new JmxOperationInfo(method.getName(), jmxOperation);
                jmxOperation = null;
            }
            if ((methodName = method.getName()).startsWith("get") || methodName.startsWith("is") || methodName.startsWith("set")) {
                throw new IllegalArgumentException("Operation method " + method + " cannot start with 'get', 'is', or 'set'.  Did you use the wrong annotation?");
            }
            Class<?>[] types = method.getParameterTypes();
            String[] stringTypes = new String[types.length];
            for (int i = 0; i < types.length; ++i) {
                stringTypes[i] = types[i].getName();
            }
            NameParams nameParams = new NameParams(methodName, stringTypes);
            MBeanParameterInfo[] parameterInfos = this.buildOperationParameterInfo(method, operationInfo);
            this.operationMethodMap.put(nameParams, method);
            String description = operationInfo.getDescription();
            if (ReflectionMbean.isEmpty(description)) {
                description = methodName + " attribute";
            }
            operations.add(new MBeanOperationInfo(methodName, description, parameterInfos, method.getReturnType().getName(), operationInfo.getAction().getActionValue()));
        }
        return operations;
    }

    private MBeanParameterInfo[] buildOperationParameterInfo(Method method, JmxOperationInfo operationInfo) {
        Class<?>[] types = method.getParameterTypes();
        MBeanParameterInfo[] parameterInfos = new MBeanParameterInfo[types.length];
        String[] parameterNames = operationInfo.getParameterNames();
        String[] parameterDescriptions = operationInfo.getParameterDescriptions();
        for (int i = 0; i < types.length; ++i) {
            String parameterName = parameterNames == null || i >= parameterNames.length ? "p" + (i + 1) : parameterNames[i];
            String typeName = types[i].getName();
            String description = parameterDescriptions == null || i >= parameterDescriptions.length ? "parameter #" + (i + 1) + " of type: " + typeName : parameterDescriptions[i];
            parameterInfos[i] = new MBeanParameterInfo(parameterName, typeName, description);
        }
        return parameterInfos;
    }

    private String buildMethodSuffix(Method method, String methodName, boolean isIs) {
        if (isIs) {
            if (methodName.length() < 3) {
                throw new IllegalArgumentException("Method '" + methodName + "' has a name that is too short");
            }
            return Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3);
        }
        if (methodName.length() < 4) {
            throw new IllegalArgumentException("Method '" + methodName + "' has a name that is too short");
        }
        return Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
    }

    private void throwUnknownAttributeException(String attributeName) throws AttributeNotFoundException {
        throw new AttributeNotFoundException("Unknown attribute " + attributeName);
    }

    private static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    private static class AttributeFieldInfo {
        final Field field;
        final boolean isGetter;
        final boolean isSetter;

        public AttributeFieldInfo(Field field, boolean isGetter, boolean isSetter) {
            this.field = field;
            this.isGetter = isGetter;
            this.isSetter = isSetter;
        }
    }

    private static class AttributeMethodInfo {
        final String varName;
        final String description;
        Method getterMethod;
        Method setterMethod;
        final Class<?> type;

        public AttributeMethodInfo(String varName, String description, Method getterMethod, Method setterMethod) {
            this.varName = varName;
            this.description = description == null || description.length() == 0 ? varName + " attribute" : description;
            this.getterMethod = getterMethod;
            this.setterMethod = setterMethod;
            this.type = getterMethod == null ? setterMethod.getParameterTypes()[0] : getterMethod.getReturnType();
        }

        public boolean isIs() {
            return this.getterMethod != null && this.getterMethod.getName().startsWith("is") && (this.type == Boolean.TYPE || this.type == Boolean.class);
        }
    }

    private static class NameParams {
        String name;
        String[] paramTypes;

        public NameParams(String name, String[] paramTypes) {
            this.name = name;
            this.paramTypes = paramTypes;
        }

        public int hashCode() {
            int hashCode = 31 * (31 + this.name.hashCode());
            if (this.paramTypes != null) {
                hashCode += Arrays.hashCode(this.paramTypes);
            }
            return hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            NameParams other = (NameParams)obj;
            if (!this.name.equals(other.name)) {
                return false;
            }
            return Arrays.equals(this.paramTypes, other.paramTypes);
        }
    }
}

