/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplejmx.spring;

import com.j256.simplejmx.common.JmxResource;
import com.j256.simplejmx.common.JmxSelfNaming;
import com.j256.simplejmx.server.JmxServer;
import com.j256.simplejmx.server.PublishAllBeanWrapper;
import com.j256.simplejmx.spring.JmxBean;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class BeanPublisher
implements InitializingBean,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private JmxServer jmxServer;

    public void afterPropertiesSet() throws Exception {
        Map beans = this.applicationContext.getBeansOfType(null);
        for (Object bean : beans.values()) {
            if (bean.getClass().isAnnotationPresent(JmxResource.class) || bean instanceof JmxSelfNaming) {
                this.jmxServer.register(bean);
                continue;
            }
            if (bean instanceof JmxBean) {
                JmxBean jmxBean = (JmxBean)bean;
                this.jmxServer.register(jmxBean.getTarget(), jmxBean.getJmxResourceInfo(), jmxBean.getAttributeFieldInfos(), jmxBean.getAttributeMethodInfos(), jmxBean.getOperationInfos());
                continue;
            }
            if (!(bean instanceof PublishAllBeanWrapper)) continue;
            PublishAllBeanWrapper wrapper = (PublishAllBeanWrapper)bean;
            this.jmxServer.register(wrapper);
        }
    }

    @Required
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Required
    public void setJmxServer(JmxServer jmxServer) {
        this.jmxServer = jmxServer;
    }
}

