/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplejmx.web;

import com.j256.simplejmx.web.JmxHandler;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class JmxWebServer {
    private static final int WEB_SERVER_MIN_THREADS = 1;
    private static final int WEB_SERVER_MAX_THREADS = 5;
    private int serverPort;
    private Server server;
    private SelectChannelConnector connector;

    public JmxWebServer() {
    }

    public JmxWebServer(int serverPort) {
        this.serverPort = serverPort;
    }

    public void start() throws Exception {
        this.server = new Server();
        this.connector = new SelectChannelConnector();
        this.connector.setPort(this.serverPort);
        this.configConnector((AbstractConnector)this.connector);
        this.server.addConnector((Connector)this.connector);
        this.server.setHandler((Handler)new JmxHandler());
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
        this.connector.close();
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    private void configConnector(AbstractConnector conector) {
        this.connector.setStatsOn(true);
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMinThreads(1);
        threadPool.setMaxThreads(5);
        threadPool.setName("web-server");
        this.connector.setThreadPool((ThreadPool)threadPool);
        this.connector.setReuseAddress(true);
    }
}

