/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLException;
import org.bridj.Pointer;
import org.bridj.SizeT;
import org.bridj.ann.Ptr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CLInfoGetter {
    CLInfoGetter() {
    }

    protected abstract int getInfo(long var1, int var3, long var4, Pointer var6, Pointer<SizeT> var7);

    public String getString(@Ptr long entity, int infoName) {
        Pointer<SizeT> pLen = Pointer.allocateSizeT();
        CLException.error(this.getInfo(entity, infoName, 0L, null, pLen));
        int len = (int)pLen.getSizeT();
        if (len == 0) {
            return "";
        }
        Pointer<Byte> buffer = Pointer.allocateBytes(len + 1);
        CLException.error(this.getInfo(entity, infoName, len, buffer, null));
        return buffer.getCString();
    }

    public Pointer getPointer(@Ptr long entity, int infoName) {
        Pointer<SizeT> pLen = Pointer.allocateSizeT();
        Pointer<Pointer<?>> mem = Pointer.allocatePointer();
        CLException.error(this.getInfo(entity, infoName, Pointer.SIZE, mem, pLen));
        if (pLen.getSizeT() != (long)Pointer.SIZE) {
            throw new RuntimeException("Not a pointer : len = " + pLen.get());
        }
        return mem.get();
    }

    public Pointer<?> getMemory(@Ptr long entity, int infoName) {
        Pointer<SizeT> pLen = Pointer.allocateSizeT();
        CLException.error(this.getInfo(entity, infoName, 0L, null, pLen));
        int len = (int)pLen.getSizeT();
        Pointer<Byte> buffer = Pointer.allocateBytes(len);
        CLException.error(this.getInfo(entity, infoName, len, buffer, null));
        return buffer;
    }

    public long[] getNativeSizes(@Ptr long entity, int infoName, int n) {
        int nBytes = SizeT.SIZE * n;
        Pointer<SizeT> pLen = Pointer.pointerToSizeT(nBytes);
        Pointer<SizeT> mem = Pointer.allocateSizeTs(n);
        CLException.error(this.getInfo(entity, infoName, nBytes, mem, pLen));
        int actualLen = (int)pLen.getSizeT();
        if (actualLen != nBytes) {
            throw new RuntimeException("Not a Size[" + n + "] : len = " + actualLen);
        }
        return mem.getSizeTs(n);
    }

    public int getOptionalFeatureInt(@Ptr long entity, int infoName) {
        try {
            return this.getInt(entity, infoName);
        }
        catch (CLException.InvalidValue ex) {
            throw new UnsupportedOperationException("Cannot get value " + infoName, ex);
        }
        catch (CLException.InvalidOperation ex) {
            throw new UnsupportedOperationException("Cannot get value " + infoName, ex);
        }
    }

    public int getInt(@Ptr long entity, int infoName) {
        return (int)this.getIntOrLong(entity, infoName);
    }

    public boolean getBool(@Ptr long entity, int infoName) {
        Pointer<SizeT> pLen = Pointer.allocateSizeT();
        Pointer<Byte> mem = Pointer.allocateBytes(8L);
        CLException.error(this.getInfo(entity, infoName, 8L, mem, pLen));
        long len = pLen.getSizeT();
        switch ((int)len) {
            case 1: {
                return mem.getByte() != 0;
            }
            case 2: {
                return mem.getShort() != 0;
            }
            case 4: {
                return mem.getInt() != 0;
            }
            case 8: {
                return mem.getLong() != 0L;
            }
            case 0: {
                return true;
            }
        }
        throw new RuntimeException("Not a BOOL : len = " + len);
    }

    public long getIntOrLong(@Ptr long entity, int infoName) {
        Pointer<SizeT> pLen = Pointer.allocateSizeT();
        Pointer<Long> mem = Pointer.allocateLong();
        CLException.error(this.getInfo(entity, infoName, 8L, mem, pLen));
        switch ((int)pLen.getSizeT()) {
            case 4: {
                return mem.getInt();
            }
            case 8: {
                return mem.getLong();
            }
        }
        throw new RuntimeException("Not a native long : len = " + pLen.get());
    }
}

