/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl.util;

import com.nativelibs4java.opencl.CLBuildException;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLDevice;
import com.nativelibs4java.opencl.CLKernel;
import com.nativelibs4java.opencl.CLProgram;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.opencl.JavaCL;
import com.nativelibs4java.opencl.util.Fun1;
import com.nativelibs4java.opencl.util.Fun2;
import com.nativelibs4java.opencl.util.Primitive;
import com.nativelibs4java.util.Pair;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public class ParallelMath {
    protected CLContext context;
    protected CLQueue queue;
    private EnumMap<Fun1, EnumMap<Primitive, CLKernel>> fun1Kernels = new EnumMap(Fun1.class);
    private EnumMap<Fun2, Map<PrimitiveTrio, CLKernel>> fun2Kernels = new EnumMap(Fun2.class);

    public ParallelMath() {
        this(JavaCL.createBestContext().createDefaultQueue(new CLDevice.QueueProperties[0]));
    }

    public ParallelMath(CLQueue queue) {
        this.queue = queue;
        CLContext context = queue.getContext();
    }

    public CLQueue getQueue() {
        return this.queue;
    }

    public CLContext getContext() {
        return this.getQueue().getContext();
    }

    protected String createVectFun1Source(Fun1 function, Primitive type, StringBuilder out) {
        String t = type.clTypeName();
        String kernelName = "vect_" + function.name() + "_" + t;
        out.append("__kernel void " + kernelName + "(\n");
        out.append("\t__global const " + t + "* in,\n");
        out.append("\t__global " + t + "* out,\n");
        out.append("\tlong length\n");
        out.append(") {\n");
        out.append("\tint i = get_global_id(0);\n");
        out.append("\tif (i >= length) return;\n");
        out.append("\tout[i] = ");
        function.expr("in[i]", out);
        out.append(";\n");
        out.append("}\n");
        return kernelName;
    }

    protected String createVectFun2Source(Fun2 function, Primitive type1, Primitive type2, Primitive typeOut, StringBuilder out, boolean secondOperandIsScalar) {
        String t1 = type1.clTypeName();
        String t2 = type2.clTypeName();
        String to = typeOut.clTypeName();
        String kernelName = "vect_" + function.name() + "_" + t1 + "_" + t2 + "_" + to;
        out.append("__kernel void " + kernelName + "(\n");
        out.append("\t__global const " + t1 + "* in1,\n");
        if (secondOperandIsScalar) {
            out.append("\t" + t2 + " in2,\n");
        } else {
            out.append("\t__global const " + t2 + "* in2,\n");
        }
        out.append("\t__global " + to + "* out,\n");
        out.append("\tlong length\n");
        out.append(") {\n");
        out.append("\tint i = get_global_id(0);\n");
        out.append("\tif (i >= length) return;\n");
        out.append("\tout[i] = (" + to + ")");
        function.expr("in1[i]", secondOperandIsScalar ? "in2" : "in2[i]", out);
        out.append(";\n");
        out.append("}\n");
        return kernelName;
    }

    public synchronized CLKernel getKernel(Fun1 op, Primitive prim) throws CLBuildException {
        CLKernel kers;
        EnumMap<Primitive, CLKernel> m = this.fun1Kernels.get((Object)op);
        if (m == null) {
            m = new EnumMap(Primitive.class);
            this.fun1Kernels.put(op, m);
        }
        if ((kers = m.get((Object)prim)) == null) {
            StringBuilder out = new StringBuilder(300);
            String name = this.createVectFun1Source(op, prim, out);
            CLProgram prog = this.getContext().createProgram(out.toString()).build();
            kers = prog.createKernel(name, new Object[0]);
            m.put(prim, kers);
        }
        return kers;
    }

    public synchronized CLKernel getKernel(Fun2 op, Primitive prim, boolean secondOperandIsScalar) throws CLBuildException {
        return this.getKernel(op, prim, prim, prim, secondOperandIsScalar);
    }

    public synchronized CLKernel getKernel(Fun2 op, Primitive prim1, Primitive prim2, Primitive primOut, boolean secondOperandIsScalar) throws CLBuildException {
        PrimitiveTrio key;
        CLKernel ker;
        Map<PrimitiveTrio, CLKernel> m = this.fun2Kernels.get((Object)op);
        if (m == null) {
            m = new HashMap<PrimitiveTrio, CLKernel>();
            this.fun2Kernels.put(op, m);
        }
        if ((ker = m.get(key = new PrimitiveTrio(prim1, prim2, primOut, secondOperandIsScalar))) == null) {
            StringBuilder out = new StringBuilder(300);
            String name = this.createVectFun2Source(op, prim1, prim2, primOut, out, secondOperandIsScalar);
            CLProgram prog = this.getContext().createProgram(out.toString()).build();
            ker = prog.createKernel(name, new Object[0]);
            m.put(key, ker);
        }
        return ker;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PrimitiveTrio
    extends Pair<Pair<Primitive, Primitive>, Pair<Primitive, Boolean>> {
        public PrimitiveTrio(Primitive a, Primitive b, Primitive c, boolean secondOperandIsScalar) {
            super(new Pair<Primitive, Primitive>(a, b), new Pair<Primitive, Boolean>(c, secondOperandIsScalar));
        }
    }
}

