/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllOfValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(AllOfValidator.class);
    private List<JsonSchema> schemas = new ArrayList<JsonSchema>();

    public AllOfValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.ALL_OF, validationContext);
        int size = schemaNode.size();
        for (int i = 0; i < size; ++i) {
            this.schemas.add(new JsonSchema(validationContext, this.getValidatorType().getValue(), parentSchema.getCurrentUri(), schemaNode.get(i), parentSchema).initialize());
        }
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        for (JsonSchema schema : this.schemas) {
            errors.addAll(schema.validate(node, rootNode, at));
        }
        return Collections.unmodifiableSet(errors);
    }

    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        LinkedHashSet<ValidationMessage> validationMessages = new LinkedHashSet<ValidationMessage>();
        for (JsonSchema schema : this.schemas) {
            if (shouldValidateSchema) {
                validationMessages.addAll(schema.validate(node, rootNode, at));
            }
            validationMessages.addAll(schema.walk(node, rootNode, at, shouldValidateSchema));
        }
        return Collections.unmodifiableSet(validationMessages);
    }
}

