/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring.reporter;

import com.ryantenney.metrics.spring.reporter.AbstractReporterElementParser;
import com.ryantenney.metrics.spring.reporter.DatadogReporterFactoryBean;

public class DatadogReporterElementParser
extends AbstractReporterElementParser {
    @Override
    public String getType() {
        return "datadog";
    }

    @Override
    protected Class<?> getBeanClass() {
        return DatadogReporterFactoryBean.class;
    }

    @Override
    protected void validate(AbstractReporterElementParser.ValidationContext c) {
        c.require("transport", "^http|udp|statsd$", "Transport must be one of: http, udp, statsd");
        c.require("period", "^(\\d+)\\s?(ns|us|ms|s|m|h|d)?$", "Period is required and must be in the form '\\d+(ns|us|ms|s|m|h|d)'");
        if ("http".equals(c.get("transport"))) {
            c.require("api-key");
        }
        c.optional("connect-timeout", "^(\\d+)\\s?(ns|us|ms|s|m|h|d)?$", "Connect timeout must be in the form '\\d+(ns|us|ms|s|m|h|d)'");
        c.optional("socket-timeout", "^(\\d+)\\s?(ns|us|ms|s|m|h|d)?$", "Socket timeout must be in the form '\\d+(ns|us|ms|s|m|h|d)'");
        c.optional("statsd-host");
        c.optional("statsd-port", "^([1-9][0-9]{0,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])$", "Port number must be an integer between 1-65536");
        c.optional("statsd-prefix");
        c.optional("host");
        c.optional("use-ec2-host");
        c.optional("expansions");
        c.optional("tags");
        c.optional("dynamic-tag-callback-ref");
        c.optional("metric-name-formatter-ref");
        c.optional("prefix");
        c.optional("clock-ref");
        c.optional("rate-unit", "^(?:DAY|HOUR|MINUTE|(?:MICRO|MILLI|NANO)?SECOND)S$", "Rate unit must be one of the enum constants from java.util.concurrent.TimeUnit");
        c.optional("duration-unit", "^(?:DAY|HOUR|MINUTE|(?:MICRO|MILLI|NANO)?SECOND)S$", "Duration unit must be one of the enum constants from java.util.concurrent.TimeUnit");
        c.optional("filter");
        c.optional("filter-ref");
        if (c.has("filter") && c.has("filter-ref")) {
            c.reject("filter-ref", "Reporter element must not specify both the 'filter' and 'filter-ref' attributes");
        }
        c.rejectUnmatchedProperties();
    }
}

