/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.maven.plugins.iterator;

import com.soebes.maven.plugins.iterator.AbstractInvokerMojo;
import com.soebes.maven.plugins.iterator.ItemWithProperties;
import com.soebes.maven.plugins.iterator.OutputConsumer;
import java.io.File;
import java.util.ArrayList;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;

@Mojo(name="invoker", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, threadSafe=true)
public class InvokerMojo
extends AbstractInvokerMojo {
    @Component
    private BuildPluginManager pluginManager;
    @Parameter(defaultValue="${plugin}", required=true, readonly=true)
    private PluginDescriptor pluginDescriptor;
    @Parameter
    private File workingDirectory;
    @Component
    private Invoker invoker;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skip by user request.");
            return;
        }
        if (this.isNoneSet()) {
            throw new MojoExecutionException("You have to use at least one. Either items, itemsWithProperties, content or folder element!");
        }
        if (this.isMoreThanOneSet()) {
            throw new MojoExecutionException("You can use only one element. Either items, itemsWithProperties, content or folder element but not more than one of them.");
        }
        File localRepository = new File(this.getMavenSession().getSettings().getLocalRepository());
        this.invoker.setLocalRepositoryDirectory(localRepository);
        ArrayList<RuntimeException> exceptions = new ArrayList<RuntimeException>();
        for (ItemWithProperties itemWithProperties : this.getItemsConverted()) {
            try {
                this.createLogOutput(itemWithProperties);
                InvocationResult result = this.mavenCall(itemWithProperties);
                if (result.getExitCode() == 0) {
                    this.getLog().info((CharSequence)"------ Maven call was Ok.");
                    continue;
                }
                this.getLog().error((CharSequence)("------ Maven call was NOT Ok. for iteration " + itemWithProperties.getName() + " ( return code: " + result.getExitCode() + " )"));
                if (result.getExecutionException() != null) {
                    this.getLog().error((CharSequence)result.getExecutionException().getMessage(), result.getExecutionException().getCause());
                }
                String failureMessage = "Maven call failed with return code " + result.getExitCode() + " for iteration: " + itemWithProperties.getName();
                if (this.isFailAtEnd()) {
                    exceptions.add(new RuntimeException(failureMessage));
                    continue;
                }
                throw new MojoFailureException(failureMessage);
            }
            catch (MavenInvocationException e) {
                this.getLog().error((CharSequence)"------ ***** Command line options are wrong:", (Throwable)e);
                throw new MojoExecutionException("Command line options are wrong:", (Exception)((Object)e));
            }
        }
        if (!exceptions.isEmpty()) {
            for (Exception exception : exceptions) {
                this.getLog().error((Throwable)exception);
            }
            throw new MojoExecutionException("Failures during iterations.");
        }
    }

    private File getWorkingDirectoryAfterPlaceHolderIsReplaced(ItemWithProperties currentValue) {
        File baseDir = this.getWorkingDirectory();
        if (baseDir != null && baseDir.toString().contains(this.getPlaceHolder())) {
            baseDir = new File(baseDir.toString().replaceAll(this.getPlaceHolder(), currentValue.getName()));
        }
        return baseDir;
    }

    private InvocationResult mavenCall(ItemWithProperties item) throws MavenInvocationException {
        InvocationRequest request = this.createAndConfigureAnInvocationRequest(item);
        OutputConsumer output = new OutputConsumer(this.getLog());
        request.setOutputHandler((InvocationOutputHandler)output);
        this.invoker.setWorkingDirectory(this.getWorkingDirectoryAfterPlaceHolderIsReplaced(item));
        return this.invoker.execute(request);
    }

    private void createLogOutput(ItemWithProperties item) {
        StringBuilder sb = new StringBuilder("------ ");
        sb.append(" iterator-maven-plugin ");
        sb.append("( iteration: ");
        sb.append(item.getName());
        sb.append(" )");
        this.getLog().info((CharSequence)sb.toString());
    }

    public void setThreads(String threads) {
        this.threads = threads;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }
}

