/*
 * Decompiled with CFR 0.152.
 */
package spark;

import spark.Filter;
import spark.Route;
import spark.route.HttpMethod;
import spark.route.RouteMatcher;
import spark.route.RouteMatcherFactory;
import spark.webserver.SparkServer;
import spark.webserver.SparkServerFactory;

public final class Spark {
    private static final int SPARK_DEFAULT_PORT = 4567;
    private static boolean initialized = false;
    private static SparkServer server;
    private static RouteMatcher routeMatcher;
    private static String ipAddress;
    private static int port;
    private static String keystoreFile;
    private static String keystorePassword;
    private static String truststoreFile;
    private static String truststorePassword;
    private static String staticFileFolder;
    private static String externalStaticFileFolder;

    private Spark() {
    }

    public static synchronized void setIpAddress(String ipAddress) {
        if (initialized) {
            Spark.throwBeforeRouteMappingException();
        }
        Spark.ipAddress = ipAddress;
    }

    public static synchronized void setPort(int port) {
        if (initialized) {
            Spark.throwBeforeRouteMappingException();
        }
        Spark.port = port;
    }

    public static synchronized void setSecure(String keystoreFile, String keystorePassword, String truststoreFile, String truststorePassword) {
        if (initialized) {
            Spark.throwBeforeRouteMappingException();
        }
        if (keystoreFile == null) {
            throw new IllegalArgumentException("Must provide a keystore file to run secured");
        }
        Spark.keystoreFile = keystoreFile;
        Spark.keystorePassword = keystorePassword;
        Spark.truststoreFile = truststoreFile;
        Spark.truststorePassword = truststorePassword;
    }

    public static synchronized void staticFileLocation(String folder) {
        if (initialized) {
            Spark.throwBeforeRouteMappingException();
        }
        staticFileFolder = folder;
    }

    public static synchronized void externalStaticFileLocation(String externalFolder) {
        if (initialized) {
            Spark.throwBeforeRouteMappingException();
        }
        externalStaticFileFolder = externalFolder;
    }

    public static synchronized void get(Route route) {
        Spark.addRoute(HttpMethod.get.name(), route);
    }

    public static synchronized void post(Route route) {
        Spark.addRoute(HttpMethod.post.name(), route);
    }

    public static synchronized void put(Route route) {
        Spark.addRoute(HttpMethod.put.name(), route);
    }

    public static synchronized void patch(Route route) {
        Spark.addRoute(HttpMethod.patch.name(), route);
    }

    public static synchronized void delete(Route route) {
        Spark.addRoute(HttpMethod.delete.name(), route);
    }

    public static synchronized void head(Route route) {
        Spark.addRoute(HttpMethod.head.name(), route);
    }

    public static synchronized void trace(Route route) {
        Spark.addRoute(HttpMethod.trace.name(), route);
    }

    public static synchronized void connect(Route route) {
        Spark.addRoute(HttpMethod.connect.name(), route);
    }

    public static synchronized void options(Route route) {
        Spark.addRoute(HttpMethod.options.name(), route);
    }

    public static synchronized void before(Filter filter) {
        Spark.addFilter(HttpMethod.before.name(), filter);
    }

    public static synchronized void after(Filter filter) {
        Spark.addFilter(HttpMethod.after.name(), filter);
    }

    static synchronized void runFromServlet() {
        if (!initialized) {
            routeMatcher = RouteMatcherFactory.get();
            initialized = true;
        }
    }

    static synchronized void clearRoutes() {
        routeMatcher.clearRoutes();
    }

    static synchronized void stop() {
        if (server != null) {
            server.stop();
        }
        initialized = false;
    }

    private static void addRoute(String httpMethod, Route route) {
        Spark.init();
        routeMatcher.parseValidateAddRoute(httpMethod + " '" + route.getPath() + "'", route.getAcceptType(), route);
    }

    private static void addFilter(String httpMethod, Filter filter) {
        Spark.init();
        routeMatcher.parseValidateAddRoute(httpMethod + " '" + filter.getPath() + "'", filter.getAcceptType(), filter);
    }

    private static boolean hasMultipleHandlers() {
        return staticFileFolder != null || externalStaticFileFolder != null;
    }

    private static synchronized void init() {
        if (!initialized) {
            routeMatcher = RouteMatcherFactory.get();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    server = SparkServerFactory.create(Spark.hasMultipleHandlers());
                    server.ignite(ipAddress, port, keystoreFile, keystorePassword, truststoreFile, truststorePassword, staticFileFolder, externalStaticFileFolder);
                }
            }).start();
            initialized = true;
        }
    }

    private static void throwBeforeRouteMappingException() {
        throw new IllegalStateException("This must be done before route mapping has begun");
    }

    static {
        ipAddress = "0.0.0.0";
        port = 4567;
        staticFileFolder = null;
        externalStaticFileFolder = null;
    }
}

