/*
 * Decompiled with CFR 0.152.
 */
package spark.embeddedserver.jetty;

import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import spark.ssl.SslStores;
import spark.utils.Assert;

public class SocketConnectorFactory {
    public static ServerConnector createSocketConnector(Server server, String host, int port) {
        Assert.notNull(server, "'server' must not be null");
        Assert.notNull(host, "'host' must not be null");
        HttpConnectionFactory httpConnectionFactory = SocketConnectorFactory.createHttpConnectionFactory();
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{httpConnectionFactory});
        SocketConnectorFactory.initializeConnector(connector, host, port);
        return connector;
    }

    public static ServerConnector createSecureSocketConnector(Server server, String host, int port, SslStores sslStores) {
        Assert.notNull(server, "'server' must not be null");
        Assert.notNull(host, "'host' must not be null");
        Assert.notNull(sslStores, "'sslStores' must not be null");
        SslContextFactory sslContextFactory = new SslContextFactory(sslStores.keystoreFile());
        if (sslStores.keystorePassword() != null) {
            sslContextFactory.setKeyStorePassword(sslStores.keystorePassword());
        }
        if (sslStores.certAlias() != null) {
            sslContextFactory.setCertAlias(sslStores.certAlias());
        }
        if (sslStores.trustStoreFile() != null) {
            sslContextFactory.setTrustStorePath(sslStores.trustStoreFile());
        }
        if (sslStores.trustStorePassword() != null) {
            sslContextFactory.setTrustStorePassword(sslStores.trustStorePassword());
        }
        if (sslStores.needsClientCert()) {
            sslContextFactory.setNeedClientAuth(true);
            sslContextFactory.setWantClientAuth(true);
        }
        HttpConnectionFactory httpConnectionFactory = SocketConnectorFactory.createHttpConnectionFactory();
        ServerConnector connector = new ServerConnector(server, sslContextFactory, new ConnectionFactory[]{httpConnectionFactory});
        SocketConnectorFactory.initializeConnector(connector, host, port);
        return connector;
    }

    private static void initializeConnector(ServerConnector connector, String host, int port) {
        connector.setIdleTimeout(TimeUnit.HOURS.toMillis(1L));
        connector.setHost(host);
        connector.setPort(port);
    }

    private static HttpConnectionFactory createHttpConnectionFactory() {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSecureScheme("https");
        httpConfig.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
        return new HttpConnectionFactory(httpConfig);
    }
}

