/*
 * Decompiled with CFR 0.152.
 */
package retrofit;

import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.ResponseBody;
import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import retrofit.Converter;
import retrofit.Utils;
import retrofit.http.Streaming;

final class BuiltInConverters
extends Converter.Factory {
    BuiltInConverters() {
    }

    @Override
    public Converter<ResponseBody, ?> fromResponseBody(Type type, Annotation[] annotations) {
        if (ResponseBody.class.equals((Object)type)) {
            boolean isStreaming = Utils.isAnnotationPresent(annotations, Streaming.class);
            return new OkHttpResponseBodyConverter(isStreaming);
        }
        if (Void.class.equals((Object)type)) {
            return new VoidConverter();
        }
        return null;
    }

    @Override
    public Converter<?, RequestBody> toRequestBody(Type type, Annotation[] annotations) {
        if (type instanceof Class && RequestBody.class.isAssignableFrom((Class)type)) {
            return new OkHttpRequestBodyConverter();
        }
        return null;
    }

    static final class OkHttpResponseBodyConverter
    implements Converter<ResponseBody, ResponseBody> {
        private final boolean isStreaming;

        OkHttpResponseBodyConverter(boolean isStreaming) {
            this.isStreaming = isStreaming;
        }

        @Override
        public ResponseBody convert(ResponseBody value) throws IOException {
            if (this.isStreaming) {
                return value;
            }
            try {
                ResponseBody responseBody = Utils.readBodyToBytesIfNecessary(value);
                return responseBody;
            }
            finally {
                Utils.closeQuietly((Closeable)value);
            }
        }
    }

    static final class OkHttpRequestBodyConverter
    implements Converter<RequestBody, RequestBody> {
        OkHttpRequestBodyConverter() {
        }

        @Override
        public RequestBody convert(RequestBody value) throws IOException {
            return value;
        }
    }

    static final class VoidConverter
    implements Converter<ResponseBody, Void> {
        VoidConverter() {
        }

        @Override
        public Void convert(ResponseBody value) throws IOException {
            value.close();
            return null;
        }
    }
}

