/*
 * Decompiled with CFR 0.152.
 */
package retrofit;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.Executor;
import retrofit.Call;
import retrofit.CallAdapter;
import retrofit.Callback;
import retrofit.Response;
import retrofit.Retrofit;
import retrofit.Utils;

final class ExecutorCallAdapterFactory
implements CallAdapter.Factory {
    private final Executor callbackExecutor;

    ExecutorCallAdapterFactory(Executor callbackExecutor) {
        this.callbackExecutor = callbackExecutor;
    }

    public CallAdapter<Call<?>> get(Type returnType, Annotation[] annotations, Retrofit retrofit) {
        if (Utils.getRawType(returnType) != Call.class) {
            return null;
        }
        final Type responseType = Utils.getCallResponseType(returnType);
        return new CallAdapter<Call<?>>(){

            @Override
            public Type responseType() {
                return responseType;
            }

            @Override
            public <R> Call<R> adapt(Call<R> call) {
                return new ExecutorCallbackCall<R>(ExecutorCallAdapterFactory.this.callbackExecutor, call);
            }
        };
    }

    static final class ExecutorCallback<T>
    implements Callback<T> {
        private final Executor callbackExecutor;
        private final Callback<T> delegate;

        ExecutorCallback(Executor callbackExecutor, Callback<T> delegate) {
            this.callbackExecutor = callbackExecutor;
            this.delegate = delegate;
        }

        @Override
        public void onResponse(final Response<T> response, final Retrofit retrofit) {
            this.callbackExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    ExecutorCallback.this.delegate.onResponse(response, retrofit);
                }
            });
        }

        @Override
        public void onFailure(final Throwable t) {
            this.callbackExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    ExecutorCallback.this.delegate.onFailure(t);
                }
            });
        }
    }

    static final class ExecutorCallbackCall<T>
    implements Call<T> {
        private final Executor callbackExecutor;
        private final Call<T> delegate;

        ExecutorCallbackCall(Executor callbackExecutor, Call<T> delegate) {
            this.callbackExecutor = callbackExecutor;
            this.delegate = delegate;
        }

        @Override
        public void enqueue(Callback<T> callback) {
            this.delegate.enqueue(new ExecutorCallback<T>(this.callbackExecutor, callback));
        }

        @Override
        public Response<T> execute() throws IOException {
            return this.delegate.execute();
        }

        @Override
        public void cancel() {
            this.delegate.cancel();
        }

        @Override
        public Call<T> clone() {
            return new ExecutorCallbackCall<T>(this.callbackExecutor, this.delegate.clone());
        }
    }
}

