/*
 * Decompiled with CFR 0.152.
 */
package retrofit;

import com.squareup.okhttp.ResponseBody;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import retrofit.CallAdapter;
import retrofit.Converter;
import retrofit.OkHttpCall;
import retrofit.RequestFactory;
import retrofit.RequestFactoryParser;
import retrofit.Retrofit;
import retrofit.Utils;

final class MethodHandler<T> {
    private final Retrofit retrofit;
    private final RequestFactory requestFactory;
    private final CallAdapter<T> callAdapter;
    private final Converter<ResponseBody, T> responseConverter;

    static MethodHandler<?> create(Retrofit retrofit, Method method) {
        CallAdapter<?> callAdapter = MethodHandler.createCallAdapter(method, retrofit);
        Type responseType = callAdapter.responseType();
        Converter<ResponseBody, ?> responseConverter = MethodHandler.createResponseConverter(method, retrofit, responseType);
        RequestFactory requestFactory = RequestFactoryParser.parse(method, responseType, retrofit);
        return new MethodHandler(retrofit, requestFactory, callAdapter, responseConverter);
    }

    private static CallAdapter<?> createCallAdapter(Method method, Retrofit retrofit) {
        Type returnType = method.getGenericReturnType();
        if (Utils.hasUnresolvableType(returnType)) {
            throw Utils.methodError(method, "Method return type must not include a type variable or wildcard: %s", returnType);
        }
        if (returnType == Void.TYPE) {
            throw Utils.methodError(method, "Service methods cannot return void.", new Object[0]);
        }
        Annotation[] annotations = method.getAnnotations();
        try {
            return retrofit.callAdapter(returnType, annotations);
        }
        catch (RuntimeException e) {
            throw Utils.methodError(e, method, "Unable to create call adapter for %s", returnType);
        }
    }

    private static Converter<ResponseBody, ?> createResponseConverter(Method method, Retrofit retrofit, Type responseType) {
        Annotation[] annotations = method.getAnnotations();
        try {
            return retrofit.responseConverter(responseType, annotations);
        }
        catch (RuntimeException e) {
            throw Utils.methodError(e, method, "Unable to create converter for %s", responseType);
        }
    }

    private MethodHandler(Retrofit retrofit, RequestFactory requestFactory, CallAdapter<T> callAdapter, Converter<ResponseBody, T> responseConverter) {
        this.retrofit = retrofit;
        this.requestFactory = requestFactory;
        this.callAdapter = callAdapter;
        this.responseConverter = responseConverter;
    }

    Object invoke(Object ... args) {
        return this.callAdapter.adapt(new OkHttpCall<T>(this.retrofit, this.requestFactory, this.responseConverter, args));
    }
}

