/*
 * Decompiled with CFR 0.152.
 */
package retrofit;

import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.ResponseBody;
import java.io.Closeable;
import java.io.IOException;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;
import retrofit.Call;
import retrofit.Callback;
import retrofit.Converter;
import retrofit.RequestFactory;
import retrofit.Response;
import retrofit.Retrofit;
import retrofit.Utils;

final class OkHttpCall<T>
implements Call<T> {
    private final Retrofit retrofit;
    private final RequestFactory requestFactory;
    private final Converter<ResponseBody, T> responseConverter;
    private final Object[] args;
    private volatile com.squareup.okhttp.Call rawCall;
    private boolean executed;
    private volatile boolean canceled;

    OkHttpCall(Retrofit retrofit, RequestFactory requestFactory, Converter<ResponseBody, T> responseConverter, Object[] args) {
        this.retrofit = retrofit;
        this.requestFactory = requestFactory;
        this.responseConverter = responseConverter;
        this.args = args;
    }

    @Override
    public OkHttpCall<T> clone() {
        return new OkHttpCall<T>(this.retrofit, this.requestFactory, this.responseConverter, this.args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(final Callback<T> callback) {
        com.squareup.okhttp.Call rawCall;
        OkHttpCall okHttpCall = this;
        synchronized (okHttpCall) {
            if (this.executed) {
                throw new IllegalStateException("Already executed");
            }
            this.executed = true;
        }
        try {
            rawCall = this.createRawCall();
        }
        catch (Throwable t) {
            callback.onFailure(t);
            return;
        }
        if (this.canceled) {
            rawCall.cancel();
        }
        this.rawCall = rawCall;
        rawCall.enqueue(new com.squareup.okhttp.Callback(){

            private void callFailure(Throwable e) {
                try {
                    callback.onFailure(e);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }

            private void callSuccess(Response<T> response) {
                try {
                    callback.onResponse(response, OkHttpCall.this.retrofit);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }

            public void onFailure(Request request, IOException e) {
                this.callFailure(e);
            }

            public void onResponse(com.squareup.okhttp.Response rawResponse) {
                Response response;
                try {
                    response = OkHttpCall.this.parseResponse(rawResponse);
                }
                catch (Throwable e) {
                    this.callFailure(e);
                    return;
                }
                this.callSuccess(response);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response<T> execute() throws IOException {
        OkHttpCall okHttpCall = this;
        synchronized (okHttpCall) {
            if (this.executed) {
                throw new IllegalStateException("Already executed");
            }
            this.executed = true;
        }
        com.squareup.okhttp.Call rawCall = this.createRawCall();
        if (this.canceled) {
            rawCall.cancel();
        }
        this.rawCall = rawCall;
        return this.parseResponse(rawCall.execute());
    }

    private com.squareup.okhttp.Call createRawCall() {
        return this.retrofit.client().newCall(this.requestFactory.create(this.args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response<T> parseResponse(com.squareup.okhttp.Response rawResponse) throws IOException {
        ResponseBody rawBody = rawResponse.body();
        int code = (rawResponse = rawResponse.newBuilder().body((ResponseBody)new NoContentResponseBody(rawBody.contentType(), rawBody.contentLength())).build()).code();
        if (code < 200 || code >= 300) {
            try {
                ResponseBody bufferedBody = Utils.readBodyToBytesIfNecessary(rawBody);
                Response response = Response.error(bufferedBody, rawResponse);
                return response;
            }
            finally {
                Utils.closeQuietly((Closeable)rawBody);
            }
        }
        if (code == 204 || code == 205) {
            return Response.success(null, rawResponse);
        }
        ExceptionCatchingRequestBody catchingBody = new ExceptionCatchingRequestBody(rawBody);
        try {
            T body = this.responseConverter.convert(catchingBody);
            return Response.success(body, rawResponse);
        }
        catch (RuntimeException e) {
            catchingBody.throwIfCaught();
            throw e;
        }
    }

    @Override
    public void cancel() {
        this.canceled = true;
        com.squareup.okhttp.Call rawCall = this.rawCall;
        if (rawCall != null) {
            rawCall.cancel();
        }
    }

    static final class ExceptionCatchingRequestBody
    extends ResponseBody {
        private final ResponseBody delegate;
        private IOException thrownException;

        ExceptionCatchingRequestBody(ResponseBody delegate) {
            this.delegate = delegate;
        }

        public MediaType contentType() {
            return this.delegate.contentType();
        }

        public long contentLength() throws IOException {
            try {
                return this.delegate.contentLength();
            }
            catch (IOException e) {
                this.thrownException = e;
                throw e;
            }
        }

        public BufferedSource source() throws IOException {
            BufferedSource delegateSource;
            try {
                delegateSource = this.delegate.source();
            }
            catch (IOException e) {
                this.thrownException = e;
                throw e;
            }
            return Okio.buffer((Source)new ForwardingSource((Source)delegateSource){

                public long read(Buffer sink, long byteCount) throws IOException {
                    try {
                        return super.read(sink, byteCount);
                    }
                    catch (IOException e) {
                        ExceptionCatchingRequestBody.this.thrownException = e;
                        throw e;
                    }
                }
            });
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        void throwIfCaught() throws IOException {
            if (this.thrownException != null) {
                throw this.thrownException;
            }
        }
    }

    static final class NoContentResponseBody
    extends ResponseBody {
        private final MediaType contentType;
        private final long contentLength;

        NoContentResponseBody(MediaType contentType, long contentLength) {
            this.contentType = contentType;
            this.contentLength = contentLength;
        }

        public MediaType contentType() {
            return this.contentType;
        }

        public long contentLength() throws IOException {
            return this.contentLength;
        }

        public BufferedSource source() throws IOException {
            throw new IllegalStateException("Cannot read raw response body of a converted body.");
        }
    }
}

