/*
 * Decompiled with CFR 0.152.
 */
package retrofit;

import com.squareup.okhttp.Headers;
import com.squareup.okhttp.RequestBody;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Map;
import retrofit.Converter;
import retrofit.RequestBuilder;
import retrofit.Retrofit;
import retrofit.Utils;

abstract class RequestBuilderAction {
    RequestBuilderAction() {
    }

    abstract void perform(RequestBuilder var1, Object var2);

    static final class Body<T>
    extends RequestBuilderAction {
        private final Converter<T, RequestBody> converter;

        Body(Converter<T, RequestBody> converter) {
            this.converter = converter;
        }

        @Override
        void perform(RequestBuilder builder, Object value) {
            RequestBody body;
            if (value == null) {
                throw new IllegalArgumentException("Body parameter value must not be null.");
            }
            try {
                body = this.converter.convert(value);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to convert " + value + " to RequestBody");
            }
            builder.setBody(body);
        }
    }

    static final class PartMap
    extends RequestBuilderAction {
        private final Retrofit retrofit;
        private final String transferEncoding;
        private final Annotation[] annotations;

        PartMap(Retrofit retrofit, String transferEncoding, Annotation[] annotations) {
            this.retrofit = retrofit;
            this.transferEncoding = transferEncoding;
            this.annotations = annotations;
        }

        @Override
        void perform(RequestBuilder builder, Object value) {
            if (value == null) {
                return;
            }
            Map map = (Map)value;
            for (Map.Entry entry : map.entrySet()) {
                RequestBody body;
                Object entryKey = entry.getKey();
                if (entryKey == null) {
                    throw new IllegalArgumentException("Part map contained null key.");
                }
                Object entryValue = entry.getValue();
                if (entryValue == null) continue;
                Headers headers = Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + entryKey + "\"", "Content-Transfer-Encoding", this.transferEncoding});
                Class<?> entryClass = entryValue.getClass();
                Converter converter = this.retrofit.requestConverter(entryClass, this.annotations);
                try {
                    body = converter.convert(entryValue);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to convert " + entryValue + " to RequestBody");
                }
                builder.addPart(headers, body);
            }
        }
    }

    static final class Part<T>
    extends RequestBuilderAction {
        private final Headers headers;
        private final Converter<T, RequestBody> converter;

        Part(Headers headers, Converter<T, RequestBody> converter) {
            this.headers = headers;
            this.converter = converter;
        }

        @Override
        void perform(RequestBuilder builder, Object value) {
            RequestBody body;
            if (value == null) {
                return;
            }
            try {
                body = this.converter.convert(value);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to convert " + value + " to RequestBody");
            }
            builder.addPart(this.headers, body);
        }
    }

    static final class FieldMap
    extends RequestBuilderAction {
        private final boolean encoded;

        FieldMap(boolean encoded) {
            this.encoded = encoded;
        }

        @Override
        void perform(RequestBuilder builder, Object value) {
            if (value == null) {
                return;
            }
            Map map = (Map)value;
            for (Map.Entry entry : map.entrySet()) {
                Object entryKey = entry.getKey();
                if (entryKey == null) {
                    throw new IllegalArgumentException("Field map contained null key.");
                }
                Object entryValue = entry.getValue();
                if (entryValue == null) continue;
                builder.addFormField(entryKey.toString(), entryValue.toString(), this.encoded);
            }
        }
    }

    static final class Field
    extends RequestBuilderAction {
        private final String name;
        private final boolean encoded;

        Field(String name, boolean encoded) {
            this.name = Utils.checkNotNull(name, "name == null");
            this.encoded = encoded;
        }

        @Override
        void perform(RequestBuilder builder, Object value) {
            if (value == null) {
                return;
            }
            if (value instanceof Iterable) {
                for (Object iterableValue : (Iterable)value) {
                    if (iterableValue == null) continue;
                    builder.addFormField(this.name, iterableValue.toString(), this.encoded);
                }
            } else if (value.getClass().isArray()) {
                int arrayLength = Array.getLength(value);
                for (int x = 0; x < arrayLength; ++x) {
                    Object arrayValue = Array.get(value, x);
                    if (arrayValue == null) continue;
                    builder.addFormField(this.name, arrayValue.toString(), this.encoded);
                }
            } else {
                builder.addFormField(this.name, value.toString(), this.encoded);
            }
        }
    }

    static final class QueryMap
    extends RequestBuilderAction {
        private final boolean encoded;

        QueryMap(boolean encoded) {
            this.encoded = encoded;
        }

        @Override
        void perform(RequestBuilder builder, Object value) {
            if (value == null) {
                return;
            }
            Map map = (Map)value;
            for (Map.Entry entry : map.entrySet()) {
                Object entryKey = entry.getKey();
                if (entryKey == null) {
                    throw new IllegalArgumentException("Query map contained null key.");
                }
                Object entryValue = entry.getValue();
                if (entryValue == null) continue;
                builder.addQueryParam(entryKey.toString(), entryValue.toString(), this.encoded);
            }
        }
    }

    static final class Query
    extends RequestBuilderAction {
        private final String name;
        private final boolean encoded;

        Query(String name, boolean encoded) {
            this.name = Utils.checkNotNull(name, "name == null");
            this.encoded = encoded;
        }

        @Override
        void perform(RequestBuilder builder, Object value) {
            if (value == null) {
                return;
            }
            if (value instanceof Iterable) {
                for (Object iterableValue : (Iterable)value) {
                    if (iterableValue == null) continue;
                    builder.addQueryParam(this.name, iterableValue.toString(), this.encoded);
                }
            } else if (value.getClass().isArray()) {
                int arrayLength = Array.getLength(value);
                for (int x = 0; x < arrayLength; ++x) {
                    Object arrayValue = Array.get(value, x);
                    if (arrayValue == null) continue;
                    builder.addQueryParam(this.name, arrayValue.toString(), this.encoded);
                }
            } else {
                builder.addQueryParam(this.name, value.toString(), this.encoded);
            }
        }
    }

    static final class Path
    extends RequestBuilderAction {
        private final String name;
        private final boolean encoded;

        Path(String name, boolean encoded) {
            this.name = Utils.checkNotNull(name, "name == null");
            this.encoded = encoded;
        }

        @Override
        void perform(RequestBuilder builder, Object value) {
            if (value == null) {
                throw new IllegalArgumentException("Path parameter \"" + this.name + "\" value must not be null.");
            }
            builder.addPathParam(this.name, value.toString(), this.encoded);
        }
    }

    static final class Header
    extends RequestBuilderAction {
        private final String name;

        Header(String name) {
            this.name = Utils.checkNotNull(name, "name == null");
        }

        @Override
        void perform(RequestBuilder builder, Object value) {
            if (value == null) {
                return;
            }
            if (value instanceof Iterable) {
                for (Object iterableValue : (Iterable)value) {
                    if (iterableValue == null) continue;
                    builder.addHeader(this.name, iterableValue.toString());
                }
            } else if (value.getClass().isArray()) {
                int arrayLength = Array.getLength(value);
                for (int x = 0; x < arrayLength; ++x) {
                    Object arrayValue = Array.get(value, x);
                    if (arrayValue == null) continue;
                    builder.addHeader(this.name, arrayValue.toString());
                }
            } else {
                builder.addHeader(this.name, value.toString());
            }
        }
    }

    static final class Url
    extends RequestBuilderAction {
        Url() {
        }

        @Override
        void perform(RequestBuilder builder, Object value) {
            builder.setRelativeUrl((String)value);
        }
    }
}

