/*
 * Decompiled with CFR 0.152.
 */
package retrofit;

import com.squareup.okhttp.Headers;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import retrofit.Utils;

public final class Response<T> {
    private final com.squareup.okhttp.Response rawResponse;
    private final T body;
    private final ResponseBody errorBody;

    public static <T> Response<T> success(T body) {
        return Response.success(body, new Response.Builder().code(200).protocol(Protocol.HTTP_1_1).request(new Request.Builder().url(HttpUrl.parse((String)"http://localhost")).build()).build());
    }

    public static <T> Response<T> success(T body, com.squareup.okhttp.Response rawResponse) {
        return new Response<T>(rawResponse, body, null);
    }

    public static <T> Response<T> error(int code, ResponseBody body) {
        return Response.error(body, new Response.Builder().code(code).protocol(Protocol.HTTP_1_1).request(new Request.Builder().url(HttpUrl.parse((String)"http://localhost")).build()).build());
    }

    public static <T> Response<T> error(ResponseBody body, com.squareup.okhttp.Response rawResponse) {
        return new Response<Object>(rawResponse, null, body);
    }

    private Response(com.squareup.okhttp.Response rawResponse, T body, ResponseBody errorBody) {
        this.rawResponse = Utils.checkNotNull(rawResponse, "rawResponse == null");
        this.body = body;
        this.errorBody = errorBody;
    }

    public com.squareup.okhttp.Response raw() {
        return this.rawResponse;
    }

    public int code() {
        return this.rawResponse.code();
    }

    public String message() {
        return this.rawResponse.message();
    }

    public Headers headers() {
        return this.rawResponse.headers();
    }

    public boolean isSuccess() {
        return this.rawResponse.isSuccessful();
    }

    public T body() {
        return this.body;
    }

    public ResponseBody errorBody() {
        return this.errorBody;
    }
}

