/*
 * Decompiled with CFR 0.152.
 */
package retrofit;

import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.ResponseBody;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import retrofit.BaseUrl;
import retrofit.BuiltInConverters;
import retrofit.CallAdapter;
import retrofit.Converter;
import retrofit.MethodHandler;
import retrofit.Platform;
import retrofit.Utils;

public final class Retrofit {
    private final Map<Method, MethodHandler<?>> methodHandlerCache = new LinkedHashMap();
    private final OkHttpClient client;
    private final BaseUrl baseUrl;
    private final List<Converter.Factory> converterFactories;
    private final List<CallAdapter.Factory> adapterFactories;
    private final Executor callbackExecutor;
    private final boolean validateEagerly;

    private Retrofit(OkHttpClient client, BaseUrl baseUrl, List<Converter.Factory> converterFactories, List<CallAdapter.Factory> adapterFactories, Executor callbackExecutor, boolean validateEagerly) {
        this.client = client;
        this.baseUrl = baseUrl;
        this.converterFactories = converterFactories;
        this.adapterFactories = adapterFactories;
        this.callbackExecutor = callbackExecutor;
        this.validateEagerly = validateEagerly;
    }

    public <T> T create(final Class<T> service) {
        Utils.validateServiceInterface(service);
        if (this.validateEagerly) {
            this.eagerlyValidateMethods(service);
        }
        return (T)Proxy.newProxyInstance(service.getClassLoader(), new Class[]{service}, new InvocationHandler(){
            private final Platform platform = Platform.get();

            @Override
            public Object invoke(Object proxy, Method method, Object ... args) throws Throwable {
                if (method.getDeclaringClass() == Object.class) {
                    return method.invoke((Object)this, args);
                }
                if (this.platform.isDefaultMethod(method)) {
                    return this.platform.invokeDefaultMethod(method, service, proxy, args);
                }
                return Retrofit.this.loadMethodHandler(method).invoke(args);
            }
        });
    }

    private void eagerlyValidateMethods(Class<?> service) {
        Platform platform = Platform.get();
        for (Method method : service.getDeclaredMethods()) {
            if (platform.isDefaultMethod(method)) continue;
            this.loadMethodHandler(method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MethodHandler<?> loadMethodHandler(Method method) {
        MethodHandler<?> handler;
        Map<Method, MethodHandler<?>> map = this.methodHandlerCache;
        synchronized (map) {
            handler = this.methodHandlerCache.get(method);
            if (handler == null) {
                handler = MethodHandler.create(this, method);
                this.methodHandlerCache.put(method, handler);
            }
        }
        return handler;
    }

    public OkHttpClient client() {
        return this.client;
    }

    public BaseUrl baseUrl() {
        return this.baseUrl;
    }

    public List<CallAdapter.Factory> callAdapterFactories() {
        return Collections.unmodifiableList(this.adapterFactories);
    }

    public CallAdapter<?> callAdapter(Type returnType, Annotation[] annotations) {
        return this.nextCallAdapter(null, returnType, annotations);
    }

    public CallAdapter<?> nextCallAdapter(CallAdapter.Factory skipPast, Type returnType, Annotation[] annotations) {
        int i;
        int start;
        Utils.checkNotNull(returnType, "returnType == null");
        Utils.checkNotNull(annotations, "annotations == null");
        int count = this.adapterFactories.size();
        for (int i2 = start = this.adapterFactories.indexOf(skipPast) + 1; i2 < count; ++i2) {
            CallAdapter<?> adapter = this.adapterFactories.get(i2).get(returnType, annotations, this);
            if (adapter == null) continue;
            return adapter;
        }
        StringBuilder builder = new StringBuilder("Could not locate call adapter for ").append(returnType).append(". Tried:");
        int count2 = this.adapterFactories.size();
        for (i = start; i < count2; ++i) {
            builder.append("\n * ").append(this.adapterFactories.get(i).getClass().getName());
        }
        if (skipPast != null) {
            builder.append("\nSkipped:");
            for (i = 0; i < start; ++i) {
                builder.append("\n * ").append(this.adapterFactories.get(i).getClass().getName());
            }
        }
        throw new IllegalArgumentException(builder.toString());
    }

    public List<Converter.Factory> converterFactories() {
        return Collections.unmodifiableList(this.converterFactories);
    }

    public <T> Converter<T, RequestBody> requestConverter(Type type, Annotation[] annotations) {
        Utils.checkNotNull(type, "type == null");
        Utils.checkNotNull(annotations, "annotations == null");
        int count = this.converterFactories.size();
        for (int i = 0; i < count; ++i) {
            Converter<?, RequestBody> converter = this.converterFactories.get(i).toRequestBody(type, annotations);
            if (converter == null) continue;
            return converter;
        }
        StringBuilder builder = new StringBuilder("Could not locate RequestBody converter for ").append(type).append(". Tried:");
        for (Converter.Factory converterFactory : this.converterFactories) {
            builder.append("\n * ").append(converterFactory.getClass().getName());
        }
        throw new IllegalArgumentException(builder.toString());
    }

    public <T> Converter<ResponseBody, T> responseConverter(Type type, Annotation[] annotations) {
        Utils.checkNotNull(type, "type == null");
        Utils.checkNotNull(annotations, "annotations == null");
        int count = this.converterFactories.size();
        for (int i = 0; i < count; ++i) {
            Converter<ResponseBody, ?> converter = this.converterFactories.get(i).fromResponseBody(type, annotations);
            if (converter == null) continue;
            return converter;
        }
        StringBuilder builder = new StringBuilder("Could not locate ResponseBody converter for ").append(type).append(". Tried:");
        for (Converter.Factory converterFactory : this.converterFactories) {
            builder.append("\n * ").append(converterFactory.getClass().getName());
        }
        throw new IllegalArgumentException(builder.toString());
    }

    public Executor callbackExecutor() {
        return this.callbackExecutor;
    }

    public static final class Builder {
        private OkHttpClient client;
        private BaseUrl baseUrl;
        private List<Converter.Factory> converterFactories = new ArrayList<Converter.Factory>();
        private List<CallAdapter.Factory> adapterFactories = new ArrayList<CallAdapter.Factory>();
        private Executor callbackExecutor;
        private boolean validateEagerly;

        public Builder() {
            this.converterFactories.add(new BuiltInConverters());
        }

        public Builder client(OkHttpClient client) {
            this.client = Utils.checkNotNull(client, "client == null");
            return this;
        }

        public Builder baseUrl(String baseUrl) {
            Utils.checkNotNull(baseUrl, "baseUrl == null");
            HttpUrl httpUrl = HttpUrl.parse((String)baseUrl);
            if (httpUrl == null) {
                throw new IllegalArgumentException("Illegal URL: " + baseUrl);
            }
            return this.baseUrl(httpUrl);
        }

        public Builder baseUrl(final HttpUrl baseUrl) {
            Utils.checkNotNull(baseUrl, "baseUrl == null");
            return this.baseUrl(new BaseUrl(){

                @Override
                public HttpUrl url() {
                    return baseUrl;
                }
            });
        }

        public Builder baseUrl(BaseUrl baseUrl) {
            this.baseUrl = Utils.checkNotNull(baseUrl, "baseUrl == null");
            return this;
        }

        public Builder addConverterFactory(Converter.Factory converterFactory) {
            this.converterFactories.add(Utils.checkNotNull(converterFactory, "converterFactory == null"));
            return this;
        }

        public Builder addCallAdapterFactory(CallAdapter.Factory factory) {
            this.adapterFactories.add(Utils.checkNotNull(factory, "factory == null"));
            return this;
        }

        public Builder callbackExecutor(Executor callbackExecutor) {
            this.callbackExecutor = Utils.checkNotNull(callbackExecutor, "callbackExecutor == null");
            return this;
        }

        public Builder validateEagerly() {
            this.validateEagerly = true;
            return this;
        }

        public Retrofit build() {
            if (this.baseUrl == null) {
                throw new IllegalStateException("Base URL required.");
            }
            OkHttpClient client = this.client;
            if (client == null) {
                client = new OkHttpClient();
            }
            ArrayList<CallAdapter.Factory> adapterFactories = new ArrayList<CallAdapter.Factory>(this.adapterFactories);
            adapterFactories.add(Platform.get().defaultCallAdapterFactory(this.callbackExecutor));
            ArrayList<Converter.Factory> converterFactories = new ArrayList<Converter.Factory>(this.converterFactories);
            return new Retrofit(client, this.baseUrl, converterFactories, adapterFactories, this.callbackExecutor, this.validateEagerly);
        }
    }
}

