/*
 * Decompiled with CFR 0.152.
 */
package retrofit;

import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.ResponseBody;
import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import okio.Buffer;
import okio.BufferedSource;
import okio.Source;
import retrofit.Response;

final class Utils {
    static <T> T checkNotNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static boolean isAnnotationPresent(Annotation[] annotations, Class<? extends Annotation> cls) {
        for (Annotation annotation : annotations) {
            if (!cls.isInstance(annotation)) continue;
            return true;
        }
        return false;
    }

    static ResponseBody readBodyToBytesIfNecessary(ResponseBody body) throws IOException {
        if (body == null) {
            return null;
        }
        BufferedSource source = body.source();
        Buffer buffer = new Buffer();
        buffer.writeAll((Source)source);
        source.close();
        return ResponseBody.create((MediaType)body.contentType(), (long)body.contentLength(), (BufferedSource)buffer);
    }

    static <T> void validateServiceInterface(Class<T> service) {
        if (!service.isInterface()) {
            throw new IllegalArgumentException("API declarations must be interfaces.");
        }
        if (service.getInterfaces().length > 0) {
            throw new IllegalArgumentException("API interfaces must not extend other interfaces.");
        }
    }

    public static Type getSingleParameterUpperBound(ParameterizedType type) {
        Object[] types = type.getActualTypeArguments();
        if (types.length != 1) {
            throw new IllegalArgumentException("Expected one type argument but got: " + Arrays.toString(types));
        }
        Type paramType = types[0];
        if (paramType instanceof WildcardType) {
            return ((WildcardType)paramType).getUpperBounds()[0];
        }
        return paramType;
    }

    public static boolean hasUnresolvableType(Type type) {
        if (type instanceof Class) {
            return false;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            for (Type typeArgument : parameterizedType.getActualTypeArguments()) {
                if (!Utils.hasUnresolvableType(typeArgument)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof GenericArrayType) {
            return Utils.hasUnresolvableType(((GenericArrayType)type).getGenericComponentType());
        }
        if (type instanceof TypeVariable) {
            return true;
        }
        if (type instanceof WildcardType) {
            return true;
        }
        String className = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type + "> is of type " + className);
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (!(rawType instanceof Class)) {
                throw new IllegalArgumentException();
            }
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            return Array.newInstance(Utils.getRawType(componentType), 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return Object.class;
        }
        if (type instanceof WildcardType) {
            return Utils.getRawType(((WildcardType)type).getUpperBounds()[0]);
        }
        String className = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type + "> is of type " + className);
    }

    static RuntimeException methodError(Method method, String message, Object ... args) {
        return Utils.methodError(null, method, message, args);
    }

    static RuntimeException methodError(Throwable cause, Method method, String message, Object ... args) {
        message = String.format(message, args);
        IllegalArgumentException e = new IllegalArgumentException(message + "\n    for method " + method.getDeclaringClass().getSimpleName() + "." + method.getName());
        e.initCause(cause);
        return e;
    }

    static Type getCallResponseType(Type returnType) {
        if (!(returnType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Call return type must be parameterized as Call<Foo> or Call<? extends Foo>");
        }
        Type responseType = Utils.getSingleParameterUpperBound((ParameterizedType)returnType);
        if (Utils.getRawType(responseType) == Response.class) {
            throw new IllegalArgumentException("Call<T> cannot use Response as its generic parameter. Specify the response body type only (e.g., Call<TweetResponse>).");
        }
        return responseType;
    }

    private Utils() {
    }
}

