/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.test.framework;

import com.sun.jersey.spi.container.servlet.ServletContainer;
import com.sun.jersey.test.framework.AppDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;

public class WebAppDescriptor
extends AppDescriptor {
    private final Map<String, String> initParams;
    private final Map<String, String> contextParams;
    private final Class<? extends HttpServlet> servletClass;
    private final List<FilterDescriptor> filters;
    private final List<Class<? extends EventListener>> listeners;
    private final String contextPath;
    private final String servletPath;

    private WebAppDescriptor(Builder b) {
        super(b);
        this.initParams = b.initParams == null ? new HashMap() : b.initParams;
        this.contextParams = b.contextParams == null ? new HashMap() : b.contextParams;
        this.servletClass = b.servletClass;
        this.filters = b.filters;
        this.contextPath = b.contextPath;
        this.servletPath = b.servletPath;
        this.listeners = b.listeners == null ? Collections.emptyList() : Collections.unmodifiableList(b.listeners);
    }

    public Map<String, String> getInitParams() {
        return this.initParams;
    }

    public Map<String, String> getContextParams() {
        return this.contextParams;
    }

    public Class<? extends HttpServlet> getServletClass() {
        return this.servletClass;
    }

    public List<FilterDescriptor> getFilters() {
        return this.filters;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public List<Class<? extends EventListener>> getListeners() {
        return this.listeners;
    }

    public static class FilterDescriptor {
        private Class<? extends Filter> filterClass;
        private String filterName;
        private Map<String, String> initParams;

        FilterDescriptor(Class<? extends Filter> filterClass, String filterName, Map<String, String> initParams) {
            this.filterClass = filterClass;
            this.filterName = filterName;
            this.initParams = initParams;
        }

        public Class<? extends Filter> getFilterClass() {
            return this.filterClass;
        }

        public String getFilterName() {
            return this.filterName;
        }

        public Map<String, String> getInitParams() {
            return this.initParams;
        }
    }

    public static class Builder
    extends AppDescriptor.AppDescriptorBuilder<Builder, WebAppDescriptor> {
        protected Map<String, String> initParams;
        protected Map<String, String> contextParams;
        protected Class<? extends HttpServlet> servletClass = ServletContainer.class;
        protected List<FilterDescriptor> filters;
        protected List<Class<? extends EventListener>> listeners;
        protected String contextPath = "";
        protected String servletPath = "";

        public Builder() {
        }

        public Builder(Map<String, String> initParams) throws IllegalArgumentException {
            if (initParams == null) {
                throw new IllegalArgumentException("The initialization parameters must not be null");
            }
            this.initParams = new HashMap<String, String>();
            this.initParams.putAll(initParams);
        }

        public Builder(String name, String value) {
            this.initParam(name, value);
        }

        public Builder(String ... packages) throws IllegalArgumentException {
            if (packages == null) {
                throw new IllegalArgumentException("The packages must not be null");
            }
            StringBuilder sb = new StringBuilder();
            for (String packageName : packages) {
                if (sb.length() > 0) {
                    sb.append(';');
                }
                sb.append(packageName);
            }
            this.initParam("com.sun.jersey.config.property.packages", sb.toString());
        }

        public Builder initParam(String name, String value) {
            if (this.initParams == null) {
                this.initParams = new HashMap<String, String>();
            }
            this.initParams.put(name, value);
            return this;
        }

        public Builder contextParam(String name, String value) {
            if (this.contextParams == null) {
                this.contextParams = new HashMap<String, String>();
            }
            this.contextParams.put(name, value);
            return this;
        }

        public Builder servletClass(Class<? extends HttpServlet> servletClass) throws IllegalArgumentException {
            if (servletClass == null) {
                throw new IllegalArgumentException("The servlet class must not be null");
            }
            this.servletClass = servletClass;
            this.filters = null;
            return this;
        }

        public Builder filterClass(Class<? extends Filter> filterClass) throws IllegalArgumentException {
            if (filterClass == null) {
                throw new IllegalArgumentException("The filter class must not be null");
            }
            this.filters = new ArrayList<FilterDescriptor>();
            this.filters.add(new FilterDescriptor(filterClass, "jerseyfilter", null));
            this.servletClass = null;
            return this;
        }

        public Builder addFilter(Class<? extends Filter> filterClass, String filterName) throws IllegalArgumentException {
            return this.addFilter(filterClass, filterName, Collections.<String, String>emptyMap());
        }

        public Builder addFilter(Class<? extends Filter> filterClass, String filterName, Map<String, String> initParams) throws IllegalArgumentException {
            if (this.filters == null) {
                this.filters = new ArrayList<FilterDescriptor>();
            }
            if (filterClass == null) {
                throw new IllegalArgumentException("The filter class must not be null");
            }
            if (filterName == null || filterName.isEmpty()) {
                throw new IllegalArgumentException("The filter name must not be null or empty string");
            }
            if (initParams == null) {
                throw new IllegalArgumentException("Provided initParams are invalid; initParams must not be null");
            }
            this.filters.add(new FilterDescriptor(filterClass, filterName, initParams));
            return this;
        }

        public Builder contextPath(String contextPath) {
            if (contextPath == null) {
                throw new IllegalArgumentException("The context path must not be null");
            }
            this.contextPath = contextPath;
            return this;
        }

        public Builder servletPath(String servletPath) {
            if (servletPath == null) {
                throw new IllegalArgumentException("The servlet path must not be null");
            }
            this.servletPath = servletPath;
            return this;
        }

        public Builder contextListenerClass(Class<? extends ServletContextListener> contextListenerClass) {
            if (contextListenerClass == null) {
                throw new IllegalArgumentException("The servlet context listener class must not be null");
            }
            if (this.listeners == null) {
                this.listeners = new ArrayList<Class<? extends EventListener>>();
            }
            this.listeners.add(contextListenerClass);
            return this;
        }

        public Builder contextAttributeListenerClass(Class<? extends ServletContextAttributeListener> contextAttributeListenerClass) {
            if (contextAttributeListenerClass == null) {
                throw new IllegalArgumentException("The servlet context listener class must not be null");
            }
            if (this.listeners == null) {
                this.listeners = new ArrayList<Class<? extends EventListener>>();
            }
            this.listeners.add(contextAttributeListenerClass);
            return this;
        }

        public Builder requestListenerClass(Class<? extends ServletRequestListener> requestListenerClass) {
            if (requestListenerClass == null) {
                throw new IllegalArgumentException("The servlet request listener class must not be null");
            }
            if (this.listeners == null) {
                this.listeners = new ArrayList<Class<? extends EventListener>>();
            }
            this.listeners.add(requestListenerClass);
            return this;
        }

        public Builder requestAttributeListenerClass(Class<? extends ServletRequestAttributeListener> requestAttributeListenerClass) {
            if (requestAttributeListenerClass == null) {
                throw new IllegalArgumentException("The servlet request attribute listener class must not be null");
            }
            if (this.listeners == null) {
                this.listeners = new ArrayList<Class<? extends EventListener>>();
            }
            this.listeners.add(requestAttributeListenerClass);
            return this;
        }

        public Builder httpSessionListenerClass(Class<? extends HttpSessionListener> httpSessionListenerClass) {
            if (httpSessionListenerClass == null) {
                throw new IllegalArgumentException("The http session listener class must not be null");
            }
            if (this.listeners == null) {
                this.listeners = new ArrayList<Class<? extends EventListener>>();
            }
            this.listeners.add(httpSessionListenerClass);
            return this;
        }

        public Builder httpSessionActivationListenerClass(Class<? extends HttpSessionActivationListener> httpSessionActivationListenerClass) {
            if (httpSessionActivationListenerClass == null) {
                throw new IllegalArgumentException("The http session activation listener class must not be null");
            }
            if (this.listeners == null) {
                this.listeners = new ArrayList<Class<? extends EventListener>>();
            }
            this.listeners.add(httpSessionActivationListenerClass);
            return this;
        }

        public Builder httpSessionAttributeListenerClass(Class<? extends HttpSessionAttributeListener> httpSessionAttributeListenerClass) {
            if (httpSessionAttributeListenerClass == null) {
                throw new IllegalArgumentException("The http session attribute listener class must not be null");
            }
            if (this.listeners == null) {
                this.listeners = new ArrayList<Class<? extends EventListener>>();
            }
            this.listeners.add(httpSessionAttributeListenerClass);
            return this;
        }

        @Override
        public WebAppDescriptor build() {
            WebAppDescriptor wd = new WebAppDescriptor(this);
            this.reset();
            return wd;
        }

        @Override
        protected void reset() {
            super.reset();
            this.initParams = null;
            this.contextParams = null;
            this.servletClass = ServletContainer.class;
            this.filters = null;
            this.listeners = null;
            this.contextPath = "";
            this.servletPath = "";
        }
    }
}

