/*
 * Copyright (c) 1997, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Distribution License v. 1.0, which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

package com.sun.xml.ws.resources;

import java.util.Locale;
import java.util.ResourceBundle;
import com.sun.istack.localization.Localizable;
import com.sun.istack.localization.LocalizableMessageFactory;
import com.sun.istack.localization.LocalizableMessageFactory.ResourceBundleSupplier;
import com.sun.istack.localization.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class DispatchMessages {

    private static final String BUNDLE_NAME = "com.sun.xml.ws.resources.dispatch";
    private static final LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new DispatchMessages.BundleSupplier());
    private static final Localizer LOCALIZER = new Localizer();

    private DispatchMessages() {
    }

    public static Localizable localizableINVALID_NULLARG_SOAP_MSGMODE(Object arg0, Object arg1) {
        return MESSAGE_FACTORY.getMessage("invalid.nullarg.soap.msgmode", arg0, arg1);
    }

    /**
     * SOAP/HTTP Binding in {0} is not allowed with a null invocation argument. Must be: {1}
     * 
     */
    public static String INVALID_NULLARG_SOAP_MSGMODE(Object arg0, Object arg1) {
        return LOCALIZER.localize(localizableINVALID_NULLARG_SOAP_MSGMODE(arg0, arg1));
    }

    public static Localizable localizableINVALID_QUERY_STRING(Object arg0) {
        return MESSAGE_FACTORY.getMessage("invalid.query.string", arg0);
    }

    /**
     * Unable to resolve endpoint address using the supplied query string: {0}.
     * 
     */
    public static String INVALID_QUERY_STRING(Object arg0) {
        return LOCALIZER.localize(localizableINVALID_QUERY_STRING(arg0));
    }

    public static Localizable localizableINVALID_URI_DECODE() {
        return MESSAGE_FACTORY.getMessage("invalid.uri.decode");
    }

    /**
     * Unable to decode the resolved endpoint using UTF-8 encoding.
     * 
     */
    public static String INVALID_URI_DECODE() {
        return LOCALIZER.localize(localizableINVALID_URI_DECODE());
    }

    public static Localizable localizableINVALID_URI_RESOLUTION(Object arg0) {
        return MESSAGE_FACTORY.getMessage("invalid.uri.resolution", arg0);
    }

    /**
     * Unable to resolve endpoint address using the supplied path: {0}.
     * 
     */
    public static String INVALID_URI_RESOLUTION(Object arg0) {
        return LOCALIZER.localize(localizableINVALID_URI_RESOLUTION(arg0));
    }

    public static Localizable localizableINVALID_NULLARG_URI() {
        return MESSAGE_FACTORY.getMessage("invalid.nullarg.uri");
    }

    /**
     * Endpoint address URI is not allowed with a null argument
     * 
     */
    public static String INVALID_NULLARG_URI() {
        return LOCALIZER.localize(localizableINVALID_NULLARG_URI());
    }

    public static Localizable localizableINVALID_URI_PATH_QUERY(Object arg0, Object arg1) {
        return MESSAGE_FACTORY.getMessage("invalid.uri.path.query", arg0, arg1);
    }

    /**
     * Unable to construct a URI with this path info {0} and this query string {1}.
     * 
     */
    public static String INVALID_URI_PATH_QUERY(Object arg0, Object arg1) {
        return LOCALIZER.localize(localizableINVALID_URI_PATH_QUERY(arg0, arg1));
    }

    public static Localizable localizableINVALID_URI(Object arg0) {
        return MESSAGE_FACTORY.getMessage("invalid.uri", arg0);
    }

    /**
     * Endpoint String: {0} is and invalid URI.
     * 
     */
    public static String INVALID_URI(Object arg0) {
        return LOCALIZER.localize(localizableINVALID_URI(arg0));
    }

    public static Localizable localizableINVALID_DATASOURCE_DISPATCH_MSGMODE(Object arg0, Object arg1) {
        return MESSAGE_FACTORY.getMessage("invalid.datasource.dispatch.msgmode", arg0, arg1);
    }

    /**
     * Can not create Dispatch{@code <}DataSource{@code >} of Service.Mode.PAYLOAD{0}. Must be: {1}
     * 
     */
    public static String INVALID_DATASOURCE_DISPATCH_MSGMODE(Object arg0, Object arg1) {
        return LOCALIZER.localize(localizableINVALID_DATASOURCE_DISPATCH_MSGMODE(arg0, arg1));
    }

    public static Localizable localizableDUPLICATE_PORT(Object arg0) {
        return MESSAGE_FACTORY.getMessage("duplicate.port", arg0);
    }

    /**
     * WSDLPort {0} already exists. Can not create a port of the same QName.
     * 
     */
    public static String DUPLICATE_PORT(Object arg0) {
        return LOCALIZER.localize(localizableDUPLICATE_PORT(arg0));
    }

    public static Localizable localizableINVALID_SOAPMESSAGE_DISPATCH_BINDING(Object arg0, Object arg1) {
        return MESSAGE_FACTORY.getMessage("invalid.soapmessage.dispatch.binding", arg0, arg1);
    }

    /**
     * Can not create Dispatch{@code <}SOAPMessage{@code >} with {0} Binding. Must be: {1} Binding.
     * 
     */
    public static String INVALID_SOAPMESSAGE_DISPATCH_BINDING(Object arg0, Object arg1) {
        return LOCALIZER.localize(localizableINVALID_SOAPMESSAGE_DISPATCH_BINDING(arg0, arg1));
    }

    public static Localizable localizableINVALID_QUERY_LEADING_CHAR(Object arg0) {
        return MESSAGE_FACTORY.getMessage("invalid.query.leading.char", arg0);
    }

    /**
     * Leading '?' of MessageContext.QUERY_STRING: {0} is not valid. Remove '?' and run again.
     * 
     */
    public static String INVALID_QUERY_LEADING_CHAR(Object arg0) {
        return LOCALIZER.localize(localizableINVALID_QUERY_LEADING_CHAR(arg0));
    }

    public static Localizable localizableINVALID_RESPONSE_DESERIALIZATION() {
        return MESSAGE_FACTORY.getMessage("invalid.response.deserialization");
    }

    /**
     * Failed to deserialize the response.
     * 
     */
    public static String INVALID_RESPONSE_DESERIALIZATION() {
        return LOCALIZER.localize(localizableINVALID_RESPONSE_DESERIALIZATION());
    }

    public static Localizable localizableINVALID_RESPONSE() {
        return MESSAGE_FACTORY.getMessage("invalid.response");
    }

    /**
     * No response returned.
     * 
     */
    public static String INVALID_RESPONSE() {
        return LOCALIZER.localize(localizableINVALID_RESPONSE());
    }

    public static Localizable localizableINVALID_SOAPMESSAGE_DISPATCH_MSGMODE(Object arg0, Object arg1) {
        return MESSAGE_FACTORY.getMessage("invalid.soapmessage.dispatch.msgmode", arg0, arg1);
    }

    /**
     * Can not create Dispatch{@code <}SOAPMessage{@code >} of {0}. Must be {1}.
     * 
     */
    public static String INVALID_SOAPMESSAGE_DISPATCH_MSGMODE(Object arg0, Object arg1) {
        return LOCALIZER.localize(localizableINVALID_SOAPMESSAGE_DISPATCH_MSGMODE(arg0, arg1));
    }

    public static Localizable localizableINVALID_DATASOURCE_DISPATCH_BINDING(Object arg0, Object arg1) {
        return MESSAGE_FACTORY.getMessage("invalid.datasource.dispatch.binding", arg0, arg1);
    }

    /**
     * Can not create Dispatch{@code <}DataSource{@code >} with {0}. Must be: {1}
     * 
     */
    public static String INVALID_DATASOURCE_DISPATCH_BINDING(Object arg0, Object arg1) {
        return LOCALIZER.localize(localizableINVALID_DATASOURCE_DISPATCH_BINDING(arg0, arg1));
    }

    public static Localizable localizableINVALID_NULLARG_XMLHTTP_REQUEST_METHOD(Object arg0, Object arg1) {
        return MESSAGE_FACTORY.getMessage("invalid.nullarg.xmlhttp.request.method", arg0, arg1);
    }

    /**
     * A XML/HTTP request using MessageContext.HTTP_REQUEST_METHOD equals {0} with a Null invocation Argument is not allowed. Must be: {1}
     * 
     */
    public static String INVALID_NULLARG_XMLHTTP_REQUEST_METHOD(Object arg0, Object arg1) {
        return LOCALIZER.localize(localizableINVALID_NULLARG_XMLHTTP_REQUEST_METHOD(arg0, arg1));
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
