/*
 * (c) 2003-2005, 2009, 2010 ThoughtWorks Ltd
 * All rights reserved.
 *
 * The software in this package is published under the terms of the BSD
 * style license a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 * 
 * Created on 03-May-2004
 */
package com.thoughtworks.proxy.factory;

import com.thoughtworks.proxy.Invoker;


/**
 * Interface to access the {@link Invoker} of the proxy. Every proxy generated by ProxyToys implements this interface.
 *
 * @author Aslak Helles&oslash;y
 * @since 0.1
 */
public interface InvokerReference {
    /**
     * Retrieve the Invoker instance from the proxy.
     *
     * @return the {@link Invoker} instance.
     * @since 0.1
     */
    Invoker getInvoker();
}