/*
 * Decompiled with CFR 0.152.
 */
package com.uber.nullaway;

import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.util.ASTHelpers;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import com.uber.nullaway.AutoValue_AbstractConfig_MethodClassAndName;
import com.uber.nullaway.Config;
import com.uber.nullaway.Nullness;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public abstract class AbstractConfig
implements Config {
    protected Pattern annotatedPackages;
    protected Pattern unannotatedSubPackages;
    @Nullable
    protected ImmutableSet<String> sourceClassesToExclude;
    @Nullable
    protected ImmutableSet<String> unannotatedClasses;
    protected Pattern fieldAnnotPattern;
    protected boolean isExhaustiveOverride;
    protected boolean isSuggestSuppressions;
    protected boolean isAcknowledgeRestrictive;
    protected boolean checkOptionalEmptiness;
    protected boolean handleTestAssertionLibraries;
    protected Set<String> optionalClassPaths;
    protected boolean assertsEnabled;
    protected boolean treatGeneratedAsUnannotated;
    protected boolean acknowledgeAndroidRecent;
    protected Set<MethodClassAndName> knownInitializers;
    protected Set<String> excludedClassAnnotations;
    protected Set<String> initializerAnnotations;
    protected Set<String> externalInitAnnotations;
    @Nullable
    protected String castToNonNullMethod;
    protected String autofixSuppressionComment;
    protected boolean jarInferEnabled;
    protected boolean jarInferUseReturnAnnotations;
    protected String jarInferRegexStripModelJarName;
    protected String jarInferRegexStripCodeJarName;
    protected String errorURL;

    protected static Pattern getPackagePattern(Set<String> packagePrefixes) {
        String choiceRegexp = Joiner.on((String)"|").join(Iterables.transform(packagePrefixes, input -> input.replaceAll("\\.", "\\\\.")));
        return Pattern.compile("^(?:" + choiceRegexp + ")(?:\\..*)?");
    }

    @Override
    public boolean fromAnnotatedPackage(Symbol.ClassSymbol symbol) {
        String className = symbol.getQualifiedName().toString();
        return this.annotatedPackages.matcher(className).matches() && !this.unannotatedSubPackages.matcher(className).matches() && (!this.treatGeneratedAsUnannotated || !ASTHelpers.hasDirectAnnotationWithSimpleName((Symbol)symbol, (String)"Generated"));
    }

    @Override
    public boolean isExcludedClass(String className) {
        if (this.sourceClassesToExclude == null) {
            return false;
        }
        for (String classPrefix : this.sourceClassesToExclude) {
            if (!className.startsWith(classPrefix)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isUnannotatedClass(Symbol.ClassSymbol symbol) {
        if (this.unannotatedClasses == null) {
            return false;
        }
        String className = symbol.getQualifiedName().toString();
        for (String classPrefix : this.unannotatedClasses) {
            if (!className.startsWith(classPrefix)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ImmutableSet<String> getExcludedClassAnnotations() {
        return ImmutableSet.copyOf(this.excludedClassAnnotations);
    }

    @Override
    public boolean isInitializerMethodAnnotation(String annotationName) {
        return this.initializerAnnotations.contains(annotationName);
    }

    @Override
    public boolean exhaustiveOverride() {
        return this.isExhaustiveOverride;
    }

    @Override
    public boolean isKnownInitializerMethod(Symbol.MethodSymbol methodSymbol) {
        Symbol.ClassSymbol enclosingClass = ASTHelpers.enclosingClass((Symbol)methodSymbol);
        MethodClassAndName classAndName = MethodClassAndName.create(enclosingClass.getQualifiedName().toString(), ((Name)methodSymbol.getSimpleName()).toString());
        return this.knownInitializers.contains(classAndName);
    }

    @Override
    public boolean isExcludedFieldAnnotation(String annotationName) {
        return Nullness.isNullableAnnotation(annotationName, this) || this.fieldAnnotPattern != null && this.fieldAnnotPattern.matcher(annotationName).matches();
    }

    @Override
    public boolean suggestSuppressions() {
        return this.isSuggestSuppressions;
    }

    @Override
    public boolean acknowledgeRestrictiveAnnotations() {
        return this.isAcknowledgeRestrictive;
    }

    @Override
    public boolean checkOptionalEmptiness() {
        return this.checkOptionalEmptiness;
    }

    @Override
    public boolean handleTestAssertionLibraries() {
        return this.handleTestAssertionLibraries;
    }

    @Override
    public Set<String> getOptionalClassPaths() {
        return this.optionalClassPaths;
    }

    @Override
    public boolean assertsEnabled() {
        return this.assertsEnabled;
    }

    @Override
    @Nullable
    public String getCastToNonNullMethod() {
        return this.castToNonNullMethod;
    }

    @Override
    public String getAutofixSuppressionComment() {
        if (this.autofixSuppressionComment.trim().length() > 0) {
            return "/* " + this.autofixSuppressionComment + " */ ";
        }
        return "";
    }

    @Override
    public boolean isExternalInitClassAnnotation(String annotationName) {
        return this.externalInitAnnotations.contains(annotationName);
    }

    protected Set<MethodClassAndName> getKnownInitializers(Set<String> qualifiedNames) {
        LinkedHashSet<MethodClassAndName> result = new LinkedHashSet<MethodClassAndName>();
        for (String name : qualifiedNames) {
            int lastDot = name.lastIndexOf(46);
            String methodName = name.substring(lastDot + 1);
            String className = name.substring(0, lastDot);
            result.add(MethodClassAndName.create(className, methodName));
        }
        return result;
    }

    @Override
    public boolean isJarInferEnabled() {
        return this.jarInferEnabled;
    }

    @Override
    public boolean isJarInferUseReturnAnnotations() {
        return this.jarInferUseReturnAnnotations;
    }

    @Override
    public String getJarInferRegexStripModelJarName() {
        return this.jarInferRegexStripModelJarName;
    }

    @Override
    public String getJarInferRegexStripCodeJarName() {
        return this.jarInferRegexStripCodeJarName;
    }

    @Override
    public String getErrorURL() {
        return this.errorURL;
    }

    @Override
    public boolean treatGeneratedAsUnannotated() {
        return this.treatGeneratedAsUnannotated;
    }

    @Override
    public boolean acknowledgeAndroidRecent() {
        return this.acknowledgeAndroidRecent;
    }

    @AutoValue
    static abstract class MethodClassAndName {
        MethodClassAndName() {
        }

        static MethodClassAndName create(String enclosingClass, String methodName) {
            return new AutoValue_AbstractConfig_MethodClassAndName(enclosingClass, methodName);
        }

        abstract String enclosingClass();

        abstract String methodName();
    }
}

