/*
 * Decompiled with CFR 0.152.
 */
package com.uber.nullaway;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.errorprone.VisitorState;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Name;
import com.uber.nullaway.Config;
import com.uber.nullaway.ErrorMessage;
import com.uber.nullaway.NullAway;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;

public class ErrorBuilder {
    private final Config config;
    private final String suppressionName;
    private final Set<String> allNames;

    ErrorBuilder(Config config, String suppressionName, Set<String> allNames) {
        this.config = config;
        this.suppressionName = suppressionName;
        this.allNames = allNames;
    }

    Description createErrorDescription(ErrorMessage errorMessage, Description.Builder descriptionBuilder, VisitorState state) {
        Tree enclosingSuppressTree = this.suppressibleNode(state.getPath());
        return this.createErrorDescription(errorMessage, enclosingSuppressTree, descriptionBuilder, state);
    }

    public Description createErrorDescription(ErrorMessage errorMessage, @Nullable Tree suggestTree, Description.Builder descriptionBuilder, VisitorState state) {
        Description.Builder builder = descriptionBuilder.setMessage(errorMessage.message);
        String checkName = "NullAway.<core>";
        if (errorMessage.messageType.equals((Object)ErrorMessage.MessageTypes.GET_ON_EMPTY_OPTIONAL)) {
            checkName = "NullAway.Optional";
        } else if (errorMessage.messageType.equals((Object)ErrorMessage.MessageTypes.FIELD_NO_INIT) || errorMessage.messageType.equals((Object)ErrorMessage.MessageTypes.METHOD_NO_INIT) || errorMessage.messageType.equals((Object)ErrorMessage.MessageTypes.NONNULL_FIELD_READ_BEFORE_INIT)) {
            checkName = "NullAway.Init";
        }
        if (this.hasPathSuppression(state.getPath(), checkName)) {
            return Description.NO_MATCH;
        }
        if (this.config.suggestSuppressions() && suggestTree != null) {
            builder = this.addSuggestedSuppression(errorMessage, suggestTree, builder);
        }
        return builder.build();
    }

    private static boolean canHaveSuppressWarningsAnnotation(Tree tree) {
        return tree instanceof MethodTree || tree instanceof ClassTree && ((ClassTree)tree).getSimpleName().length() != 0 || tree instanceof VariableTree;
    }

    private boolean hasPathSuppression(TreePath treePath, String subcheckerName) {
        return StreamSupport.stream(treePath.spliterator(), false).filter(ErrorBuilder::canHaveSuppressWarningsAnnotation).map(tree -> ASTHelpers.getSymbol((Tree)tree)).filter(symbol -> symbol != null).anyMatch(symbol -> this.symbolHasSuppressWarningsAnnotation((Symbol)symbol, subcheckerName) || this.symbolIsExcludedClassSymbol((Symbol)symbol));
    }

    private Description.Builder addSuggestedSuppression(ErrorMessage errorMessage, Tree suggestTree, Description.Builder builder) {
        switch (errorMessage.messageType) {
            case DEREFERENCE_NULLABLE: 
            case RETURN_NULLABLE: 
            case PASS_NULLABLE: 
            case ASSIGN_FIELD_NULLABLE: 
            case SWITCH_EXPRESSION_NULLABLE: {
                if (this.config.getCastToNonNullMethod() != null) {
                    builder = this.addCastToNonNullFix(suggestTree, builder);
                    break;
                }
                builder = this.addSuppressWarningsFix(suggestTree, builder, this.suppressionName);
                break;
            }
            case CAST_TO_NONNULL_ARG_NONNULL: {
                builder = this.removeCastToNonNullFix(suggestTree, builder);
                break;
            }
            case WRONG_OVERRIDE_RETURN: {
                builder = this.addSuppressWarningsFix(suggestTree, builder, this.suppressionName);
                break;
            }
            case WRONG_OVERRIDE_PARAM: {
                builder = this.addSuppressWarningsFix(suggestTree, builder, this.suppressionName);
                break;
            }
            case METHOD_NO_INIT: 
            case FIELD_NO_INIT: {
                builder = this.addSuppressWarningsFix(suggestTree, builder, "NullAway.Init");
                break;
            }
            case ANNOTATION_VALUE_INVALID: {
                break;
            }
            default: {
                builder = this.addSuppressWarningsFix(suggestTree, builder, this.suppressionName);
            }
        }
        return builder;
    }

    Description createErrorDescriptionForNullAssignment(ErrorMessage errorMessage, @Nullable Tree suggestTreeIfCastToNonNull, Description.Builder descriptionBuilder, VisitorState state) {
        if (this.config.getCastToNonNullMethod() != null) {
            return this.createErrorDescription(errorMessage, suggestTreeIfCastToNonNull, descriptionBuilder, state);
        }
        return this.createErrorDescription(errorMessage, this.suppressibleNode(state.getPath()), descriptionBuilder, state);
    }

    Description.Builder addSuppressWarningsFix(Tree suggestTree, Description.Builder builder, String suppressionName) {
        SuggestedFix fix;
        SuppressWarnings extantSuppressWarnings = null;
        Symbol treeSymbol = ASTHelpers.getSymbol((Tree)suggestTree);
        if (treeSymbol != null) {
            extantSuppressWarnings = treeSymbol.getAnnotation(SuppressWarnings.class);
        }
        if (extantSuppressWarnings == null) {
            fix = SuggestedFix.prefixWith((Tree)suggestTree, (String)("@SuppressWarnings(\"" + suppressionName + "\") " + this.config.getAutofixSuppressionComment()));
        } else {
            ArrayList suppressions = Lists.newArrayList((Object[])extantSuppressWarnings.value());
            suppressions.add(suppressionName);
            ModifiersTree modifiers = suggestTree instanceof MethodTree ? ((MethodTree)suggestTree).getModifiers() : ((VariableTree)suggestTree).getModifiers();
            List<? extends AnnotationTree> annotations = modifiers.getAnnotations();
            Optional suppressWarningsAnnot = Iterables.tryFind(annotations, annot -> annot.getAnnotationType().toString().endsWith("SuppressWarnings"));
            if (!suppressWarningsAnnot.isPresent()) {
                throw new AssertionError((Object)"something went horribly wrong");
            }
            String replacement = "@SuppressWarnings({" + Joiner.on((char)',').join(Iterables.transform((Iterable)suppressions, s2 -> '\"' + s2 + '\"')) + "}) " + this.config.getAutofixSuppressionComment();
            fix = SuggestedFix.replace((Tree)((Tree)suppressWarningsAnnot.get()), (String)replacement);
        }
        return builder.addFix((Fix)fix);
    }

    @Nullable
    private Tree suppressibleNode(@Nullable TreePath path) {
        if (path == null) {
            return null;
        }
        return StreamSupport.stream(path.spliterator(), false).filter(ErrorBuilder::canHaveSuppressWarningsAnnotation).findFirst().orElse(null);
    }

    private Description.Builder addCastToNonNullFix(Tree suggestTree, Description.Builder builder) {
        String fullMethodName = this.config.getCastToNonNullMethod();
        assert (fullMethodName != null);
        String[] parts = fullMethodName.split("\\.");
        String shortMethodName = parts[parts.length - 1];
        String replacement = shortMethodName + "(" + suggestTree.toString() + ")";
        SuggestedFix fix = SuggestedFix.builder().replace(suggestTree, replacement).addStaticImport(fullMethodName).build();
        return builder.addFix((Fix)fix);
    }

    private Description.Builder removeCastToNonNullFix(Tree suggestTree, Description.Builder builder) {
        assert (suggestTree.getKind() == Tree.Kind.METHOD_INVOCATION);
        MethodInvocationTree invTree = (MethodInvocationTree)suggestTree;
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodInvocationTree)invTree);
        String qualifiedName = ASTHelpers.enclosingClass((Symbol)methodSymbol) + "." + ((Name)methodSymbol.getSimpleName()).toString();
        if (!qualifiedName.equals(this.config.getCastToNonNullMethod())) {
            throw new RuntimeException("suggestTree should point to the castToNonNull invocation.");
        }
        SuggestedFix fix = SuggestedFix.builder().replace(suggestTree, invTree.getArguments().get(0).toString()).build();
        return builder.addFix((Fix)fix);
    }

    void reportInitializerError(Symbol.MethodSymbol methodSymbol, String message, VisitorState state, Description.Builder descriptionBuilder) {
        if (this.symbolHasSuppressWarningsAnnotation(methodSymbol, "NullAway.Init")) {
            return;
        }
        MethodTree methodTree = NullAway.getTreesInstance(state).getTree(methodSymbol);
        state.reportMatch(this.createErrorDescription(new ErrorMessage(ErrorMessage.MessageTypes.METHOD_NO_INIT, message), methodTree, descriptionBuilder, state));
    }

    boolean symbolHasSuppressWarningsAnnotation(Symbol symbol, String suppression) {
        SuppressWarnings annotation = symbol.getAnnotation(SuppressWarnings.class);
        if (annotation != null) {
            for (String s2 : annotation.value()) {
                if (!s2.equals(suppression)) {
                    if (!this.allNames.stream().anyMatch(s2::equals)) continue;
                }
                return true;
            }
        }
        return false;
    }

    private boolean symbolIsExcludedClassSymbol(Symbol symbol) {
        if (symbol instanceof Symbol.ClassSymbol) {
            ImmutableSet<String> excludedClassAnnotations = this.config.getExcludedClassAnnotations();
            return ((Symbol.ClassSymbol)symbol).getAnnotationMirrors().stream().map(anno -> anno.getAnnotationType().toString()).anyMatch(arg_0 -> excludedClassAnnotations.contains(arg_0));
        }
        return false;
    }

    static int getLineNumForElement(Element uninitField, VisitorState state) {
        Tree tree = NullAway.getTreesInstance(state).getTree(uninitField);
        if (tree == null) {
            throw new RuntimeException("When getting the line number for uninitialized field, can't get the tree from the element.");
        }
        JCDiagnostic.DiagnosticPosition position = (JCDiagnostic.DiagnosticPosition)((Object)tree);
        TreePath path = state.getPath();
        JCTree.JCCompilationUnit compilation = (JCTree.JCCompilationUnit)path.getCompilationUnit();
        JavaFileObject file = compilation.getSourceFile();
        DiagnosticSource source = new DiagnosticSource(file, null);
        return source.getLineNumber(position.getStartPosition());
    }

    static String errMsgForInitializer(Set<Element> uninitFields, VisitorState state) {
        StringBuilder message = new StringBuilder("initializer method does not guarantee @NonNull ");
        if (uninitFields.size() == 1) {
            Element uninitField = uninitFields.iterator().next();
            message.append("field ");
            message.append(uninitField.toString());
            message.append(" (line ");
            message.append(ErrorBuilder.getLineNumForElement(uninitField, state));
            message.append(") is initialized");
        } else {
            message.append("fields ");
            Iterator<Element> it = uninitFields.iterator();
            while (it.hasNext()) {
                Element uninitField = it.next();
                message.append(uninitField.toString() + " (line " + ErrorBuilder.getLineNumForElement(uninitField, state) + ")");
                if (it.hasNext()) {
                    message.append(", ");
                    continue;
                }
                message.append(" are initialized");
            }
        }
        message.append(" along all control-flow paths (remember to check for exceptions or early returns).");
        return message.toString();
    }

    void reportInitErrorOnField(Symbol symbol, VisitorState state, Description.Builder builder) {
        if (this.symbolHasSuppressWarningsAnnotation(symbol, "NullAway.Init")) {
            return;
        }
        Tree tree = NullAway.getTreesInstance(state).getTree(symbol);
        String fieldName = symbol.toString();
        if (symbol.enclClass().getNestingKind().isNested()) {
            String flatName = symbol.enclClass().flatName().toString();
            int index = flatName.lastIndexOf(".") + 1;
            fieldName = flatName.substring(index) + "." + fieldName;
        }
        if (symbol.isStatic()) {
            state.reportMatch(this.createErrorDescription(new ErrorMessage(ErrorMessage.MessageTypes.FIELD_NO_INIT, "@NonNull static field " + fieldName + " not initialized"), tree, builder, state));
        } else {
            state.reportMatch(this.createErrorDescription(new ErrorMessage(ErrorMessage.MessageTypes.FIELD_NO_INIT, "@NonNull field " + fieldName + " not initialized"), tree, builder, state));
        }
    }
}

