/*
 * Decompiled with CFR 0.152.
 */
package com.uber.nullaway;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.ErrorProneFlags;
import com.uber.nullaway.AbstractConfig;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;

final class ErrorProneCLIFlagsConfig
extends AbstractConfig {
    private static final String BASENAME_REGEX = ".*/([^/]+)\\.[ja]ar$";
    static final String EP_FL_NAMESPACE = "NullAway";
    static final String FL_ANNOTATED_PACKAGES = "NullAway:AnnotatedPackages";
    static final String FL_ASSERTS_ENABLED = "NullAway:AssertsEnabled";
    static final String FL_UNANNOTATED_SUBPACKAGES = "NullAway:UnannotatedSubPackages";
    static final String FL_CLASSES_TO_EXCLUDE = "NullAway:ExcludedClasses";
    static final String FL_EXHAUSTIVE_OVERRIDE = "NullAway:ExhaustiveOverride";
    static final String FL_KNOWN_INITIALIZERS = "NullAway:KnownInitializers";
    static final String FL_CLASS_ANNOTATIONS_TO_EXCLUDE = "NullAway:ExcludedClassAnnotations";
    static final String FL_SUGGEST_SUPPRESSIONS = "NullAway:SuggestSuppressions";
    static final String FL_GENERATED_UNANNOTATED = "NullAway:TreatGeneratedAsUnannotated";
    static final String FL_ACKNOWLEDGE_ANDROID_RECENT = "NullAway:AcknowledgeAndroidRecent";
    static final String FL_EXCLUDED_FIELD_ANNOT = "NullAway:ExcludedFieldAnnotations";
    static final String FL_INITIALIZER_ANNOT = "NullAway:CustomInitializerAnnotations";
    static final String FL_CTNN_METHOD = "NullAway:CastToNonNullMethod";
    static final String FL_EXTERNAL_INIT_ANNOT = "NullAway:ExternalInitAnnotations";
    static final String FL_UNANNOTATED_CLASSES = "NullAway:UnannotatedClasses";
    static final String FL_ACKNOWLEDGE_RESTRICTIVE = "NullAway:AcknowledgeRestrictiveAnnotations";
    static final String FL_CHECK_OPTIONAL_EMPTINESS = "NullAway:CheckOptionalEmptiness";
    static final String FL_HANDLE_TEST_ASSERTION_LIBRARIES = "NullAway:HandleTestAssertionLibraries";
    static final String FL_OPTIONAL_CLASS_PATHS = "NullAway:CheckOptionalEmptinessCustomClasses";
    static final String FL_SUPPRESS_COMMENT = "NullAway:AutoFixSuppressionComment";
    static final String FL_JI_ENABLED = "NullAway:JarInferEnabled";
    static final String FL_JI_USE_RETURN = "NullAway:JarInferUseReturnAnnotations";
    static final String FL_JI_REGEX_MODEL_PATH = "NullAway:JarInferRegexStripModelJar";
    static final String FL_JI_REGEX_CODE_PATH = "NullAway:JarInferRegexStripCodeJar";
    static final String FL_ERROR_URL = "NullAway:ErrorURL";
    private static final String DELIMITER = ",";
    static final ImmutableSet<String> DEFAULT_KNOWN_INITIALIZERS = ImmutableSet.of((Object)"android.view.View.onFinishInflate", (Object)"android.app.Service.onCreate", (Object)"android.app.Activity.onCreate", (Object)"android.app.Fragment.onCreate", (Object)"android.app.Fragment.onAttach", (Object)"android.app.Fragment.onCreateView", (Object[])new String[]{"android.app.Fragment.onViewCreated", "android.app.Application.onCreate", "javax.annotation.processing.Processor.init", "android.support.v4.app.ActivityCompat.onCreate", "android.support.v4.app.Fragment.onCreate", "android.support.v4.app.Fragment.onAttach", "android.support.v4.app.Fragment.onCreateView", "android.support.v4.app.Fragment.onViewCreated", "androidx.core.app.ActivityCompat.onCreate", "androidx.fragment.app.Fragment.onCreate", "androidx.fragment.app.Fragment.onAttach", "androidx.fragment.app.Fragment.onCreateView", "androidx.fragment.app.Fragment.onActivityCreated", "androidx.fragment.app.Fragment.onViewCreated", "android.support.multidex.Application.onCreate"});
    static final ImmutableSet<String> DEFAULT_INITIALIZER_ANNOT = ImmutableSet.of((Object)"org.junit.Before", (Object)"org.junit.BeforeClass", (Object)"org.junit.jupiter.api.BeforeAll", (Object)"org.junit.jupiter.api.BeforeEach");
    static final ImmutableSet<String> DEFAULT_EXCLUDED_FIELD_ANNOT = ImmutableSet.of((Object)"javax.inject.Inject", (Object)"com.google.errorprone.annotations.concurrent.LazyInit", (Object)"shadow.checkerframework.checker.nullness.qual.MonotonicNonNull");
    private static final String DEFAULT_URL = "http://t.uber.com/nullaway";

    ErrorProneCLIFlagsConfig(ErrorProneFlags flags) {
        if (!flags.get(FL_ANNOTATED_PACKAGES).isPresent()) {
            throw new IllegalStateException("DO NOT report an issue to Error Prone for this crash!  NullAway configuration is incorrect.  Must specify annotated packages, using the -XepOpt:NullAway:AnnotatedPackages=[...] flag.  If you feel you have gotten this message in error report an issue at https://github.com/uber/NullAway/issues.");
        }
        this.annotatedPackages = ErrorProneCLIFlagsConfig.getPackagePattern(ErrorProneCLIFlagsConfig.getFlagStringSet(flags, FL_ANNOTATED_PACKAGES));
        this.unannotatedSubPackages = ErrorProneCLIFlagsConfig.getPackagePattern(ErrorProneCLIFlagsConfig.getFlagStringSet(flags, FL_UNANNOTATED_SUBPACKAGES));
        this.sourceClassesToExclude = ErrorProneCLIFlagsConfig.getFlagStringSet(flags, FL_CLASSES_TO_EXCLUDE);
        this.unannotatedClasses = ErrorProneCLIFlagsConfig.getFlagStringSet(flags, FL_UNANNOTATED_CLASSES);
        this.knownInitializers = this.getKnownInitializers((Set<String>)ErrorProneCLIFlagsConfig.getFlagStringSet(flags, FL_KNOWN_INITIALIZERS, DEFAULT_KNOWN_INITIALIZERS));
        this.excludedClassAnnotations = ErrorProneCLIFlagsConfig.getFlagStringSet(flags, FL_CLASS_ANNOTATIONS_TO_EXCLUDE);
        this.initializerAnnotations = ErrorProneCLIFlagsConfig.getFlagStringSet(flags, FL_INITIALIZER_ANNOT, DEFAULT_INITIALIZER_ANNOT);
        this.externalInitAnnotations = ErrorProneCLIFlagsConfig.getFlagStringSet(flags, FL_EXTERNAL_INIT_ANNOT);
        this.isExhaustiveOverride = flags.getBoolean(FL_EXHAUSTIVE_OVERRIDE).orElse(false);
        this.isSuggestSuppressions = flags.getBoolean(FL_SUGGEST_SUPPRESSIONS).orElse(false);
        this.isAcknowledgeRestrictive = flags.getBoolean(FL_ACKNOWLEDGE_RESTRICTIVE).orElse(false);
        this.checkOptionalEmptiness = flags.getBoolean(FL_CHECK_OPTIONAL_EMPTINESS).orElse(false);
        this.handleTestAssertionLibraries = flags.getBoolean(FL_HANDLE_TEST_ASSERTION_LIBRARIES).orElse(false);
        this.treatGeneratedAsUnannotated = flags.getBoolean(FL_GENERATED_UNANNOTATED).orElse(false);
        this.acknowledgeAndroidRecent = flags.getBoolean(FL_ACKNOWLEDGE_ANDROID_RECENT).orElse(false);
        this.assertsEnabled = flags.getBoolean(FL_ASSERTS_ENABLED).orElse(false);
        this.fieldAnnotPattern = ErrorProneCLIFlagsConfig.getPackagePattern(ErrorProneCLIFlagsConfig.getFlagStringSet(flags, FL_EXCLUDED_FIELD_ANNOT, DEFAULT_EXCLUDED_FIELD_ANNOT));
        this.castToNonNullMethod = flags.get(FL_CTNN_METHOD).orElse(null);
        this.autofixSuppressionComment = flags.get(FL_SUPPRESS_COMMENT).orElse("");
        this.optionalClassPaths = new ImmutableSet.Builder().addAll(ErrorProneCLIFlagsConfig.getFlagStringSet(flags, FL_OPTIONAL_CLASS_PATHS)).add((Object)"java.util.Optional").build();
        if (this.autofixSuppressionComment.contains("\n")) {
            throw new IllegalStateException("Invalid -XepOpt:NullAway:AutoFixSuppressionComment value. Comment must be single line.");
        }
        this.jarInferEnabled = flags.getBoolean(FL_JI_ENABLED).orElse(false);
        this.jarInferUseReturnAnnotations = flags.getBoolean(FL_JI_USE_RETURN).orElse(false);
        this.jarInferRegexStripModelJarName = flags.get(FL_JI_REGEX_MODEL_PATH).orElse(BASENAME_REGEX);
        this.jarInferRegexStripCodeJarName = flags.get(FL_JI_REGEX_CODE_PATH).orElse(BASENAME_REGEX);
        this.errorURL = flags.get(FL_ERROR_URL).orElse(DEFAULT_URL);
        if (this.acknowledgeAndroidRecent && !this.isAcknowledgeRestrictive) {
            throw new IllegalStateException("-XepOpt:NullAway:AcknowledgeAndroidRecent should only be set when -XepOpt:NullAway:AcknowledgeRestrictiveAnnotations is also set");
        }
    }

    private static ImmutableSet<String> getFlagStringSet(ErrorProneFlags flags, String flagName) {
        Optional flagValue = flags.get(flagName);
        if (flagValue.isPresent()) {
            return ImmutableSet.copyOf((Object[])((String)flagValue.get()).split(DELIMITER));
        }
        return ImmutableSet.of();
    }

    private static ImmutableSet<String> getFlagStringSet(ErrorProneFlags flags, String flagName, ImmutableSet<String> defaults) {
        LinkedHashSet<String> combined = new LinkedHashSet<String>((Collection<String>)defaults);
        Optional flagValue = flags.get(flagName);
        if (flagValue.isPresent()) {
            Collections.addAll(combined, ((String)flagValue.get()).split(DELIMITER));
        }
        return ImmutableSet.copyOf(combined);
    }
}

