/*
 * Decompiled with CFR 0.152.
 */
package com.uber.nullaway;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.sun.tools.javac.code.Symbol;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface LibraryModels {
    public ImmutableSetMultimap<MethodRef, Integer> failIfNullParameters();

    public ImmutableSetMultimap<MethodRef, Integer> explicitlyNullableParameters();

    public ImmutableSetMultimap<MethodRef, Integer> nonNullParameters();

    public ImmutableSetMultimap<MethodRef, Integer> nullImpliesTrueParameters();

    public ImmutableSetMultimap<MethodRef, Integer> nullImpliesFalseParameters();

    public ImmutableSetMultimap<MethodRef, Integer> nullImpliesNullParameters();

    public ImmutableSet<MethodRef> nullableReturns();

    public ImmutableSet<MethodRef> nonNullReturns();

    public static final class MethodRef {
        public final String enclosingClass;
        public final String methodName;
        public final String fullMethodSig;
        private static final Pattern METHOD_SIG_PATTERN = Pattern.compile("^(<.*>)?(\\w+)(\\(.*\\))$");

        private MethodRef(String enclosingClass, String methodName, String fullMethodSig) {
            this.enclosingClass = enclosingClass;
            this.methodName = methodName;
            this.fullMethodSig = fullMethodSig;
        }

        public static MethodRef methodRef(String enclosingClass, String methodSignature) {
            Matcher matcher = METHOD_SIG_PATTERN.matcher(methodSignature);
            if (matcher.find()) {
                String methodName = matcher.group(2);
                if (methodName.equals(enclosingClass.substring(enclosingClass.lastIndexOf(46) + 1))) {
                    methodName = "<init>";
                }
                return new MethodRef(enclosingClass, methodName, methodSignature);
            }
            throw new IllegalArgumentException("malformed method signature " + methodSignature);
        }

        public static MethodRef fromSymbol(Symbol.MethodSymbol symbol) {
            String methodStr = symbol.toString();
            return new MethodRef(symbol.owner.getQualifiedName().toString(), symbol.name.toString(), methodStr);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodRef methodRef = (MethodRef)o;
            return Objects.equals(this.enclosingClass, methodRef.enclosingClass) && Objects.equals(this.fullMethodSig, methodRef.fullMethodSig);
        }

        public int hashCode() {
            return Objects.hash(this.enclosingClass, this.fullMethodSig);
        }

        public String toString() {
            return "MethodRef{enclosingClass='" + this.enclosingClass + '\'' + ", fullMethodSig='" + this.fullMethodSig + '\'' + '}';
        }
    }
}

