/*
 * Decompiled with CFR 0.152.
 */
package com.uber.nullaway;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.uber.nullaway.AutoValue_NullAway_FieldInitEntities;
import com.uber.nullaway.Config;
import com.uber.nullaway.DummyOptionsConfig;
import com.uber.nullaway.ErrorBuilder;
import com.uber.nullaway.ErrorMessage;
import com.uber.nullaway.ErrorProneCLIFlagsConfig;
import com.uber.nullaway.NullabilityUtil;
import com.uber.nullaway.Nullness;
import com.uber.nullaway.dataflow.AccessPathNullnessAnalysis;
import com.uber.nullaway.dataflow.EnclosingEnvironmentNullness;
import com.uber.nullaway.handlers.Handler;
import com.uber.nullaway.handlers.Handlers;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.type.TypeKind;
import shadow.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import shadow.checkerframework.javacutil.AnnotationUtils;

@BugPattern(name="NullAway", altNames={"CheckNullabilityTypes"}, summary="Nullability type error.", tags={"LikelyError"}, severity=BugPattern.SeverityLevel.WARNING)
public class NullAway
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.AssignmentTreeMatcher,
BugChecker.MemberSelectTreeMatcher,
BugChecker.ArrayAccessTreeMatcher,
BugChecker.ReturnTreeMatcher,
BugChecker.ClassTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher,
BugChecker.NewClassTreeMatcher,
BugChecker.BinaryTreeMatcher,
BugChecker.UnaryTreeMatcher,
BugChecker.ConditionalExpressionTreeMatcher,
BugChecker.IfTreeMatcher,
BugChecker.WhileLoopTreeMatcher,
BugChecker.ForLoopTreeMatcher,
BugChecker.EnhancedForLoopTreeMatcher,
BugChecker.LambdaExpressionTreeMatcher,
BugChecker.IdentifierTreeMatcher,
BugChecker.MemberReferenceTreeMatcher,
BugChecker.CompoundAssignmentTreeMatcher,
BugChecker.SwitchTreeMatcher {
    static final String INITIALIZATION_CHECK_NAME = "NullAway.Init";
    static final String OPTIONAL_CHECK_NAME = "NullAway.Optional";
    static final String CORE_CHECK_NAME = "NullAway.<core>";
    private static final Matcher<ExpressionTree> THIS_MATCHER = NullAway::isThisIdentifierMatcher;
    private final Predicate<MethodInvocationNode> nonAnnotatedMethod;
    private boolean matchWithinTopLevelClass = true;
    private final Config config;
    private final ErrorBuilder errorBuilder;
    private final Handler handler;
    private final Map<Symbol.ClassSymbol, FieldInitEntities> class2Entities = new LinkedHashMap<Symbol.ClassSymbol, FieldInitEntities>();
    private final SetMultimap<Symbol.ClassSymbol, Symbol> class2ConstructorUninit = LinkedHashMultimap.create();
    private final Map<Symbol.ClassSymbol, Multimap<Tree, Element>> initTree2PrevFieldInit = new LinkedHashMap<Symbol.ClassSymbol, Multimap<Tree, Element>>();
    private final Map<ExpressionTree, Nullness> computedNullnessMap = new LinkedHashMap<ExpressionTree, Nullness>();

    public NullAway() {
        this.config = new DummyOptionsConfig();
        this.handler = Handlers.buildEmpty();
        this.nonAnnotatedMethod = this::isMethodUnannotated;
        this.errorBuilder = new ErrorBuilder(this.config, "", (Set<String>)ImmutableSet.of());
    }

    public NullAway(ErrorProneFlags flags) {
        this.config = new ErrorProneCLIFlagsConfig(flags);
        this.handler = Handlers.buildDefault(this.config);
        this.nonAnnotatedMethod = this::isMethodUnannotated;
        this.errorBuilder = new ErrorBuilder(this.config, this.canonicalName(), this.allNames());
        AnnotationUtils.clear();
    }

    private boolean isMethodUnannotated(MethodInvocationNode invocationNode) {
        return invocationNode == null || NullabilityUtil.isUnannotated(ASTHelpers.getSymbol((MethodInvocationTree)invocationNode.getTree()), this.config);
    }

    public String linkUrl() {
        return this.config.getErrorURL() + " ";
    }

    public Description matchReturn(ReturnTree tree, VisitorState state) {
        Symbol.MethodSymbol methodSymbol;
        if (!this.matchWithinTopLevelClass) {
            return Description.NO_MATCH;
        }
        this.handler.onMatchReturn(this, tree, state);
        ExpressionTree retExpr = tree.getExpression();
        if (retExpr == null) {
            return Description.NO_MATCH;
        }
        TreePath enclosingMethodOrLambda = NullabilityUtil.findEnclosingMethodOrLambdaOrInitializer(state.getPath());
        if (enclosingMethodOrLambda == null) {
            throw new RuntimeException("no enclosing method, lambda or initializer!");
        }
        if (!(enclosingMethodOrLambda.getLeaf() instanceof MethodTree) && !(enclosingMethodOrLambda.getLeaf() instanceof LambdaExpressionTree)) {
            throw new RuntimeException("return statement outside of a method or lambda! (e.g. in an initializer block)");
        }
        Tree leaf = enclosingMethodOrLambda.getLeaf();
        if (leaf instanceof MethodTree) {
            MethodTree enclosingMethod = (MethodTree)leaf;
            methodSymbol = ASTHelpers.getSymbol((MethodTree)enclosingMethod);
        } else {
            methodSymbol = NullabilityUtil.getFunctionalInterfaceMethod((LambdaExpressionTree)leaf, state.getTypes());
        }
        return this.checkReturnExpression(tree, retExpr, methodSymbol, state);
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!this.matchWithinTopLevelClass) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        if (methodSymbol == null) {
            throw new RuntimeException("not expecting unresolved method here");
        }
        this.handler.onMatchMethodInvocation(this, tree, state, methodSymbol);
        java.util.List<? extends ExpressionTree> actualParams = tree.getArguments();
        return this.handleInvocation(tree, state, methodSymbol, actualParams);
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (!this.matchWithinTopLevelClass) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((NewClassTree)tree);
        if (methodSymbol == null) {
            throw new RuntimeException("not expecting unresolved method here");
        }
        java.util.List<? extends ExpressionTree> actualParams = tree.getArguments();
        if (tree.getClassBody() != null && actualParams.size() > 0) {
            methodSymbol = this.getSymbolOfSuperConstructor(methodSymbol, state);
        }
        return this.handleInvocation(tree, state, methodSymbol, actualParams);
    }

    private void updateEnvironmentMapping(Tree tree, VisitorState state) {
        AccessPathNullnessAnalysis analysis = this.getNullnessAnalysis(state);
        EnclosingEnvironmentNullness.instance(state.context).addEnvironmentMapping(tree, analysis.getNullnessInfoBeforeNewContext(state.getPath(), state, this.handler));
    }

    private Symbol.MethodSymbol getSymbolOfSuperConstructor(Symbol.MethodSymbol anonClassConstructorSymbol, VisitorState state) {
        ExpressionTree expression;
        StatementTree stmt;
        java.util.List<? extends StatementTree> statements = NullAway.getTreesInstance(state).getTree(anonClassConstructorSymbol).getBody().getStatements();
        if (statements.size() == 1 && (stmt = statements.get(0)) instanceof ExpressionStatementTree && (expression = ((ExpressionStatementTree)stmt).getExpression()) instanceof MethodInvocationTree) {
            return ASTHelpers.getSymbol((MethodInvocationTree)((MethodInvocationTree)expression));
        }
        throw new IllegalStateException("unexpected anonymous class constructor body " + statements);
    }

    public Description matchAssignment(AssignmentTree tree, VisitorState state) {
        if (!this.matchWithinTopLevelClass) {
            return Description.NO_MATCH;
        }
        Type lhsType = ASTHelpers.getType((Tree)tree.getVariable());
        if (lhsType != null && lhsType.isPrimitive()) {
            return this.doUnboxingCheck(state, tree.getExpression());
        }
        Symbol assigned = ASTHelpers.getSymbol((Tree)tree.getVariable());
        if (assigned == null || assigned.getKind() != ElementKind.FIELD) {
            return Description.NO_MATCH;
        }
        if (Nullness.hasNullableAnnotation(assigned, this.config)) {
            return Description.NO_MATCH;
        }
        ExpressionTree expression = tree.getExpression();
        if (this.mayBeNullExpr(state, expression)) {
            String message = "assigning @Nullable expression to @NonNull field";
            return this.errorBuilder.createErrorDescriptionForNullAssignment(new ErrorMessage(ErrorMessage.MessageTypes.ASSIGN_FIELD_NULLABLE, message), expression, this.buildDescription(tree), state);
        }
        return Description.NO_MATCH;
    }

    public Description matchCompoundAssignment(CompoundAssignmentTree tree, VisitorState state) {
        if (!this.matchWithinTopLevelClass) {
            return Description.NO_MATCH;
        }
        Type lhsType = ASTHelpers.getType((Tree)tree.getVariable());
        Type stringType = state.getTypeFromString("java.lang.String");
        if (lhsType != null && !state.getTypes().isSameType(lhsType, stringType)) {
            return this.doUnboxingCheck(state, tree.getVariable(), tree.getExpression());
        }
        return Description.NO_MATCH;
    }

    public Description matchArrayAccess(ArrayAccessTree tree, VisitorState state) {
        if (!this.matchWithinTopLevelClass) {
            return Description.NO_MATCH;
        }
        Description description = this.matchDereference(tree.getExpression(), tree, state);
        if (!description.equals(Description.NO_MATCH)) {
            return description;
        }
        return this.doUnboxingCheck(state, tree.getIndex());
    }

    public Description matchMemberSelect(MemberSelectTree tree, VisitorState state) {
        if (!this.matchWithinTopLevelClass) {
            return Description.NO_MATCH;
        }
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        if (symbol == null || symbol.getSimpleName().toString().equals("class") || symbol.isEnum()) {
            return Description.NO_MATCH;
        }
        Description badDeref = this.matchDereference(tree.getExpression(), tree, state);
        if (!badDeref.equals(Description.NO_MATCH)) {
            return badDeref;
        }
        if (tree.getExpression() instanceof IdentifierTree && ((IdentifierTree)tree.getExpression()).getName().toString().equals("this")) {
            return this.checkForReadBeforeInit(tree, state);
        }
        return Description.NO_MATCH;
    }

    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol closestOverriddenMethod;
        if (!this.matchWithinTopLevelClass) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodTree)tree);
        this.handler.onMatchMethod(this, tree, state, methodSymbol);
        boolean isOverriding = ASTHelpers.hasAnnotation((Symbol)methodSymbol, Override.class, (VisitorState)state);
        boolean exhaustiveOverride = this.config.exhaustiveOverride();
        if ((isOverriding || !exhaustiveOverride) && (closestOverriddenMethod = this.getClosestOverriddenMethod(methodSymbol, state.getTypes())) != null) {
            return this.checkOverriding(closestOverriddenMethod, methodSymbol, null, state);
        }
        return Description.NO_MATCH;
    }

    public Description matchSwitch(SwitchTree tree, VisitorState state) {
        if (!this.matchWithinTopLevelClass) {
            return Description.NO_MATCH;
        }
        ExpressionTree switchExpression = tree.getExpression();
        if (switchExpression instanceof ParenthesizedTree) {
            switchExpression = ((ParenthesizedTree)switchExpression).getExpression();
        }
        if (this.mayBeNullExpr(state, switchExpression)) {
            String message = "switch expression " + state.getSourceForNode((Tree)switchExpression) + " is @Nullable";
            ErrorMessage errorMessage = new ErrorMessage(ErrorMessage.MessageTypes.SWITCH_EXPRESSION_NULLABLE, message);
            return this.errorBuilder.createErrorDescription(errorMessage, switchExpression, this.buildDescription(switchExpression), state);
        }
        return Description.NO_MATCH;
    }

    private Description checkParamOverriding(java.util.List<Symbol.VarSymbol> overridingParamSymbols, Symbol.MethodSymbol overriddenMethod, @Nullable LambdaExpressionTree lambdaExpressionTree, @Nullable MemberReferenceTree memberReferenceTree, VisitorState state) {
        int i;
        ImmutableSet nullableParamsOfOverriden;
        int startParam;
        boolean unboundMemberRef;
        java.util.List superParamSymbols = overriddenMethod.getParameters();
        boolean bl = unboundMemberRef = memberReferenceTree != null && ((JCTree.JCMemberReference)memberReferenceTree).kind.isUnbound();
        if (unboundMemberRef) {
            boolean isFirstParamNull = false;
            if (!NullabilityUtil.isUnannotated(overriddenMethod, this.config)) {
                isFirstParamNull = Nullness.hasNullableAnnotation((Symbol)((List)superParamSymbols).get(0), this.config);
            }
            if (isFirstParamNull = this.handler.onUnannotatedInvocationGetExplicitlyNullablePositions(state.context, overriddenMethod, (ImmutableSet<Integer>)(isFirstParamNull ? ImmutableSet.of((Object)0) : ImmutableSet.of())).contains((Object)0)) {
                String message = "unbound instance method reference cannot be used, as first parameter of functional interface method " + ASTHelpers.enclosingClass((Symbol)overriddenMethod) + "." + overriddenMethod.toString() + " is @Nullable";
                return this.errorBuilder.createErrorDescription(new ErrorMessage(ErrorMessage.MessageTypes.WRONG_OVERRIDE_PARAM, message), this.buildDescription(memberReferenceTree), state);
            }
        }
        int n = startParam = unboundMemberRef ? 1 : 0;
        if (NullabilityUtil.isUnannotated(overriddenMethod, this.config)) {
            nullableParamsOfOverriden = this.handler.onUnannotatedInvocationGetExplicitlyNullablePositions(state.context, overriddenMethod, (ImmutableSet<Integer>)ImmutableSet.of());
        } else {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (i = startParam; i < ((List)superParamSymbols).size(); ++i) {
                if (!Nullness.paramHasNullableAnnotation(overriddenMethod, i, this.config)) continue;
                builder.add((Object)i);
            }
            nullableParamsOfOverriden = builder.build();
        }
        UnmodifiableIterator unmodifiableIterator = nullableParamsOfOverriden.iterator();
        while (unmodifiableIterator.hasNext()) {
            boolean implicitlyTypedLambdaParam;
            i = (Integer)unmodifiableIterator.next();
            int methodParamInd = i - startParam;
            Symbol.VarSymbol paramSymbol = overridingParamSymbols.get(methodParamInd);
            boolean bl2 = implicitlyTypedLambdaParam = lambdaExpressionTree != null && NullabilityUtil.lambdaParamIsImplicitlyTyped(lambdaExpressionTree.getParameters().get(methodParamInd));
            if (Nullness.hasNullableAnnotation(paramSymbol, this.config) || implicitlyTypedLambdaParam) continue;
            String message = "parameter " + paramSymbol.name.toString() + (memberReferenceTree != null ? " of referenced method" : "") + " is @NonNull, but parameter in " + (lambdaExpressionTree != null || memberReferenceTree != null ? "functional interface " : "superclass ") + "method " + ASTHelpers.enclosingClass((Symbol)overriddenMethod) + "." + overriddenMethod.toString() + " is @Nullable";
            Tree errorTree = memberReferenceTree != null ? memberReferenceTree : NullAway.getTreesInstance(state).getTree(paramSymbol);
            return this.errorBuilder.createErrorDescription(new ErrorMessage(ErrorMessage.MessageTypes.WRONG_OVERRIDE_PARAM, message), this.buildDescription(errorTree), state);
        }
        return Description.NO_MATCH;
    }

    static Trees getTreesInstance(VisitorState state) {
        return Trees.instance(JavacProcessingEnvironment.instance(state.context));
    }

    private Description checkReturnExpression(Tree tree, ExpressionTree retExpr, Symbol.MethodSymbol methodSymbol, VisitorState state) {
        Type returnType = methodSymbol.getReturnType();
        if (returnType.isPrimitive()) {
            return this.doUnboxingCheck(state, retExpr);
        }
        if (returnType.toString().equals("java.lang.Void")) {
            return Description.NO_MATCH;
        }
        if (NullabilityUtil.isUnannotated(methodSymbol, this.config) || Nullness.hasNullableAnnotation(methodSymbol, this.config)) {
            return Description.NO_MATCH;
        }
        if (this.mayBeNullExpr(state, retExpr)) {
            ErrorMessage errorMessage = new ErrorMessage(ErrorMessage.MessageTypes.RETURN_NULLABLE, "returning @Nullable expression from method with @NonNull return type");
            return this.errorBuilder.createErrorDescriptionForNullAssignment(errorMessage, retExpr, this.buildDescription(tree), state);
        }
        return Description.NO_MATCH;
    }

    public Description matchLambdaExpression(LambdaExpressionTree tree, VisitorState state) {
        if (!this.matchWithinTopLevelClass) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol funcInterfaceMethod = NullabilityUtil.getFunctionalInterfaceMethod(tree, state.getTypes());
        this.updateEnvironmentMapping(tree, state);
        this.handler.onMatchLambdaExpression(this, tree, state, funcInterfaceMethod);
        if (NullabilityUtil.isUnannotated(funcInterfaceMethod, this.config)) {
            return Description.NO_MATCH;
        }
        Description description = this.checkParamOverriding(tree.getParameters().stream().map(ASTHelpers::getSymbol).collect(Collectors.toList()), funcInterfaceMethod, tree, null, state);
        if (description != Description.NO_MATCH) {
            return description;
        }
        if (tree.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION && funcInterfaceMethod.getReturnType().getKind() != TypeKind.VOID) {
            ExpressionTree resExpr = (ExpressionTree)tree.getBody();
            return this.checkReturnExpression(tree, resExpr, funcInterfaceMethod, state);
        }
        return Description.NO_MATCH;
    }

    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        if (!this.matchWithinTopLevelClass) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol referencedMethod = ASTHelpers.getSymbol((MemberReferenceTree)tree);
        Symbol.MethodSymbol funcInterfaceSymbol = NullabilityUtil.getFunctionalInterfaceMethod(tree, state.getTypes());
        this.handler.onMatchMethodReference(this, tree, state, referencedMethod);
        return this.checkOverriding(funcInterfaceSymbol, referencedMethod, tree, state);
    }

    private Description checkOverriding(Symbol.MethodSymbol overriddenMethod, Symbol.MethodSymbol overridingMethod, @Nullable MemberReferenceTree memberReferenceTree, VisitorState state) {
        boolean overriddenMethodReturnsNonNull;
        boolean isOverridenMethodUnannotated = NullabilityUtil.isUnannotated(overriddenMethod, this.config);
        boolean bl = overriddenMethodReturnsNonNull = isOverridenMethodUnannotated && this.handler.onUnannotatedInvocationGetExplicitlyNonNullReturn(overriddenMethod, false) || !isOverridenMethodUnannotated && !Nullness.hasNullableAnnotation(overriddenMethod, this.config);
        if (overriddenMethodReturnsNonNull && Nullness.hasNullableAnnotation(overridingMethod, this.config) && this.getComputedNullness(memberReferenceTree).equals(Nullness.NULLABLE)) {
            String message = memberReferenceTree != null ? "referenced method returns @Nullable, but functional interface method " + ASTHelpers.enclosingClass((Symbol)overriddenMethod) + "." + overriddenMethod.toString() + " returns @NonNull" : "method returns @Nullable, but superclass method " + ASTHelpers.enclosingClass((Symbol)overriddenMethod) + "." + overriddenMethod.toString() + " returns @NonNull";
            MemberReferenceTree errorTree = memberReferenceTree != null ? memberReferenceTree : NullAway.getTreesInstance(state).getTree(overridingMethod);
            return this.errorBuilder.createErrorDescription(new ErrorMessage(ErrorMessage.MessageTypes.WRONG_OVERRIDE_RETURN, message), this.buildDescription(errorTree), state);
        }
        return this.checkParamOverriding(overridingMethod.getParameters(), overriddenMethod, null, memberReferenceTree, state);
    }

    public Description matchIdentifier(IdentifierTree tree, VisitorState state) {
        if (!this.matchWithinTopLevelClass) {
            return Description.NO_MATCH;
        }
        return this.checkForReadBeforeInit(tree, state);
    }

    private Description checkForReadBeforeInit(ExpressionTree tree, VisitorState state) {
        TreePath path = state.getPath();
        TreePath enclosingBlockPath = this.config.assertsEnabled() ? NullabilityUtil.findEnclosingMethodOrLambdaOrInitializer(path) : NullabilityUtil.findEnclosingMethodOrLambdaOrInitializer(path, (ImmutableSet<Tree.Kind>)ImmutableSet.of((Object)((Object)Tree.Kind.ASSERT)));
        if (enclosingBlockPath == null) {
            return Description.NO_MATCH;
        }
        if (!this.config.assertsEnabled() && enclosingBlockPath.getLeaf().getKind().equals((Object)Tree.Kind.ASSERT)) {
            return Description.NO_MATCH;
        }
        if (!this.relevantInitializerMethodOrBlock(enclosingBlockPath, state)) {
            return Description.NO_MATCH;
        }
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        if (symbol == null) {
            return Description.NO_MATCH;
        }
        if (!symbol.getKind().equals((Object)ElementKind.FIELD)) {
            return Description.NO_MATCH;
        }
        if (symbol.isStatic()) {
            Tree enclosing = enclosingBlockPath.getLeaf();
            if (enclosing instanceof MethodTree && !ASTHelpers.getSymbol((MethodTree)((MethodTree)enclosing)).isStatic()) {
                return Description.NO_MATCH;
            }
            if (enclosing instanceof BlockTree && !((BlockTree)enclosing).isStatic()) {
                return Description.NO_MATCH;
            }
        }
        if (this.okToReadBeforeInitialized(path)) {
            return Description.NO_MATCH;
        }
        FieldInitEntities entities = this.class2Entities.get(this.enclosingClassSymbol(enclosingBlockPath));
        if (!entities.nonnullInstanceFields().contains((Object)symbol) && !entities.nonnullStaticFields().contains((Object)symbol)) {
            return Description.NO_MATCH;
        }
        if (this.errorBuilder.symbolHasSuppressWarningsAnnotation(symbol, INITIALIZATION_CHECK_NAME)) {
            return Description.NO_MATCH;
        }
        return this.checkPossibleUninitFieldRead(tree, state, symbol, path, enclosingBlockPath);
    }

    private Symbol.ClassSymbol enclosingClassSymbol(TreePath enclosingBlockPath) {
        Tree leaf = enclosingBlockPath.getLeaf();
        if (leaf instanceof BlockTree) {
            Tree parent = enclosingBlockPath.getParentPath().getLeaf();
            return ASTHelpers.getSymbol((ClassTree)((ClassTree)parent));
        }
        return ASTHelpers.enclosingClass((Symbol)ASTHelpers.getSymbol((Tree)leaf));
    }

    private boolean relevantInitializerMethodOrBlock(TreePath enclosingBlockPath, VisitorState state) {
        Tree methodLambdaOrBlock = enclosingBlockPath.getLeaf();
        if (methodLambdaOrBlock instanceof LambdaExpressionTree) {
            return false;
        }
        if (methodLambdaOrBlock instanceof MethodTree) {
            MethodTree methodTree = (MethodTree)methodLambdaOrBlock;
            if (this.isConstructor(methodTree) && !this.constructorInvokesAnother(methodTree, state)) {
                return true;
            }
            if (ASTHelpers.getSymbol((MethodTree)methodTree).isStatic()) {
                ImmutableSet<MethodTree> staticInitializerMethods = this.class2Entities.get(this.enclosingClassSymbol(enclosingBlockPath)).staticInitializerMethods();
                return staticInitializerMethods.size() == 1 && staticInitializerMethods.contains(methodTree);
            }
            ImmutableSet<MethodTree> instanceInitializerMethods = this.class2Entities.get(this.enclosingClassSymbol(enclosingBlockPath)).instanceInitializerMethods();
            return instanceInitializerMethods.size() == 1 && instanceInitializerMethods.contains(methodTree);
        }
        return true;
    }

    private Description checkPossibleUninitFieldRead(ExpressionTree tree, VisitorState state, Symbol symbol, TreePath path, TreePath enclosingBlockPath) {
        if (!this.fieldInitializedByPreviousInitializer(symbol, enclosingBlockPath, state) && !this.fieldAlwaysInitializedBeforeRead(symbol, path, state, enclosingBlockPath)) {
            ErrorMessage errorMessage = new ErrorMessage(ErrorMessage.MessageTypes.NONNULL_FIELD_READ_BEFORE_INIT, "read of @NonNull field " + symbol + " before initialization");
            return this.errorBuilder.createErrorDescription(errorMessage, this.buildDescription(tree), state);
        }
        return Description.NO_MATCH;
    }

    private boolean fieldAlwaysInitializedBeforeRead(Symbol symbol, TreePath pathToRead, VisitorState state, TreePath enclosingBlockPath) {
        Set<Object> nonnullFields;
        AccessPathNullnessAnalysis nullnessAnalysis = this.getNullnessAnalysis(state);
        if (symbol.isStatic()) {
            nonnullFields = nullnessAnalysis.getNonnullStaticFieldsBefore(pathToRead, state.context);
        } else {
            nonnullFields = new LinkedHashSet<Element>();
            nonnullFields.addAll(nullnessAnalysis.getNonnullFieldsOfReceiverBefore(pathToRead, state.context));
            nonnullFields.addAll((Collection<Object>)this.safeInitByCalleeBefore(pathToRead, state, enclosingBlockPath));
        }
        return nonnullFields.contains(symbol);
    }

    private ImmutableSet<Element> safeInitByCalleeBefore(TreePath pathToRead, VisitorState state, TreePath enclosingBlockPath) {
        LinkedHashSet<Element> safeInitMethods = new LinkedHashSet<Element>();
        Tree enclosingBlockOrMethod = enclosingBlockPath.getLeaf();
        if (enclosingBlockOrMethod instanceof VariableTree) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        BlockTree blockTree = enclosingBlockOrMethod instanceof BlockTree ? (BlockTree)enclosingBlockOrMethod : ((MethodTree)enclosingBlockOrMethod).getBody();
        java.util.List<? extends StatementTree> statements = blockTree.getStatements();
        Tree readExprTree = pathToRead.getLeaf();
        int readStartPos = this.getStartPos((JCTree)readExprTree);
        TreePath classTreePath = enclosingBlockPath;
        while (!(classTreePath.getLeaf() instanceof ClassTree)) {
            if ((classTreePath = classTreePath.getParentPath()) != null) continue;
            throw new IllegalStateException("could not find enclosing class / enum / interface for " + state.getSourceForNode(enclosingBlockPath.getLeaf()));
        }
        Symbol.ClassSymbol classSymbol = ASTHelpers.getSymbol((ClassTree)((ClassTree)classTreePath.getLeaf()));
        for (int i = 0; i < statements.size(); ++i) {
            TryTree tryTree;
            StatementTree curStmt = statements.get(i);
            if (this.getStartPos((JCTree)((Object)curStmt)) > readStartPos) continue;
            Element privMethodElem = this.getInvokeOfSafeInitMethod(curStmt, classSymbol, state);
            if (privMethodElem != null) {
                safeInitMethods.add(privMethodElem);
            }
            if (!curStmt.getKind().equals((Object)Tree.Kind.TRY) || (tryTree = (TryTree)curStmt).getCatches().size() != 0) continue;
            if (tryTree.getBlock() != null) {
                resultBuilder.addAll(this.safeInitByCalleeBefore(pathToRead, state, new TreePath(enclosingBlockPath, tryTree.getBlock())));
            }
            if (tryTree.getFinallyBlock() == null) continue;
            resultBuilder.addAll(this.safeInitByCalleeBefore(pathToRead, state, new TreePath(enclosingBlockPath, tryTree.getFinallyBlock())));
        }
        this.addGuaranteedNonNullFromInvokes(state, NullAway.getTreesInstance(state), safeInitMethods, this.getNullnessAnalysis(state), (ImmutableSet.Builder<Element>)resultBuilder);
        return resultBuilder.build();
    }

    private int getStartPos(JCTree tree) {
        return tree.pos().getStartPosition();
    }

    private boolean fieldInitializedByPreviousInitializer(Symbol fieldSymbol, TreePath initTreePath, VisitorState state) {
        TreePath enclosingClassPath = initTreePath.getParentPath();
        ClassTree enclosingClass = (ClassTree)enclosingClassPath.getLeaf();
        Multimap<Tree, Element> tree2Init = this.initTree2PrevFieldInit.get(ASTHelpers.getSymbol((ClassTree)enclosingClass));
        if (tree2Init == null) {
            tree2Init = this.computeTree2Init(enclosingClassPath, state);
            this.initTree2PrevFieldInit.put(ASTHelpers.getSymbol((ClassTree)enclosingClass), tree2Init);
        }
        return tree2Init.containsEntry((Object)initTreePath.getLeaf(), (Object)fieldSymbol);
    }

    private Multimap<Tree, Element> computeTree2Init(TreePath enclosingClassPath, VisitorState state) {
        ClassTree enclosingClass = (ClassTree)enclosingClassPath.getLeaf();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        LinkedHashSet<Element> initThusFar = new LinkedHashSet<Element>();
        LinkedHashSet<MethodTree> constructors = new LinkedHashSet<MethodTree>();
        AccessPathNullnessAnalysis nullnessAnalysis = this.getNullnessAnalysis(state);
        for (Tree tree : enclosingClass.getMembers()) {
            MethodTree methodTree;
            if (tree instanceof VariableTree || tree instanceof BlockTree) {
                builder.putAll((Object)tree, initThusFar);
            }
            if (tree instanceof BlockTree) {
                BlockTree blockTree = (BlockTree)tree;
                TreePath memberPath = new TreePath(enclosingClassPath, tree);
                if (blockTree.isStatic()) {
                    initThusFar.addAll(nullnessAnalysis.getNonnullStaticFieldsAtExit(memberPath, state.context));
                } else {
                    initThusFar.addAll(nullnessAnalysis.getNonnullFieldsOfReceiverAtExit(memberPath, state.context));
                }
            }
            if (!(tree instanceof MethodTree) || !this.isConstructor(methodTree = (MethodTree)tree)) continue;
            constructors.add(methodTree);
        }
        constructors.stream().forEach(c -> builder.putAll(c, (Iterable)initThusFar));
        Symbol.ClassSymbol classSymbol = ASTHelpers.getSymbol((ClassTree)enclosingClass);
        FieldInitEntities fieldInitEntities = this.class2Entities.get(classSymbol);
        if (fieldInitEntities.instanceInitializerMethods().size() == 1) {
            MethodTree initMethod = (MethodTree)fieldInitEntities.instanceInitializerMethods().iterator().next();
            Set constructorUninitSymbols = this.class2ConstructorUninit.get((Object)classSymbol);
            Sets.SetView initAfterConstructors = Sets.union(initThusFar, (Set)Sets.difference(fieldInitEntities.nonnullInstanceFields(), (Set)constructorUninitSymbols));
            builder.putAll((Object)initMethod, (Iterable)initAfterConstructors);
        }
        if (fieldInitEntities.staticInitializerMethods().size() == 1) {
            MethodTree staticInitMethod = (MethodTree)fieldInitEntities.staticInitializerMethods().iterator().next();
            builder.putAll((Object)staticInitMethod, initThusFar);
        }
        return builder.build();
    }

    private boolean okToReadBeforeInitialized(TreePath path) {
        MethodInvocationTree methodInvoke;
        Symbol.MethodSymbol methodSymbol;
        String qualifiedName;
        TreePath parentPath = path.getParentPath();
        Tree leaf = path.getLeaf();
        Tree parent = parentPath.getLeaf();
        if (parent instanceof AssignmentTree) {
            AssignmentTree assignment = (AssignmentTree)parent;
            return assignment.getVariable().equals(leaf);
        }
        if (parent instanceof BinaryTree) {
            BinaryTree binaryTree = (BinaryTree)parent;
            Tree.Kind kind = binaryTree.getKind();
            if (kind.equals((Object)Tree.Kind.EQUAL_TO) || kind.equals((Object)Tree.Kind.NOT_EQUAL_TO)) {
                ExpressionTree left = binaryTree.getLeftOperand();
                ExpressionTree right = binaryTree.getRightOperand();
                return left.equals(leaf) && right.getKind().equals((Object)Tree.Kind.NULL_LITERAL) || right.equals(leaf) && left.getKind().equals((Object)Tree.Kind.NULL_LITERAL);
            }
        } else if (parent instanceof MethodInvocationTree && (qualifiedName = ASTHelpers.enclosingClass((Symbol)(methodSymbol = ASTHelpers.getSymbol((MethodInvocationTree)(methodInvoke = (MethodInvocationTree)parent)))) + "." + ((Name)methodSymbol.getSimpleName()).toString()).equals(this.config.getCastToNonNullMethod())) {
            java.util.List<? extends ExpressionTree> arguments = methodInvoke.getArguments();
            return arguments.size() == 1 && leaf.equals(arguments.get(0));
        }
        return false;
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (!this.matchWithinTopLevelClass) {
            return Description.NO_MATCH;
        }
        Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)tree);
        if (symbol.type.isPrimitive() && tree.getInitializer() != null) {
            return this.doUnboxingCheck(state, tree.getInitializer());
        }
        if (!symbol.getKind().equals((Object)ElementKind.FIELD)) {
            return Description.NO_MATCH;
        }
        ExpressionTree initializer = tree.getInitializer();
        if (initializer != null && !symbol.type.isPrimitive() && !this.skipDueToFieldAnnotation(symbol) && this.mayBeNullExpr(state, initializer)) {
            ErrorMessage errorMessage = new ErrorMessage(ErrorMessage.MessageTypes.ASSIGN_FIELD_NULLABLE, "assigning @Nullable expression to @NonNull field");
            return this.errorBuilder.createErrorDescriptionForNullAssignment(errorMessage, initializer, this.buildDescription(tree), state);
        }
        return Description.NO_MATCH;
    }

    public Description matchClass(ClassTree tree, VisitorState state) {
        Symbol.ClassSymbol classSymbol = ASTHelpers.getSymbol((ClassTree)tree);
        NestingKind nestingKind = classSymbol.getNestingKind();
        if (!nestingKind.isNested()) {
            this.matchWithinTopLevelClass = !this.isExcludedClass(classSymbol);
            this.handler.onMatchTopLevelClass(this, tree, state, classSymbol);
            this.getNullnessAnalysis(state).invalidateCaches();
            this.initTree2PrevFieldInit.clear();
            this.class2Entities.clear();
            this.class2ConstructorUninit.clear();
            this.computedNullnessMap.clear();
            EnclosingEnvironmentNullness.instance(state.context).clear();
        }
        if (this.matchWithinTopLevelClass) {
            if (nestingKind.equals((Object)NestingKind.LOCAL) || nestingKind.equals((Object)NestingKind.ANONYMOUS)) {
                this.updateEnvironmentMapping(tree, state);
            }
            this.checkFieldInitialization(tree, state);
        }
        return Description.NO_MATCH;
    }

    public Description matchBinary(BinaryTree tree, VisitorState state) {
        if (!this.matchWithinTopLevelClass) {
            return Description.NO_MATCH;
        }
        ExpressionTree leftOperand = tree.getLeftOperand();
        ExpressionTree rightOperand = tree.getRightOperand();
        Type leftType = ASTHelpers.getType((Tree)leftOperand);
        Type rightType = ASTHelpers.getType((Tree)rightOperand);
        if (leftType == null || rightType == null) {
            throw new RuntimeException();
        }
        if (leftType.isPrimitive() && !rightType.isPrimitive()) {
            return this.doUnboxingCheck(state, rightOperand);
        }
        if (rightType.isPrimitive() && !leftType.isPrimitive()) {
            return this.doUnboxingCheck(state, leftOperand);
        }
        return Description.NO_MATCH;
    }

    public Description matchUnary(UnaryTree tree, VisitorState state) {
        if (!this.matchWithinTopLevelClass) {
            return Description.NO_MATCH;
        }
        return this.doUnboxingCheck(state, tree.getExpression());
    }

    public Description matchConditionalExpression(ConditionalExpressionTree tree, VisitorState state) {
        if (!this.matchWithinTopLevelClass) {
            return Description.NO_MATCH;
        }
        return this.doUnboxingCheck(state, tree.getCondition());
    }

    public Description matchIf(IfTree tree, VisitorState state) {
        if (!this.matchWithinTopLevelClass) {
            return Description.NO_MATCH;
        }
        return this.doUnboxingCheck(state, tree.getCondition());
    }

    public Description matchWhileLoop(WhileLoopTree tree, VisitorState state) {
        if (!this.matchWithinTopLevelClass) {
            return Description.NO_MATCH;
        }
        return this.doUnboxingCheck(state, tree.getCondition());
    }

    public Description matchForLoop(ForLoopTree tree, VisitorState state) {
        if (!this.matchWithinTopLevelClass) {
            return Description.NO_MATCH;
        }
        if (tree.getCondition() != null) {
            return this.doUnboxingCheck(state, tree.getCondition());
        }
        return Description.NO_MATCH;
    }

    public Description matchEnhancedForLoop(EnhancedForLoopTree tree, VisitorState state) {
        if (!this.matchWithinTopLevelClass) {
            return Description.NO_MATCH;
        }
        ExpressionTree expr = tree.getExpression();
        ErrorMessage errorMessage = new ErrorMessage(ErrorMessage.MessageTypes.DEREFERENCE_NULLABLE, "enhanced-for expression " + state.getSourceForNode((Tree)expr) + " is @Nullable");
        if (this.mayBeNullExpr(state, expr)) {
            return this.errorBuilder.createErrorDescription(errorMessage, this.buildDescription(expr), state);
        }
        return Description.NO_MATCH;
    }

    private Description doUnboxingCheck(VisitorState state, ExpressionTree ... expressions) {
        for (ExpressionTree tree : expressions) {
            Type type = ASTHelpers.getType((Tree)tree);
            if (type == null) {
                throw new RuntimeException("was not expecting null type");
            }
            if (type.isPrimitive() || !this.mayBeNullExpr(state, tree)) continue;
            ErrorMessage errorMessage = new ErrorMessage(ErrorMessage.MessageTypes.UNBOX_NULLABLE, "unboxing of a @Nullable value");
            return this.errorBuilder.createErrorDescription(errorMessage, this.buildDescription(tree), state);
        }
        return Description.NO_MATCH;
    }

    private Description handleInvocation(Tree tree, VisitorState state, Symbol.MethodSymbol methodSymbol, java.util.List<? extends ExpressionTree> actualParams) {
        java.util.List formalParams;
        ImmutableSet nonNullPositions = null;
        if (NullabilityUtil.isUnannotated(methodSymbol, this.config)) {
            nonNullPositions = this.handler.onUnannotatedInvocationGetNonNullPositions(this, state, methodSymbol, actualParams, (ImmutableSet<Integer>)ImmutableSet.of());
        }
        if ((formalParams = methodSymbol.getParameters()).size() != actualParams.size() && !methodSymbol.isVarArgs() && !methodSymbol.isStatic() && methodSymbol.isConstructor() && methodSymbol.enclClass().isInner()) {
            return Description.NO_MATCH;
        }
        if (nonNullPositions == null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (int i = 0; i < formalParams.size(); ++i) {
                Symbol.VarSymbol param = (Symbol.VarSymbol)formalParams.get(i);
                if (param.type.isPrimitive()) {
                    Description unboxingCheck = this.doUnboxingCheck(state, actualParams.get(i));
                    if (unboxingCheck == Description.NO_MATCH) continue;
                    return unboxingCheck;
                }
                if (Nullness.paramHasNullableAnnotation(methodSymbol, i, this.config)) continue;
                builder.add((Object)i);
            }
            nonNullPositions = builder.build();
        }
        UnmodifiableIterator unmodifiableIterator = nonNullPositions.iterator();
        while (unmodifiableIterator.hasNext()) {
            int argPos = (Integer)unmodifiableIterator.next();
            ExpressionTree actual = null;
            boolean mayActualBeNull = false;
            if (argPos == formalParams.size() - 1 && methodSymbol.isVarArgs()) {
                ExpressionTree arg;
                if (actualParams.size() <= argPos) continue;
                Iterator<? extends ExpressionTree> iterator = actualParams.subList(argPos, actualParams.size()).iterator();
                while (iterator.hasNext() && !(mayActualBeNull = this.mayBeNullExpr(state, actual = (arg = iterator.next())))) {
                }
            } else {
                actual = actualParams.get(argPos);
                mayActualBeNull = this.mayBeNullExpr(state, actual);
            }
            Preconditions.checkNotNull((Object)actual);
            if (!mayActualBeNull) continue;
            String message = "passing @Nullable parameter '" + state.getSourceForNode((Tree)actual) + "' where @NonNull is required";
            return this.errorBuilder.createErrorDescriptionForNullAssignment(new ErrorMessage(ErrorMessage.MessageTypes.PASS_NULLABLE, message), actual, this.buildDescription(actual), state);
        }
        return this.checkCastToNonNullTakesNullable(tree, state, methodSymbol, actualParams);
    }

    private Description checkCastToNonNullTakesNullable(Tree tree, VisitorState state, Symbol.MethodSymbol methodSymbol, java.util.List<? extends ExpressionTree> actualParams) {
        String qualifiedName = ASTHelpers.enclosingClass((Symbol)methodSymbol) + "." + ((Name)methodSymbol.getSimpleName()).toString();
        if (qualifiedName.equals(this.config.getCastToNonNullMethod())) {
            boolean isInitializer;
            if (actualParams.size() != 1) {
                throw new RuntimeException("Invalid number of parameters passed to configured CastToNonNullMethod.");
            }
            ExpressionTree actual = actualParams.get(0);
            TreePath enclosingMethodOrLambda = NullabilityUtil.findEnclosingMethodOrLambdaOrInitializer(state.getPath());
            if (enclosingMethodOrLambda == null) {
                throw new RuntimeException("no enclosing method, lambda or initializer!");
            }
            if (enclosingMethodOrLambda.getLeaf() instanceof LambdaExpressionTree) {
                isInitializer = false;
            } else if (enclosingMethodOrLambda.getLeaf() instanceof MethodTree) {
                MethodTree enclosingMethod = (MethodTree)enclosingMethodOrLambda.getLeaf();
                isInitializer = this.isInitializerMethod(state, ASTHelpers.getSymbol((MethodTree)enclosingMethod));
            } else {
                isInitializer = true;
            }
            if (!isInitializer && !this.mayBeNullExpr(state, actual)) {
                String message = "passing known @NonNull parameter '" + state.getSourceForNode((Tree)actual) + "' to CastToNonNullMethod (" + qualifiedName + "). This method should only take arguments that NullAway considers @Nullable at the invocation site, but which are known not to be null at runtime.";
                return this.errorBuilder.createErrorDescription(new ErrorMessage(ErrorMessage.MessageTypes.CAST_TO_NONNULL_ARG_NONNULL, message), tree, this.buildDescription(tree), state);
            }
        }
        return Description.NO_MATCH;
    }

    private void checkFieldInitialization(ClassTree tree, VisitorState state) {
        ImmutableSet notInitializedInConstructors;
        SetMultimap<MethodTree, Symbol> constructorInitInfo;
        FieldInitEntities entities = this.collectEntities(tree, state);
        Symbol.ClassSymbol classSymbol = ASTHelpers.getSymbol((ClassTree)tree);
        this.class2Entities.put(classSymbol, entities);
        if (entities.constructors().isEmpty()) {
            constructorInitInfo = null;
            notInitializedInConstructors = entities.nonnullInstanceFields();
        } else {
            constructorInitInfo = this.checkConstructorInitialization(entities, state);
            notInitializedInConstructors = ImmutableSet.copyOf((Collection)constructorInitInfo.values());
        }
        this.class2ConstructorUninit.putAll((Object)classSymbol, (Iterable)notInitializedInConstructors);
        Set<Symbol> notInitializedAtAll = this.notAssignedInAnyInitializer(entities, (Set<Symbol>)notInitializedInConstructors, state);
        LinkedHashMultimap errorFieldsForInitializer = LinkedHashMultimap.create();
        Symbol.MethodSymbol singleInitializerMethod = null;
        if (entities.instanceInitializerMethods().size() == 1) {
            singleInitializerMethod = ASTHelpers.getSymbol((MethodTree)((MethodTree)entities.instanceInitializerMethods().iterator().next()));
        }
        for (Symbol uninitField : notInitializedAtAll) {
            if (this.errorBuilder.symbolHasSuppressWarningsAnnotation(uninitField, INITIALIZATION_CHECK_NAME)) continue;
            if (singleInitializerMethod != null) {
                errorFieldsForInitializer.put((Object)singleInitializerMethod, (Object)uninitField);
                continue;
            }
            if (constructorInitInfo == null) {
                if (this.isExternalInit(classSymbol) && entities.instanceInitializerMethods().isEmpty()) continue;
                this.errorBuilder.reportInitErrorOnField(uninitField, state, this.buildDescription(NullAway.getTreesInstance(state).getTree(uninitField)));
                continue;
            }
            for (MethodTree methodTree : constructorInitInfo.keySet()) {
                Set uninitFieldsForConstructor = constructorInitInfo.get((Object)methodTree);
                if (!uninitFieldsForConstructor.contains(uninitField)) continue;
                errorFieldsForInitializer.put((Object)ASTHelpers.getSymbol((MethodTree)methodTree), (Object)uninitField);
            }
        }
        for (Element constructorElement : errorFieldsForInitializer.keySet()) {
            this.errorBuilder.reportInitializerError((Symbol.MethodSymbol)constructorElement, ErrorBuilder.errMsgForInitializer(errorFieldsForInitializer.get((Object)constructorElement), state), state, this.buildDescription(NullAway.getTreesInstance(state).getTree(constructorElement)));
        }
        Set<Symbol> notInitializedStaticFields = this.notInitializedStatic(entities, state);
        for (Symbol uninitSField : notInitializedStaticFields) {
            this.errorBuilder.reportInitErrorOnField(uninitSField, state, this.buildDescription(NullAway.getTreesInstance(state).getTree(uninitSField)));
        }
    }

    private Set<Symbol> notAssignedInAnyInitializer(FieldInitEntities entities, Set<Symbol> notInitializedInConstructors, VisitorState state) {
        Trees trees = NullAway.getTreesInstance(state);
        Symbol.ClassSymbol classSymbol = entities.classSymbol();
        ImmutableSet.Builder initInSomeInitializerBuilder = ImmutableSet.builder();
        for (MethodTree initMethodTree : entities.instanceInitializerMethods()) {
            if (initMethodTree.getBody() == null) continue;
            this.addInitializedFieldsForBlock(state, trees, classSymbol, (ImmutableSet.Builder<Element>)initInSomeInitializerBuilder, initMethodTree.getBody(), new TreePath(state.getPath(), initMethodTree));
        }
        for (BlockTree block : entities.instanceInitializerBlocks()) {
            this.addInitializedFieldsForBlock(state, trees, classSymbol, (ImmutableSet.Builder<Element>)initInSomeInitializerBuilder, block, new TreePath(state.getPath(), block));
        }
        LinkedHashSet<Symbol> result = new LinkedHashSet<Symbol>();
        ImmutableSet initInSomeInitializer = initInSomeInitializerBuilder.build();
        for (Symbol fieldSymbol : notInitializedInConstructors) {
            if (initInSomeInitializer.contains((Object)fieldSymbol)) continue;
            result.add(fieldSymbol);
        }
        return result;
    }

    private void addInitializedFieldsForBlock(VisitorState state, Trees trees, Symbol.ClassSymbol classSymbol, ImmutableSet.Builder<Element> initInSomeInitializerBuilder, BlockTree block, TreePath path) {
        AccessPathNullnessAnalysis nullnessAnalysis = this.getNullnessAnalysis(state);
        Set<Element> nonnullAtExit = nullnessAnalysis.getNonnullFieldsOfReceiverAtExit(path, state.context);
        initInSomeInitializerBuilder.addAll(nonnullAtExit);
        Set<Element> safeInitMethods = this.getSafeInitMethods(block, classSymbol, state);
        this.addGuaranteedNonNullFromInvokes(state, trees, safeInitMethods, nullnessAnalysis, initInSomeInitializerBuilder);
    }

    private SetMultimap<MethodTree, Symbol> checkConstructorInitialization(FieldInitEntities entities, VisitorState state) {
        LinkedHashMultimap result = LinkedHashMultimap.create();
        ImmutableSet<Symbol> nonnullInstanceFields = entities.nonnullInstanceFields();
        Trees trees = NullAway.getTreesInstance(state);
        boolean isExternalInit = this.isExternalInit(entities.classSymbol());
        for (MethodTree constructor : entities.constructors()) {
            if (this.constructorInvokesAnother(constructor, state) || constructor.getParameters().size() == 0 && isExternalInit) continue;
            ImmutableSet<Element> guaranteedNonNull = this.guaranteedNonNullForConstructor(entities, state, trees, constructor);
            for (Symbol fieldSymbol : nonnullInstanceFields) {
                if (guaranteedNonNull.contains(fieldSymbol)) continue;
                result.put((Object)constructor, (Object)fieldSymbol);
            }
        }
        return result;
    }

    private boolean isExternalInit(Symbol.ClassSymbol classSymbol) {
        return StreamSupport.stream(NullabilityUtil.getAllAnnotations(classSymbol).spliterator(), false).map(anno -> anno.getAnnotationType().toString()).anyMatch(this.config::isExternalInitClassAnnotation);
    }

    private ImmutableSet<Element> guaranteedNonNullForConstructor(FieldInitEntities entities, VisitorState state, Trees trees, MethodTree constructor) {
        Set<Element> safeInitMethods = this.getSafeInitMethods(constructor.getBody(), entities.classSymbol(), state);
        AccessPathNullnessAnalysis nullnessAnalysis = this.getNullnessAnalysis(state);
        ImmutableSet.Builder guaranteedNonNullBuilder = ImmutableSet.builder();
        guaranteedNonNullBuilder.addAll(nullnessAnalysis.getNonnullFieldsOfReceiverAtExit(new TreePath(state.getPath(), constructor), state.context));
        this.addGuaranteedNonNullFromInvokes(state, trees, safeInitMethods, nullnessAnalysis, (ImmutableSet.Builder<Element>)guaranteedNonNullBuilder);
        return guaranteedNonNullBuilder.build();
    }

    private boolean constructorInvokesAnother(MethodTree constructor, VisitorState state) {
        StatementTree statementTree;
        BlockTree body = constructor.getBody();
        java.util.List<? extends StatementTree> statements = body.getStatements();
        return statements.size() > 0 && this.isThisCall(statementTree = statements.get(0), state);
    }

    private Set<Symbol> notInitializedStatic(FieldInitEntities entities, VisitorState state) {
        Set<Element> nonnullAtExit;
        ImmutableSet<Symbol> nonNullStaticFields = entities.nonnullStaticFields();
        LinkedHashSet<Element> initializedInStaticInitializers = new LinkedHashSet<Element>();
        AccessPathNullnessAnalysis nullnessAnalysis = this.getNullnessAnalysis(state);
        for (BlockTree initializer : entities.staticInitializerBlocks()) {
            nonnullAtExit = nullnessAnalysis.getNonnullStaticFieldsAtExit(new TreePath(state.getPath(), initializer), state.context);
            initializedInStaticInitializers.addAll(nonnullAtExit);
        }
        for (MethodTree initializerMethod : entities.staticInitializerMethods()) {
            nonnullAtExit = nullnessAnalysis.getNonnullStaticFieldsAtExit(new TreePath(state.getPath(), initializerMethod), state.context);
            initializedInStaticInitializers.addAll(nonnullAtExit);
        }
        LinkedHashSet<Symbol> notInitializedStaticFields = new LinkedHashSet<Symbol>();
        for (Symbol field : nonNullStaticFields) {
            if (initializedInStaticInitializers.contains(field)) continue;
            notInitializedStaticFields.add(field);
        }
        return notInitializedStaticFields;
    }

    private void addGuaranteedNonNullFromInvokes(VisitorState state, Trees trees, Set<Element> safeInitMethods, AccessPathNullnessAnalysis nullnessAnalysis, ImmutableSet.Builder<Element> guaranteedNonNullBuilder) {
        for (Element invoked : safeInitMethods) {
            Tree invokedTree = trees.getTree(invoked);
            guaranteedNonNullBuilder.addAll(nullnessAnalysis.getNonnullFieldsOfReceiverAtExit(new TreePath(state.getPath(), invokedTree), state.context));
        }
    }

    private Set<Element> getSafeInitMethods(BlockTree blockTree, Symbol.ClassSymbol classSymbol, VisitorState state) {
        LinkedHashSet<Element> result = new LinkedHashSet<Element>();
        java.util.List<? extends StatementTree> statements = blockTree.getStatements();
        for (StatementTree statementTree : statements) {
            TryTree tryTree;
            Element privMethodElem = this.getInvokeOfSafeInitMethod(statementTree, classSymbol, state);
            if (privMethodElem != null) {
                result.add(privMethodElem);
            }
            if (!statementTree.getKind().equals((Object)Tree.Kind.TRY) || (tryTree = (TryTree)statementTree).getCatches().size() != 0) continue;
            if (tryTree.getBlock() != null) {
                result.addAll(this.getSafeInitMethods(tryTree.getBlock(), classSymbol, state));
            }
            if (tryTree.getFinallyBlock() == null) continue;
            result.addAll(this.getSafeInitMethods(tryTree.getFinallyBlock(), classSymbol, state));
        }
        return result;
    }

    @Nullable
    private Element getInvokeOfSafeInitMethod(StatementTree stmt, Symbol.ClassSymbol enclosingClassSymbol, VisitorState state) {
        ExpressionTree expression;
        Matcher & Serializable invokeMatcher = (Matcher & Serializable)(expressionTree, s2) -> {
            if (!(expressionTree instanceof MethodInvocationTree)) {
                return false;
            }
            MethodInvocationTree methodInvocationTree = (MethodInvocationTree)expressionTree;
            Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodInvocationTree)methodInvocationTree);
            Set<Modifier> modifiers = symbol.getModifiers();
            Set<Modifier> classModifiers = enclosingClassSymbol.getModifiers();
            if ((symbol.isPrivate() || modifiers.contains((Object)Modifier.FINAL) || classModifiers.contains((Object)Modifier.FINAL)) && !symbol.isStatic() && !modifiers.contains((Object)Modifier.NATIVE) && ASTHelpers.enclosingClass((Symbol)symbol).equals(enclosingClassSymbol)) {
                ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)expressionTree);
                return receiver == null || NullAway.isThisIdentifier(receiver);
            }
            return false;
        };
        if (stmt.getKind().equals((Object)Tree.Kind.EXPRESSION_STATEMENT) && invokeMatcher.matches((Tree)(expression = ((ExpressionStatementTree)stmt).getExpression()), state)) {
            return ASTHelpers.getSymbol((Tree)expression);
        }
        return null;
    }

    private boolean isThisCall(StatementTree statementTree, VisitorState state) {
        if (statementTree.getKind().equals((Object)Tree.Kind.EXPRESSION_STATEMENT)) {
            ExpressionTree expression = ((ExpressionStatementTree)statementTree).getExpression();
            return Matchers.methodInvocation(THIS_MATCHER).matches((Tree)expression, state);
        }
        return false;
    }

    private FieldInitEntities collectEntities(ClassTree tree, VisitorState state) {
        Symbol.ClassSymbol classSymbol = ASTHelpers.getSymbol((ClassTree)tree);
        LinkedHashSet<Symbol.VarSymbol> nonnullInstanceFields = new LinkedHashSet<Symbol.VarSymbol>();
        LinkedHashSet<Symbol.VarSymbol> nonnullStaticFields = new LinkedHashSet<Symbol.VarSymbol>();
        ArrayList<BlockTree> instanceInitializerBlocks = new ArrayList<BlockTree>();
        ArrayList<BlockTree> staticInitializerBlocks = new ArrayList<BlockTree>();
        LinkedHashSet<MethodTree> constructors = new LinkedHashSet<MethodTree>();
        LinkedHashSet<MethodTree> instanceInitializerMethods = new LinkedHashSet<MethodTree>();
        LinkedHashSet<MethodTree> staticInitializerMethods = new LinkedHashSet<MethodTree>();
        block6: for (Tree tree2 : tree.getMembers()) {
            switch (tree2.getKind()) {
                case METHOD: {
                    MethodTree methodTree = (MethodTree)tree2;
                    Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodTree)methodTree);
                    if (this.isConstructor(methodTree)) {
                        constructors.add(methodTree);
                        continue block6;
                    }
                    if (!this.isInitializerMethod(state, symbol)) continue block6;
                    if (symbol.isStatic()) {
                        staticInitializerMethods.add(methodTree);
                        continue block6;
                    }
                    instanceInitializerMethods.add(methodTree);
                    continue block6;
                }
                case VARIABLE: {
                    VariableTree varTree = (VariableTree)tree2;
                    Symbol.VarSymbol fieldSymbol = ASTHelpers.getSymbol((VariableTree)varTree);
                    if (fieldSymbol.type.isPrimitive() || this.skipDueToFieldAnnotation(fieldSymbol) || varTree.getInitializer() != null) continue block6;
                    if (fieldSymbol.isStatic()) {
                        nonnullStaticFields.add(fieldSymbol);
                        continue block6;
                    }
                    nonnullInstanceFields.add(fieldSymbol);
                    continue block6;
                }
                case BLOCK: {
                    BlockTree blockTree = (BlockTree)tree2;
                    if (blockTree.isStatic()) {
                        staticInitializerBlocks.add(blockTree);
                        continue block6;
                    }
                    instanceInitializerBlocks.add(blockTree);
                    continue block6;
                }
                case ENUM: 
                case CLASS: 
                case INTERFACE: 
                case ANNOTATION_TYPE: {
                    continue block6;
                }
            }
            throw new RuntimeException(tree2.getKind().toString() + " " + state.getSourceForNode(tree2));
        }
        return FieldInitEntities.create(classSymbol, (Set<Symbol>)ImmutableSet.copyOf(nonnullInstanceFields), (Set<Symbol>)ImmutableSet.copyOf(nonnullStaticFields), (java.util.List<BlockTree>)ImmutableList.copyOf(instanceInitializerBlocks), (java.util.List<BlockTree>)ImmutableList.copyOf(staticInitializerBlocks), (Set<MethodTree>)ImmutableSet.copyOf(constructors), (Set<MethodTree>)ImmutableSet.copyOf(instanceInitializerMethods), (Set<MethodTree>)ImmutableSet.copyOf(staticInitializerMethods));
    }

    private boolean isConstructor(MethodTree methodTree) {
        return ASTHelpers.getSymbol((MethodTree)methodTree).isConstructor() && !ASTHelpers.isGeneratedConstructor((MethodTree)methodTree);
    }

    private boolean isInitializerMethod(VisitorState state, Symbol.MethodSymbol symbol) {
        if (ASTHelpers.hasDirectAnnotationWithSimpleName((Symbol)symbol, (String)"Initializer") || this.config.isKnownInitializerMethod(symbol)) {
            return true;
        }
        for (AnnotationMirror anno : symbol.getAnnotationMirrors()) {
            String annoTypeStr = anno.getAnnotationType().toString();
            if (!this.config.isInitializerMethodAnnotation(annoTypeStr)) continue;
            return true;
        }
        Symbol.MethodSymbol closestOverriddenMethod = this.getClosestOverriddenMethod(symbol, state.getTypes());
        if (closestOverriddenMethod == null) {
            return false;
        }
        return this.isInitializerMethod(state, closestOverriddenMethod);
    }

    private boolean skipDueToFieldAnnotation(Symbol fieldSymbol) {
        return NullabilityUtil.getAllAnnotations(fieldSymbol).map(anno -> anno.getAnnotationType().toString()).anyMatch(this.config::isExcludedFieldAnnotation);
    }

    private boolean isExcludedClass(Symbol.ClassSymbol classSymbol) {
        String className = classSymbol.getQualifiedName().toString();
        if (this.config.isExcludedClass(className)) {
            return true;
        }
        if (!this.config.fromAnnotatedPackage(classSymbol)) {
            return true;
        }
        ImmutableSet<String> excludedClassAnnotations = this.config.getExcludedClassAnnotations();
        return classSymbol.getAnnotationMirrors().stream().map(anno -> anno.getAnnotationType().toString()).anyMatch(arg_0 -> excludedClassAnnotations.contains(arg_0));
    }

    private boolean mayBeNullExpr(VisitorState state, ExpressionTree expr) {
        boolean exprMayBeNull;
        if (ASTHelpers.constValue((Tree)(expr = NullAway.stripParensAndCasts(expr))) != null) {
            return false;
        }
        Symbol exprSymbol = ASTHelpers.getSymbol((Tree)expr);
        switch (expr.getKind()) {
            case NULL_LITERAL: {
                exprMayBeNull = true;
                break;
            }
            case ARRAY_ACCESS: {
                exprMayBeNull = false;
                break;
            }
            case NEW_CLASS: 
            case NEW_ARRAY: 
            case LAMBDA_EXPRESSION: 
            case MEMBER_REFERENCE: 
            case MULTIPLY_ASSIGNMENT: 
            case DIVIDE_ASSIGNMENT: 
            case REMAINDER_ASSIGNMENT: 
            case PLUS_ASSIGNMENT: 
            case MINUS_ASSIGNMENT: 
            case LEFT_SHIFT_ASSIGNMENT: 
            case RIGHT_SHIFT_ASSIGNMENT: 
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: 
            case AND_ASSIGNMENT: 
            case XOR_ASSIGNMENT: 
            case OR_ASSIGNMENT: 
            case PLUS: 
            case MINUS: 
            case MULTIPLY: 
            case DIVIDE: 
            case REMAINDER: 
            case CONDITIONAL_AND: 
            case CONDITIONAL_OR: 
            case LOGICAL_COMPLEMENT: 
            case INSTANCE_OF: 
            case PREFIX_INCREMENT: 
            case PREFIX_DECREMENT: 
            case POSTFIX_DECREMENT: 
            case POSTFIX_INCREMENT: 
            case EQUAL_TO: 
            case NOT_EQUAL_TO: 
            case GREATER_THAN: 
            case GREATER_THAN_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_EQUAL: 
            case UNARY_MINUS: 
            case UNARY_PLUS: 
            case AND: 
            case OR: 
            case XOR: 
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: {
                exprMayBeNull = false;
                break;
            }
            case MEMBER_SELECT: {
                exprMayBeNull = this.mayBeNullFieldAccess(state, expr, exprSymbol);
                break;
            }
            case IDENTIFIER: {
                if (exprSymbol != null && exprSymbol.getKind().equals((Object)ElementKind.FIELD)) {
                    return this.mayBeNullFieldAccess(state, expr, exprSymbol);
                }
                boolean exprMayBeNull2 = this.handler.onOverrideMayBeNullExpr(this, expr, state, true);
                return exprMayBeNull2 ? this.nullnessFromDataflow(state, expr) : false;
            }
            case METHOD_INVOCATION: {
                return this.mayBeNullMethodCall(state, expr, (Symbol.MethodSymbol)exprSymbol);
            }
            case CONDITIONAL_EXPRESSION: 
            case ASSIGNMENT: {
                exprMayBeNull = this.nullnessFromDataflow(state, expr);
                break;
            }
            default: {
                throw new RuntimeException("whoops, better handle " + (Object)((Object)expr.getKind()) + " " + state.getSourceForNode((Tree)expr));
            }
        }
        exprMayBeNull = this.handler.onOverrideMayBeNullExpr(this, expr, state, exprMayBeNull);
        return exprMayBeNull;
    }

    private boolean mayBeNullMethodCall(VisitorState state, ExpressionTree expr, Symbol.MethodSymbol exprSymbol) {
        boolean exprMayBeNull = true;
        if (NullabilityUtil.isUnannotated(exprSymbol, this.config)) {
            exprMayBeNull = false;
        }
        if (!Nullness.hasNullableAnnotation(exprSymbol, this.config)) {
            exprMayBeNull = false;
        }
        return (exprMayBeNull = this.handler.onOverrideMayBeNullExpr(this, expr, state, exprMayBeNull)) ? this.nullnessFromDataflow(state, expr) : false;
    }

    public boolean nullnessFromDataflow(VisitorState state, ExpressionTree expr) {
        Nullness nullness = this.getNullnessAnalysis(state).getNullness(new TreePath(state.getPath(), expr), state.context);
        if (nullness == null) {
            return false;
        }
        return NullAway.nullnessToBool(nullness);
    }

    public AccessPathNullnessAnalysis getNullnessAnalysis(VisitorState state) {
        return AccessPathNullnessAnalysis.instance(state.context, this.nonAnnotatedMethod, this.config, this.handler);
    }

    private boolean mayBeNullFieldAccess(VisitorState state, ExpressionTree expr, Symbol exprSymbol) {
        boolean exprMayBeNull = true;
        if (!NullabilityUtil.mayBeNullFieldFromType(exprSymbol, this.config)) {
            exprMayBeNull = false;
        }
        return (exprMayBeNull = this.handler.onOverrideMayBeNullExpr(this, expr, state, exprMayBeNull)) ? this.nullnessFromDataflow(state, expr) : false;
    }

    private boolean kindMayDeferenceNull(ElementKind kind) {
        switch (kind) {
            case CLASS: 
            case PACKAGE: 
            case ENUM: 
            case INTERFACE: 
            case ANNOTATION_TYPE: {
                return false;
            }
        }
        return true;
    }

    private Description matchDereference(ExpressionTree baseExpression, ExpressionTree derefExpression, VisitorState state) {
        Symbol dereferenced = ASTHelpers.getSymbol((Tree)baseExpression);
        if (dereferenced == null || dereferenced.type.isPrimitive() || !this.kindMayDeferenceNull(dereferenced.getKind())) {
            return Description.NO_MATCH;
        }
        if (this.mayBeNullExpr(state, baseExpression)) {
            String message = "dereferenced expression " + state.getSourceForNode((Tree)baseExpression) + " is @Nullable";
            ErrorMessage errorMessage = new ErrorMessage(ErrorMessage.MessageTypes.DEREFERENCE_NULLABLE, message);
            return this.errorBuilder.createErrorDescriptionForNullAssignment(errorMessage, baseExpression, this.buildDescription(derefExpression), state);
        }
        Optional<ErrorMessage> handlerErrorMessage = this.handler.onExpressionDereference(derefExpression, baseExpression, state);
        if (handlerErrorMessage.isPresent()) {
            return this.errorBuilder.createErrorDescriptionForNullAssignment(handlerErrorMessage.get(), derefExpression, this.buildDescription(derefExpression), state);
        }
        return Description.NO_MATCH;
    }

    private Description.Builder changeReturnNullabilityFix(Tree suggestTree, Description.Builder builder, VisitorState state) {
        if (suggestTree.getKind() != Tree.Kind.METHOD) {
            throw new RuntimeException("This should be a MethodTree");
        }
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        MethodTree methodTree = (MethodTree)suggestTree;
        int countNullableAnnotations = 0;
        for (AnnotationTree annotationTree : methodTree.getModifiers().getAnnotations()) {
            if (!state.getSourceForNode(annotationTree.getAnnotationType()).endsWith("Nullable")) continue;
            fixBuilder.delete((Tree)annotationTree);
            ++countNullableAnnotations;
        }
        assert (countNullableAnnotations > 1);
        return builder.addFix((Fix)fixBuilder.build());
    }

    private Description.Builder changeParamNullabilityFix(Tree suggestTree, Description.Builder builder) {
        return builder.addFix((Fix)SuggestedFix.prefixWith((Tree)suggestTree, (String)"@Nullable "));
    }

    private int depth(ExpressionTree expression) {
        switch (expression.getKind()) {
            case MEMBER_SELECT: {
                MemberSelectTree selectTree = (MemberSelectTree)expression;
                return 1 + this.depth(selectTree.getExpression());
            }
            case METHOD_INVOCATION: {
                MethodInvocationTree invTree = (MethodInvocationTree)expression;
                return this.depth(invTree.getMethodSelect());
            }
            case IDENTIFIER: {
                IdentifierTree varTree = (IdentifierTree)expression;
                Symbol symbol = ASTHelpers.getSymbol((Tree)varTree);
                return symbol.getKind().equals((Object)ElementKind.FIELD) ? 2 : 1;
            }
        }
        return 0;
    }

    private static boolean isThisIdentifier(ExpressionTree expressionTree) {
        return expressionTree.getKind().equals((Object)Tree.Kind.IDENTIFIER) && ((IdentifierTree)expressionTree).getName().toString().equals("this");
    }

    private static boolean isThisIdentifierMatcher(ExpressionTree expressionTree, VisitorState state) {
        return NullAway.isThisIdentifier(expressionTree);
    }

    public ErrorBuilder getErrorBuilder() {
        return this.errorBuilder;
    }

    private static ExpressionTree stripParensAndCasts(ExpressionTree expr) {
        boolean someChange = true;
        while (someChange) {
            someChange = false;
            if (expr.getKind().equals((Object)Tree.Kind.PARENTHESIZED)) {
                expr = ((ParenthesizedTree)expr).getExpression();
                someChange = true;
            }
            if (expr.getKind().equals((Object)Tree.Kind.TYPE_CAST)) {
                expr = ((TypeCastTree)expr).getExpression();
                someChange = true;
            }
            if (!expr.getKind().equals((Object)Tree.Kind.OTHER) || !(expr instanceof JCTree.JCUnary)) continue;
            expr = ((JCTree.JCUnary)expr).getExpression();
            someChange = true;
        }
        return expr;
    }

    private static boolean nullnessToBool(Nullness nullness) {
        switch (nullness) {
            case BOTTOM: 
            case NONNULL: {
                return false;
            }
            case NULL: 
            case NULLABLE: {
                return true;
            }
        }
        throw new AssertionError((Object)("Impossible: " + nullness));
    }

    @Nullable
    private Symbol.MethodSymbol getClosestOverriddenMethod(Symbol.MethodSymbol method, Types types) {
        Symbol.ClassSymbol owner = method.enclClass();
        for (Type s2 : types.closure(owner.type)) {
            if (types.isSameType(s2, owner.type)) continue;
            for (Symbol m3 : s2.tsym.members().getSymbolsByName(method.name)) {
                Symbol.MethodSymbol msym;
                if (!(m3 instanceof Symbol.MethodSymbol) || (msym = (Symbol.MethodSymbol)m3).isStatic() || !method.overrides(msym, owner, types, false)) continue;
                return msym;
            }
        }
        return null;
    }

    public Nullness getComputedNullness(ExpressionTree e) {
        if (this.computedNullnessMap.containsKey(e)) {
            return this.computedNullnessMap.get(e);
        }
        return Nullness.NULLABLE;
    }

    public void setComputedNullness(ExpressionTree e, Nullness nullness) {
        this.computedNullnessMap.put(e, nullness);
    }

    @AutoValue
    static abstract class FieldInitEntities {
        FieldInitEntities() {
        }

        static FieldInitEntities create(Symbol.ClassSymbol classSymbol, Set<Symbol> nonnullInstanceFields, Set<Symbol> nonnullStaticFields, java.util.List<BlockTree> instanceInitializerBlocks, java.util.List<BlockTree> staticInitializerBlocks, Set<MethodTree> constructors, Set<MethodTree> instanceInitializerMethods, Set<MethodTree> staticInitializerMethods) {
            return new AutoValue_NullAway_FieldInitEntities(classSymbol, (ImmutableSet<Symbol>)ImmutableSet.copyOf(nonnullInstanceFields), (ImmutableSet<Symbol>)ImmutableSet.copyOf(nonnullStaticFields), (ImmutableList<BlockTree>)ImmutableList.copyOf(instanceInitializerBlocks), (ImmutableList<BlockTree>)ImmutableList.copyOf(staticInitializerBlocks), (ImmutableSet<MethodTree>)ImmutableSet.copyOf(constructors), (ImmutableSet<MethodTree>)ImmutableSet.copyOf(instanceInitializerMethods), (ImmutableSet<MethodTree>)ImmutableSet.copyOf(staticInitializerMethods));
        }

        abstract Symbol.ClassSymbol classSymbol();

        abstract ImmutableSet<Symbol> nonnullInstanceFields();

        abstract ImmutableSet<Symbol> nonnullStaticFields();

        abstract ImmutableList<BlockTree> instanceInitializerBlocks();

        abstract ImmutableList<BlockTree> staticInitializerBlocks();

        abstract ImmutableSet<MethodTree> constructors();

        abstract ImmutableSet<MethodTree> instanceInitializerMethods();

        abstract ImmutableSet<MethodTree> staticInitializerMethods();
    }
}

