/*
 * Decompiled with CFR 0.152.
 */
package com.uber.nullaway;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.uber.nullaway.Config;
import com.uber.nullaway.Nullness;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationMirror;

public class NullabilityUtil {
    private NullabilityUtil() {
    }

    public static Symbol.MethodSymbol getFunctionalInterfaceMethod(ExpressionTree tree, Types types) {
        Preconditions.checkArgument((tree instanceof LambdaExpressionTree || tree instanceof MemberReferenceTree ? 1 : 0) != 0);
        Type funcInterfaceType = ((JCTree.JCFunctionalExpression)tree).type;
        return (Symbol.MethodSymbol)types.findDescriptorSymbol(funcInterfaceType.tsym);
    }

    public static boolean lambdaParamIsImplicitlyTyped(VariableTree lambdaParameter) {
        JCDiagnostic.DiagnosticPosition diagnosticPosition = (JCDiagnostic.DiagnosticPosition)((Object)lambdaParameter);
        return diagnosticPosition.getStartPosition() == diagnosticPosition.getPreferredPosition();
    }

    public static Symbol.ClassSymbol getOutermostClassSymbol(Symbol symbol) {
        Symbol.ClassSymbol enclosingSymbol;
        Symbol.ClassSymbol outermostClassSymbol = ASTHelpers.enclosingClass((Symbol)symbol);
        while (outermostClassSymbol.getNestingKind().isNested() && (enclosingSymbol = ASTHelpers.enclosingClass((Symbol)outermostClassSymbol.owner)) != null) {
            outermostClassSymbol = enclosingSymbol;
        }
        return outermostClassSymbol;
    }

    @Nullable
    public static TreePath findEnclosingMethodOrLambdaOrInitializer(TreePath path, ImmutableSet<Tree.Kind> others) {
        TreePath curPath = path.getParentPath();
        while (curPath != null) {
            if (curPath.getLeaf() instanceof MethodTree || curPath.getLeaf() instanceof LambdaExpressionTree || others.contains((Object)curPath.getLeaf().getKind())) {
                return curPath;
            }
            TreePath parent = curPath.getParentPath();
            if (parent != null && parent.getLeaf() instanceof ClassTree) {
                if (curPath.getLeaf() instanceof BlockTree) {
                    return curPath;
                }
                if (curPath.getLeaf() instanceof VariableTree && ((VariableTree)curPath.getLeaf()).getInitializer() != null) {
                    return curPath;
                }
            }
            curPath = parent;
        }
        return null;
    }

    @Nullable
    public static TreePath findEnclosingMethodOrLambdaOrInitializer(TreePath path) {
        return NullabilityUtil.findEnclosingMethodOrLambdaOrInitializer(path, (ImmutableSet<Tree.Kind>)ImmutableSet.of());
    }

    public static Stream<? extends AnnotationMirror> getAllAnnotations(Symbol symbol) {
        Stream<? extends AnnotationMirror> typeUseAnnotations = NullabilityUtil.getTypeUseAnnotations(symbol);
        return Stream.concat(symbol.getAnnotationMirrors().stream(), typeUseAnnotations);
    }

    public static Stream<? extends AnnotationMirror> getAllAnnotationsForParameter(Symbol.MethodSymbol symbol, int paramInd) {
        Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)((List)symbol.getParameters()).get(paramInd);
        return Stream.concat(varSymbol.getAnnotationMirrors().stream(), symbol.getRawTypeAttributes().stream().filter(t -> t.position.type.equals((Object)TargetType.METHOD_FORMAL_PARAMETER) && t.position.parameter_index == paramInd));
    }

    private static Stream<? extends AnnotationMirror> getTypeUseAnnotations(Symbol symbol) {
        Stream rawTypeAttributes = symbol.getRawTypeAttributes().stream();
        if (symbol instanceof Symbol.MethodSymbol) {
            return rawTypeAttributes.filter(t -> t.position.type.equals((Object)TargetType.METHOD_RETURN));
        }
        return rawTypeAttributes;
    }

    public static boolean mayBeNullFieldFromType(@Nullable Symbol symbol, Config config) {
        if (symbol == null) {
            return true;
        }
        return !symbol.getSimpleName().toString().equals("class") && !symbol.isEnum() && !NullabilityUtil.isUnannotated(symbol, config) && Nullness.hasNullableAnnotation(symbol, config);
    }

    public static boolean isUnannotated(Symbol symbol, Config config) {
        Symbol.ClassSymbol outermostClassSymbol = NullabilityUtil.getOutermostClassSymbol(symbol);
        return !config.fromAnnotatedPackage(outermostClassSymbol) || config.isUnannotatedClass(outermostClassSymbol);
    }

    public static boolean isGenerated(Symbol symbol) {
        Symbol.ClassSymbol outermostClassSymbol = NullabilityUtil.getOutermostClassSymbol(symbol);
        return ASTHelpers.hasDirectAnnotationWithSimpleName((Symbol)outermostClassSymbol, (String)"Generated");
    }
}

