/*
 * Decompiled with CFR 0.152.
 */
package com.uber.nullaway;

import com.sun.tools.javac.code.Symbol;
import com.uber.nullaway.Config;
import com.uber.nullaway.NullabilityUtil;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import shadow.checkerframework.dataflow.analysis.AbstractValue;

public enum Nullness implements AbstractValue<Nullness>
{
    NULLABLE("Nullable"),
    NULL("Null"),
    NONNULL("Non-null"),
    BOTTOM("Bottom");

    private final String displayName;

    private Nullness(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public Nullness leastUpperBound(Nullness other) {
        if (this == other) {
            return this;
        }
        if (this == BOTTOM) {
            return other;
        }
        if (other == BOTTOM) {
            return this;
        }
        return NULLABLE;
    }

    public Nullness greatestLowerBound(Nullness other) {
        if (this == other) {
            return this;
        }
        if (this == NULLABLE) {
            return other;
        }
        if (other == NULLABLE) {
            return this;
        }
        return BOTTOM;
    }

    public Nullness deducedValueWhenNotEqual() {
        switch (this) {
            case NULLABLE: {
                return NULLABLE;
            }
            case NONNULL: {
                return NULLABLE;
            }
            case NULL: {
                return NONNULL;
            }
            case BOTTOM: {
                return BOTTOM;
            }
        }
        throw new AssertionError((Object)("Inverse of " + this + " not defined"));
    }

    public String toString() {
        return this.displayName;
    }

    private static boolean hasNullableAnnotation(Stream<? extends AnnotationMirror> annotations, Config config) {
        return annotations.map(anno -> anno.getAnnotationType().toString()).anyMatch(anno -> Nullness.isNullableAnnotation(anno, config));
    }

    private static boolean hasNonNullAnnotation(Stream<? extends AnnotationMirror> annotations, Config config) {
        return annotations.map(anno -> anno.getAnnotationType().toString()).anyMatch(anno -> Nullness.isNonNullAnnotation(anno, config));
    }

    public static boolean isNullableAnnotation(String annotName, Config config) {
        return annotName.endsWith(".Nullable") || annotName.endsWith(".checkerframework.checker.nullness.compatqual.NullableDecl") || annotName.endsWith(".CheckForNull") || config.acknowledgeAndroidRecent() && annotName.equals("androidx.annotation.RecentlyNullable");
    }

    private static boolean isNonNullAnnotation(String annotName, Config config) {
        return annotName.endsWith(".NonNull") || annotName.endsWith(".NotNull") || annotName.endsWith(".Nonnull") || config.acknowledgeAndroidRecent() && annotName.equals("androidx.annotation.RecentlyNonNull");
    }

    public static boolean hasNonNullAnnotation(Symbol symbol, Config config) {
        return Nullness.hasNonNullAnnotation(NullabilityUtil.getAllAnnotations(symbol), config);
    }

    public static boolean hasNullableAnnotation(Symbol symbol, Config config) {
        return Nullness.hasNullableAnnotation(NullabilityUtil.getAllAnnotations(symbol), config);
    }

    public static boolean paramHasNullableAnnotation(Symbol.MethodSymbol symbol, int paramInd, Config config) {
        return Nullness.hasNullableAnnotation(NullabilityUtil.getAllAnnotationsForParameter(symbol, paramInd), config);
    }

    public static boolean paramHasNonNullAnnotation(Symbol.MethodSymbol symbol, int paramInd, Config config) {
        return Nullness.hasNonNullAnnotation(NullabilityUtil.getAllAnnotationsForParameter(symbol, paramInd), config);
    }
}

