/*
 * Decompiled with CFR 0.152.
 */
package com.uber.nullaway.dataflow;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.uber.nullaway.dataflow.AccessPathElement;
import com.uber.nullaway.dataflow.MapKey;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import shadow.checkerframework.dataflow.cfg.node.FieldAccessNode;
import shadow.checkerframework.dataflow.cfg.node.IntegerLiteralNode;
import shadow.checkerframework.dataflow.cfg.node.LocalVariableNode;
import shadow.checkerframework.dataflow.cfg.node.LongLiteralNode;
import shadow.checkerframework.dataflow.cfg.node.MethodAccessNode;
import shadow.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import shadow.checkerframework.dataflow.cfg.node.Node;
import shadow.checkerframework.dataflow.cfg.node.StringLiteralNode;
import shadow.checkerframework.dataflow.cfg.node.ThisLiteralNode;
import shadow.checkerframework.dataflow.cfg.node.VariableDeclarationNode;
import shadow.checkerframework.javacutil.TreeUtils;

public final class AccessPath
implements MapKey {
    private final Root root;
    private final ImmutableList<AccessPathElement> elements;
    @Nullable
    private final MapKey mapGetArg;

    AccessPath(Root root, java.util.List<AccessPathElement> elements) {
        this.root = root;
        this.elements = ImmutableList.copyOf(elements);
        this.mapGetArg = null;
    }

    private AccessPath(Root root, java.util.List<AccessPathElement> elements, MapKey mapGetArg) {
        this.root = root;
        this.elements = ImmutableList.copyOf(elements);
        this.mapGetArg = mapGetArg;
    }

    static AccessPath fromLocal(LocalVariableNode node) {
        return new AccessPath(new Root(node.getElement()), (java.util.List<AccessPathElement>)ImmutableList.of());
    }

    static AccessPath fromVarDecl(VariableDeclarationNode node) {
        VariableElement elem = TreeUtils.elementFromDeclaration(node.getTree());
        return new AccessPath(new Root(elem), (java.util.List<AccessPathElement>)ImmutableList.of());
    }

    @Nullable
    static AccessPath fromFieldAccess(FieldAccessNode node) {
        ArrayList<AccessPathElement> elements = new ArrayList<AccessPathElement>();
        Root root = AccessPath.populateElementsRec(node, elements);
        return root != null ? new AccessPath(root, elements) : null;
    }

    @Nullable
    static AccessPath fromMethodCall(MethodInvocationNode node, @Nullable Types types) {
        if (types != null && AccessPath.isMapGet(ASTHelpers.getSymbol((MethodInvocationTree)node.getTree()), types)) {
            return AccessPath.fromMapGetCall(node);
        }
        return AccessPath.fromVanillaMethodCall(node);
    }

    @Nullable
    private static AccessPath fromVanillaMethodCall(MethodInvocationNode node) {
        ArrayList<AccessPathElement> elements = new ArrayList<AccessPathElement>();
        Root root = AccessPath.populateElementsRec(node, elements);
        return root != null ? new AccessPath(root, elements) : null;
    }

    @Nullable
    public static AccessPath fromBaseAndElement(Node base, Element element) {
        ArrayList<AccessPathElement> elements = new ArrayList<AccessPathElement>();
        Root root = AccessPath.populateElementsRec(base, elements);
        if (root == null) {
            return null;
        }
        elements.add(new AccessPathElement(element));
        return new AccessPath(root, elements);
    }

    @Nullable
    public static AccessPath getForMapInvocation(MethodInvocationNode node) {
        return AccessPath.fromMapGetCall(node);
    }

    @Nullable
    private static MapKey argumentToMapKeySpecifier(Node argument) {
        switch (argument.getTree().getKind()) {
            case STRING_LITERAL: {
                return new StringMapKey(((StringLiteralNode)argument).getValue());
            }
            case INT_LITERAL: {
                return new NumericMapKey(((IntegerLiteralNode)argument).getValue().intValue());
            }
            case LONG_LITERAL: {
                return new NumericMapKey(((LongLiteralNode)argument).getValue());
            }
            case METHOD_INVOCATION: {
                MethodAccessNode target = ((MethodInvocationNode)argument).getTarget();
                java.util.List<Node> arguments = ((MethodInvocationNode)argument).getArguments();
                if (!target.getMethod().getSimpleName().toString().equals("valueOf") || arguments.size() != 1 || !target.getReceiver().getTree().getKind().equals((Object)Tree.Kind.IDENTIFIER) || !target.getReceiver().toString().equals("Integer") && !target.getReceiver().toString().equals("Long")) break;
                return AccessPath.argumentToMapKeySpecifier(arguments.get(0));
            }
        }
        return AccessPath.getAccessPathForNodeNoMapGet(argument);
    }

    @Nullable
    private static AccessPath fromMapGetCall(MethodInvocationNode node) {
        ArrayList<AccessPathElement> elements;
        Node argument = node.getArgument(0);
        MapKey mapKey = AccessPath.argumentToMapKeySpecifier(argument);
        if (mapKey == null) {
            return null;
        }
        MethodAccessNode target = node.getTarget();
        Node receiver = target.getReceiver();
        Root root = AccessPath.populateElementsRec(receiver, elements = new ArrayList<AccessPathElement>());
        if (root == null) {
            return null;
        }
        return new AccessPath(root, elements, mapKey);
    }

    @Nullable
    public static AccessPath getAccessPathForNodeNoMapGet(Node node) {
        return AccessPath.getAccessPathForNodeWithMapGet(node, null);
    }

    @Nullable
    public static AccessPath getAccessPathForNodeWithMapGet(Node node, @Nullable Types types) {
        if (node instanceof LocalVariableNode) {
            return AccessPath.fromLocal((LocalVariableNode)node);
        }
        if (node instanceof FieldAccessNode) {
            return AccessPath.fromFieldAccess((FieldAccessNode)node);
        }
        if (node instanceof MethodInvocationNode) {
            return AccessPath.fromMethodCall((MethodInvocationNode)node, types);
        }
        return null;
    }

    private static boolean isBoxingMethod(Symbol.MethodSymbol methodSymbol) {
        return methodSymbol.isStatic() && ((Name)methodSymbol.getSimpleName()).contentEquals("valueOf") && methodSymbol.enclClass().packge().fullname.contentEquals("java.lang");
    }

    @Nullable
    private static Root populateElementsRec(Node node, java.util.List<AccessPathElement> elements) {
        Root result;
        if (node instanceof FieldAccessNode) {
            FieldAccessNode fieldAccess = (FieldAccessNode)node;
            if (fieldAccess.isStatic()) {
                result = new Root(fieldAccess.getElement());
            } else {
                result = AccessPath.populateElementsRec(fieldAccess.getReceiver(), elements);
                elements.add(new AccessPathElement(fieldAccess.getElement()));
            }
        } else if (node instanceof MethodInvocationNode) {
            AccessPathElement accessPathElement;
            MethodInvocationNode invocation = (MethodInvocationNode)node;
            MethodAccessNode accessNode = invocation.getTarget();
            if (invocation.getArguments().size() == 0) {
                accessPathElement = new AccessPathElement(accessNode.getMethod());
            } else {
                ArrayList<String> constantArgumentValues = new ArrayList<String>();
                block3: for (Node argumentNode : invocation.getArguments()) {
                    MethodInvocationTree methodInvocationTree;
                    Tree tree = argumentNode.getTree();
                    if (tree == null) {
                        return null;
                    }
                    if (tree.getKind().equals((Object)Tree.Kind.METHOD_INVOCATION) && (methodInvocationTree = (MethodInvocationTree)tree).getArguments().size() == 1 && AccessPath.isBoxingMethod(ASTHelpers.getSymbol((MethodInvocationTree)methodInvocationTree))) {
                        tree = methodInvocationTree.getArguments().get(0);
                    }
                    switch (tree.getKind()) {
                        case STRING_LITERAL: 
                        case INT_LITERAL: 
                        case LONG_LITERAL: 
                        case BOOLEAN_LITERAL: 
                        case CHAR_LITERAL: 
                        case DOUBLE_LITERAL: 
                        case FLOAT_LITERAL: {
                            constantArgumentValues.add(((LiteralTree)tree).getValue().toString());
                            continue block3;
                        }
                    }
                    return null;
                }
                accessPathElement = new AccessPathElement(accessNode.getMethod(), constantArgumentValues);
            }
            result = AccessPath.populateElementsRec(accessNode.getReceiver(), elements);
            elements.add(accessPathElement);
        } else {
            result = node instanceof LocalVariableNode ? new Root(((LocalVariableNode)node).getElement()) : (node instanceof ThisLiteralNode ? new Root() : null);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AccessPath)) {
            return false;
        }
        AccessPath that = (AccessPath)o;
        if (!this.root.equals(that.root)) {
            return false;
        }
        if (!this.elements.equals(that.elements)) {
            return false;
        }
        return this.mapGetArg != null ? that.mapGetArg != null && this.mapGetArg.equals(that.mapGetArg) : that.mapGetArg == null;
    }

    public int hashCode() {
        int result = this.root.hashCode();
        result = 31 * result + this.elements.hashCode();
        result = 31 * result + (this.mapGetArg != null ? this.mapGetArg.hashCode() : 0);
        return result;
    }

    public Root getRoot() {
        return this.root;
    }

    public ImmutableList<AccessPathElement> getElements() {
        return this.elements;
    }

    public String toString() {
        return "AccessPath{root=" + this.root + ", elements=" + this.elements + '}';
    }

    private static boolean isMapMethod(Symbol.MethodSymbol symbol, Types types, String methodName, int numParams) {
        if (!((Name)symbol.getSimpleName()).toString().equals(methodName)) {
            return false;
        }
        if (((List)symbol.getParameters()).size() != numParams) {
            return false;
        }
        Symbol owner = symbol.owner;
        if (owner.getQualifiedName().toString().equals("java.util.Map")) {
            return true;
        }
        List<Type> supertypes = types.closure(owner.type);
        for (Type t : supertypes) {
            if (!t.asElement().getQualifiedName().toString().equals("java.util.Map")) continue;
            return true;
        }
        return false;
    }

    private static boolean isMapGet(Symbol.MethodSymbol symbol, Types types) {
        return AccessPath.isMapMethod(symbol, types, "get", 1);
    }

    public static boolean isContainsKey(Symbol.MethodSymbol symbol, Types types) {
        return AccessPath.isMapMethod(symbol, types, "containsKey", 1);
    }

    public static boolean isMapPut(Symbol.MethodSymbol symbol, Types types) {
        return AccessPath.isMapMethod(symbol, types, "put", 2);
    }

    private static final class NumericMapKey
    implements MapKey {
        private long key;

        public NumericMapKey(long key) {
            this.key = key;
        }

        public int hashCode() {
            return Long.hashCode(this.key);
        }

        public boolean equals(Object obj) {
            if (obj instanceof NumericMapKey) {
                return this.key == ((NumericMapKey)obj).key;
            }
            return false;
        }
    }

    private static final class StringMapKey
    implements MapKey {
        private String key;

        public StringMapKey(String key) {
            this.key = key;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof StringMapKey) {
                return this.key.equals(((StringMapKey)obj).key);
            }
            return false;
        }
    }

    public static final class Root {
        private final boolean isMethodReceiver;
        @Nullable
        private final Element varElement;

        Root(Element varElement) {
            this.isMethodReceiver = false;
            this.varElement = (Element)Preconditions.checkNotNull((Object)varElement);
        }

        Root() {
            this.isMethodReceiver = true;
            this.varElement = null;
        }

        public Element getVarElement() {
            return (Element)Preconditions.checkNotNull((Object)this.varElement);
        }

        public boolean isReceiver() {
            return this.isMethodReceiver;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Root root = (Root)o;
            if (this.isMethodReceiver != root.isMethodReceiver) {
                return false;
            }
            return this.varElement != null ? this.varElement.equals(root.varElement) : root.varElement == null;
        }

        public int hashCode() {
            int result = this.isMethodReceiver ? 1 : 0;
            result = 31 * result + (this.varElement != null ? this.varElement.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Root{isMethodReceiver=" + this.isMethodReceiver + ", varElement=" + this.varElement + '}';
        }
    }
}

