/*
 * Decompiled with CFR 0.152.
 */
package com.uber.nullaway.dataflow;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;

public final class AccessPathElement {
    private final Element javaElement;
    @Nullable
    private final ImmutableList<String> constantArguments;

    public AccessPathElement(Element javaElement, List<String> constantArguments) {
        this.javaElement = javaElement;
        this.constantArguments = ImmutableList.copyOf(constantArguments);
    }

    public AccessPathElement(Element javaElement) {
        this.javaElement = javaElement;
        this.constantArguments = null;
    }

    public Element getJavaElement() {
        return this.javaElement;
    }

    public ImmutableList<String> getConstantArguments() {
        return this.constantArguments;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AccessPathElement) {
            AccessPathElement otherNode = (AccessPathElement)obj;
            return this.javaElement.equals(otherNode.javaElement) && (this.constantArguments == null ? otherNode.constantArguments == null : this.constantArguments.equals(otherNode.constantArguments));
        }
        return false;
    }

    public int hashCode() {
        int result = this.javaElement.hashCode();
        result = 31 * result + (this.constantArguments != null ? this.constantArguments.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "APElement{javaElement=" + this.javaElement.toString() + ", constantArguments=" + Arrays.deepToString(this.constantArguments != null ? this.constantArguments.toArray() : null) + '}';
    }
}

