/*
 * Decompiled with CFR 0.152.
 */
package com.uber.nullaway.dataflow;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.util.Context;
import com.uber.nullaway.Config;
import com.uber.nullaway.Nullness;
import com.uber.nullaway.dataflow.AccessPath;
import com.uber.nullaway.dataflow.AccessPathElement;
import com.uber.nullaway.dataflow.AccessPathNullnessPropagation;
import com.uber.nullaway.dataflow.DataFlow;
import com.uber.nullaway.dataflow.NullnessStore;
import com.uber.nullaway.handlers.Handler;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.VariableElement;
import shadow.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import shadow.checkerframework.dataflow.cfg.node.Node;

public final class AccessPathNullnessAnalysis {
    private static final Context.Key<AccessPathNullnessAnalysis> FIELD_NULLNESS_ANALYSIS_KEY = new Context.Key();
    private final AccessPathNullnessPropagation nullnessPropagation;
    private final DataFlow dataFlow;

    private AccessPathNullnessAnalysis(Predicate<MethodInvocationNode> methodReturnsNonNull, Context context, Config config, Handler handler) {
        this.nullnessPropagation = new AccessPathNullnessPropagation(Nullness.NONNULL, methodReturnsNonNull, context, config, handler);
        this.dataFlow = new DataFlow(config.assertsEnabled());
    }

    public static AccessPathNullnessAnalysis instance(Context context, Predicate<MethodInvocationNode> methodReturnsNonNull, Config config, Handler handler) {
        AccessPathNullnessAnalysis instance = context.get(FIELD_NULLNESS_ANALYSIS_KEY);
        if (instance == null) {
            instance = new AccessPathNullnessAnalysis(methodReturnsNonNull, context, config, handler);
            context.put(FIELD_NULLNESS_ANALYSIS_KEY, instance);
        }
        return instance;
    }

    @Nullable
    public Nullness getNullness(TreePath exprPath, Context context) {
        return (Nullness)this.dataFlow.expressionDataflow(exprPath, context, this.nullnessPropagation);
    }

    public Set<Element> getNonnullFieldsOfReceiverAtExit(TreePath path, Context context) {
        NullnessStore nullnessResult = (NullnessStore)this.dataFlow.finalResult(path, context, this.nullnessPropagation);
        if (nullnessResult == null) {
            return Collections.emptySet();
        }
        return this.getNonnullReceiverFields(nullnessResult);
    }

    private Set<Element> getNonnullReceiverFields(NullnessStore nullnessResult) {
        Set<AccessPath> nonnullAccessPaths = nullnessResult.getAccessPathsWithValue(Nullness.NONNULL);
        LinkedHashSet<Element> result = new LinkedHashSet<Element>();
        for (AccessPath ap : nonnullAccessPaths) {
            Element elem;
            ImmutableList<AccessPathElement> elements;
            if (!ap.getRoot().isReceiver() || (elements = ap.getElements()).size() != 1 || !(elem = ((AccessPathElement)elements.get(0)).getJavaElement()).getKind().equals((Object)ElementKind.FIELD)) continue;
            result.add(elem);
        }
        return result;
    }

    public Set<Element> getNonnullFieldsOfReceiverBefore(TreePath path, Context context) {
        NullnessStore store = (NullnessStore)this.dataFlow.resultBeforeExpr(path, context, this.nullnessPropagation);
        if (store == null) {
            return Collections.emptySet();
        }
        return this.getNonnullReceiverFields(store);
    }

    public Set<Element> getNonnullStaticFieldsBefore(TreePath path, Context context) {
        NullnessStore store = (NullnessStore)this.dataFlow.resultBeforeExpr(path, context, this.nullnessPropagation);
        if (store == null) {
            return Collections.emptySet();
        }
        return this.getNonnullStaticFields(store);
    }

    public NullnessStore getNullnessInfoBeforeNewContext(TreePath path, VisitorState state, Handler handler) {
        NullnessStore store = (NullnessStore)this.dataFlow.resultBefore(path, state.context, this.nullnessPropagation);
        if (store == null) {
            return NullnessStore.empty();
        }
        return store.filterAccessPaths(ap -> {
            AccessPath.Root root;
            if (ap.getElements().size() == 0 && !(root = ap.getRoot()).isReceiver()) {
                Element e = root.getVarElement();
                return e.getKind().equals((Object)ElementKind.PARAMETER) || e.getKind().equals((Object)ElementKind.LOCAL_VARIABLE);
            }
            return handler.includeApInfoInSavedContext((AccessPath)ap, state);
        });
    }

    public Set<Element> getNonnullStaticFieldsAtExit(TreePath path, Context context) {
        NullnessStore nullnessResult = (NullnessStore)this.dataFlow.finalResult(path, context, this.nullnessPropagation);
        if (nullnessResult == null) {
            return Collections.emptySet();
        }
        return this.getNonnullStaticFields(nullnessResult);
    }

    private Set<Element> getNonnullStaticFields(NullnessStore nullnessResult) {
        Set<AccessPath> nonnullAccessPaths = nullnessResult.getAccessPathsWithValue(Nullness.NONNULL);
        LinkedHashSet<Element> result = new LinkedHashSet<Element>();
        for (AccessPath ap : nonnullAccessPaths) {
            assert (!ap.getRoot().isReceiver());
            Element varElement = ap.getRoot().getVarElement();
            if (!varElement.getKind().equals((Object)ElementKind.FIELD)) continue;
            result.add(varElement);
        }
        return result;
    }

    public NullnessStore forceRunOnMethod(TreePath methodPath, Context context) {
        return (NullnessStore)this.dataFlow.finalResult(methodPath, context, this.nullnessPropagation);
    }

    public Nullness getNullnessOfExpressionNamedField(TreePath exprPath, Context context, VariableElement variableElement) {
        NullnessStore store = (NullnessStore)this.dataFlow.resultBeforeExpr(exprPath, context, this.nullnessPropagation);
        Set<Node> exprNodes = this.dataFlow.getControlFlowGraph(exprPath, context, this.nullnessPropagation).getNodesCorrespondingToTree(exprPath.getLeaf());
        if (exprNodes.size() != 1) {
            return Nullness.NULLABLE;
        }
        AccessPath ap = AccessPath.fromBaseAndElement(exprNodes.iterator().next(), variableElement);
        if (store != null && ap != null && store.getAccessPathsWithValue(Nullness.NONNULL).stream().anyMatch(accessPath -> accessPath.equals(ap))) {
            return Nullness.NONNULL;
        }
        return Nullness.NULLABLE;
    }

    public void invalidateCaches() {
        this.dataFlow.invalidateCaches();
    }
}

