/*
 * Decompiled with CFR 0.152.
 */
package com.uber.nullaway.dataflow;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.uber.nullaway.Config;
import com.uber.nullaway.NullabilityUtil;
import com.uber.nullaway.Nullness;
import com.uber.nullaway.dataflow.AccessPath;
import com.uber.nullaway.dataflow.EnclosingEnvironmentNullness;
import com.uber.nullaway.dataflow.NullnessStore;
import com.uber.nullaway.handlers.Handler;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.VariableElement;
import shadow.checkerframework.dataflow.analysis.ConditionalTransferResult;
import shadow.checkerframework.dataflow.analysis.RegularTransferResult;
import shadow.checkerframework.dataflow.analysis.TransferFunction;
import shadow.checkerframework.dataflow.analysis.TransferInput;
import shadow.checkerframework.dataflow.analysis.TransferResult;
import shadow.checkerframework.dataflow.cfg.UnderlyingAST;
import shadow.checkerframework.dataflow.cfg.node.ArrayAccessNode;
import shadow.checkerframework.dataflow.cfg.node.ArrayCreationNode;
import shadow.checkerframework.dataflow.cfg.node.ArrayTypeNode;
import shadow.checkerframework.dataflow.cfg.node.AssertionErrorNode;
import shadow.checkerframework.dataflow.cfg.node.AssignmentNode;
import shadow.checkerframework.dataflow.cfg.node.BitwiseAndNode;
import shadow.checkerframework.dataflow.cfg.node.BitwiseComplementNode;
import shadow.checkerframework.dataflow.cfg.node.BitwiseOrNode;
import shadow.checkerframework.dataflow.cfg.node.BitwiseXorNode;
import shadow.checkerframework.dataflow.cfg.node.BooleanLiteralNode;
import shadow.checkerframework.dataflow.cfg.node.CaseNode;
import shadow.checkerframework.dataflow.cfg.node.CharacterLiteralNode;
import shadow.checkerframework.dataflow.cfg.node.ClassDeclarationNode;
import shadow.checkerframework.dataflow.cfg.node.ClassNameNode;
import shadow.checkerframework.dataflow.cfg.node.ConditionalAndNode;
import shadow.checkerframework.dataflow.cfg.node.ConditionalNotNode;
import shadow.checkerframework.dataflow.cfg.node.ConditionalOrNode;
import shadow.checkerframework.dataflow.cfg.node.DoubleLiteralNode;
import shadow.checkerframework.dataflow.cfg.node.EqualToNode;
import shadow.checkerframework.dataflow.cfg.node.ExplicitThisLiteralNode;
import shadow.checkerframework.dataflow.cfg.node.FieldAccessNode;
import shadow.checkerframework.dataflow.cfg.node.FloatLiteralNode;
import shadow.checkerframework.dataflow.cfg.node.FloatingDivisionNode;
import shadow.checkerframework.dataflow.cfg.node.FloatingRemainderNode;
import shadow.checkerframework.dataflow.cfg.node.FunctionalInterfaceNode;
import shadow.checkerframework.dataflow.cfg.node.GreaterThanNode;
import shadow.checkerframework.dataflow.cfg.node.GreaterThanOrEqualNode;
import shadow.checkerframework.dataflow.cfg.node.ImplicitThisLiteralNode;
import shadow.checkerframework.dataflow.cfg.node.InstanceOfNode;
import shadow.checkerframework.dataflow.cfg.node.IntegerDivisionNode;
import shadow.checkerframework.dataflow.cfg.node.IntegerLiteralNode;
import shadow.checkerframework.dataflow.cfg.node.IntegerRemainderNode;
import shadow.checkerframework.dataflow.cfg.node.LambdaResultExpressionNode;
import shadow.checkerframework.dataflow.cfg.node.LeftShiftNode;
import shadow.checkerframework.dataflow.cfg.node.LessThanNode;
import shadow.checkerframework.dataflow.cfg.node.LessThanOrEqualNode;
import shadow.checkerframework.dataflow.cfg.node.LocalVariableNode;
import shadow.checkerframework.dataflow.cfg.node.LongLiteralNode;
import shadow.checkerframework.dataflow.cfg.node.MarkerNode;
import shadow.checkerframework.dataflow.cfg.node.MethodAccessNode;
import shadow.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import shadow.checkerframework.dataflow.cfg.node.NarrowingConversionNode;
import shadow.checkerframework.dataflow.cfg.node.Node;
import shadow.checkerframework.dataflow.cfg.node.NotEqualNode;
import shadow.checkerframework.dataflow.cfg.node.NullChkNode;
import shadow.checkerframework.dataflow.cfg.node.NullLiteralNode;
import shadow.checkerframework.dataflow.cfg.node.NumericalAdditionNode;
import shadow.checkerframework.dataflow.cfg.node.NumericalMinusNode;
import shadow.checkerframework.dataflow.cfg.node.NumericalMultiplicationNode;
import shadow.checkerframework.dataflow.cfg.node.NumericalPlusNode;
import shadow.checkerframework.dataflow.cfg.node.NumericalSubtractionNode;
import shadow.checkerframework.dataflow.cfg.node.ObjectCreationNode;
import shadow.checkerframework.dataflow.cfg.node.PackageNameNode;
import shadow.checkerframework.dataflow.cfg.node.ParameterizedTypeNode;
import shadow.checkerframework.dataflow.cfg.node.PrimitiveTypeNode;
import shadow.checkerframework.dataflow.cfg.node.ReturnNode;
import shadow.checkerframework.dataflow.cfg.node.ShortLiteralNode;
import shadow.checkerframework.dataflow.cfg.node.SignedRightShiftNode;
import shadow.checkerframework.dataflow.cfg.node.StringConcatenateAssignmentNode;
import shadow.checkerframework.dataflow.cfg.node.StringConcatenateNode;
import shadow.checkerframework.dataflow.cfg.node.StringConversionNode;
import shadow.checkerframework.dataflow.cfg.node.StringLiteralNode;
import shadow.checkerframework.dataflow.cfg.node.SuperNode;
import shadow.checkerframework.dataflow.cfg.node.SynchronizedNode;
import shadow.checkerframework.dataflow.cfg.node.TernaryExpressionNode;
import shadow.checkerframework.dataflow.cfg.node.ThisLiteralNode;
import shadow.checkerframework.dataflow.cfg.node.ThrowNode;
import shadow.checkerframework.dataflow.cfg.node.TypeCastNode;
import shadow.checkerframework.dataflow.cfg.node.UnsignedRightShiftNode;
import shadow.checkerframework.dataflow.cfg.node.VariableDeclarationNode;
import shadow.checkerframework.dataflow.cfg.node.WideningConversionNode;
import shadow.checkerframework.javacutil.TreeUtils;

public class AccessPathNullnessPropagation
implements TransferFunction<Nullness, NullnessStore> {
    private static final boolean NO_STORE_CHANGE = false;
    private final Nullness defaultAssumption;
    private final Predicate<MethodInvocationNode> methodReturnsNonNull;
    private final Context context;
    private final Types types;
    private final Config config;
    private final Handler handler;

    AccessPathNullnessPropagation(Nullness defaultAssumption, Predicate<MethodInvocationNode> methodReturnsNonNull, Context context, Config config, Handler handler) {
        this.defaultAssumption = defaultAssumption;
        this.methodReturnsNonNull = methodReturnsNonNull;
        this.context = context;
        this.types = Types.instance(context);
        this.config = config;
        this.handler = handler;
    }

    private static SubNodeValues values(TransferInput<Nullness, NullnessStore> input) {
        return input::getValueOfSubNode;
    }

    private static Node unwrapAssignExpr(Node node) {
        if (node instanceof AssignmentNode) {
            return ((AssignmentNode)node).getTarget();
        }
        return node;
    }

    @Override
    public NullnessStore initialStore(UnderlyingAST underlyingAST, java.util.List<LocalVariableNode> parameters) {
        if (parameters == null) {
            UnderlyingAST.CFGStatement ast = (UnderlyingAST.CFGStatement)underlyingAST;
            return this.getEnvNullnessStoreForClass(ast.getClassTree());
        }
        boolean isLambda = underlyingAST.getKind().equals((Object)UnderlyingAST.Kind.LAMBDA);
        if (isLambda) {
            return this.lambdaInitialStore((UnderlyingAST.CFGLambda)underlyingAST, parameters);
        }
        return this.methodInitialStore((UnderlyingAST.CFGMethod)underlyingAST, parameters);
    }

    private NullnessStore lambdaInitialStore(UnderlyingAST.CFGLambda underlyingAST, java.util.List<LocalVariableNode> parameters) {
        EnclosingEnvironmentNullness environmentNullness = EnclosingEnvironmentNullness.instance(this.context);
        NullnessStore environmentMapping = Objects.requireNonNull(environmentNullness.getEnvironmentMapping(underlyingAST.getLambdaTree()), "no environment stored for lambda");
        NullnessStore.Builder result = environmentMapping.toBuilder();
        LambdaExpressionTree code = underlyingAST.getLambdaTree();
        Symbol.MethodSymbol fiMethodSymbol = NullabilityUtil.getFunctionalInterfaceMethod(code, this.types);
        java.util.List fiMethodParameters = fiMethodSymbol.getParameters();
        ImmutableSet<Integer> nullableParamsFromHandler = this.handler.onUnannotatedInvocationGetExplicitlyNullablePositions(this.context, fiMethodSymbol, (ImmutableSet<Integer>)ImmutableSet.of());
        for (int i = 0; i < parameters.size(); ++i) {
            LocalVariableNode param = parameters.get(i);
            VariableTree variableTree = code.getParameters().get(i);
            Element element = param.getElement();
            Nullness assumed = Nullness.hasNullableAnnotation((Symbol)element, this.config) ? Nullness.NULLABLE : (!NullabilityUtil.lambdaParamIsImplicitlyTyped(variableTree) ? Nullness.NONNULL : (NullabilityUtil.isUnannotated(fiMethodSymbol, this.config) ? (nullableParamsFromHandler.contains((Object)i) ? Nullness.NULLABLE : Nullness.NONNULL) : (Nullness.hasNullableAnnotation((Symbol)((List)fiMethodParameters).get(i), this.config) ? Nullness.NULLABLE : Nullness.NONNULL)));
            result.setInformation(AccessPath.fromLocal(param), assumed);
        }
        result = this.handler.onDataflowInitialStore(underlyingAST, parameters, result);
        return result.build();
    }

    private NullnessStore methodInitialStore(UnderlyingAST.CFGMethod underlyingAST, java.util.List<LocalVariableNode> parameters) {
        ClassTree classTree = underlyingAST.getClassTree();
        NullnessStore envStore = this.getEnvNullnessStoreForClass(classTree);
        NullnessStore.Builder result = envStore.toBuilder();
        for (LocalVariableNode param : parameters) {
            Element element = param.getElement();
            Nullness assumed = Nullness.hasNullableAnnotation((Symbol)element, this.config) ? Nullness.NULLABLE : Nullness.NONNULL;
            result.setInformation(AccessPath.fromLocal(param), assumed);
        }
        result = this.handler.onDataflowInitialStore(underlyingAST, parameters, result);
        return result.build();
    }

    private NullnessStore getEnvNullnessStoreForClass(ClassTree classTree) {
        NullnessStore envStore = NullnessStore.empty();
        ClassTree enclosingLocalOrAnonymous = this.findEnclosingLocalOrAnonymousClass(classTree);
        if (enclosingLocalOrAnonymous != null) {
            EnclosingEnvironmentNullness environmentNullness = EnclosingEnvironmentNullness.instance(this.context);
            envStore = Objects.requireNonNull(environmentNullness.getEnvironmentMapping(enclosingLocalOrAnonymous));
        }
        return envStore;
    }

    @Nullable
    private ClassTree findEnclosingLocalOrAnonymousClass(ClassTree classTree) {
        Symbol.ClassSymbol symbol = ASTHelpers.getSymbol((ClassTree)classTree);
        while (symbol.getNestingKind().isNested()) {
            if (symbol.getNestingKind().equals((Object)NestingKind.ANONYMOUS) || symbol.getNestingKind().equals((Object)NestingKind.LOCAL)) {
                return Trees.instance(JavacProcessingEnvironment.instance(this.context)).getTree(symbol);
            }
            symbol = symbol.owner.enclClass();
        }
        return null;
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitShortLiteral(ShortLiteralNode shortLiteralNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitIntegerLiteral(IntegerLiteralNode integerLiteralNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitLongLiteral(LongLiteralNode longLiteralNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitFloatLiteral(FloatLiteralNode floatLiteralNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitDoubleLiteral(DoubleLiteralNode doubleLiteralNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitBooleanLiteral(BooleanLiteralNode booleanLiteralNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitCharacterLiteral(CharacterLiteralNode characterLiteralNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitStringLiteral(StringLiteralNode stringLiteralNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitNullLiteral(NullLiteralNode nullLiteralNode, TransferInput<Nullness, NullnessStore> input) {
        return new RegularTransferResult<Nullness, NullnessStore>(Nullness.NULL, input.getRegularStore());
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitNumericalMinus(NumericalMinusNode numericalMinusNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitNumericalPlus(NumericalPlusNode numericalPlusNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitBitwiseComplement(BitwiseComplementNode bitwiseComplementNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitNullChk(NullChkNode nullChkNode, TransferInput<Nullness, NullnessStore> input) {
        SubNodeValues values = AccessPathNullnessPropagation.values(input);
        Nullness nullness = AccessPathNullnessPropagation.hasPrimitiveType(nullChkNode) ? Nullness.NONNULL : values.valueOfSubNode(nullChkNode.getOperand());
        return this.noStoreChanges(nullness, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitStringConcatenate(StringConcatenateNode stringConcatenateNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitNumericalAddition(NumericalAdditionNode numericalAdditionNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitNumericalSubtraction(NumericalSubtractionNode numericalSubtractionNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitNumericalMultiplication(NumericalMultiplicationNode numericalMultiplicationNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitIntegerDivision(IntegerDivisionNode integerDivisionNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitFloatingDivision(FloatingDivisionNode floatingDivisionNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitIntegerRemainder(IntegerRemainderNode integerRemainderNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitFloatingRemainder(FloatingRemainderNode floatingRemainderNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitLeftShift(LeftShiftNode leftShiftNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitSignedRightShift(SignedRightShiftNode signedRightShiftNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitUnsignedRightShift(UnsignedRightShiftNode unsignedRightShiftNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitBitwiseAnd(BitwiseAndNode bitwiseAndNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitBitwiseOr(BitwiseOrNode bitwiseOrNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitBitwiseXor(BitwiseXorNode bitwiseXorNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitStringConcatenateAssignment(StringConcatenateAssignmentNode stringConcatenateAssignmentNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NULLABLE, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitLessThan(LessThanNode lessThanNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitLessThanOrEqual(LessThanOrEqualNode lessThanOrEqualNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitGreaterThan(GreaterThanNode greaterThanNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitGreaterThanOrEqual(GreaterThanOrEqualNode greaterThanOrEqualNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitEqualTo(EqualToNode equalToNode, TransferInput<Nullness, NullnessStore> input) {
        ReadableUpdates thenUpdates = new ReadableUpdates();
        ReadableUpdates elseUpdates = new ReadableUpdates();
        this.handleEqualityComparison(true, equalToNode.getLeftOperand(), equalToNode.getRightOperand(), AccessPathNullnessPropagation.values(input), thenUpdates, elseUpdates);
        ResultingStore thenStore = AccessPathNullnessPropagation.updateStore(input.getThenStore(), thenUpdates);
        ResultingStore elseStore = AccessPathNullnessPropagation.updateStore(input.getElseStore(), elseUpdates);
        return AccessPathNullnessPropagation.conditionalResult(thenStore.store, elseStore.store, thenStore.storeChanged || elseStore.storeChanged);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitNotEqual(NotEqualNode notEqualNode, TransferInput<Nullness, NullnessStore> input) {
        ReadableUpdates thenUpdates = new ReadableUpdates();
        ReadableUpdates elseUpdates = new ReadableUpdates();
        this.handleEqualityComparison(false, notEqualNode.getLeftOperand(), notEqualNode.getRightOperand(), AccessPathNullnessPropagation.values(input), thenUpdates, elseUpdates);
        ResultingStore thenStore = AccessPathNullnessPropagation.updateStore(input.getThenStore(), thenUpdates);
        ResultingStore elseStore = AccessPathNullnessPropagation.updateStore(input.getElseStore(), elseUpdates);
        return AccessPathNullnessPropagation.conditionalResult(thenStore.store, elseStore.store, thenStore.storeChanged || elseStore.storeChanged);
    }

    private void handleEqualityComparison(boolean equalTo, Node leftNode, Node rightNode, SubNodeValues inputs, Updates thenUpdates, Updates elseUpdates) {
        AccessPath rightAP;
        Nullness leftVal = inputs.valueOfSubNode(leftNode);
        Nullness rightVal = inputs.valueOfSubNode(rightNode);
        Nullness equalBranchValue = leftVal.greatestLowerBound(rightVal);
        Updates equalBranchUpdates = equalTo ? thenUpdates : elseUpdates;
        Updates notEqualBranchUpdates = equalTo ? elseUpdates : thenUpdates;
        Node realLeftNode = AccessPathNullnessPropagation.unwrapAssignExpr(leftNode);
        Node realRightNode = AccessPathNullnessPropagation.unwrapAssignExpr(rightNode);
        AccessPath leftAP = AccessPath.getAccessPathForNodeWithMapGet(realLeftNode, this.types);
        if (leftAP != null) {
            equalBranchUpdates.set(leftAP, equalBranchValue);
            notEqualBranchUpdates.set(leftAP, leftVal.greatestLowerBound(rightVal.deducedValueWhenNotEqual()));
        }
        if ((rightAP = AccessPath.getAccessPathForNodeWithMapGet(realRightNode, this.types)) != null) {
            equalBranchUpdates.set(rightAP, equalBranchValue);
            notEqualBranchUpdates.set(rightAP, rightVal.greatestLowerBound(leftVal.deducedValueWhenNotEqual()));
        }
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitConditionalAnd(ConditionalAndNode conditionalAndNode, TransferInput<Nullness, NullnessStore> input) {
        return AccessPathNullnessPropagation.conditionalResult(input.getThenStore(), input.getElseStore(), false);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitConditionalOr(ConditionalOrNode conditionalOrNode, TransferInput<Nullness, NullnessStore> input) {
        return AccessPathNullnessPropagation.conditionalResult(input.getThenStore(), input.getElseStore(), false);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitConditionalNot(ConditionalNotNode conditionalNotNode, TransferInput<Nullness, NullnessStore> input) {
        boolean storeChanged = !input.getThenStore().equals(input.getElseStore());
        return AccessPathNullnessPropagation.conditionalResult(input.getElseStore(), input.getThenStore(), storeChanged);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitTernaryExpression(TernaryExpressionNode node, TransferInput<Nullness, NullnessStore> input) {
        SubNodeValues inputs = AccessPathNullnessPropagation.values(input);
        Nullness result = inputs.valueOfSubNode(node.getThenOperand()).leastUpperBound(inputs.valueOfSubNode(node.getElseOperand()));
        return new RegularTransferResult<Nullness, NullnessStore>(result, input.getRegularStore());
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitAssignment(AssignmentNode node, TransferInput<Nullness, NullnessStore> input) {
        FieldAccessNode fieldAccessNode;
        Node receiver;
        ReadableUpdates updates = new ReadableUpdates();
        Nullness value = AccessPathNullnessPropagation.values(input).valueOfSubNode(node.getExpression());
        Node target = node.getTarget();
        if (target instanceof LocalVariableNode) {
            updates.set((LocalVariableNode)target, value);
        }
        if (target instanceof ArrayAccessNode) {
            this.setNonnullIfAnalyzeable(updates, ((ArrayAccessNode)target).getArray());
        }
        if (target instanceof FieldAccessNode && ((receiver = (fieldAccessNode = (FieldAccessNode)target).getReceiver()) instanceof ThisLiteralNode || fieldAccessNode.isStatic()) && fieldAccessNode.getElement().getKind().equals((Object)ElementKind.FIELD)) {
            updates.set(fieldAccessNode, value);
        }
        return this.updateRegularStore(value, input, updates);
    }

    private TransferResult<Nullness, NullnessStore> updateRegularStore(Nullness value, TransferInput<Nullness, NullnessStore> input, ReadableUpdates updates) {
        ResultingStore newStore = AccessPathNullnessPropagation.updateStore(input.getRegularStore(), updates);
        return new RegularTransferResult<Nullness, NullnessStore>(value, newStore.store, newStore.storeChanged);
    }

    private void setNonnullIfAnalyzeable(Updates updates, Node node) {
        AccessPath ap = AccessPath.getAccessPathForNodeWithMapGet(node, this.types);
        if (ap != null) {
            updates.set(ap, Nullness.NONNULL);
        }
    }

    private static boolean hasPrimitiveType(Node node) {
        return node.getType().getKind().isPrimitive();
    }

    private static boolean hasNonNullConstantValue(LocalVariableNode node) {
        if (node.getElement() instanceof VariableElement) {
            VariableElement element = (VariableElement)node.getElement();
            return element.getConstantValue() != null;
        }
        return false;
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitLocalVariable(LocalVariableNode node, TransferInput<Nullness, NullnessStore> input) {
        NullnessStore values = input.getRegularStore();
        Nullness nullness = AccessPathNullnessPropagation.hasPrimitiveType(node) || AccessPathNullnessPropagation.hasNonNullConstantValue(node) ? Nullness.NONNULL : values.valueOfLocalVariable(node, this.defaultAssumption);
        return new RegularTransferResult<Nullness, NullnessStore>(nullness, values);
    }

    private static boolean isCatchVariable(VariableDeclarationNode node) {
        return TreeUtils.elementFromDeclaration(node.getTree()).getKind() == ElementKind.EXCEPTION_PARAMETER;
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitVariableDeclaration(VariableDeclarationNode node, TransferInput<Nullness, NullnessStore> input) {
        ReadableUpdates updates = new ReadableUpdates();
        if (AccessPathNullnessPropagation.isCatchVariable(node)) {
            updates.set(node, Nullness.NONNULL);
        }
        return this.updateRegularStore(Nullness.BOTTOM, input, updates);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitFieldAccess(FieldAccessNode fieldAccessNode, TransferInput<Nullness, NullnessStore> input) {
        ReadableUpdates updates = new ReadableUpdates();
        Symbol symbol = ASTHelpers.getSymbol((Tree)fieldAccessNode.getTree());
        this.setReceiverNonnull(updates, fieldAccessNode.getReceiver(), symbol);
        Nullness nullness = Nullness.NULLABLE;
        nullness = !NullabilityUtil.mayBeNullFieldFromType(symbol, this.config) ? Nullness.NONNULL : input.getRegularStore().valueOfField(fieldAccessNode, nullness);
        return this.updateRegularStore(nullness, input, updates);
    }

    private void setReceiverNonnull(ReadableUpdates updates, Node receiver, Symbol symbol) {
        if (symbol != null && !symbol.isStatic()) {
            this.setNonnullIfAnalyzeable(updates, receiver);
        }
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitMethodAccess(MethodAccessNode methodAccessNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NULLABLE, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitArrayAccess(ArrayAccessNode node, TransferInput<Nullness, NullnessStore> input) {
        ReadableUpdates updates = new ReadableUpdates();
        this.setNonnullIfAnalyzeable(updates, node.getArray());
        return this.updateRegularStore(this.defaultAssumption, input, updates);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitImplicitThisLiteral(ImplicitThisLiteralNode implicitThisLiteralNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitExplicitThisLiteral(ExplicitThisLiteralNode explicitThisLiteralNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    private TransferResult<Nullness, NullnessStore> noStoreChanges(Nullness value, TransferInput<Nullness, NullnessStore> input) {
        return new RegularTransferResult<Nullness, NullnessStore>(value, input.getRegularStore());
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitSuper(SuperNode superNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitReturn(ReturnNode returnNode, TransferInput<Nullness, NullnessStore> input) {
        this.handler.onDataflowVisitReturn(returnNode.getTree(), input.getThenStore(), input.getElseStore());
        return this.noStoreChanges(Nullness.NULLABLE, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitLambdaResultExpression(LambdaResultExpressionNode resultNode, TransferInput<Nullness, NullnessStore> input) {
        this.handler.onDataflowVisitLambdaResultExpression(resultNode.getTree(), input.getThenStore(), input.getElseStore());
        SubNodeValues values = AccessPathNullnessPropagation.values(input);
        Nullness nullness = values.valueOfSubNode(resultNode.getResult());
        return this.noStoreChanges(nullness, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitStringConversion(StringConversionNode stringConversionNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitNarrowingConversion(NarrowingConversionNode narrowingConversionNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitWideningConversion(WideningConversionNode wideningConversionNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitInstanceOf(InstanceOfNode node, TransferInput<Nullness, NullnessStore> input) {
        ReadableUpdates thenUpdates = new ReadableUpdates();
        ReadableUpdates elseUpdates = new ReadableUpdates();
        this.setNonnullIfAnalyzeable(thenUpdates, node.getOperand());
        ResultingStore thenStore = AccessPathNullnessPropagation.updateStore(input.getThenStore(), thenUpdates);
        ResultingStore elseStore = AccessPathNullnessPropagation.updateStore(input.getElseStore(), elseUpdates);
        return new ConditionalTransferResult<Nullness, NullnessStore>(Nullness.NONNULL, thenStore.store, elseStore.store, thenStore.storeChanged || elseStore.storeChanged);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitTypeCast(TypeCastNode node, TransferInput<Nullness, NullnessStore> input) {
        SubNodeValues values = AccessPathNullnessPropagation.values(input);
        Nullness nullness = AccessPathNullnessPropagation.hasPrimitiveType(node) ? Nullness.NONNULL : values.valueOfSubNode(node.getOperand());
        return this.noStoreChanges(nullness, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitSynchronized(SynchronizedNode synchronizedNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NULLABLE, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitAssertionError(AssertionErrorNode assertionErrorNode, TransferInput<Nullness, NullnessStore> input) {
        Node condition = assertionErrorNode.getCondition();
        if (condition == null || !(condition instanceof NotEqualNode) || !(((NotEqualNode)condition).getRightOperand() instanceof NullLiteralNode)) {
            return this.noStoreChanges(Nullness.NULLABLE, input);
        }
        AccessPath accessPath = AccessPath.getAccessPathForNodeNoMapGet(((NotEqualNode)condition).getLeftOperand());
        if (accessPath == null) {
            return this.noStoreChanges(Nullness.NULLABLE, input);
        }
        ReadableUpdates updates = new ReadableUpdates();
        updates.set(accessPath, Nullness.NONNULL);
        return this.updateRegularStore(Nullness.NULLABLE, input, updates);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitThrow(ThrowNode throwNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NULLABLE, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitCase(CaseNode caseNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NULLABLE, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitMethodInvocation(MethodInvocationNode node, TransferInput<Nullness, NullnessStore> input) {
        ReadableUpdates thenUpdates = new ReadableUpdates();
        ReadableUpdates elseUpdates = new ReadableUpdates();
        ReadableUpdates bothUpdates = new ReadableUpdates();
        Symbol.MethodSymbol callee = ASTHelpers.getSymbol((MethodInvocationTree)node.getTree());
        Preconditions.checkNotNull((Object)callee);
        this.setReceiverNonnull(bothUpdates, node.getTarget().getReceiver(), callee);
        this.setNullnessForMapCalls(node, callee, node.getArguments(), this.types, AccessPathNullnessPropagation.values(input), thenUpdates, bothUpdates);
        Handler.NullnessHint nullnessHint = this.handler.onDataflowVisitMethodInvocation(node, this.types, this.context, AccessPathNullnessPropagation.values(input), thenUpdates, elseUpdates, bothUpdates);
        Nullness nullness = this.returnValueNullness(node, input, nullnessHint);
        if (this.booleanReturnType(node)) {
            ResultingStore thenStore = AccessPathNullnessPropagation.updateStore(input.getThenStore(), thenUpdates, bothUpdates);
            ResultingStore elseStore = AccessPathNullnessPropagation.updateStore(input.getElseStore(), elseUpdates, bothUpdates);
            return AccessPathNullnessPropagation.conditionalResult(thenStore.store, elseStore.store, thenStore.storeChanged || elseStore.storeChanged);
        }
        return this.updateRegularStore(nullness, input, bothUpdates);
    }

    private void setNullnessForMapCalls(MethodInvocationNode node, Symbol.MethodSymbol callee, java.util.List<Node> arguments, Types types, SubNodeValues inputs, Updates thenUpdates, Updates bothUpdates) {
        AccessPath getAccessPath;
        if (AccessPath.isContainsKey(callee, types)) {
            AccessPath getAccessPath2 = AccessPath.getForMapInvocation(node);
            if (getAccessPath2 != null) {
                thenUpdates.set(getAccessPath2, Nullness.NONNULL);
            }
        } else if (AccessPath.isMapPut(callee, types) && (getAccessPath = AccessPath.getForMapInvocation(node)) != null) {
            Nullness value = inputs.valueOfSubNode(arguments.get(1));
            bothUpdates.set(getAccessPath, value);
        }
    }

    private boolean booleanReturnType(MethodInvocationNode node) {
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodInvocationTree)node.getTree());
        return methodSymbol != null && methodSymbol.getReturnType().getTag() == TypeTag.BOOLEAN;
    }

    Nullness returnValueNullness(MethodInvocationNode node, TransferInput<Nullness, NullnessStore> input, Handler.NullnessHint returnValueNullnessHint) {
        Nullness nullness = node != null && returnValueNullnessHint == Handler.NullnessHint.FORCE_NONNULL ? Nullness.NONNULL : (node != null && returnValueNullnessHint == Handler.NullnessHint.HINT_NULLABLE ? input.getRegularStore().valueOfMethodCall(node, this.types, Nullness.NULLABLE) : (node == null || this.methodReturnsNonNull.test(node) || !Nullness.hasNullableAnnotation((Symbol)((Object)node.getTarget().getMethod()), this.config) ? Nullness.NONNULL : input.getRegularStore().valueOfMethodCall(node, this.types, Nullness.NULLABLE)));
        return nullness;
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitObjectCreation(ObjectCreationNode objectCreationNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitMemberReference(FunctionalInterfaceNode functionalInterfaceNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitArrayCreation(ArrayCreationNode arrayCreationNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NONNULL, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitArrayType(ArrayTypeNode arrayTypeNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NULLABLE, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitPrimitiveType(PrimitiveTypeNode primitiveTypeNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NULLABLE, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitClassName(ClassNameNode classNameNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NULLABLE, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitClassDeclaration(ClassDeclarationNode classDeclarationNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NULLABLE, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitPackageName(PackageNameNode packageNameNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NULLABLE, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitParameterizedType(ParameterizedTypeNode parameterizedTypeNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NULLABLE, input);
    }

    @Override
    public TransferResult<Nullness, NullnessStore> visitMarker(MarkerNode markerNode, TransferInput<Nullness, NullnessStore> input) {
        return this.noStoreChanges(Nullness.NULLABLE, input);
    }

    @CheckReturnValue
    private static ResultingStore updateStore(NullnessStore oldStore, ReadableUpdates ... updates) {
        NullnessStore newStore;
        NullnessStore.Builder builder = oldStore.toBuilder();
        for (ReadableUpdates update : updates) {
            for (Map.Entry<AccessPath, Nullness> entry : update.values.entrySet()) {
                AccessPath key = entry.getKey();
                builder.setInformation(key, entry.getValue());
            }
        }
        return new ResultingStore(newStore, !(newStore = builder.build()).equals(oldStore));
    }

    private static TransferResult<Nullness, NullnessStore> conditionalResult(NullnessStore thenStore, NullnessStore elseStore, boolean storeChanged) {
        return new ConditionalTransferResult<Nullness, NullnessStore>(Nullness.NONNULL, thenStore, elseStore, storeChanged);
    }

    private final class ReadableUpdates
    implements Updates {
        final Map<AccessPath, Nullness> values = new HashMap<AccessPath, Nullness>();

        private ReadableUpdates() {
        }

        @Override
        public void set(LocalVariableNode node, Nullness value) {
            this.values.put(AccessPath.fromLocal(node), (Nullness)Preconditions.checkNotNull((Object)value));
        }

        @Override
        public void set(VariableDeclarationNode node, Nullness value) {
            this.values.put(AccessPath.fromVarDecl(node), (Nullness)Preconditions.checkNotNull((Object)value));
        }

        @Override
        public void set(FieldAccessNode node, Nullness value) {
            AccessPath accessPath = AccessPath.fromFieldAccess(node);
            this.values.put((AccessPath)Preconditions.checkNotNull((Object)accessPath), (Nullness)Preconditions.checkNotNull((Object)value));
        }

        @Override
        public void set(MethodInvocationNode node, Nullness value) {
            AccessPath path = AccessPath.fromMethodCall(node, AccessPathNullnessPropagation.this.types);
            this.values.put((AccessPath)Preconditions.checkNotNull((Object)path), value);
        }

        @Override
        public void set(AccessPath ap, Nullness value) {
            this.values.put((AccessPath)Preconditions.checkNotNull((Object)ap), value);
        }
    }

    public static interface Updates {
        public void set(LocalVariableNode var1, Nullness var2);

        public void set(VariableDeclarationNode var1, Nullness var2);

        public void set(FieldAccessNode var1, Nullness var2);

        public void set(MethodInvocationNode var1, Nullness var2);

        public void set(AccessPath var1, Nullness var2);
    }

    private static final class ResultingStore {
        final NullnessStore store;
        final boolean storeChanged;

        ResultingStore(NullnessStore store, boolean storeChanged) {
            this.store = store;
            this.storeChanged = storeChanged;
        }
    }

    public static interface SubNodeValues {
        public Nullness valueOfSubNode(Node var1);
    }
}

