/*
 * Decompiled with CFR 0.152.
 */
package com.uber.nullaway.dataflow;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import com.uber.nullaway.NullabilityUtil;
import com.uber.nullaway.dataflow.AutoValue_DataFlow_AnalysisParams;
import com.uber.nullaway.dataflow.AutoValue_DataFlow_CfgParams;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import shadow.checkerframework.dataflow.analysis.AbstractValue;
import shadow.checkerframework.dataflow.analysis.Analysis;
import shadow.checkerframework.dataflow.analysis.AnalysisResult;
import shadow.checkerframework.dataflow.analysis.Store;
import shadow.checkerframework.dataflow.analysis.TransferFunction;
import shadow.checkerframework.dataflow.cfg.CFGBuilder;
import shadow.checkerframework.dataflow.cfg.ControlFlowGraph;
import shadow.checkerframework.dataflow.cfg.UnderlyingAST;

public final class DataFlow {
    private static final int MAX_CACHE_SIZE = 50;
    private final boolean assertsEnabled;
    private final LoadingCache<AnalysisParams, Analysis<?, ?, ?>> analysisCache = CacheBuilder.newBuilder().maximumSize(50L).build(new CacheLoader<AnalysisParams, Analysis<?, ?, ?>>(){

        public Analysis<?, ?, ?> load(AnalysisParams key) {
            ProcessingEnvironment env = key.environment();
            ControlFlowGraph cfg = key.cfg();
            TransferFunction<?, ?> transfer = key.transferFunction();
            Analysis analysis = new Analysis(transfer, env);
            analysis.performAnalysis(cfg);
            return analysis;
        }
    });
    private final LoadingCache<CfgParams, ControlFlowGraph> cfgCache = CacheBuilder.newBuilder().maximumSize(50L).build((CacheLoader)new CacheLoader<CfgParams, ControlFlowGraph>(){

        public ControlFlowGraph load(CfgParams key) {
            TreePath bodyPath;
            UnderlyingAST ast;
            TreePath codePath = key.codePath();
            ProcessingEnvironment env = key.environment();
            if (codePath.getLeaf() instanceof LambdaExpressionTree) {
                LambdaExpressionTree lambdaExpressionTree = (LambdaExpressionTree)codePath.getLeaf();
                ast = new UnderlyingAST.CFGLambda(lambdaExpressionTree);
                bodyPath = new TreePath(codePath, lambdaExpressionTree.getBody());
            } else if (codePath.getLeaf() instanceof MethodTree) {
                MethodTree method = (MethodTree)codePath.getLeaf();
                ClassTree enclClass = (ClassTree)ASTHelpers.findEnclosingNode((TreePath)codePath, ClassTree.class);
                ast = new UnderlyingAST.CFGMethod(method, enclClass);
                BlockTree body = method.getBody();
                if (body == null) {
                    throw new IllegalStateException("trying to compute CFG for method " + method + ", which has no body");
                }
                bodyPath = new TreePath(codePath, body);
            } else {
                ast = new UnderlyingAST.CFGStatement(codePath.getLeaf(), (ClassTree)codePath.getParentPath().getLeaf());
                bodyPath = codePath;
            }
            return CFGBuilder.build(bodyPath, ast, DataFlow.this.assertsEnabled, !DataFlow.this.assertsEnabled, env);
        }
    });

    DataFlow(boolean assertsEnabled) {
        this.assertsEnabled = assertsEnabled;
    }

    private <A extends AbstractValue<A>, S extends Store<S>, T extends TransferFunction<A, S>> Result<A, S, T> dataflow(TreePath path, Context context, T transfer) {
        JavacProcessingEnvironment env = JavacProcessingEnvironment.instance(context);
        final ControlFlowGraph cfg = (ControlFlowGraph)this.cfgCache.getUnchecked((Object)CfgParams.create(path, env));
        AnalysisParams aparams = AnalysisParams.create(transfer, cfg, env);
        final Analysis analysis = (Analysis)this.analysisCache.getUnchecked((Object)aparams);
        return new Result<A, S, T>(){

            @Override
            public Analysis<A, S, T> getAnalysis() {
                return analysis;
            }

            @Override
            public ControlFlowGraph getControlFlowGraph() {
                return cfg;
            }
        };
    }

    <A extends AbstractValue<A>, S extends Store<S>, T extends TransferFunction<A, S>> ControlFlowGraph getControlFlowGraph(TreePath path, Context context, T transfer) {
        return this.dataflow(NullabilityUtil.findEnclosingMethodOrLambdaOrInitializer(path), context, transfer).getControlFlowGraph();
    }

    @Nullable
    public <A extends AbstractValue<A>, S extends Store<S>, T extends TransferFunction<A, S>> A expressionDataflow(TreePath exprPath, Context context, T transfer) {
        AnalysisResult<A, S> analysisResult = this.resultForExpr(exprPath, context, transfer);
        return analysisResult == null ? null : (A)analysisResult.getValue(exprPath.getLeaf());
    }

    public <A extends AbstractValue<A>, S extends Store<S>, T extends TransferFunction<A, S>> S finalResult(TreePath path, Context context, T transfer) {
        Tree leaf = path.getLeaf();
        Preconditions.checkArgument((leaf instanceof MethodTree || leaf instanceof LambdaExpressionTree || leaf instanceof BlockTree || leaf instanceof VariableTree ? 1 : 0) != 0, (String)"Leaf of methodPath must be of type MethodTree, LambdaExpressionTree, BlockTree, or VariableTree, but was %s", (Object)leaf.getClass().getName());
        return this.dataflow(path, context, transfer).getAnalysis().getRegularExitStore();
    }

    @Nullable
    public <A extends AbstractValue<A>, S extends Store<S>, T extends TransferFunction<A, S>> S resultBeforeExpr(TreePath exprPath, Context context, T transfer) {
        AnalysisResult<A, S> analysisResult = this.resultForExpr(exprPath, context, transfer);
        return analysisResult == null ? null : (S)analysisResult.getStoreBefore(exprPath.getLeaf());
    }

    @Nullable
    public <A extends AbstractValue<A>, S extends Store<S>, T extends TransferFunction<A, S>> S resultBefore(TreePath exprPath, Context context, T transfer) {
        AnalysisResult<A, S> analysisResult = this.resultFor(exprPath, context, transfer);
        return analysisResult == null ? null : (S)analysisResult.getStoreBefore(exprPath.getLeaf());
    }

    @Nullable
    private <A extends AbstractValue<A>, S extends Store<S>, T extends TransferFunction<A, S>> AnalysisResult<A, S> resultForExpr(TreePath exprPath, Context context, T transfer) {
        Tree leaf = exprPath.getLeaf();
        Preconditions.checkArgument((boolean)(leaf instanceof ExpressionTree), (String)"Leaf of exprPath must be of type ExpressionTree, but was %s", (Object)leaf.getClass().getName());
        return this.resultFor(exprPath, context, transfer);
    }

    private <A extends AbstractValue<A>, S extends Store<S>, T extends TransferFunction<A, S>> AnalysisResult<A, S> resultFor(TreePath exprPath, Context context, T transfer) {
        TreePath enclosingPath = NullabilityUtil.findEnclosingMethodOrLambdaOrInitializer(exprPath);
        if (enclosingPath == null) {
            throw new RuntimeException("expression is not inside a method, lambda or initializer block!");
        }
        Tree method = enclosingPath.getLeaf();
        if (method instanceof MethodTree && ((MethodTree)method).getBody() == null) {
            return null;
        }
        return this.dataflow(enclosingPath, context, transfer).getAnalysis().getResult();
    }

    public void invalidateCaches() {
        this.cfgCache.invalidateAll();
        this.analysisCache.invalidateAll();
    }

    private static interface Result<A extends AbstractValue<A>, S extends Store<S>, T extends TransferFunction<A, S>> {
        public Analysis<A, S, T> getAnalysis();

        public ControlFlowGraph getControlFlowGraph();
    }

    @AutoValue
    static abstract class AnalysisParams {
        private ProcessingEnvironment environment;

        AnalysisParams() {
        }

        private static AnalysisParams create(TransferFunction<?, ?> transferFunction, ControlFlowGraph cfg, ProcessingEnvironment environment) {
            AutoValue_DataFlow_AnalysisParams ap = new AutoValue_DataFlow_AnalysisParams(transferFunction, cfg);
            ap.environment = environment;
            return ap;
        }

        ProcessingEnvironment environment() {
            return this.environment;
        }

        abstract TransferFunction<?, ?> transferFunction();

        abstract ControlFlowGraph cfg();
    }

    @AutoValue
    static abstract class CfgParams {
        private ProcessingEnvironment environment;

        CfgParams() {
        }

        private static CfgParams create(TreePath codePath, ProcessingEnvironment environment) {
            AutoValue_DataFlow_CfgParams cp = new AutoValue_DataFlow_CfgParams(codePath);
            cp.environment = environment;
            return cp;
        }

        ProcessingEnvironment environment() {
            return this.environment;
        }

        abstract TreePath codePath();
    }
}

