/*
 * Decompiled with CFR 0.152.
 */
package com.uber.nullaway.dataflow;

import com.google.common.base.Preconditions;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.util.Context;
import com.uber.nullaway.dataflow.NullnessStore;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.lang.model.element.NestingKind;

public class EnclosingEnvironmentNullness {
    public static final Context.Key<EnclosingEnvironmentNullness> ENCLOSING_ENVIRONMENT_NULLNESS_ANALYSIS_KEY = new Context.Key();
    private final Map<Tree, NullnessStore> environmentNullness = new LinkedHashMap<Tree, NullnessStore>();

    public static EnclosingEnvironmentNullness instance(Context context) {
        EnclosingEnvironmentNullness instance = context.get(ENCLOSING_ENVIRONMENT_NULLNESS_ANALYSIS_KEY);
        if (instance == null) {
            instance = new EnclosingEnvironmentNullness();
            context.put(ENCLOSING_ENVIRONMENT_NULLNESS_ANALYSIS_KEY, instance);
        }
        return instance;
    }

    public void addEnvironmentMapping(Tree t, NullnessStore s2) {
        Preconditions.checkArgument((boolean)this.isValidTreeType(t), (Object)("cannot store environment for node " + t));
        this.environmentNullness.put(t, s2);
    }

    @Nullable
    public NullnessStore getEnvironmentMapping(Tree t) {
        Preconditions.checkArgument((boolean)this.isValidTreeType(t));
        return this.environmentNullness.get(t);
    }

    public void clear() {
        this.environmentNullness.clear();
    }

    private boolean isValidTreeType(Tree t) {
        if (t instanceof LambdaExpressionTree) {
            return true;
        }
        if (t instanceof ClassTree) {
            NestingKind nestingKind = ASTHelpers.getSymbol((ClassTree)((ClassTree)t)).getNestingKind();
            return nestingKind.equals((Object)NestingKind.ANONYMOUS) || nestingKind.equals((Object)NestingKind.LOCAL);
        }
        return false;
    }
}

