/*
 * Decompiled with CFR 0.152.
 */
package com.uber.nullaway.dataflow;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.sun.tools.javac.code.Types;
import com.uber.nullaway.Nullness;
import com.uber.nullaway.dataflow.AccessPath;
import com.uber.nullaway.dataflow.AccessPathElement;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import shadow.checkerframework.dataflow.analysis.FlowExpressions;
import shadow.checkerframework.dataflow.analysis.Store;
import shadow.checkerframework.dataflow.cfg.CFGVisualizer;
import shadow.checkerframework.dataflow.cfg.node.FieldAccessNode;
import shadow.checkerframework.dataflow.cfg.node.LocalVariableNode;
import shadow.checkerframework.dataflow.cfg.node.MethodInvocationNode;

public class NullnessStore
implements Store<NullnessStore> {
    private static final NullnessStore EMPTY = new NullnessStore((Map<AccessPath, Nullness>)ImmutableMap.of());
    private final ImmutableMap<AccessPath, Nullness> contents;

    private NullnessStore(Map<AccessPath, Nullness> contents) {
        this.contents = ImmutableMap.copyOf(contents);
    }

    public static NullnessStore empty() {
        return EMPTY;
    }

    public Nullness valueOfLocalVariable(LocalVariableNode node, Nullness defaultValue) {
        Nullness result = (Nullness)this.contents.get((Object)AccessPath.fromLocal(node));
        return result != null ? result : defaultValue;
    }

    public Nullness valueOfField(FieldAccessNode node, Nullness defaultValue) {
        AccessPath path = AccessPath.fromFieldAccess(node);
        if (path == null) {
            return defaultValue;
        }
        Nullness result = (Nullness)this.contents.get((Object)path);
        return result != null ? result : defaultValue;
    }

    public Nullness valueOfMethodCall(MethodInvocationNode node, Types types, Nullness defaultValue) {
        AccessPath accessPath = AccessPath.fromMethodCall(node, types);
        if (accessPath == null) {
            return defaultValue;
        }
        Nullness result = (Nullness)this.contents.get((Object)accessPath);
        return result != null ? result : defaultValue;
    }

    public Set<AccessPath> getAccessPathsWithValue(Nullness value) {
        LinkedHashSet<AccessPath> result = new LinkedHashSet<AccessPath>();
        for (Map.Entry entry : this.contents.entrySet()) {
            if (!value.equals(entry.getValue())) continue;
            result.add((AccessPath)entry.getKey());
        }
        return result;
    }

    Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public NullnessStore copy() {
        return this;
    }

    @Override
    public NullnessStore leastUpperBound(NullnessStore other) {
        Builder result = NullnessStore.empty().toBuilder();
        for (AccessPath ap : Sets.intersection((Set)this.contents.keySet(), (Set)other.contents.keySet())) {
            Nullness apContents = (Nullness)this.contents.get((Object)ap);
            if (apContents == null) {
                throw new RuntimeException("null contents for " + ap);
            }
            Nullness otherAPContents = (Nullness)other.contents.get((Object)ap);
            if (otherAPContents == null) {
                throw new RuntimeException("null other contents for " + ap);
            }
            result.contents.put(ap, apContents.leastUpperBound(otherAPContents));
        }
        return result.build();
    }

    @Override
    public NullnessStore widenedUpperBound(NullnessStore vNullnessStore) {
        return this.leastUpperBound(vNullnessStore);
    }

    public boolean equals(Object o) {
        if (!(o instanceof NullnessStore)) {
            return false;
        }
        NullnessStore other = (NullnessStore)o;
        return this.contents.equals(other.contents);
    }

    public int hashCode() {
        return this.contents.hashCode();
    }

    public String toString() {
        return this.contents.toString();
    }

    @Override
    public boolean canAlias(FlowExpressions.Receiver receiver, FlowExpressions.Receiver receiver1) {
        return true;
    }

    @Override
    public String visualize(CFGVisualizer<?, NullnessStore, ?> cfgVisualizer) {
        throw new UnsupportedOperationException();
    }

    public NullnessStore uprootAccessPaths(Map<LocalVariableNode, LocalVariableNode> localVarTranslations) {
        Builder nullnessBuilder = NullnessStore.empty().toBuilder();
        for (AccessPath ap : this.contents.keySet()) {
            if (ap.getRoot().isReceiver()) continue;
            Element varElement = ap.getRoot().getVarElement();
            for (LocalVariableNode fromVar : localVarTranslations.keySet()) {
                if (!varElement.equals(fromVar.getElement())) continue;
                LocalVariableNode toVar = localVarTranslations.get(fromVar);
                AccessPath newAP = new AccessPath(new AccessPath.Root(toVar.getElement()), (List<AccessPathElement>)ap.getElements());
                nullnessBuilder.setInformation(newAP, (Nullness)this.contents.get((Object)ap));
            }
        }
        return nullnessBuilder.build();
    }

    public NullnessStore filterAccessPaths(Predicate<AccessPath> pred) {
        return new NullnessStore(this.contents.entrySet().stream().filter(e -> pred.test((AccessPath)e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    public static final class Builder {
        private final Map<AccessPath, Nullness> contents;

        Builder(NullnessStore prototype) {
            this.contents = new HashMap<AccessPath, Nullness>((Map<AccessPath, Nullness>)prototype.contents);
        }

        public Builder setInformation(AccessPath ap, Nullness value) {
            this.contents.put((AccessPath)Preconditions.checkNotNull((Object)ap), (Nullness)Preconditions.checkNotNull((Object)value));
            return this;
        }

        public NullnessStore build() {
            return new NullnessStore(this.contents);
        }
    }
}

