/*
 * Decompiled with CFR 0.152.
 */
package com.uber.nullaway.handlers;

import com.google.common.base.Preconditions;
import com.google.errorprone.VisitorState;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.uber.nullaway.NullAway;
import com.uber.nullaway.Nullness;
import com.uber.nullaway.dataflow.AccessPath;
import com.uber.nullaway.dataflow.AccessPathNullnessPropagation;
import com.uber.nullaway.handlers.BaseNoOpHandler;
import com.uber.nullaway.handlers.Handler;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import shadow.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import shadow.checkerframework.dataflow.cfg.node.Node;
import shadow.checkerframework.javacutil.Pair;

public class ApacheThriftIsSetHandler
extends BaseNoOpHandler {
    private static String TBASE_NAME = "org.apache.thrift.TBase";
    @Nullable
    private Optional<Type> tbaseType;

    @Override
    public void onMatchTopLevelClass(NullAway analysis, ClassTree tree, VisitorState state, Symbol.ClassSymbol classSymbol) {
        if (this.tbaseType == null) {
            this.tbaseType = Optional.ofNullable(state.getTypeFromString(TBASE_NAME)).map(state.getTypes()::erasure);
        }
    }

    @Override
    public Handler.NullnessHint onDataflowVisitMethodInvocation(MethodInvocationNode node, Types types, Context context, AccessPathNullnessPropagation.SubNodeValues inputs, AccessPathNullnessPropagation.Updates thenUpdates, AccessPathNullnessPropagation.Updates elseUpdates, AccessPathNullnessPropagation.Updates bothUpdates) {
        String methodName;
        String capPropName;
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodInvocationTree)node.getTree());
        if (this.thriftIsSetCall(symbol, types) && (capPropName = (methodName = ((Name)symbol.getSimpleName()).toString()).substring(5)).length() > 0) {
            Pair<Element, Element> fieldAndGetter = this.getFieldAndSetterForProperty(symbol, capPropName);
            Node base = node.getTarget().getReceiver();
            this.updateNonNullAPsForElement(thenUpdates, (Element)fieldAndGetter.first, base);
            this.updateNonNullAPsForElement(thenUpdates, (Element)fieldAndGetter.second, base);
        }
        return Handler.NullnessHint.UNKNOWN;
    }

    private void updateNonNullAPsForElement(AccessPathNullnessPropagation.Updates updates, @Nullable Element elem, Node base) {
        AccessPath ap;
        if (elem != null && (ap = AccessPath.fromBaseAndElement(base, elem)) != null) {
            updates.set(ap, Nullness.NONNULL);
        }
    }

    private Pair<Element, Element> getFieldAndSetterForProperty(Symbol.MethodSymbol symbol, String capPropName) {
        Element field = null;
        Symbol getter = null;
        String fieldName = ApacheThriftIsSetHandler.decapitalize(capPropName);
        String getterName = "get" + capPropName;
        for (Symbol elem : symbol.owner.getEnclosedElements()) {
            if (elem.getKind().isField() && elem.getSimpleName().toString().equals(fieldName)) {
                if (field != null) {
                    throw new RuntimeException("already found field " + fieldName);
                }
                field = elem;
                continue;
            }
            if (!elem.getKind().equals((Object)ElementKind.METHOD) || !elem.getSimpleName().toString().equals(getterName)) continue;
            if (getter != null) {
                throw new RuntimeException("already found getter " + getterName);
            }
            getter = elem;
        }
        if (field != null && field.asType().getKind().isPrimitive()) {
            return Pair.of(null, null);
        }
        return Pair.of(field, getter);
    }

    private static String decapitalize(String str) {
        char[] c = str.toCharArray();
        c[0] = Character.toLowerCase(c[0]);
        return new String(c);
    }

    private boolean thriftIsSetCall(Symbol.MethodSymbol symbol, Types types) {
        Preconditions.checkNotNull(this.tbaseType);
        return this.tbaseType.isPresent() && ((Name)symbol.getSimpleName()).toString().startsWith("isSet") && ((List)symbol.getParameters()).length() == 0 && types.isSubtype(symbol.owner.type, this.tbaseType.get());
    }
}

