/*
 * Decompiled with CFR 0.152.
 */
package com.uber.nullaway.handlers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.VisitorState;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Context;
import com.uber.nullaway.ErrorMessage;
import com.uber.nullaway.NullAway;
import com.uber.nullaway.dataflow.AccessPath;
import com.uber.nullaway.dataflow.AccessPathNullnessPropagation;
import com.uber.nullaway.dataflow.NullnessStore;
import com.uber.nullaway.handlers.Handler;
import java.util.List;
import java.util.Optional;
import shadow.checkerframework.dataflow.cfg.UnderlyingAST;
import shadow.checkerframework.dataflow.cfg.node.LocalVariableNode;
import shadow.checkerframework.dataflow.cfg.node.MethodInvocationNode;

class CompositeHandler
implements Handler {
    private final List<Handler> handlers;

    CompositeHandler(ImmutableList<Handler> handlers) {
        this.handlers = handlers;
    }

    @Override
    public void onMatchTopLevelClass(NullAway analysis, ClassTree tree, VisitorState state, Symbol.ClassSymbol classSymbol) {
        for (Handler h2 : this.handlers) {
            h2.onMatchTopLevelClass(analysis, tree, state, classSymbol);
        }
    }

    @Override
    public void onMatchMethod(NullAway analysis, MethodTree tree, VisitorState state, Symbol.MethodSymbol methodSymbol) {
        for (Handler h2 : this.handlers) {
            h2.onMatchMethod(analysis, tree, state, methodSymbol);
        }
    }

    @Override
    public void onMatchLambdaExpression(NullAway analysis, LambdaExpressionTree tree, VisitorState state, Symbol.MethodSymbol methodSymbol) {
        for (Handler h2 : this.handlers) {
            h2.onMatchLambdaExpression(analysis, tree, state, methodSymbol);
        }
    }

    @Override
    public void onMatchMethodReference(NullAway analysis, MemberReferenceTree tree, VisitorState state, Symbol.MethodSymbol methodSymbol) {
        for (Handler h2 : this.handlers) {
            h2.onMatchMethodReference(analysis, tree, state, methodSymbol);
        }
    }

    @Override
    public void onMatchMethodInvocation(NullAway analysis, MethodInvocationTree tree, VisitorState state, Symbol.MethodSymbol methodSymbol) {
        for (Handler h2 : this.handlers) {
            h2.onMatchMethodInvocation(analysis, tree, state, methodSymbol);
        }
    }

    @Override
    public void onMatchReturn(NullAway analysis, ReturnTree tree, VisitorState state) {
        for (Handler h2 : this.handlers) {
            h2.onMatchReturn(analysis, tree, state);
        }
    }

    @Override
    public ImmutableSet<Integer> onUnannotatedInvocationGetExplicitlyNullablePositions(Context context, Symbol.MethodSymbol methodSymbol, ImmutableSet<Integer> explicitlyNullablePositions) {
        for (Handler h2 : this.handlers) {
            explicitlyNullablePositions = h2.onUnannotatedInvocationGetExplicitlyNullablePositions(context, methodSymbol, explicitlyNullablePositions);
        }
        return explicitlyNullablePositions;
    }

    @Override
    public boolean onUnannotatedInvocationGetExplicitlyNonNullReturn(Symbol.MethodSymbol methodSymbol, boolean explicitlyNonNullReturn) {
        for (Handler h2 : this.handlers) {
            explicitlyNonNullReturn = h2.onUnannotatedInvocationGetExplicitlyNonNullReturn(methodSymbol, explicitlyNonNullReturn);
        }
        return explicitlyNonNullReturn;
    }

    @Override
    public ImmutableSet<Integer> onUnannotatedInvocationGetNonNullPositions(NullAway analysis, VisitorState state, Symbol.MethodSymbol methodSymbol, List<? extends ExpressionTree> actualParams, ImmutableSet<Integer> nonNullPositions) {
        for (Handler h2 : this.handlers) {
            nonNullPositions = h2.onUnannotatedInvocationGetNonNullPositions(analysis, state, methodSymbol, actualParams, nonNullPositions);
        }
        return nonNullPositions;
    }

    @Override
    public boolean onOverrideMayBeNullExpr(NullAway analysis, ExpressionTree expr, VisitorState state, boolean exprMayBeNull) {
        for (Handler h2 : this.handlers) {
            exprMayBeNull = h2.onOverrideMayBeNullExpr(analysis, expr, state, exprMayBeNull);
        }
        return exprMayBeNull;
    }

    @Override
    public NullnessStore.Builder onDataflowInitialStore(UnderlyingAST underlyingAST, List<LocalVariableNode> parameters, NullnessStore.Builder result) {
        for (Handler h2 : this.handlers) {
            result = h2.onDataflowInitialStore(underlyingAST, parameters, result);
        }
        return result;
    }

    @Override
    public Handler.NullnessHint onDataflowVisitMethodInvocation(MethodInvocationNode node, Types types, Context context, AccessPathNullnessPropagation.SubNodeValues inputs, AccessPathNullnessPropagation.Updates thenUpdates, AccessPathNullnessPropagation.Updates elseUpdates, AccessPathNullnessPropagation.Updates bothUpdates) {
        Handler.NullnessHint nullnessHint = Handler.NullnessHint.UNKNOWN;
        for (Handler h2 : this.handlers) {
            Handler.NullnessHint n = h2.onDataflowVisitMethodInvocation(node, types, context, inputs, thenUpdates, elseUpdates, bothUpdates);
            nullnessHint = nullnessHint.merge(n);
        }
        return nullnessHint;
    }

    @Override
    public void onDataflowVisitReturn(ReturnTree tree, NullnessStore thenStore, NullnessStore elseStore) {
        for (Handler h2 : this.handlers) {
            h2.onDataflowVisitReturn(tree, thenStore, elseStore);
        }
    }

    @Override
    public void onDataflowVisitLambdaResultExpression(ExpressionTree tree, NullnessStore thenStore, NullnessStore elseStore) {
        for (Handler h2 : this.handlers) {
            h2.onDataflowVisitLambdaResultExpression(tree, thenStore, elseStore);
        }
    }

    @Override
    public Optional<ErrorMessage> onExpressionDereference(ExpressionTree expr, ExpressionTree baseExpr, VisitorState state) {
        for (Handler h2 : this.handlers) {
            Optional<ErrorMessage> optionalErrorMessage = h2.onExpressionDereference(expr, baseExpr, state);
            if (!optionalErrorMessage.isPresent()) continue;
            return optionalErrorMessage;
        }
        return Optional.empty();
    }

    @Override
    public boolean includeApInfoInSavedContext(AccessPath accessPath, VisitorState state) {
        boolean shouldFilter = false;
        for (Handler h2 : this.handlers) {
            shouldFilter |= h2.includeApInfoInSavedContext(accessPath, state);
        }
        return shouldFilter;
    }
}

