/*
 * Decompiled with CFR 0.152.
 */
package com.uber.nullaway.handlers;

import com.google.common.base.Preconditions;
import com.google.errorprone.BugCheckerInfo;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Context;
import com.uber.nullaway.ErrorMessage;
import com.uber.nullaway.NullAway;
import com.uber.nullaway.Nullness;
import com.uber.nullaway.dataflow.AccessPath;
import com.uber.nullaway.dataflow.AccessPathNullnessPropagation;
import com.uber.nullaway.handlers.BaseNoOpHandler;
import com.uber.nullaway.handlers.Handler;
import java.util.Map;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import shadow.checkerframework.dataflow.cfg.node.MethodInvocationNode;

public class ContractHandler
extends BaseNoOpHandler {
    @Nullable
    private NullAway analysis;
    @Nullable
    private VisitorState state;

    @Override
    public void onMatchTopLevelClass(NullAway analysis, ClassTree tree, VisitorState state, Symbol.ClassSymbol classSymbol) {
        this.analysis = analysis;
        this.state = state;
    }

    @Override
    public Handler.NullnessHint onDataflowVisitMethodInvocation(MethodInvocationNode node, Types types, Context context, AccessPathNullnessPropagation.SubNodeValues inputs, AccessPathNullnessPropagation.Updates thenUpdates, AccessPathNullnessPropagation.Updates elseUpdates, AccessPathNullnessPropagation.Updates bothUpdates) {
        Symbol.MethodSymbol callee = ASTHelpers.getSymbol((MethodInvocationTree)node.getTree());
        Preconditions.checkNotNull((Object)callee);
        String contractString = ContractHandler.getContractFromAnnotation(callee);
        if (contractString != null) {
            String[] clauses;
            for (String clause : clauses = contractString.split(";")) {
                String[] parts = clause.split("->");
                if (parts.length != 2) {
                    this.reportMatch(node.getTree(), "Invalid @Contract annotation detected for method " + callee + ". It contains the following uparseable clause: " + clause + "(see https://www.jetbrains.com/help/idea/contract-annotations.html).");
                }
                String[] antecedent = parts[0].split(",");
                String consequent = parts[1].trim();
                int argIdx = -1;
                Enum argAntecedentNullness = null;
                boolean supported = true;
                if (antecedent.length != node.getArguments().size()) {
                    this.reportMatch(node.getTree(), "Invalid @Contract annotation detected for method " + callee + ". It contains the following uparseable clause: " + clause + " (incorrect number of arguments in the clause's antecedent [" + antecedent.length + "], should be the same as the number of arguments in for the method [" + node.getArguments().size() + "]).");
                }
                for (int i = 0; i < antecedent.length; ++i) {
                    String valueConstraint = antecedent[i].trim();
                    if (valueConstraint.equals("_")) continue;
                    if (valueConstraint.equals("false") || valueConstraint.equals("true")) {
                        supported = false;
                        break;
                    }
                    if (valueConstraint.equals("!null") && inputs.valueOfSubNode(node.getArgument(i)).equals(Nullness.NONNULL)) continue;
                    if (valueConstraint.equals("null") || valueConstraint.equals("!null")) {
                        if (argIdx != -1) {
                            supported = false;
                            break;
                        }
                        argIdx = i;
                        argAntecedentNullness = valueConstraint.equals("null") ? Nullness.NULLABLE : Nullness.NONNULL;
                        continue;
                    }
                    this.reportMatch(node.getTree(), "Invalid @Contract annotation detected for method " + callee + ". It contains the following uparseable clause: " + clause + " (unknown value constraint: " + valueConstraint + ", see https://www.jetbrains.com/help/idea/contract-annotations.html).");
                    supported = false;
                    break;
                }
                if (!supported) continue;
                if (argIdx == -1) {
                    if (!consequent.equals("!null")) continue;
                    return Handler.NullnessHint.FORCE_NONNULL;
                }
                assert (argAntecedentNullness != null);
                AccessPath accessPath = AccessPath.getAccessPathForNodeNoMapGet(node.getArgument(argIdx));
                if (accessPath == null) continue;
                if (consequent.equals("false") && argAntecedentNullness.equals(Nullness.NULLABLE)) {
                    thenUpdates.set(accessPath, Nullness.NONNULL);
                    continue;
                }
                if (consequent.equals("true") && argAntecedentNullness.equals(Nullness.NULLABLE)) {
                    elseUpdates.set(accessPath, Nullness.NONNULL);
                    continue;
                }
                if (!consequent.equals("fail") || !argAntecedentNullness.equals(Nullness.NULLABLE)) continue;
                bothUpdates.set(accessPath, Nullness.NONNULL);
            }
        }
        return Handler.NullnessHint.UNKNOWN;
    }

    private void reportMatch(Tree errorLocTree, String message) {
        assert (this.analysis != null && this.state != null);
        if (this.analysis != null && this.state != null) {
            this.state.reportMatch(this.analysis.getErrorBuilder().createErrorDescription(new ErrorMessage(ErrorMessage.MessageTypes.ANNOTATION_VALUE_INVALID, message), errorLocTree, BugCheckerInfo.buildDescriptionFromChecker((Tree)errorLocTree, (BugChecker)this.analysis), this.state));
        }
    }

    @Nullable
    private static String getContractFromAnnotation(Symbol.MethodSymbol sym) {
        for (AnnotationMirror annotation : sym.getAnnotationMirrors()) {
            Element element = annotation.getAnnotationType().asElement();
            assert (element.getKind().equals((Object)ElementKind.ANNOTATION_TYPE));
            if (!((TypeElement)element).getQualifiedName().contentEquals("org.jetbrains.annotations.Contract")) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : annotation.getElementValues().entrySet()) {
                if (!e.getKey().getSimpleName().contentEquals("value")) continue;
                String value = e.getValue().toString();
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                }
                return value;
            }
        }
        return null;
    }
}

