/*
 * Decompiled with CFR 0.152.
 */
package com.uber.nullaway.handlers;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.VisitorState;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Context;
import com.uber.nullaway.ErrorMessage;
import com.uber.nullaway.NullAway;
import com.uber.nullaway.Nullness;
import com.uber.nullaway.dataflow.AccessPath;
import com.uber.nullaway.dataflow.AccessPathNullnessPropagation;
import com.uber.nullaway.dataflow.NullnessStore;
import java.util.List;
import java.util.Optional;
import shadow.checkerframework.dataflow.cfg.UnderlyingAST;
import shadow.checkerframework.dataflow.cfg.node.LocalVariableNode;
import shadow.checkerframework.dataflow.cfg.node.MethodInvocationNode;

public interface Handler {
    public void onMatchTopLevelClass(NullAway var1, ClassTree var2, VisitorState var3, Symbol.ClassSymbol var4);

    public void onMatchMethod(NullAway var1, MethodTree var2, VisitorState var3, Symbol.MethodSymbol var4);

    public void onMatchMethodInvocation(NullAway var1, MethodInvocationTree var2, VisitorState var3, Symbol.MethodSymbol var4);

    public void onMatchLambdaExpression(NullAway var1, LambdaExpressionTree var2, VisitorState var3, Symbol.MethodSymbol var4);

    public void onMatchMethodReference(NullAway var1, MemberReferenceTree var2, VisitorState var3, Symbol.MethodSymbol var4);

    public void onMatchReturn(NullAway var1, ReturnTree var2, VisitorState var3);

    public ImmutableSet<Integer> onUnannotatedInvocationGetExplicitlyNullablePositions(Context var1, Symbol.MethodSymbol var2, ImmutableSet<Integer> var3);

    public boolean onUnannotatedInvocationGetExplicitlyNonNullReturn(Symbol.MethodSymbol var1, boolean var2);

    public ImmutableSet<Integer> onUnannotatedInvocationGetNonNullPositions(NullAway var1, VisitorState var2, Symbol.MethodSymbol var3, List<? extends ExpressionTree> var4, ImmutableSet<Integer> var5);

    public boolean onOverrideMayBeNullExpr(NullAway var1, ExpressionTree var2, VisitorState var3, boolean var4);

    public NullnessStore.Builder onDataflowInitialStore(UnderlyingAST var1, List<LocalVariableNode> var2, NullnessStore.Builder var3);

    public NullnessHint onDataflowVisitMethodInvocation(MethodInvocationNode var1, Types var2, Context var3, AccessPathNullnessPropagation.SubNodeValues var4, AccessPathNullnessPropagation.Updates var5, AccessPathNullnessPropagation.Updates var6, AccessPathNullnessPropagation.Updates var7);

    public void onDataflowVisitReturn(ReturnTree var1, NullnessStore var2, NullnessStore var3);

    public void onDataflowVisitLambdaResultExpression(ExpressionTree var1, NullnessStore var2, NullnessStore var3);

    public Optional<ErrorMessage> onExpressionDereference(ExpressionTree var1, ExpressionTree var2, VisitorState var3);

    public boolean includeApInfoInSavedContext(AccessPath var1, VisitorState var2);

    public static enum NullnessHint {
        UNKNOWN(0, Nullness.NONNULL),
        HINT_NULLABLE(1, Nullness.NULLABLE),
        FORCE_NONNULL(2, Nullness.NONNULL);

        private final int priority;
        private final Nullness nullness;

        private NullnessHint(int priority, Nullness nullness) {
            this.priority = priority;
            this.nullness = nullness;
        }

        public Nullness toNullness() {
            return this.nullness;
        }

        public NullnessHint merge(NullnessHint other) {
            if (other.priority > this.priority) {
                return other;
            }
            return this;
        }
    }
}

